// -----------------------------------------------------------------------------
//  trees.inc -- IRTC Still July-August 2002, "Loneliness"
//
//  Copyright (c) 2002 Aaron 'Serac' Hill <serac@hillvisions.com>
//
//  This program is free for all to use, copy, modify, and distribute, provided
//  the above copyright notice is included in all versions.  Please contact the
//  developer for ideas and suggestions for improving this program.
// -----------------------------------------------------------------------------

#declare BarkPigment = pigment {
    leopard
    color_map { [0.3 color rgb <85,31,26>/255][0.3 color rgb <68,24,19>/255] }
    scale ((x+z)/15)+(y*5) warp { turbulence 1/6 octaves 1 lambda 1 omega 1 }
}
#declare BarkPigmentDark = pigment {
    leopard
    color_map { [0.3 color rgb <53,32,31>/255][0.3 color rgb <41,25,23>/255] }
    scale ((x+z)/15)+(y*5) warp { turbulence 1/6 octaves 1 lambda 1 omega 1 }
}
#declare LeavesPigment = pigment {
    bozo
    color_map { [0.5 color rgb <107,177,50>/255][0.5 color rgb <105,164,57>/255] }
    scale 2
}

#macro GenerateLeaves(Seed)
    blob { threshold 0.2
        #declare C = intersection { cone { <0,20,0>,15,<0,60,0>,5 } sphere { <0,40,0>,20 } }
        #declare R1 = seed(Seed);
        #declare I = 0;
        #while (I < 250)
            #declare P = <2*rand(R1)-1,0,2*rand(R1)-1>*15 + <0,rand(R1),0>*40 + <0,20,0>;
            #if (inside(C,P) = 1)
                sphere { P, rand(R1)*3+6, rand(R1)*.25+.75 }
                #declare I = I + 1;
            #end
        #end
    }
#end

#declare Trunk = merge {
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<0.008, -0.005, 4.916> <-0.007, 0.591, 4.705> <0.002, 0.489, 4.634> <-0.020, 1.111, 4.522> 
		<-1.375, -0.007, 4.979> <-1.390, 0.589, 4.768> <-1.284, 0.463, 4.667> <-1.306, 1.085, 4.555> 
		<-1.364, 0.021, 4.999> <-1.271, 0.564, 4.770> <-1.332, 0.469, 4.636> <-1.265, 1.048, 4.510> 
		<-2.474, 0.031, 4.171> <-2.380, 0.574, 3.942> <-2.365, 0.468, 3.869> <-2.299, 1.047, 3.743> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<0.008, -0.005, 4.916> <1.050, -0.004, 4.868> <0.770, 0.053, 4.407> <1.722, 0.036, 3.980> 
		<-0.007, 0.591, 4.705> <1.036, 0.592, 4.658> <0.697, 0.634, 4.226> <1.649, 0.617, 3.799> 
		<0.002, 0.489, 4.634> <0.980, 0.508, 4.608> <0.748, 0.522, 4.167> <1.639, 0.525, 3.764> 
		<-0.020, 1.111, 4.522> <0.958, 1.130, 4.497> <0.694, 1.120, 4.044> <1.586, 1.123, 3.642> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<1.722, 0.036, 3.980> <2.664, 0.019, 3.558> <2.702, -0.071, 3.937> <3.540, -0.068, 3.334> 
		<1.649, 0.617, 3.799> <2.591, 0.600, 3.377> <2.619, 0.565, 3.751> <3.457, 0.567, 3.148> 
		<1.639, 0.525, 3.764> <2.572, 0.528, 3.343> <2.659, 0.492, 3.670> <3.480, 0.465, 3.060> 
		<1.586, 1.123, 3.642> <2.519, 1.126, 3.221> <2.564, 1.149, 3.595> <3.385, 1.121, 2.985> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.540, -0.068, 3.334> <4.493, -0.065, 2.647> <4.724, 0.025, 2.805> <4.954, 0.045, 1.653> 
		<3.457, 0.567, 3.148> <4.411, 0.570, 2.461> <4.438, 0.551, 2.744> <4.668, 0.571, 1.592> 
		<3.480, 0.465, 3.060> <4.244, 0.440, 2.493> <4.392, 0.463, 2.521> <4.565, 0.447, 1.585> 
		<3.385, 1.121, 2.985> <4.149, 1.096, 2.418> <4.246, 1.044, 2.474> <4.419, 1.029, 1.539> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<4.954, 0.045, 1.653> <5.215, 0.068, 0.349> <4.619, 0.023, 0.541> <4.359, 0.004, -0.763> 
		<4.668, 0.571, 1.592> <4.929, 0.594, 0.288> <4.461, 0.588, 0.578> <4.201, 0.569, -0.727> 
		<4.565, 0.447, 1.585> <4.784, 0.428, 0.397> <4.361, 0.454, 0.478> <4.169, 0.483, -0.715> 
		<4.419, 1.029, 1.539> <4.638, 1.009, 0.350> <4.256, 1.031, 0.498> <4.064, 1.061, -0.695> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<4.359, 0.004, -0.763> <4.109, -0.015, -2.020> <4.676, 0.002, -2.046> <4.000, -0.024, -3.135> 
		<4.201, 0.569, -0.727> <3.951, 0.550, -1.983> <4.511, 0.624, -1.959> <3.836, 0.598, -3.048> 
		<4.169, 0.483, -0.715> <3.973, 0.513, -1.933> <4.463, 0.493, -2.035> <3.780, 0.503, -3.063> 
		<4.064, 1.061, -0.695> <3.868, 1.091, -1.912> <4.375, 1.130, -1.945> <3.692, 1.141, -2.972> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<4.000, -0.024, -3.135> <3.372, -0.049, -4.147> <3.231, -0.077, -3.889> <2.133, -0.082, -4.351> 
		<3.836, 0.598, -3.048> <3.208, 0.574, -4.060> <3.100, 0.551, -3.685> <2.002, 0.547, -4.147> 
		<3.780, 0.503, -3.063> <3.170, 0.513, -3.980> <2.974, 0.427, -3.746> <1.943, 0.443, -4.133> 
		<3.692, 1.141, -2.972> <3.083, 1.150, -3.890> <2.920, 1.078, -3.583> <1.888, 1.095, -3.969> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<2.133, -0.082, -4.351> <0.764, -0.088, -4.927> <0.905, -0.064, -5.313> <-0.557, -0.043, -5.052> 
		<2.002, 0.547, -4.147> <0.633, 0.541, -4.723> <0.863, 0.604, -5.069> <-0.599, 0.626, -4.808> 
		<1.943, 0.443, -4.133> <0.642, 0.464, -4.621> <0.720, 0.515, -4.961> <-0.656, 0.515, -4.760> 
		<1.888, 1.095, -3.969> <0.587, 1.115, -4.458> <0.741, 1.208, -4.796> <-0.635, 1.209, -4.595> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.557, -0.043, -5.052> <-2.128, -0.020, -4.771> <-1.849, -0.018, -4.462> <-3.060, -0.006, -3.422> 
		<-0.599, 0.626, -4.808> <-2.169, 0.649, -4.527> <-1.743, 0.571, -4.384> <-2.954, 0.583, -3.344> 
		<-0.656, 0.515, -4.760> <-2.026, 0.516, -4.560> <-1.923, 0.510, -4.250> <-2.964, 0.505, -3.339> 
		<-0.635, 1.209, -4.595> <-2.004, 1.209, -4.395> <-1.819, 1.102, -4.187> <-2.861, 1.096, -3.275> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.060, -0.006, -3.422> <-3.790, 0.001, -2.795> <-3.675, -0.038, -2.822> <-4.135, -0.007, -1.978> 
		<-2.954, 0.583, -3.344> <-3.683, 0.590, -2.717> <-3.532, 0.603, -2.710> <-3.992, 0.634, -1.865> 
		<-2.964, 0.505, -3.339> <-3.694, 0.502, -2.700> <-3.574, 0.536, -2.676> <-4.004, 0.542, -1.806> 
		<-2.861, 1.096, -3.275> <-3.591, 1.093, -2.637> <-3.437, 1.187, -2.637> <-3.867, 1.193, -1.767> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-4.135, -0.007, -1.978> <-4.676, 0.029, -0.983> <-4.988, 0.106, -1.141> <-4.916, 0.117, -0.011> 
		<-3.992, 0.634, -1.865> <-4.533, 0.670, -0.871> <-4.768, 0.642, -1.108> <-4.696, 0.653, 0.022> 
		<-4.004, 0.542, -1.806> <-4.460, 0.548, -0.883> <-4.707, 0.579, -0.962> <-4.633, 0.554, 0.065> 
		<-3.867, 1.193, -1.767> <-4.323, 1.199, -0.844> <-4.578, 1.144, -0.976> <-4.504, 1.119, 0.051> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-4.916, 0.117, -0.011> <-4.839, 0.128, 1.202> <-4.494, 0.052, 0.964> <-3.881, 0.030, 2.014> 
		<-4.696, 0.653, 0.022> <-4.619, 0.664, 1.235> <-4.348, 0.627, 0.881> <-3.735, 0.605, 1.931> 
		<-4.633, 0.554, 0.065> <-4.556, 0.529, 1.140> <-4.270, 0.540, 1.007> <-3.717, 0.522, 1.933> 
		<-4.504, 1.119, 0.051> <-4.427, 1.094, 1.126> <-4.160, 1.125, 0.933> <-3.607, 1.106, 1.859> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.881, 0.030, 2.014> <-3.187, 0.006, 3.202> <-3.577, 0.041, 3.348> <-2.474, 0.031, 4.171> 
		<-3.735, 0.605, 1.931> <-3.041, 0.581, 3.119> <-3.483, 0.584, 3.119> <-2.380, 0.574, 3.942> 
		<-3.717, 0.522, 1.933> <-3.088, 0.501, 2.985> <-3.350, 0.466, 3.138> <-2.365, 0.468, 3.869> 
		<-3.607, 1.106, 1.859> <-2.978, 1.086, 2.911> <-3.283, 1.046, 3.012> <-2.299, 1.047, 3.743> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.020, 1.111, 4.522> <-0.046, 1.864, 4.387> <-0.070, 1.776, 4.484> <-0.082, 2.541, 4.459> 
		<-1.306, 1.085, 4.555> <-1.333, 1.839, 4.420> <-1.279, 1.761, 4.539> <-1.291, 2.526, 4.513> 
		<-1.265, 1.048, 4.510> <-1.178, 1.802, 4.346> <-1.273, 1.729, 4.420> <-1.258, 2.505, 4.405> 
		<-2.299, 1.047, 3.743> <-2.212, 1.801, 3.578> <-2.205, 1.716, 3.649> <-2.190, 2.493, 3.635> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.020, 1.111, 4.522> <0.958, 1.130, 4.497> <0.694, 1.120, 4.044> <1.586, 1.123, 3.642> 
		<-0.046, 1.864, 4.387> <0.932, 1.883, 4.361> <0.628, 1.865, 3.891> <1.520, 1.868, 3.489> 
		<-0.070, 1.776, 4.484> <0.926, 1.788, 4.439> <0.621, 1.779, 3.879> <1.534, 1.776, 3.479> 
		<-0.082, 2.541, 4.459> <0.914, 2.553, 4.414> <0.585, 2.542, 3.868> <1.499, 2.539, 3.468> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<1.586, 1.123, 3.642> <2.519, 1.126, 3.221> <2.564, 1.149, 3.595> <3.385, 1.121, 2.985> 
		<1.520, 1.868, 3.489> <2.452, 1.871, 3.068> <2.455, 1.898, 3.510> <3.276, 1.871, 2.900> 
		<1.534, 1.776, 3.479> <2.375, 1.773, 3.111> <2.450, 1.783, 3.569> <3.200, 1.768, 3.039> 
		<1.499, 2.539, 3.468> <2.340, 2.536, 3.099> <2.413, 2.544, 3.568> <3.162, 2.529, 3.038> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.385, 1.121, 2.985> <4.149, 1.096, 2.418> <4.246, 1.044, 2.474> <4.419, 1.029, 1.539> 
		<3.276, 1.871, 2.900> <4.040, 1.845, 2.333> <4.057, 1.798, 2.413> <4.230, 1.782, 1.478> 
		<3.200, 1.768, 3.039> <4.061, 1.751, 2.430> <4.167, 1.719, 2.500> <4.374, 1.704, 1.466> 
		<3.162, 2.529, 3.038> <4.023, 2.512, 2.429> <4.136, 2.497, 2.491> <4.343, 2.482, 1.457> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<4.419, 1.029, 1.539> <4.638, 1.009, 0.350> <4.256, 1.031, 0.498> <4.064, 1.061, -0.695> 
		<4.230, 1.782, 1.478> <4.449, 1.763, 0.290> <4.119, 1.780, 0.524> <3.927, 1.809, -0.668> 
		<4.374, 1.704, 1.466> <4.603, 1.688, 0.325> <4.118, 1.685, 0.451> <3.927, 1.716, -0.696> 
		<4.343, 2.482, 1.457> <4.572, 2.467, 0.316> <4.098, 2.446, 0.471> <3.906, 2.477, -0.677> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<4.064, 1.061, -0.695> <3.868, 1.091, -1.912> <4.375, 1.130, -1.945> <3.692, 1.141, -2.972> 
		<3.927, 1.809, -0.668> <3.731, 1.840, -1.886> <4.269, 1.902, -1.835> <3.586, 1.912, -2.863> 
		<3.927, 1.716, -0.696> <3.742, 1.746, -1.806> <4.277, 1.780, -1.863> <3.654, 1.811, -2.800> 
		<3.906, 2.477, -0.677> <3.721, 2.507, -1.786> <4.262, 2.566, -1.826> <3.639, 2.597, -2.763> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.692, 1.141, -2.972> <3.083, 1.150, -3.890> <2.920, 1.078, -3.583> <1.888, 1.095, -3.969> 
		<3.586, 1.912, -2.863> <2.976, 1.922, -3.780> <2.854, 1.858, -3.387> <1.823, 1.874, -3.773> 
		<3.654, 1.811, -2.800> <3.075, 1.840, -3.672> <2.881, 1.796, -3.338> <1.912, 1.772, -3.735> 
		<3.639, 2.597, -2.763> <3.060, 2.626, -3.634> <2.878, 2.601, -3.286> <1.909, 2.577, -3.682> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<1.888, 1.095, -3.969> <0.587, 1.115, -4.458> <0.741, 1.208, -4.796> <-0.635, 1.209, -4.595> 
		<1.823, 1.874, -3.773> <0.521, 1.895, -4.261> <0.762, 1.886, -4.635> <-0.614, 1.886, -4.434> 
		<1.912, 1.772, -3.735> <0.672, 1.741, -4.243> <0.833, 1.801, -4.645> <-0.499, 1.800, -4.486> 
		<1.909, 2.577, -3.682> <0.669, 2.546, -4.190> <0.852, 2.496, -4.606> <-0.479, 2.495, -4.448> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.635, 1.209, -4.595> <-2.004, 1.209, -4.395> <-1.819, 1.102, -4.187> <-2.861, 1.096, -3.275> 
		<-0.614, 1.886, -4.434> <-1.983, 1.887, -4.234> <-1.682, 1.889, -4.102> <-2.724, 1.884, -3.191> 
		<-0.499, 1.800, -4.486> <-1.824, 1.799, -4.329> <-1.627, 1.766, -4.024> <-2.650, 1.771, -3.166> 
		<-0.479, 2.495, -4.448> <-1.805, 2.494, -4.291> <-1.587, 2.568, -4.003> <-2.610, 2.573, -3.145> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-2.861, 1.096, -3.275> <-3.591, 1.093, -2.637> <-3.437, 1.187, -2.637> <-3.867, 1.193, -1.767> 
		<-2.724, 1.884, -3.191> <-3.454, 1.880, -2.552> <-3.289, 1.889, -2.595> <-3.719, 1.895, -1.725> 
		<-2.650, 1.771, -3.166> <-3.327, 1.775, -2.598> <-3.200, 1.813, -2.598> <-3.639, 1.793, -1.832> 
		<-2.610, 2.573, -3.145> <-3.286, 2.577, -2.577> <-3.165, 2.531, -2.592> <-3.604, 2.511, -1.827> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.867, 1.193, -1.767> <-4.323, 1.199, -0.844> <-4.578, 1.144, -0.976> <-4.504, 1.119, 0.051> 
		<-3.719, 1.895, -1.725> <-4.175, 1.901, -0.802> <-4.413, 1.865, -0.995> <-4.339, 1.840, 0.032> 
		<-3.639, 1.793, -1.832> <-4.149, 1.770, -0.944> <-4.448, 1.758, -1.069> <-4.394, 1.753, -0.047> 
		<-3.604, 2.511, -1.827> <-4.113, 2.488, -0.939> <-4.426, 2.497, -1.094> <-4.372, 2.493, -0.071> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-4.504, 1.119, 0.051> <-4.427, 1.094, 1.126> <-4.160, 1.125, 0.933> <-3.607, 1.106, 1.859> 
		<-4.339, 1.840, 0.032> <-4.262, 1.815, 1.108> <-4.022, 1.860, 0.840> <-3.469, 1.841, 1.765> 
		<-4.394, 1.753, -0.047> <-4.338, 1.748, 1.027> <-3.979, 1.742, 0.800> <-3.434, 1.742, 1.726> 
		<-4.372, 2.493, -0.071> <-4.316, 2.488, 1.002> <-3.964, 2.495, 0.774> <-3.419, 2.495, 1.700> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.607, 1.106, 1.859> <-2.978, 1.086, 2.911> <-3.283, 1.046, 3.012> <-2.299, 1.047, 3.743> 
		<-3.469, 1.841, 1.765> <-2.841, 1.821, 2.818> <-3.196, 1.800, 2.847> <-2.212, 1.801, 3.578> 
		<-3.434, 1.742, 1.726> <-2.813, 1.742, 2.781> <-3.148, 1.703, 2.869> <-2.205, 1.716, 3.649> 
		<-3.419, 2.495, 1.700> <-2.797, 2.495, 2.755> <-3.134, 2.480, 2.855> <-2.190, 2.493, 3.635> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.082, 2.541, 4.459> <-0.118, 4.802, 4.384> <-0.105, 4.511, 4.366> <-0.108, 6.774, 4.335> 
		<-1.291, 2.526, 4.513> <-1.326, 4.787, 4.439> <-1.279, 4.512, 4.391> <-1.282, 6.774, 4.360> 
		<-1.258, 2.505, 4.405> <-1.214, 4.821, 4.361> <-1.275, 4.501, 4.381> <-1.267, 6.818, 4.360> 
		<-2.190, 2.493, 3.635> <-2.146, 4.808, 3.591> <-2.197, 4.512, 3.653> <-2.189, 6.828, 3.633> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.082, 2.541, 4.459> <0.914, 2.553, 4.414> <0.585, 2.542, 3.868> <1.499, 2.539, 3.468> 
		<-0.118, 4.802, 4.384> <0.878, 4.815, 4.339> <0.479, 4.833, 3.834> <1.392, 4.830, 3.434> 
		<-0.105, 4.511, 4.366> <0.765, 4.511, 4.348> <0.527, 4.545, 3.912> <1.328, 4.534, 3.574> 
		<-0.108, 6.774, 4.335> <0.762, 6.774, 4.317> <0.520, 6.839, 3.897> <1.321, 6.828, 3.558> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<1.499, 2.539, 3.468> <2.340, 2.536, 3.099> <2.413, 2.544, 3.568> <3.162, 2.529, 3.038> 
		<1.392, 4.830, 3.434> <2.233, 4.827, 3.066> <2.302, 4.785, 3.563> <3.051, 4.770, 3.033> 
		<1.328, 4.534, 3.574> <2.254, 4.520, 3.182> <2.334, 4.483, 3.587> <3.146, 4.484, 2.994> 
		<1.321, 6.828, 3.558> <2.247, 6.814, 3.166> <2.295, 6.726, 3.567> <3.107, 6.727, 2.975> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.162, 2.529, 3.038> <4.023, 2.512, 2.429> <4.136, 2.497, 2.491> <4.343, 2.482, 1.457> 
		<3.051, 4.770, 3.033> <3.912, 4.753, 2.425> <4.042, 4.820, 2.463> <4.250, 4.805, 1.429> 
		<3.146, 4.484, 2.994> <3.947, 4.485, 2.410> <4.032, 4.480, 2.425> <4.251, 4.507, 1.459> 
		<3.107, 6.727, 2.975> <3.908, 6.728, 2.391> <3.966, 6.804, 2.435> <4.185, 6.831, 1.469> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<4.343, 2.482, 1.457> <4.572, 2.467, 0.316> <4.098, 2.446, 0.471> <3.906, 2.477, -0.677> 
		<4.250, 4.805, 1.429> <4.478, 4.789, 0.288> <4.034, 4.768, 0.530> <3.843, 4.799, -0.617> 
		<4.251, 4.507, 1.459> <4.492, 4.536, 0.399> <4.093, 4.497, 0.508> <3.938, 4.501, -0.569> 
		<4.185, 6.831, 1.469> <4.426, 6.860, 0.409> <4.062, 6.820, 0.529> <3.907, 6.824, -0.547> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.906, 2.477, -0.677> <3.721, 2.507, -1.786> <4.262, 2.566, -1.826> <3.639, 2.597, -2.763> 
		<3.843, 4.799, -0.617> <3.658, 4.829, -1.727> <4.219, 4.834, -1.718> <3.596, 4.865, -2.655> 
		<3.938, 4.501, -0.569> <3.772, 4.505, -1.721> <4.265, 4.616, -1.783> <3.619, 4.576, -2.750> 
		<3.907, 6.824, -0.547> <3.740, 6.828, -1.699> <4.230, 6.886, -1.734> <3.584, 6.846, -2.701> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.639, 2.597, -2.763> <3.060, 2.626, -3.634> <2.878, 2.601, -3.286> <1.909, 2.577, -3.682> 
		<3.596, 4.865, -2.655> <3.017, 4.893, -3.527> <2.869, 4.798, -3.142> <1.900, 4.774, -3.538> 
		<3.619, 4.576, -2.750> <3.042, 4.540, -3.614> <2.839, 4.500, -3.272> <1.871, 4.495, -3.650> 
		<3.584, 6.846, -2.701> <3.007, 6.810, -3.565> <2.834, 6.701, -3.224> <1.866, 6.696, -3.602> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<1.909, 2.577, -3.682> <0.669, 2.546, -4.190> <0.852, 2.496, -4.606> <-0.479, 2.495, -4.448> 
		<1.900, 4.774, -3.538> <0.660, 4.743, -4.046> <0.918, 4.807, -4.480> <-0.414, 4.806, -4.321> 
		<1.871, 4.495, -3.650> <0.655, 4.489, -4.124> <0.808, 4.480, -4.486> <-0.489, 4.511, -4.347> 
		<1.866, 6.696, -3.602> <0.650, 6.690, -4.077> <0.821, 6.794, -4.425> <-0.476, 6.825, -4.286> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.479, 2.495, -4.448> <-1.805, 2.494, -4.291> <-1.587, 2.568, -4.003> <-2.610, 2.573, -3.145> 
		<-0.414, 4.806, -4.321> <-1.740, 4.805, -4.164> <-1.473, 4.823, -3.944> <-2.496, 4.829, -3.086> 
		<-0.489, 4.511, -4.347> <-1.762, 4.541, -4.211> <-1.611, 4.521, -3.969> <-2.599, 4.542, -3.155> 
		<-0.476, 6.825, -4.286> <-1.749, 6.855, -4.150> <-1.585, 6.780, -3.940> <-2.573, 6.801, -3.126> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-2.610, 2.573, -3.145> <-3.286, 2.577, -2.577> <-3.165, 2.531, -2.592> <-3.604, 2.511, -1.827> 
		<-2.496, 4.829, -3.086> <-3.172, 4.832, -2.519> <-3.050, 4.870, -2.575> <-3.489, 4.849, -1.809> 
		<-2.599, 4.542, -3.155> <-3.314, 4.558, -2.566> <-3.151, 4.563, -2.551> <-3.621, 4.551, -1.754> 
		<-2.573, 6.801, -3.126> <-3.287, 6.816, -2.538> <-3.116, 6.904, -2.521> <-3.586, 6.891, -1.724> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.604, 2.511, -1.827> <-4.113, 2.488, -0.939> <-4.426, 2.497, -1.094> <-4.372, 2.493, -0.071> 
		<-3.489, 4.849, -1.809> <-3.998, 4.826, -0.921> <-4.358, 4.772, -1.169> <-4.304, 4.768, -0.147> 
		<-3.621, 4.551, -1.754> <-4.099, 4.538, -0.943> <-4.381, 4.499, -1.081> <-4.355, 4.477, -0.141> 
		<-3.586, 6.891, -1.724> <-4.064, 6.879, -0.913> <-4.361, 6.776, -1.076> <-4.335, 6.754, -0.136> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-4.372, 2.493, -0.071> <-4.316, 2.488, 1.002> <-3.964, 2.495, 0.774> <-3.419, 2.495, 1.700> 
		<-4.304, 4.768, -0.147> <-4.248, 4.763, 0.927> <-3.918, 4.801, 0.696> <-3.372, 4.801, 1.622> 
		<-4.355, 4.477, -0.141> <-4.326, 4.452, 0.921> <-4.025, 4.487, 0.749> <-3.499, 4.505, 1.673> 
		<-4.335, 6.754, -0.136> <-4.306, 6.730, 0.926> <-4.018, 6.795, 0.742> <-3.492, 6.813, 1.665> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.419, 2.495, 1.700> <-2.797, 2.495, 2.755> <-3.134, 2.480, 2.855> <-2.190, 2.493, 3.635> 
		<-3.372, 4.801, 1.622> <-2.751, 4.801, 2.677> <-3.090, 4.795, 2.811> <-2.146, 4.808, 3.591> 
		<-3.499, 4.505, 1.673> <-2.875, 4.527, 2.769> <-3.187, 4.523, 2.873> <-2.197, 4.512, 3.653> 
		<-3.492, 6.813, 1.665> <-2.869, 6.834, 2.761> <-3.179, 6.840, 2.852> <-2.189, 6.828, 3.633> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.108, 6.774, 4.335> <-0.113, 10.353, 4.286> <-0.118, 9.894, 4.342> <-0.098, 13.473, 4.308> 
		<-1.282, 6.774, 4.360> <-1.287, 10.353, 4.311> <-1.291, 9.892, 4.388> <-1.271, 13.471, 4.354> 
		<-1.267, 6.818, 4.360> <-1.256, 10.347, 4.328> <-1.278, 9.918, 4.317> <-1.239, 13.448, 4.271> 
		<-2.189, 6.828, 3.633> <-2.178, 10.358, 3.601> <-2.193, 9.905, 3.582> <-2.154, 13.434, 3.536> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.108, 6.774, 4.335> <0.762, 6.774, 4.317> <0.520, 6.839, 3.897> <1.321, 6.828, 3.558> 
		<-0.113, 10.353, 4.286> <0.757, 10.353, 4.267> <0.509, 10.374, 3.873> <1.310, 10.362, 3.534> 
		<-0.118, 9.894, 4.342> <0.849, 9.895, 4.304> <0.588, 9.917, 3.856> <1.473, 9.906, 3.463> 
		<-0.098, 13.473, 4.308> <0.869, 13.474, 4.270> <0.581, 13.451, 3.786> <1.465, 13.440, 3.394> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<1.321, 6.828, 3.558> <2.247, 6.814, 3.166> <2.295, 6.726, 3.567> <3.107, 6.727, 2.975> 
		<1.310, 10.362, 3.534> <2.236, 10.349, 3.142> <2.233, 10.309, 3.537> <3.046, 10.310, 2.944> 
		<1.473, 9.906, 3.463> <2.241, 9.896, 3.122> <2.335, 9.855, 3.482> <3.012, 9.850, 2.983> 
		<1.465, 13.440, 3.394> <2.234, 13.430, 3.052> <2.297, 13.438, 3.444> <2.974, 13.433, 2.944> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.107, 6.727, 2.975> <3.908, 6.728, 2.391> <3.966, 6.804, 2.435> <4.185, 6.831, 1.469> 
		<3.046, 10.310, 2.944> <3.846, 10.311, 2.360> <3.866, 10.325, 2.449> <4.085, 10.352, 1.483> 
		<3.012, 9.850, 2.983> <3.781, 9.844, 2.415> <3.878, 9.910, 2.441> <4.086, 9.899, 1.507> 
		<2.974, 13.433, 2.944> <3.744, 13.428, 2.377> <3.824, 13.432, 2.434> <4.032, 13.421, 1.501> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<4.185, 6.831, 1.469> <4.426, 6.860, 0.409> <4.062, 6.820, 0.529> <3.907, 6.824, -0.547> 
		<4.085, 10.352, 1.483> <4.326, 10.381, 0.423> <4.014, 10.331, 0.561> <3.859, 10.335, -0.515> 
		<4.086, 9.899, 1.507> <4.330, 9.887, 0.415> <3.992, 9.881, 0.532> <3.838, 9.883, -0.577> 
		<4.032, 13.421, 1.501> <4.276, 13.409, 0.409> <3.913, 13.392, 0.533> <3.759, 13.394, -0.576> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.907, 6.824, -0.547> <3.740, 6.828, -1.699> <4.230, 6.886, -1.734> <3.584, 6.846, -2.701> 
		<3.859, 10.335, -0.515> <3.693, 10.339, -1.667> <4.176, 10.404, -1.659> <3.530, 10.363, -2.626> 
		<3.838, 9.883, -0.577> <3.693, 9.885, -1.623> <4.107, 9.924, -1.686> <3.530, 9.910, -2.570> 
		<3.759, 13.394, -0.576> <3.614, 13.396, -1.622> <4.050, 13.443, -1.646> <3.473, 13.429, -2.531> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.584, 6.846, -2.701> <3.007, 6.810, -3.565> <2.834, 6.701, -3.224> <1.866, 6.696, -3.602> 
		<3.530, 10.363, -2.626> <2.953, 10.327, -3.490> <2.826, 10.255, -3.148> <1.858, 10.250, -3.526> 
		<3.530, 9.910, -2.570> <2.994, 9.897, -3.392> <2.815, 9.796, -3.107> <1.910, 9.793, -3.487> 
		<3.473, 13.429, -2.531> <2.937, 13.415, -3.353> <2.790, 13.351, -3.070> <1.885, 13.348, -3.450> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<1.866, 6.696, -3.602> <0.650, 6.690, -4.077> <0.821, 6.794, -4.425> <-0.476, 6.825, -4.286> 
		<1.858, 10.250, -3.526> <0.642, 10.244, -4.000> <0.841, 10.315, -4.333> <-0.456, 10.346, -4.194> 
		<1.910, 9.793, -3.487> <0.722, 9.789, -3.985> <0.853, 9.883, -4.358> <-0.429, 9.894, -4.228> 
		<1.885, 13.348, -3.450> <0.697, 13.344, -3.948> <0.864, 13.404, -4.292> <-0.417, 13.415, -4.162> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.476, 6.825, -4.286> <-1.749, 6.855, -4.150> <-1.585, 6.780, -3.940> <-2.573, 6.801, -3.126> 
		<-0.456, 10.346, -4.194> <-1.729, 10.376, -4.057> <-1.543, 10.298, -3.896> <-2.531, 10.319, -3.082> 
		<-0.429, 9.894, -4.228> <-1.686, 9.904, -4.101> <-1.524, 9.856, -3.855> <-2.502, 9.867, -3.055> 
		<-0.417, 13.415, -4.162> <-1.675, 13.426, -4.034> <-1.503, 13.375, -3.808> <-2.481, 13.385, -3.007> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-2.573, 6.801, -3.126> <-3.287, 6.816, -2.538> <-3.116, 6.904, -2.521> <-3.586, 6.891, -1.724> 
		<-2.531, 10.319, -3.082> <-3.245, 10.335, -2.493> <-3.064, 10.406, -2.476> <-3.534, 10.394, -1.679> 
		<-2.502, 9.867, -3.055> <-3.178, 9.873, -2.502> <-3.032, 9.930, -2.485> <-3.485, 9.943, -1.739> 
		<-2.481, 13.385, -3.007> <-3.157, 13.392, -2.454> <-2.989, 13.433, -2.432> <-3.442, 13.446, -1.686> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.586, 6.891, -1.724> <-4.064, 6.879, -0.913> <-4.361, 6.776, -1.076> <-4.335, 6.754, -0.136> 
		<-3.534, 10.394, -1.679> <-4.012, 10.381, -0.868> <-4.331, 10.347, -1.069> <-4.305, 10.326, -0.128> 
		<-3.485, 9.943, -1.739> <-3.995, 9.958, -0.899> <-4.362, 9.873, -1.049> <-4.346, 9.867, -0.067> 
		<-3.442, 13.446, -1.686> <-3.952, 13.461, -0.846> <-4.294, 13.444, -1.030> <-4.278, 13.437, -0.048> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-4.335, 6.754, -0.136> <-4.306, 6.730, 0.926> <-4.018, 6.795, 0.742> <-3.492, 6.813, 1.665> 
		<-4.305, 10.326, -0.128> <-4.276, 10.301, 0.934> <-4.009, 10.328, 0.729> <-3.483, 10.346, 1.653> 
		<-4.346, 9.867, -0.067> <-4.330, 9.860, 0.963> <-3.974, 9.893, 0.798> <-3.448, 9.892, 1.684> 
		<-4.278, 13.437, -0.048> <-4.262, 13.431, 0.982> <-3.915, 13.425, 0.777> <-3.389, 13.425, 1.663> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.492, 6.813, 1.665> <-2.869, 6.834, 2.761> <-3.179, 6.840, 2.852> <-2.189, 6.828, 3.633> 
		<-3.483, 10.346, 1.653> <-2.859, 10.367, 2.749> <-3.168, 10.369, 2.820> <-2.178, 10.358, 3.601> 
		<-3.448, 9.892, 1.684> <-2.837, 9.891, 2.716> <-3.128, 9.891, 2.831> <-2.193, 9.905, 3.582> 
		<-3.389, 13.425, 1.663> <-2.778, 13.424, 2.694> <-3.088, 13.420, 2.785> <-2.154, 13.434, 3.536> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.001, 25.317, 4.160> <-1.135, 25.319, 4.229> <-1.105, 25.275, 4.113> <-1.984, 25.284, 3.392> 
		<-0.052, 18.988, 4.239> <-1.187, 18.991, 4.308> <-1.196, 18.943, 4.190> <-2.075, 18.952, 3.469> 
		<-0.061, 19.801, 4.249> <-1.234, 19.800, 4.295> <-1.169, 19.779, 4.189> <-2.084, 19.766, 3.454> 
		<-0.098, 13.473, 4.308> <-1.271, 13.471, 4.354> <-1.239, 13.448, 4.271> <-2.154, 13.434, 3.536> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.001, 25.317, 4.160> <-0.052, 18.988, 4.239> <-0.061, 19.801, 4.249> <-0.098, 13.473, 4.308> 
		<0.856, 25.314, 4.109> <0.804, 18.986, 4.188> <0.906, 19.803, 4.211> <0.869, 13.474, 4.270> 
		<0.507, 25.273, 3.563> <0.605, 18.948, 3.670> <0.567, 19.776, 3.662> <0.581, 13.451, 3.786> 
		<1.281, 25.276, 3.195> <1.379, 18.952, 3.301> <1.451, 19.765, 3.269> <1.465, 13.440, 3.394> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<1.281, 25.276, 3.195> <1.379, 18.952, 3.301> <1.451, 19.765, 3.269> <1.465, 13.440, 3.394> 
		<2.093, 25.280, 2.808> <2.192, 18.955, 2.915> <2.220, 19.755, 2.928> <2.234, 13.430, 3.052> 
		<2.164, 25.330, 3.276> <2.198, 18.974, 3.367> <2.230, 19.794, 3.375> <2.297, 13.438, 3.444> 
		<2.910, 25.329, 2.775> <2.944, 18.973, 2.865> <2.907, 19.790, 2.876> <2.974, 13.433, 2.944> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<2.910, 25.329, 2.775> <2.944, 18.973, 2.865> <2.907, 19.790, 2.876> <2.974, 13.433, 2.944> 
		<3.650, 25.329, 2.278> <3.684, 18.972, 2.368> <3.676, 19.784, 2.309> <3.744, 13.428, 2.377> 
		<3.748, 25.284, 2.312> <3.818, 18.951, 2.348> <3.726, 19.764, 2.422> <3.824, 13.432, 2.434> 
		<3.901, 25.274, 1.434> <3.971, 18.941, 1.470> <3.934, 19.754, 1.489> <4.032, 13.421, 1.501> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.901, 25.274, 1.434> <3.971, 18.941, 1.470> <3.934, 19.754, 1.489> <4.032, 13.421, 1.501> 
		<4.087, 25.261, 0.373> <4.157, 18.928, 0.408> <4.178, 19.742, 0.397> <4.276, 13.409, 0.409> 
		<3.657, 25.281, 0.524> <3.801, 18.924, 0.506> <3.769, 19.749, 0.535> <3.913, 13.392, 0.533> 
		<3.489, 25.291, -0.540> <3.633, 18.934, -0.559> <3.615, 19.751, -0.573> <3.759, 13.394, -0.576> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.489, 25.291, -0.540> <3.633, 18.934, -0.559> <3.615, 19.751, -0.573> <3.759, 13.394, -0.576> 
		<3.326, 25.301, -1.577> <3.470, 18.944, -1.596> <3.470, 19.753, -1.619> <3.614, 13.396, -1.622> 
		<3.830, 25.318, -1.598> <3.932, 18.969, -1.618> <3.946, 19.792, -1.575> <4.050, 13.443, -1.646> 
		<3.283, 25.312, -2.494> <3.385, 18.963, -2.514> <3.370, 19.778, -2.460> <3.473, 13.429, -2.531> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<3.283, 25.312, -2.494> <3.385, 18.963, -2.514> <3.370, 19.778, -2.460> <3.473, 13.429, -2.531> 
		<2.782, 25.307, -3.314> <2.883, 18.957, -3.334> <2.834, 19.765, -3.281> <2.937, 13.415, -3.353> 
		<2.631, 25.284, -3.061> <2.711, 18.913, -3.082> <2.745, 19.722, -3.005> <2.790, 13.351, -3.070> 
		<1.736, 25.271, -3.410> <1.816, 18.900, -3.431> <1.841, 19.719, -3.384> <1.885, 13.348, -3.450> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<1.736, 25.271, -3.410> <1.816, 18.900, -3.431> <1.841, 19.719, -3.384> <1.885, 13.348, -3.450> 
		<0.633, 25.255, -3.840> <0.713, 18.885, -3.861> <0.653, 19.714, -3.882> <0.697, 13.344, -3.948> 
		<0.758, 25.274, -4.086> <0.757, 18.945, -4.206> <0.885, 19.732, -4.172> <0.864, 13.404, -4.292> 
		<-0.415, 25.259, -3.937> <-0.416, 18.931, -4.057> <-0.396, 19.743, -4.042> <-0.417, 13.415, -4.162> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-0.415, 25.259, -3.937> <-0.416, 18.931, -4.057> <-0.396, 19.743, -4.042> <-0.417, 13.415, -4.162> 
		<-1.638, 25.244, -3.781> <-1.640, 18.915, -3.901> <-1.654, 19.754, -3.914> <-1.675, 13.426, -4.034> 
		<-1.523, 25.225, -3.672> <-1.531, 18.902, -3.742> <-1.466, 19.698, -3.722> <-1.503, 13.375, -3.808> 
		<-2.465, 25.219, -2.876> <-2.473, 18.896, -2.946> <-2.444, 19.708, -2.921> <-2.481, 13.385, -3.007> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-2.465, 25.219, -2.876> <-2.473, 18.896, -2.946> <-2.444, 19.708, -2.921> <-2.481, 13.385, -3.007> 
		<-3.153, 25.214, -2.294> <-3.162, 18.891, -2.364> <-3.120, 19.715, -2.368> <-3.157, 13.392, -2.454> 
		<-2.937, 25.223, -2.242> <-2.980, 18.922, -2.370> <-2.912, 19.734, -2.338> <-2.989, 13.433, -2.432> 
		<-3.363, 25.239, -1.448> <-3.405, 18.938, -1.575> <-3.366, 19.747, -1.591> <-3.442, 13.446, -1.686> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.363, 25.239, -1.448> <-3.405, 18.938, -1.575> <-3.366, 19.747, -1.591> <-3.442, 13.446, -1.686> 
		<-3.751, 25.252, -0.722> <-3.793, 18.951, -0.849> <-3.876, 19.762, -0.751> <-3.952, 13.461, -0.846> 
		<-4.032, 25.243, -0.859> <-4.190, 18.919, -0.864> <-4.174, 19.768, -0.997> <-4.294, 13.444, -1.030> 
		<-3.983, 25.273, -0.038> <-4.141, 18.949, -0.043> <-4.158, 19.762, -0.014> <-4.278, 13.437, -0.048> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.983, 25.273, -0.038> <-4.141, 18.949, -0.043> <-4.158, 19.762, -0.014> <-4.278, 13.437, -0.048> 
		<-3.926, 25.308, 0.912> <-4.084, 18.984, 0.907> <-4.142, 19.755, 1.016> <-4.262, 13.431, 0.982> 
		<-3.662, 25.347, 0.730> <-3.772, 18.975, 0.788> <-3.808, 19.797, 0.738> <-3.915, 13.425, 0.777> 
		<-3.182, 25.350, 1.553> <-3.293, 18.978, 1.612> <-3.282, 19.796, 1.624> <-3.389, 13.425, 1.663> 
	}
	bicubic_patch { type _PatchType flatness _PatchFlatness u_steps _PatchUSteps v_steps _PatchVSteps
		<-3.182, 25.350, 1.553> <-3.293, 18.978, 1.612> <-3.282, 19.796, 1.624> <-3.389, 13.425, 1.663> 
		<-2.591, 25.353, 2.567> <-2.702, 18.981, 2.626> <-2.671, 19.796, 2.656> <-2.778, 13.424, 2.694> 
		<-2.891, 25.293, 2.649> <-2.982, 18.962, 2.726> <-3.018, 19.752, 2.703> <-3.088, 13.420, 2.785> 
		<-1.984, 25.284, 3.392> <-2.075, 18.952, 3.469> <-2.084, 19.766, 3.454> <-2.154, 13.434, 3.536> 
	}
}