#include "colors.inc"
#include "stones3.inc"
#include "lights.inc"

global_settings {
	number_of_waves 35
}

#declare fnLand = function { pigment { image_map { png "land.png" } } }

#declare LandCol = texture { pigment {
	gradient y
	color_map {
		[ 0.00 rgb <0.23, 0.65, 0.17> ]
		[ 0.23 rgb <0.36, 0.38, 0.32> ]
		[ 0.34 rgb <0.55, 0.42, 0.23> ]
		[ 0.45 rgb <0.34, 0.34, 0.34> ]
		[ 1.00 rgb <1.00, 1.00, 1.00> ]
	}
} }

#declare Land = height_field {
  png "land.png"
  smooth
  texture { LandCol }
  translate <-.5, 0.3, -.5>
  texture { LandCol }
	scale <1000, 100, 1000>
}

#declare wtBase = <35.00, 1e6, 50.00>;
#declare ctBase = <35.00, 1e6, 50.00>;
#declare csBase = <45, 400,  65>;
#declare csNorm = <0,0,0>;
#declare cSrc = trace(Land, csBase, -y, csNorm)+y*5;
#declare cTrg = trace(Land, ctBase, -y, csNorm);
#declare wPos = trace(Land, wtBase, -y, csNorm);

Sun(2.5, 2e2, 89, 0)

camera { location csBase look_at cTrg right x*image_width/image_height }

#declare fpnWater0 = function { pattern { ripples scale .24 } }
#declare fpnWater1 = function { pattern { waves scale 2.24 } }
#declare fpnWater = function { .1*fpnWater0(x,0,z)+.5*fpnWater1(x,0,z) }

#declare tpSiz = 10;
#declare tpHgt = 6;

#declare TearPool = isosurface {
	function { y-tpHgt+fpnWater(x,0,z) }
	max_gradient 15
	accuracy 0.01
	contained_by { box { <-tpSiz, 0, -tpSiz>, <tpSiz, tpHgt, tpSiz> } }
	texture {
		pigment { rgbt 1 }
		normal { function { fpnWater(x,0,z) } .2 }
		finish {
			conserve_energy
			reflection { fresnel on }
		}
	}
	interior {
		ior 1.25
		media {
			absorption <1.00, 0.56, 0.33>*.01
			method 3
			intervals 2
			samples 3, 40
		}
		caustics 0.4
	}
}
	
#macro TestGrid(siz, sep, c0, c1, c2)
	union {
		sphere { 0, siz pigment { rgb c0 } }
		sphere { x*siz*sep, siz pigment { rgb c1 } }
		sphere { z*siz*sep, siz pigment { rgb c2 } }
	}
#end

object { TearPool translate cTrg }

#debug concat("Intersection found at ",vstr(3,cSrc,",",0,3)," .\n")

#if (cSrc.y<20) #declare cSrc = <cSrc.x, 1000, cSrc.z>; #end

object { Land }

