#declare IsTest = off;
#declare IsLand = on;

#include "tearpool.inc"

global_settings {
	number_of_waves 35
	max_trace_level 20
}

Sun(2.5, 2e6, 65,  20)

sky_sphere { Sky }

#if (IsLand)
	object { Land }
	object { Lava }
	object { Skull rotate <-45, 34, 26> translate skPos }
	object { Boulders }
	object { Smoke }
	object { TearPool translate wPos }
	object { CopyRight }
	
	camera { location cSrc1 look_at cTrg right x*image_width/image_height }
#else
	camera { location < 7000, 3740, 18600> look_at <3005, 3000, 5000> right x*image_width/image_height }
	//camera { location < 7, 12, 34> look_at <0, 0, 0> right x*image_width/image_height }
	sphere { 
		0, 10
		hollow
		texture { texLava }
		interior { intLava }
	}
#end

//camera { location < 1000, 3720, 3400> look_at <0, 3000, 0> right x*image_width/image_height }

//object { TestGrid (250, 3, <1, 1, 1>, <1, 1, 0>, <1, 0, 1>) translate cSrc1 }

