#include "colors.inc"
#include "stones3.inc"
#include "lights.inc"

// Sky
#declare Sky1 = pigment { image_map { png "skydsk1.png" interpolate 2 } scale .8 }

#declare Sky = sky_sphere {
	pigment { 
		#if (IsTest)
			rgb <0.3, 0.6, 0.8>
		#else
			Sky1
			warp{
				spherical
				orientation z
				dist_exp 1
			}			
		#end
		//rotate x*180
	}
}

// Ground
#declare imgLanda = pigment { 
	image_map { png "landa.png" interpolate 2 } 
	scale 0.01
}
#declare imgLandb = pigment { 
	image_map { png "landd.png" interpolate 2 } 
	turbulence 0.4 scale 0.01 
}
#declare imgLandc = pigment { 
	image_map { png "landc.png" interpolate 2 } 
	turbulence 0.1 scale 0.01
}
#declare imgLandd = pigment { 
	image_map { png "landb.png" interpolate 2 } 
	scale 0.04 
}
#declare imgLande = pigment { 
	image_map { png "lande.png" interpolate 2 } 
	turbulence 0.2 scale 0.001 
}

#declare texLand = texture { pigment {
	gradient y
	turbulence .03
	omega .75
	pigment_map {
		[ 0.13 imgLanda ]
		[ 0.23 imgLandb ]
		[ 0.31 imgLandb ]
		[ 0.34 imgLandc ]
		[ 0.39 imgLandc ]
		[ 0.48 imgLandd ]
		[ 0.65 imgLandd ]
		[ 0.90 imgLande ]
	}
} }

// Pool
#declare fpnWater0 = function { pattern { ripples scale .24 } }
#declare fpnWater1 = function { pattern { waves scale 2.24 } }
#declare fpnWater = function { .4*fpnWater0(x,0,z)+2.5*fpnWater1(x,0,z) }

#declare texPool = material {	
	texture {
		pigment { rgbt <2.0, 2.0, 2.0, 0.85> }
		normal { function { fpnWater(x,0,z) } .2 }
		finish {
			conserve_energy
			reflection { fresnel on }
		}
	}
	interior {
		ior 1.25
		media {
			absorption <1.00, 0.56, 0.33>*.04
			method 3
			intervals 2
			samples 3, 40
		}
		caustics 0.4
	}
}

// Rocks
#declare fpnBoulder = function { pattern { agate agate_turb .7 sine_wave scale .3 } }

#declare texBoulder = texture {
	pigment { rgb 1.2 }
	normal { function { fpnBoulder(x,y,z) } .2 }
	finish { phong .2 phong_size 60 }
}

// Lava
#declare texLava = texture { 
	pigment { rgbt 1 }
	//finish { ambient 0.7 }
}

#macro FireMap(Type)
	#local Inverse = 0;
	#switch (Type)
		#case (1) // Brightest flames, bright red to pale yellow
			#if ( Inverse )
				color_map {
					[ 0.0 rgb <0.0, 0.0, 0.0> ]
					[ 0.2 rgb <0.0, 0.0, 0.0> ]
					[ 0.2 rgb <0.0, 0.6, 0.6> ]
					[ 0.6 rgb <0.0, 0.4, 0.8> ]
					[ 1.0 rgb <0.0, 0.0, 0.5> ]
				}
			#else
				color_map {
					[ 0.0 rgb <0.0, 0.0, 0.0> ]
					[ 0.2 rgb <0.0, 0.0, 0.0> ]
					[ 0.2 rgb <1.0, 0.4, 0.4> ]
					[ 0.6 rgb <1.0, 0.6, 0.2> ]
					[ 1.0 rgb <1.0, 1.0, 0.5> ]
				}
			#end
		#break
		#case (2) // Slightly dimmer, with more red
			#if ( Inverse )
				color_map {
					[ 0.35 rgb <0.0, 0.0, 0.0> ]
					[ 0.40 rgb <0.0, 0.6, 0.6> ]
					[ 0.50 rgb <0.0, 0.6, 0.6> ]
					[ 0.65 rgb <0.1, 0.1, 1.0> ]
					[ 0.75 rgb <0.1, 0.1, 1.0> ]
					[ 0.80 rgb <0.0, 0.0, 0.8> ]
				}
			#else
				color_map {
					[ 0.35 rgb <0.0, 0.0, 0.0> ]
					[ 0.40 rgb <1.0, 0.0, 0.0> ]
					[ 0.50 rgb <1.0, 0.0, 0.0> ]
					[ 0.65 rgb <1.0, 1.0, 0.0> ]
					[ 0.75 rgb <1.0, 1.0, 0.0> ]
					[ 0.80 rgb <1.0, 1.0, 0.5> ]
				}
			#end
		#break
		#case (3) // Medium flames with red and orange
			#if ( Inverse )
				color_map {
					[ 0.25 rgb <0.0, 0.0, 0.0> ]
					[ 0.25 rgb <0.0, 0.5, 1.0> ]
					[ 0.50 rgb <0.0, 0.5, 1.0> ]
					[ 0.75 rgb <0.0, 0.3, 0.6> ]
				}
			#else
				color_map {
					[ 0.25 rgb <0.0, 0.0, 0.0> ]
					[ 0.25 rgb <0.8, 0.0, 0.1> ]
					[ 0.50 rgb <0.8, 0.0, 0.1> ]
					[ 0.75 rgb <1.0, 0.5, 0.0> ]
				}
			#end
		#break
		#case (4) // Mostly red with violet/orange mix
			#if ( Inverse )
				color_map {
					[ 0.00 rgb <0.0, 0.0, 0.0> ]
					[ 0.35 rgb <0.7, 0.3, 1.0> ]
					[ 0.65 rgb <0.7, 1.0, 0.3> ]
					[ 1.00 rgb <0.0, 1.0, 1.0> ]
				}
			#else
				color_map {
					[ 0.00 rgb <0.0, 0.0, 0.0> ]
					[ 0.35 rgb <0.3, 0.7, 0.0> ]
					[ 0.65 rgb <0.3, 0.0, 0.7> ]
					[ 1.00 rgb <1.0, 0.0, 0.0> ]
				}
			#end
		#break
		#case (5) // Dark red/orange embers
			#if ( Inverse )
				color_map {
					[ 0.0 rgb <0.0, 0.0, 0.0> ]
					[ 0.3 rgb <0.0, 0.0, 0.0> ]
					[ 0.3 rgb <0.0, 0.7, 0.7> ]
					[ 1.0 rgb <0.4, 0.8, 0.6> ]
				}
			#else
				color_map {
					[ 0.0 rgb <0.0, 0.0, 0.0> ]
					[ 0.3 rgb <0.0, 0.0, 0.0> ]
					[ 0.3 rgb <0.2, 0.1, 0.1> ]
					[ 1.0 rgb <0.4, 0.2, 0.1> ]
				}
			#end
		#break
	#end
#end

#macro Fire( Type, Size )
	interior {
		ior 1.1
		media {
			emission 0.6
			samples 1, 20
			variance 1/1000
			confidence .995
			density {
				spherical
				turbulence 1.50
				omega 0.7
				lambda 1.7
				FireMap(Type)
				scale 0.5*Size
			}
		}
	}
#end

#declare intLava = interior {
	ior 1.1
	media {
		emission 0.03
		samples 1, 20
		variance 1/1000
		confidence .995
		density {
			bozo
			turbulence 1.00
			omega 0.7
			lambda 1.7
			color_map {
				[ 0.0 rgb <0.0, 0.0, 0.0> ]
				[ 0.3 rgb <0.0, 0.0, 0.0> ]
				[ 0.6 rgb <0.2, 0.1, 0.1> ]
				[ 1.0 rgb <0.4, 0.2, 0.1> ]
			}
			scale 4
		}
	}
}

// Smoke
#declare intSmoke = interior {
	media {
		scattering { 3, 0.002 }
		samples 1, 20
		variance 1/1000
		confidence .995
		density {
			wood
			turbulence 0.60
			color_map {
				[ 0.1 rgb <0.0, 0.0, 0.0> ]
				[ 0.3 rgb <0.1, 0.1, 0.1> ]
				[ 1.0 rgb <0.2, 0.2, 0.2> ]
			}
			scale 4
		}
	}
}

// Bone
#declare Bone = texture {
	pigment {
		granite
		color_map {
			[ 0.00 color rgb < 0.80, 0.80, 0.40> ]
			[ 0.13 color rgb < 0.70, 0.70, 0.70> ]
			[ 0.26 color rgb < 0.90, 0.70, 0.50> ]
			[ 0.39 color rgb < 0.85, 0.85, 0.80> ]
			[ 0.52 color rgb < 0.80, 0.80, 0.80> ]
			[ 0.65 color rgb < 0.70, 0.85, 0.85> ]
			[ 0.78 color rgb < 0.75, 0.85, 0.95> ]
			[ 0.91 color rgb < 0.70, 0.70, 0.70> ]
			[ 1.00 color rgb < 0.80, 0.80, 0.40> ]
		}
	}
	normal { granite 0.3 scale 0.3 }
	finish { phong 0.2 phong_size 24 }
	scale 0.1
}

// Text
#declare txtCaption = texture {
	pigment { rgb 1 }
	finish { 
		ambient 0.5
		phong 0.9
		phong_size 200
	}
}	
