

#include "colors.inc"
#include "woods.inc"

camera { location <5,5,-10> look_at <0,1.5,0> 
focal_point <0,2,-.5> aperture .4 blur_samples 50 
}


//light_source { <30,10,-30> color White }

light_source {
  0*x 
  color rgb 1.5  
  area_light
 
  <8,0, 0> <0, 0, 8> 
  8, 8               
  adaptive 2
  jitter         
  translate <0,80,0> rotate <-50,-40,0>  
}

 
#declare Haar = cone { <0,-.1,0> .01 <0,.2,0> 0 }
#declare rnd = seed(1) ;

#declare kopfstep   = .01 ; //.01
#declare schnstep   = .04 ; //.04
#declare earstep    = .04 ; //.04         
#declare torso1step = .015 ;//.015
#declare torso2step = .015 ;//.015
#declare pfotestep  = .03 ; //.03
#declare armstep2   = .05 ; //.05

#declare armstep1 = 1 ; //1
#declare rot2step = 3 ; //3
#declare rot1step = 5 ; //5


#include "teddy.inc"

union {   
object { Head rotate <-20,10,0> translate <0,2.4,0> }
object { torso rotate <0,0,0> translate <0,0,0> }
 
object { armleg rotate <-30,-80,0> translate <.95,1.65,0> } //arm links
object { armleg rotate <-30,80,0> translate <-.95,1.65,0> } //arm rechts

object { armleg scale 1.3 rotate <0,-40,0> translate <.5,-1,-.2> } //bein links
object { armleg scale 1.3 rotate <0,40,0> translate <-.5,-1,-.2> } //bein rechts
rotate <0,-10,0>translate <0,0,1>}




superellipsoid { <0.1, .1>  
scale <10,.25,3> translate <0,-2.25,0>  
pigment { P_WoodGrain8B rotate <0,90,0> }
finish { ambient .4 diffuse .1 phong .5 phong_size 50 reflection .07 }}

superellipsoid { <0.1, .05>  
pigment { P_WoodGrain8B translate <2,0,1> rotate <0,90,0> }
scale <10,.25,3> rotate <0,0,90> translate <-9.75,7.75,0>  
finish { ambient .4 diffuse .1 phong .5 phong_size 50 reflection .07 }}


box { <100,100,3> <-100,-100,4> pigment { rgb <1,1,.95> } 
normal { crackle .1 scale .1 turbulence .3 } finish { ambient .1 diffuse .8 }
}