

#declare River =    //original y offset = 5
//      X    Y    Z   RAD   OFFSET
 array[12][5]
 {
     { 150,  0,  1000,   5,   1},
     { 200,  0,  800,   5,   1},
     { 200,  0,  700,   6,   1},
     { 300,  0,  600,  10,   5},
     { 150,  0,  400,  20,  10},  
     {  50,  0,  200,  10,   8},
     {  30,  0,  150,  10,   5},
     {  20,  0,  140,  10,   8},
     {  20,  0,  120,   9,   5},
     {  19,  0,  100,   8,   5},
     {  13,  0,  -20,  10,   3} 
     {  13,  0,  -40,  10,   3} 
 }
 


#declare T_Trees=
    texture{ pigment{ crackle scale .03
                     color_map{
                               [0.0 rgbf <  .18,  .30,  .18, .9>]
                               [0.2 rgbf <  .18,  .30,  .18, .9>]
                               [0.2 rgbf <  .31,  .31,  .18, .9>]
                               [0.5 rgbf <  .31,  .31,  .18, .9>]
                               [0.5 rgbf <  .13,  .55,  .13, .9>]
                               [1.0 rgbf <  .13,  .55,  .13, .9>]
                              }warp { turbulence 1 } 
                     } 
             normal {crackle scale .03 } 
                
             #if (PreTrace = 0)
                 finish{ambient 0 
                       }
             #else
                 finish {ambient <0.8, 0.9, 1.4>*0.35
                         specular 0.2
                         diffuse 0.4
                        }
                 #end
         } 

#declare T_Grass=
texture {
  pigment { color rgb <0.5, 1.15, 0.3> }
  #if (PreTrace = 0)
       finish{ambient 0 
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.1
               specular 0.1
               diffuse 0.3
               brilliance 1.6
              }
  #end
  normal {
    granite 0.5
    accuracy 0.01
    scale 10 //0.12
  }
  scale 1/200   
}

#declare T_Rock=
texture {
  pigment {
    agate
    color_map {
      [0.2 color rgb <0.55, 0.50, 0.50> ]
      [0.6 color rgb <0.75, 0.50, 0.60> ]
      [1.0 color rgb <0.70, 0.60, 0.60> ]
    }
    scale 1
    warp { turbulence 0.5 }
  }
  #if (PreTrace = 0)
       finish{ambient 0 
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.35
               specular 0.2
               diffuse 0.4
              }
  #end

  normal {
    granite 0.6
    scale 10 //0.1
  }
  scale 1/40
} 

#declare T_Snow=
texture {
  pigment {
    agate
    color_map {
      [0.0 color rgb <0.90, 0.90, 0.90> ]
      [0.5 color rgb <0.70, 0.70, 0.70> ]
      [1.0 color rgb <1.00, 1.00, 1.00> ]
    }
    scale 0.2
    warp { turbulence 0.5 }
  }
  #if (PreTrace = 0)
       finish{ambient 0 
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.6
               specular 0.2
               diffuse 0.4
              }
  #end
  normal {
    granite 0.4
    scale 0.5
  }
  scale 1/20 
}

#declare GroundTex=
         material {

                    fg_quick_grass (Camera_Pos, 10.0, "")
}


//  GROUND  //////////////

#declare Ground =
union{
difference {
   plane { y , 0
           material{GroundTex}
             #if (PreTrace = 0)
                 finish{ambient 0 
                       }
             #else
                 finish {ambient <0.8, 0.9, 1.4>*.35
                         specular 0.2
                         diffuse .4
                        }
             #end
         } 
   
   sphere_sweep {
     b_spline
     12,
     <River[0][0],  River[0][1],  River[0][2]>, River[0][3] + River[0][4]
     <River[1][0],  River[1][1],  River[1][2]>, River[1][3] + River[1][4]
     <River[2][0],  River[2][1],  River[2][2]>, River[2][3] + River[2][4]
     <River[3][0],  River[3][1],  River[3][2]>, River[3][3] + River[3][4]
     <River[4][0],  River[4][1],  River[4][2]>, River[4][3] + River[4][4]
     <River[5][0],  River[5][1],  River[5][2]>, River[5][3] + River[5][4]
     <River[6][0],  River[6][1],  River[6][2]>, River[6][3] + River[6][4]
     <River[7][0],  River[7][1],  River[7][2]>, River[7][3] + River[7][4]
     <River[8][0],  River[8][1],  River[8][2]>, River[8][3] + River[8][4]
     <River[9][0],  River[9][1],  River[9][2]>, River[9][3] + River[9][4]
     <River[10][0], River[10][1], River[10][2]>,  River[10][3] + River[10][4]
     <River[11][0], River[11][1], River[11][2]>,  River[11][3] + River[11][4]
     tolerance .000001 
   }

}

plane{y , -7 
      texture{ pigment { crackle
                         color_map{
                                   [0.0 color <  0,   0,   0>]
                                   [1.0 color <  1,   1,   1>]
                                  }
                        } scale 5
              }
     }
}

#declare Water = material {
           texture {
             pigment {     color rgbf <.5, .5, 1, .9>
              }
             finish {
               ambient 0.0
               diffuse 0.0
               reflection {
                            0.0, 1.0
                            fresnel on
                           }
               specular 0.4
               roughness 0.003
             }
             normal {
               function {
                 f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2) + sin(x*2.5)*.4
               } .8
               scale 0.13
             }
           }
           interior {
             ior 1.3
           }
         }


//  River  ////////////


#declare RiverObj=
sphere_sweep {
  b_spline
  12,
  <River[0][0],  River[0][3],  River[0][2]>, River[0][3] 
  <River[1][0],  River[1][3],  River[1][2]>, River[1][3] 
  <River[2][0],  River[2][3],  River[2][2]>, River[2][3] 
  <River[3][0],  River[3][3],  River[3][2]>, River[3][3] 
  <River[4][0],  River[4][3],  River[4][2]>, River[4][3] 
  <River[5][0],  River[5][3],  River[5][2]>, River[5][3]
  <River[6][0],  River[6][3],  River[6][2]>, River[6][3] 
  <River[7][0],  River[7][3],  River[7][2]>, River[7][3] 
  <River[8][0],  River[8][3],  River[8][2]>, River[8][3] 
  <River[9][0],  River[9][3],  River[9][2]>, River[9][3] 
  <River[10][0], River[10][3], River[10][2]>,  River[10][3]
  <River[11][0], River[11][3], River[11][2]>,  River[11][3]
  tolerance .000001
  scale <1,.1,1>
  translate <0,-1,0>
  material {Water scale 4}
  normal{ bozo 2 scale 10}
}

//  River Bank  ////////////


#declare RiverBank=
difference {

   sphere_sweep {
     b_spline
     12,
     <River[0][0],  River[0][1]+ River[0][4],  River[0][2]>, River[0][3] + River[0][4]
     <River[1][0],  River[1][1]+ River[1][4],  River[1][2]>, River[1][3] + River[1][4]
     <River[2][0],  River[2][1]+ River[2][4],  River[2][2]>, River[2][3] + River[2][4]
     <River[3][0],  River[3][1]+ River[3][4],  River[3][2]>, River[3][3] + River[3][4]
     <River[4][0],  River[4][1]+ River[4][4],  River[4][2]>, River[4][3] + River[4][4]
     <River[5][0],  River[5][1]+ River[5][4],  River[5][2]>, River[5][3] + River[5][4]
     <River[6][0],  River[6][1]+ River[6][4],  River[6][2]>, River[6][3] + River[6][4]
     <River[7][0],  River[7][1]+ River[7][4],  River[7][2]>, River[7][3] + River[7][4]
     <River[8][0],  River[8][1]+ River[8][4],  River[8][2]>, River[8][3] + River[8][4]
     <River[9][0],  River[9][1]+ River[9][4],  River[9][2]>, River[9][3] + River[9][4]
     <River[10][0], River[10][1]+ River[10][4], River[10][2]>,  River[10][3] + River[10][4]
     <River[11][0], River[11][1]+ River[11][4], River[11][2]>,  River[11][3] + River[11][4]
     tolerance .000001
     scale <1,.1,1> 
   }
   
   sphere_sweep {
     b_spline
     12,
     <River[0][0],  River[0][3],  River[0][2]>, River[0][3] 
     <River[1][0],  River[1][3],  River[1][2]>, River[1][3] 
     <River[2][0],  River[2][3],  River[2][2]>, River[2][3] 
     <River[3][0],  River[3][3],  River[3][2]>, River[3][3] 
     <River[4][0],  River[4][3],  River[4][2]>, River[4][3] 
     <River[5][0],  River[5][3],  River[5][2]>, River[5][3]
     <River[6][0],  River[6][3],  River[6][2]>, River[6][3] 
     <River[7][0],  River[7][3],  River[7][2]>, River[7][3] 
     <River[8][0],  River[8][3],  River[8][2]>, River[8][3] 
     <River[9][0],  River[9][3],  River[9][2]>, River[9][3] 
     <River[10][0], River[10][3], River[10][2]>,  River[10][3] 
     <River[11][0], River[11][3], River[11][2]>,  River[11][3] 
     tolerance .000001
     scale <1,.5,1>
     translate <0,-.5,0>
   }
 
   translate <0,-2,0> 
   texture{ pigment { crackle scale 2
                      color_map{
                                [0.0 color <  0,  0,  0> filter .9]
                                [1.0 color <  1,  1,  1> filter .9]
                               }
                     } 
           }
   #if (PreTrace = 0)
       finish{ambient 0 
             }
   #else
       finish {ambient <0.8, 0.9, 1.4>*.35
               specular 0.2
               diffuse .4
              }
   #end
} 

     

///////      Rock

  
#declare Rock = superellipsoid { <0.7, 0.7> 
                texture{T_Stone1}
                #if (PreTrace = 0)
                    finish{ambient 0 
                          }
                #else
                    finish {ambient <0.8, 0.9, 1.4>*.35
                            specular 0.2
                            diffuse .4
                           }
                 #end
                 double_illuminate
         } 
 

#declare T_Terrain1=
texture {
  //slope { -z*0.8 altitude z }
  gradient y scale 400
  texture_map {
    [0.00 T_Grass ]
    [0.10 T_Trees  ]
    [0.20 T_Trees  ]
    [0.30 T_Rock  ]
    [0.60 T_Snow  ]
    [1.00 T_Snow  ]
  }
} 


#declare Road =    //original y offset = 5
 array[12][3]
 {
   {  120,  5,  800},
   {  150,  5,  800},
   {  180,  5,  600}, 
   {  150,  5,  500}, 
   {   70,  5,  500}, 
   {   50,  5,  500},
   {  -70,  5,  500}, 
   {  -70,  5,  450},
   {  -90,  5,  500},
   { -200,  5,  500},
   { -400,  5,  600},
   { -600,  5,  600} 
 }


#declare Terrain=
            height_field {
            tga "Land1.tga"
            smooth
            rotate y*-90
            scale <2000,400,1200> 
            translate<900,-150,1000>  //translate <-600,.0001,800>
          }

  

// Road  ////////////////
#declare RoadObj=
sphere_sweep {
  b_spline
  12,
  <Road[0][0],  Road[0][1]+5,  Road[0][2]>,  5
  <Road[1][0],  Road[1][1]+5,  Road[1][2]>,  5
  <Road[2][0],  Road[2][1]+5,  Road[2][2]>,  5
  <Road[3][0],  Road[3][1]+5,  Road[3][2]>,  5
  <Road[4][0],  Road[4][1]+5,  Road[4][2]>,  5
  <Road[5][0],  Road[5][1]+5,  Road[5][2]>,  5
  <Road[6][0],  Road[6][1]+5,  Road[6][2]>,  5
  <Road[7][0],  Road[7][1]+5,  Road[7][2]>,  5
  <Road[8][0],  Road[8][1]+5,  Road[8][2]>,  5
  <Road[9][0],  Road[9][1]+5,  Road[9][2]>,  5
  <Road[10][0], Road[10][1]+5, Road[10][2]>,  5
  <Road[11][0], Road[11][1]+5, Road[11][2]>,  5
  tolerance .000001                         
  scale <1,.1,1>
  texture {
      pigment {
          bozo   scale 4
          color_map { 
              [0  rgb <0.64, 0.16, 0.16>]
              [.5 rgb <0.36, 0.25, 0.20>]              
              [.5 rgb <0.59, 0.41, 0.31>]
              [.6 rgb <0.59, 0.41, 0.31>]
              [.6 rgb <0.32, 0.08, 0.08>]
              [1  rgb <0.32, 0.08, 0.08>]
          }
      }
 } 
             #if (PreTrace = 0)
                 finish{ambient 0 
                       }
             #else
                 finish {ambient <0.8, 0.9, 1.4>*.35
                         specular 0.2
                         diffuse .4
                        }
                 #end
         
}


