#version 3.5; 

#include "colors.inc"
#include "stones.inc" 
#include "functions.inc"
#include "woods.inc"
#include "fgrass.inc"
#include "BIRCH.inc"
#include "TOMTREE.inc"


#declare camera_location = < 0, 75, -150> ; 
#declare camera_look_at = < 0, 90, 0> ; 
#declare effect_location = < -230, 340, 570> ;
#declare effect_type = "Star2"
#declare rays_type = 1;
#declare effect_scale = < .15, .15, 1.0 >; 

#include "LnsEfcts.inc"  
#include "Lens.inc"    



#declare R1 = seed (43876); 
#declare R2 = seed (56543);
#declare High_MSamples = 0;  
#declare Camera_Pos = <0,75,-150>;  // standard <0,135,-100>   low  <0,75,-100>   

#declare Rad_Quality = 2;
#declare PreTrace = 1;  //0 = compute radiosity only  1 = final render 

#include "BeanSky.inc"
#include "BeanGnd.inc"
#include "BeanOthr.inc"  

#declare SunType = 2;      //  1 = overhead, 2 = backlit, 3 = front lit, 4 = media sun
     
#declare Sun_Pos=<-10,120,300>;    // 
#declare Sun_Color=<1,.1,0>;   //1,1,1
#declare SunBeam_Color=<1,.5,0>;   //1,.5,.3
#declare SunCamera_Dir=vnormalize(Sun_Pos-Camera_Pos);



#global_settings{assumed_gamma 1  
                 max_trace_level 200
#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
    pretrace_start 0.08
    pretrace_end   0.02
    count 50
    error_bound 0.5
    recursion_limit 1
    brightness 2
    media on
    normal on
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.01
        count 120
        error_bound 0.25
        recursion_limit 1
        brightness 3
        media on
        normal on 
        always_sample on
        save_file "BeanRad2"
     #else 
        load_file "BeanRad2"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
    pretrace_start 0.08
    pretrace_end   0.005
    count 400
    error_bound 0.1
    recursion_limit 1
    media on
    normal on
  }
 #break
 #case (4)
  radiosity {             // --- Settings 4 (medium quality, recursion_limit 2) ---
    pretrace_start 0.08
    pretrace_end   0.005
    count 350
    error_bound 0.15
    recursion_limit 2
    media on
    normal on
  }
 #break
 #end

}


camera {
   location Camera_Pos
   up       y
   right    x
   angle    50
   look_at  <0,90,0> //  standard <0,130,0>  low  <0,85,0>
}
 

#switch (SunType)
  #case (1)
    light_source {
       <0,1000,-500>   // overhead
       color rgb <1,1,1>
       media_interaction off
       media_attenuation off
     }
     sky_sphere {  // reset colors to black for night   overhead
        pigment {
           gradient y
           color_map {
            [0 SkyBlue ]  
            [1 CadetBlue] //*1 if sun over head, * .3 if sun on horizon 
            }
           scale 2
           translate -1
         }
       }
    fog {
         fog_type 2
         distance 900
         color rgbt<0.2, 0.2, 0.5,.4>
         fog_offset 50
         fog_alt 5
         turbulence 2
         turb_depth .5
    }
  #break //First case ends
  #case (2)
     light_source { <0,1000,10000> rgb Sun_Color*.5+.5*vlength(Sun_Color)// Camera_Pos+SunCamera_Dir*10000
       media_interaction on
       media_attenuation on
     }
    light_source {
       <0,1000,-500>   // overhead
       color rgb <1,1,1>
       media_interaction off
       media_attenuation off
     }
      sky_sphere {  // back lit
        pigment {
           gradient y
           color_map {
            [0 rgb <.7,0,0>]  
            [.7 SkyBlue * .3] //*1 if sun over head, * .3 if sun on horizon 
            }
           scale 2
           translate -1
         }
       }
    fog {
         fog_type 2
         distance 1700
         color rgbt<0.2, 0.2, 0.5,.4>
         fog_offset 50
         fog_alt 5
         //turbulence 2
         //turb_depth .3
    } 
  #break //Second case ends
  #case (3)
    light_source {
       <0,1000,-1000>   //frontlit
       color rgb <1,1,1>   //for night, or moon light set intensity ot .1
       media_interaction off
       media_attenuation off
     }
      sky_sphere {  // front lit
        pigment {
           gradient y
           color_map {
            [0 SkyBlue * .3]  
            [1 RichBlue] //*1 if sun over head, * .3 if sun on horizon 
            }
           scale 2
           translate -1
         }
       }
  #break //Third case ends
  #case (4)
     light_source{Camera_Pos+SunCamera_Dir*300 rgb Sun_Color*.5+.5*vlength(Sun_Color)}
     cone{Camera_Pos+SunCamera_Dir*200,.6 Camera_Pos+SunCamera_Dir*1,1.2  
     hollow 
     pigment{rgbt <0,0,0,1>}
     interior{
              media{
                     scattering{4,(.05*(SunBeam_Color*.6+.2*vlength(SunBeam_Color))) *vnormalize(<.5,.5,1>) extinction .1}
                     method 3 
                     intervals 1 
                     samples 5,25
                   }
     }
     no_shadow
     }
      sky_sphere {  // media sun
        pigment {
           gradient y
           color_map {
            [0 rgb <.7,0,0>]  
            [.7 SkyBlue * .3] //*1 if sun over head, * .3 if sun on horizon 
            }
           scale 2
           translate -1
         }
       }
    fog {
         fog_type 2
         distance 800
         color rgbt<0.2, 0.2, 0.5,.2>
         fog_offset 10
         fog_alt 20
         turbulence 2
         turb_depth .5
    }
   #break //Fourth case ends
#end // End of conditional part


#object { Ground } 


#object{Cloud8 translate<0,99,0>}   

#object{ Castle translate <46,180,100> } 

#object{ Flag translate <46.5,211,100> } 

#object{Building2 rotate y*90 translate <0,5,450> }     //village1
#object{Building3 rotate y*-90 translate <50,5,450> }    //village2
#object{Building2 rotate y*-90 translate <100,5,550> }   //village3

#object{Building2 rotate y*90 translate <-35,5,550> }   //village4
#object{Building3 rotate y*90  translate <10,5,600> }    //village5
#object{Building2 rotate y*-90  translate <60,5,600> }    //village6

#object{Building2 translate <-150,5,550> } //Jacks  -150 = x


#object{RoadObj } 

#object{Stalk} 
#object {Leaves}  

#object{RiverObj}   
#object{RoadObj } 
#object {RiverBank}    
#object{RiverGrass}    

#declare MountainLight=
  light_source {
       0*x                                         // light's position (translated below)
       rgb (Sun_Color*.5+.5*vlength(Sun_Color))*.5      // light's color
       translate <0, 160, 500>                     // <x y z> position of light
       media_interaction off
       media_attenuation off
  }
 
light_group {
  light_source{MountainLight}
  object {
            Terrain
            texture { T_Terrain1 }
  }  
  global_lights off
}
      

#object
{
 TREE
 scale 60  //70
 translate <40,0,80>
 double_illuminate
 //no_shadow
} 
 

#object{
 TREE
 scale 100
 translate <-110,0,120>
 double_illuminate 
 //no_shadow
}   
 
#object {Bushes1 // 19 +- 13  
         translate <4, 0, 50>
         }

#object {Bushes1 // 19 +- 13  
         translate <30, 0, 60>
         }

#object {Bushes1 // 19 +- 13  
         translate <4, 0, 130>
         }
#object{ Bushes2
         translate <75, 0, 400>
       }
       
#object{ Bushes2
         translate <30, 0, 500>
       }
       
#object{ Bushes2
         translate <120, 0, 610>
       }
       
#object{ Bushes2
         translate <-50, 0, 450>
       }
       

//Folage

   #declare N4 = 0; 

   #while (N4<15)
      #object {Bushes1
               translate <-150 + rand(R2) * 450, 0, 630 + rand(R2) * 400>
      }
      #object {Bushes2
               translate <-150 + rand(R2) * 450, 0, 630 + rand(R2) * 400>
      }         
      #declare N4=N4+1;
   #end   




//+sc0.240469 +sr0.478488 +ec0.695992 +er0.773142 stalk & buildings
//+sc0.366569 +sr0.581486 +ec0.416422 +er1.000000 vertical strip
//+sc0.000000 +sr0.582790 +ec0.916911 +er1.000000  baottom half

