/* GUILIN.POV - Programmed by Maarten Hofman */
/* 071002: Second attempt for the competition */
/* 101002: Changed heightfield, added palm trees */
/* 111002: Removed the single tree on the mountain */
/* 301002: Clean up */

#include "colors.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"
#include "functions.inc"  
#include "fkpalm01.inc"
#include "palms.inc"
     
#declare r1=seed(1);
 
#declare ground = texture {
  bozo         
  turbulence <30,10,10>
  texture_map {
    [0.0 pigment { colour DarkBrown } ]  
    [0.1 pigment { colour Mica } ]
    [0.2 T_Grnt15 /* pigment { colour DarkTan } */ ]
    [0.3 pigment { colour Black } ]
    [0.4 pigment { colour DarkSlateGray } ]
    [0.5 T_Grnt25 /* pigment { colour IndianRed } */ ]
    [0.6 T_Grnt17 /* pigment { colour DarkGreen } */ ]
    [0.7 pigment { colour DarkOliveGreen } ]
    [0.8 T_Grnt7 /* pigment { colour Salmon } */ ]   
    [0.9 pigment { colour BakersChoc } ]
    [1.0 pigment { colour VeryDarkBrown } ]
  }                      
}
camera {
  location <-25,10,0>
  look_at <1,9,100>
}          

object {
  palmx1     
  scale <0.1,0.1,0.1>
  translate <6,10,20>
}

fog {
  distance 300
  color rgbt <0.5,0.5,0.5,0.3>  
  turbulence 0.2    
  turb_depth 0.3
}
     
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0 colour Orange]
      [1 colour Red]
    }
  } 
  pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    rotate -135*x
}


#declare cloud = sphere { <0,0,0>,1 
  hollow 
  texture { 
    pigment { 
      rgbt <1,1,1,1>
    }    
    finish {
      ambient 0
      diffuse 0
    }
  }
  interior {
    media { 
         intervals 30
         ratio 0.9
         samples 2,4
         confidence 0.9
         variance 1.0/128.0
         method 1
         absorption <0.0,0.0,0.0>
         emission <0.025,0.025,0.025>
         scattering {
            1, <0,0,0>
            extinction 0
         } 
         
         density {
            spherical
            density_map {
               [0.0 colour <0.2,0.1,0> ]
               [1.0 colour 1 ]
            }
         }
          
         density {
            bozo
            scale 0.2
            density_map {
               [ 0.0 colour <0.2,0.1,0> ]
               [ 1.0 colour 1 ]
            }
         }
    } 
  }    
  scale <2000,400,400>       
}

cylinder {
  <200,310,1050>,
  <200,310,1051>,50
  pigment {
    White
  }   
  finish {
    ambient 1
    reflection 1
  }
}

object {
  cloud
  translate <200,310,1050>
}

light_source { <199,299,1000> color <1,0.9,0.9> }
light_source { <198,298,999> color <1,0.9,0.9> }

#declare water = material {
  texture {
    pigment {
      color rgbt <1, 1, 1, 1>
    }
    finish {
      ambient 0.0
      diffuse 0.0

      reflection {
        0.0, 1.0
        fresnel on
      }

      specular 0.4
      roughness 0.003
    }
    normal {
      function {
        f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2)
      } 0.8
    }
  }
  interior {
    ior 1.3
  }

}   

plane {
  y,0
  material {
    water
  }  
}    

height_field {
  png "height.png"
  smooth       
  scale <800,300,800>
  texture {
    ground
  }
  translate <-270,-60,-80>       
}

object {
  palmx1
  scale <0.6,0.4,0.6>
  rotate <0,0,-20>
  rotate <20,0,0>
  translate <-70,0,140>
}

object {
  palmx1
  scale <0.6,0.4,0.6>
  rotate <0,0,-25>
  rotate <25,0,0>
  translate <-65,2.5,150>
}

object {
  palmx1
  scale <0.6,0.4,0.6>
  rotate <0,0,-15>
  rotate <15,0,0>
  translate <-60,5,170>
}

object {
  palmx1
  scale <0.6,0.4,0.6>
  rotate <0,0,-20>
  rotate <20,0,0>
  translate <-50,2.5,180>
}

object {
  palmx1
  scale <0.6,0.4,0.6>
  rotate <0,0,-25>
  rotate <25,0,0>
  translate <-50,10,200>
}

object {
  palmx1
  scale <0.6,0.4,0.6>
  rotate <0,0,-10>
  rotate <20,0,0>
  translate <-40,15,240>
}

object {
  palmx1
  scale <0.6,0.4,0.6>
  rotate <0,0,-20>
  rotate <10,0,0>
  translate <-30,12.5,260>
}

object {
  palmx1
  scale <0.6,0.4,0.6>
  rotate <0,0,-15>
  rotate <5,0,0>
  translate <0,2.5,250>
}

palmtree(<-45,27.5,220>)
palmtree(<-55,17.5,175>)
palmtree(<-65,12.5,145>)
palmtree(<-35,22.5,205>)
