// Paisajes Internos ( Internal Landscapes )
// Internet Ray-Tracing Competition  
// September - October 2002 | Spectacular Landscapes
// Author: luisvaloyes | Bogota | Colombia
// http://www.luisvaloyes.uni.cc
// arte3d@luisvaloyes.uni.cc 
//
// This scene must be rendered using POV-Ray 3.5 or later
// Esta escena debe ser renderizada usando POV-Ray 3.5 o posterior
//
// You can use all the objects and textures in this scene for your own scenes, but if you do please
// add a link to my website from yours.
//
// Usted puede utilizar todos los objetos y texturas de esta escena en sus propias escenas, pero si
// lo hace por favor incluya un enlace a mi sitio web desde el suyo.
//
// Nota: los comentarios en castellano no llevan acentos ni caracteres especiales intencionalmente

// the camera used for the final scene || la camara usada en la escena final
camera {location <10,10,27> look_at <-40,10,-37> }

// a camera used for object's placement || una camara usada para ubicar los objetos
//camera {orthographic up <0,80,0> right <80,0,0> location <0,40,0> look_at <0,0,0>}

// additional lights for pre-renders || luces adicionales para vistas previas de la escena
//light_source {<0,29,0> rgb <1,1,1>}  
//light_source {<0,29,20> rgb .5} 
//light_source {<0,29,-20> rgb .5} 

#include "todas.inc"

// the room - walls, floor, ceiling, windows || el salon - paredes, piso, techo, ventanas
object {salon001}

// the easels with the paintings || los caballetes con las pinturas
object {caballete01 rotate <0,5,0> translate <-21,0,-16>}
object {caballete04 rotate <0,-7,0> translate <-1.5,0,-13>} 
object {caballete02 rotate <0,5,0> translate <9,0,2>} 
object {caballete05 rotate <0,15,0> translate <-13,0,9>}

// the student's chairs || las bancas de los estudiantes
object {butaca rotate <0,-15,0> translate <-23,0,-6>}
object {butaca rotate <0,5,0> translate <-2,0,-4>}  
object {butaca rotate <0,29,0> translate <7,0,11>} 
object {butaca rotate <0,-35,0> translate <-13,0,19>}  

// the lamps that iluminate the room || las lamparas que  iluminan el salon
object {lamptecho translate <-15,30,-20>}
object {lamptecho translate <8,30,-20>}
object {lamptecho translate <-15,30,20>}
object {lamptecho translate <8,30,20>}
object {lamptecho translate <-15,30,0>}
object {lamptecho translate <8,30,0>}

// the fans in the ceiling || las rejillas en el cieloraso
object {rejilla translate <-5,30,-25>}
object {rejilla translate <-25,30,-25>}
object {rejilla translate <-5,30,-5>}
object {rejilla translate <-25,30,-5>} 
object {rejilla translate <15,30,-5>}
object {rejilla translate <15,30,-25>}
 
// the wall clock || el reloj de pared
object {reloj01 translate <-16,22.5,-40>} 

// the posters on the wall || los afiches en la pared 
object {afiche01 translate <-25,22,-40>}  
object {afiche02 translate <-3,24,-40>}  

//the warning signal on the window || el aviso de advertencia en la ventana 
object {aviso001 rotate <0,-90,0> translate <-39,21.5,0>}  

//the poster on the window || el afiche en la ventana
object {afiche03 rotate <0,90,0> translate <-39.45,19,7>}

// the external light || la luz exterior
light_source {<0,1000,0> rgb 1 shadowless} 

// the neighbour building || el edificio vecino
object {habitatx0 rotate <0,90,0> translate <-140,0,-40>} 

// the sky | el cielo
object {cielo0 translate <-500,-200,-500>}

// the teacher's chair and desk || silla y escritorio del profesor
object {escrisilla rotate <0,200,0> translate <-14,0,-28>}

// shelf with several objects || estante con varios objetos
object {estante01 rotate <0,90,0> translate <-35,0,7>} 
object {bastidor rotate <-90,80,0> translate <-30,5.5,7>}  
object {bastidor rotate <-90,95,0> translate <-30,5.7,7>} 
object {bastidor rotate <-90,70,0> translate <-30,5.9,7>}
object {tarro01 rotate <0,30,0> translate <-34,.7,3>}
object {tarro01 rotate <0,-30,0> translate <-35,.7,5>}
object {tarro01 rotate <0,70,0> translate <-36,.7,8>}
object {tarro01 rotate <0,120,0> translate <-36,2.2,8>}
object {tarro01 rotate <0,90,0> translate <-36,.7,3>}
object {frasco001 rotate <0,30,0> translate <-35,7.8,4>}
object {frasco001 rotate <0,-40,0> translate <-34,7.8,3>}
object {frasco002 rotate <0,30,0> translate <-35,7.8,8>}
object {frasco002 rotate <0,70,0> translate <-34,7.8,10>}
object {tarro01 rotate <0,-30,0> translate <-37,7.8,4>}

// garbage basket || canasta para la basura
object {caneca translate <-16,0,-23>}

// the student's bags || las maletas de los estudiantes
object {maleta01 rotate <0,20,0> translate <-19,0,-6>}
object {maleta03 rotate <0,-30,0> translate <-7,0,-7>} 
object {maleta02 rotate <0,120,0> translate <-8,0,17>}

// the pencils, books and notebooks || los lapices, libros y cuadernos
object {libro02 rotate <0,150,0> translate <-7,0,13>} 
object {cuaderno01 rotate <0,120,0> translate <8.5,4.2,10>}
object {cuaderno02 rotate <0,-10,0> translate <6,4.2,12>}
object {libro03 rotate <0,-70,0> translate <-15,4.2,18>}
object {libro01 pigment {rgb <.7,.3,0>} rotate <0,190,0> translate <-17,7.3,-26.5>}  
object {libro01 pigment {rgb <0,.3,.7>} rotate <0,3,0> translate <-17,7.7,-26.5>}
object {libro01 pigment {rgb <1,.3,.5>} rotate <0,172,0> translate <-17,8.1,-26.75>}
object {lapiz01 pigment {rgb <.9,.8,0>} rotate <0,30,0> translate <5.5,4.28,12>}
object {lapiz01 pigment {rgb <.2,.7,.8>} rotate <0,-100,0> translate <7,4.36,10>}

// the gas masks || las mascaras antigases
object {mascara01a rotate <0,-30,0> translate <-14,7.3,-28>} 
object {mascara01a rotate <0,-7,0> translate <-4,0,9>}
object {mascara01a rotate <0,80,0> translate <-23,4.2,-6>} 
object {mascara01a rotate <0,70,0> translate <-2,4.2,-4>}

// the human figures || las figuras humanas
object {hombre01 scale .75 rotate <0,-50,0> translate <-13,0,14.5>} 
object {hombre02 scale .75 rotate <0,-87,0> translate <-23,0,-10>}
object {hombre03 scale .75 rotate <0,82,0> translate <-10,0,-5>}
