/*
 * createwillow.pov - Maurizio Tomasi 2002 (zio_tom78@hotmail.com)
 *                    Visit my website at http://www.geocities.com/zio_tom78
 *
 * Run this macro to create the trees used in the "lilypond.pov" file.
 *
 * Created with POV-Ray 3.5 under Linux version 2.4.18-3 (Red Hat 7.3)
 */

#include "colors.inc"
#include "txttree.inc"
#include "maketree.pov" // tree & leaf macro

//-----------------------------------------
// tree texture with a image_map
//-----------------------------------------
#declare txtWillowTree =
  texture {
    pigment {
      image_map {
	jpeg "bark.jpg"
	map_type 2
	interpolate 2
      }
    }

    normal {
      bump_map {
	// These normals were created using the "Emboss" filter
	// with The GIMP.
	jpeg "bark-normals.jpg"
	bump_size 2.0
      }
    }

    finish { ambient 0 }
    
    scale <1.0, 3.0, 1.0>
  }

//-----------------------------------------
// Yellow and greenish (need scaling)
//-----------------------------------------
#declare colLeaf_1 =
  rgb <0.7,1,0.2> * 0.3; // greenish 
#declare colLeaf_2 =
  rgb <1,0.7,0.2> * 0.3; // yellow
#declare txtWillowLeaf =
  texture {
    pigment {
      agate color_map {
	[0.0 color colLeaf_1]
	[0.3 color colLeaf_2]
	[0.7 color colLeaf_2]
	[1.0 color colLeaf_1] 
      }
    }       
    finish {
      ambient 0.1
      roughness 0.01
    }
    
    scale 10
  }

//=========================================
// Tree macro Parameters
//-----------------------------------------
// These parameters must be declared before calling the tree macro
//-----------------------------------------
#declare dofile=true;    // true creates a tree file ; false otherwise
#declare dotexture=true;  // true creates a textured tree (with the texture following the branch); false otherwise
#declare txtTree=texture{txtWillowTree} // Bark texture

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
#declare rsd=211;      // random seed
//#declare rsd=212;      // random seed
//#declare rsd=213;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

//-----------------------------------------
// Tree structure parameters        
// test with low level0 and nseg0 (3 or 4)
// High (>=6) recursion levels [level0] gives more complex trees
// High (>=6) segment numbers [nseg0] gives smoother trees
//-----------------------------------------
#declare level0=4;      // recursion level
//#declare level0=2;      // recursion level
#declare nseg0=10;       // initial number of branch segments (decreases of one at each level)
#declare nb=7;          // max number of branches per level
#declare dotop=false;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=40;        // initial branch length
#declare rb0=2;         // initial branch radius
#declare ab0=95;        // initial branch angle (x angle between the trunk and the first branch)
#declare qlb=0.6;       // branch length decrease ratio (1=constant length)
#declare qrb=0.4;       // branch radius decrease ratio (1=constant radius)
#declare qab=0.7;       // branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=1; // probability of branch apparition 
#declare jb=0.5;        // secondary branches start after this ratio of branch length

#declare fgnarl=0.4;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0.5; // probability to have a twig on a trunk segment

#declare v0=<0,1,0>;    // initial direction - change to give an initial orientation
#declare pos0=<0,0,0>;  // initial trunk position (no need to change this one)

//-----------------------------------------
// constraints parameters
//-----------------------------------------
#declare vpush=<0,-1,0>;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity
#declare fpush=0.4;       // force of push
#declare aboveground=10; // constrains the branches above this level 
#declare belowsky=180;  // constrains the branches below this level 

//-----------------------------------------
// root parameters
//-----------------------------------------
#declare rootproba=1;   // probability of root 0=no root ; 1=all [nb] roots
#declare nroot=5;      // number of main roots;
#declare vroot=<1,-0.1,0>; // initial direction of root 
#declare yroot=<0,1.5,0>;   // initial position of root above ground

//-----------------------------------------
// leaf position parameters
//-----------------------------------------
#declare leafproba=0.8; // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=4;   // level where the leaves start to appear
#declare alz0=40;       // max z angle for leaf
#declare alx0=-20;      // start x angle for leaf
#declare stdalx=40;     // std x angle for leaf
#declare stdlsize=0.5;     // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare txtLeaf=texture{txtWillowLeaf} // Leaf texture
#declare lsize=0.4;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=15;         // leaf length
#declare wl=1;          // leaf width 
#declare fl=0.5;        // depth of leaf fold
#declare lpow=2;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=1;      // number of lobes (individual leaves)
#declare alobes=280;    // angle made by all the lobes
#declare qlobes=0.6;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=3;          // stalk length (0=no stalk)
#declare ws=0.1;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward
//-----------------------------------------
// end of parameters
//=========================================

/////////////////////////////////////////////////////////////////////////////


#declare ftname="gttree1.inc" // file name for tree
#declare fvname="gtfoliage1.inc" // file name for foliage
#declare ffname="gtleaf1.inc" // file name for leaf

object {
  #if (leafproba > 0)
    #declare Leaf =
    object {
      MakeLeaf (lsize, seg, ll, wl, fl, lpow, al, apow, 
	ndents, nlobes, alobes, qlobes, ls, ws, as, dofile, ffname)
      
      #if (dotexture=false)
	// no texture applied to tree segments, so the leaf texture
	// must be used for the individual leaf
	texture{txtLeaf}
      #end
    }
    
  #end              
  MakeTree()
  
  #if (dotexture = true)
    // texture is already applied to tree so that we can safely
    // apply the leaf texture to the leaves
    texture {txtLeaf}
  #else
    // apply tree texture, regardless of the tree structure
    texture {txtTree}
  #end
  
  // Update the following lines after changes in the tree structure!
  
  #local MinPoint = <-31.857,-6.578,-35.153>;
  #local MaxPoint = <36.836,60.534,37.899>;
  bounded_by {
    box { MinPoint, MaxPoint }
  }
  
  #local Size = MaxPoint - MinPoint;
  #local NewPos = -MinPoint - Size/2;
  translate <NewPos.x, -MinPoint.y, NewPos.z>
}


//////////////////////////////////////////////////////////////////////////


#declare rsd=212;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

#declare ftname="gttree2.inc" // file name for tree
#declare fvname="gtfoliage2.inc" // file name for foliage
#declare ffname="gtleaf2.inc" // file name for leaf

#declare aboveground=10; // constrains the branches above this level 
#declare belowsky=120;  // constrains the branches below this level 

#declare lsize=0.6;     // leaf size
#declare ll=8;         // leaf length
#declare wl=2;          // leaf width 
#declare fl=0.5;        // depth of leaf fold
#declare lpow=3;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf

object {
  #if (leafproba > 0)
    #declare Leaf =
    object {
      MakeLeaf (lsize, seg, ll, wl, fl, lpow, al, apow, 
	ndents, nlobes, alobes, qlobes, ls, ws, as, dofile, ffname)
      
      #if (dotexture=false)
	// no texture applied to tree segments, so the leaf texture
	// must be used for the individual leaf
	texture{txtLeaf}
      #end
    }
    
  #end              
  MakeTree()
  
  #if (dotexture = true)
    // texture is already applied to tree so that we can safely
    // apply the leaf texture to the leaves
    texture {txtLeaf}
  #else
    // apply tree texture, regardless of the tree structure
    texture {txtTree}
  #end
  
  // Update the following lines after changes in the tree structure!
  
  #local MinPoint = <-31.857,-6.578,-35.153>;
  #local MaxPoint = <36.836,60.534,37.899>;
  bounded_by {
    box { MinPoint, MaxPoint }
  }
  
  #local Size = MaxPoint - MinPoint;
  #local NewPos = -MinPoint - Size/2;
  translate <NewPos.x, -MinPoint.y, NewPos.z>
}


//////////////////////////////////////////////////////////////////////////




#declare rsd=214;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

#declare ftname="gttree3.inc" // file name for tree
#declare fvname="gtfoliage3.inc" // file name for foliage
#declare ffname="gtleaf3.inc" // file name for leaf

#declare aboveground=30; // constrains the branches above this level 
#declare belowsky=170;  // constrains the branches below this level 

#declare leafproba=0.9; // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=3;   // level where the leaves start to appear

#declare lsize=0.2;     // leaf size
#declare ll=5;   // leaf length
#declare wl=4;   // leaf width 
#declare fl=0.5; // depth of leaf fold
#declare lpow=2; // modifies the leaf shape : lpow=3 makes heart-shaped leaf

object {
  #if (leafproba > 0)
    #declare Leaf =
    object {
      MakeLeaf (lsize, seg, ll, wl, fl, lpow, al, apow, 
	ndents, nlobes, alobes, qlobes, ls, ws, as, dofile, ffname)
      
      #if (dotexture=false)
	// no texture applied to tree segments, so the leaf texture
	// must be used for the individual leaf
	texture{txtLeaf}
      #end
    }
    
  #end              
  MakeTree()
  
  #if (dotexture = true)
    // texture is already applied to tree so that we can safely
    // apply the leaf texture to the leaves
    texture {txtLeaf}
  #else
    // apply tree texture, regardless of the tree structure
    texture {txtTree}
  #end
  
  // Update the following lines after changes in the tree structure!
  
  #local MinPoint = <-31.857,-6.578,-35.153>;
  #local MaxPoint = <36.836,60.534,37.899>;
  bounded_by {
    box { MinPoint, MaxPoint }
  }
  
  #local Size = MaxPoint - MinPoint;
  #local NewPos = -MinPoint - Size/2;
  translate <NewPos.x, -MinPoint.y, NewPos.z>
}


//////////////////////////////////////////////////////////////////////////


#declare txtLeaf = txtWillowLeaf;
#declare txtTree = txtWillowTree;

#declare Leaf=
  #include "gtleaf3.inc"

#declare Foliage =
  #include "gtfoliage3.inc"

#declare Tree =
  #include "gttree3.inc"

// perspective (default) camera
camera {
  location  <0.0, 30.0, -100.0>
  look_at   <0.0, 30.0,  0.0>
  right     x*image_width/image_height
}

light_source {
  0*x                  
  color rgb <1,1,1>    
  translate <-200, 400, -200>
}


#declare Willow =
  union {
    object {
      Foliage
      
      texture { txtLeaf }
    }
    
    object {
      Tree
    }
  }

object {
  Willow
}
