/*
 * lily.inc - Maurizio Tomasi 2002 (zio_tom78@hotmail.com)
 *            Visit my website at http://www.geocities.com/zio_tom78
 *
 * Waterlilies (petals and leaves).
 */

#declare lilyStream = seed (13);
#declare leafStream = seed (17);
  
#declare petalStream = seed (14);

#declare LilyPetalPigment1 =
  pigment {
    bozo
    turbulence 3
    color_map {
      [0.00 color rgb <0.92, 0.08, 0.11> * 0.8]
      [0.80 color rgb 1 * 0.8]
      [1.00 color rgb 1 * 0.8]
    }
  }

#macro LilyPetalPigment2 ()
  #switch (floor (RRand (0, 3, petalStream)))
    #case (0)
      color rgb 1 * 0.8
    #break
    
    #case (1)
      color rgb <0.93, 0.74, 0.83> * 0.8
    #break
    
    #case (2)
      color rgb <0.95, 0.94, 0.62> * 0.8
    #break
  #end
#end

#declare LilyPetal =
  intersection {
    difference {
      sphere { <0, 1, 0>, 1 }
      sphere { <0, 1, 0>, 0.985 }
    }
    
    object {
      sphere { <0, 0, -0.5>, 1 }
      
      scale <0.5, 1.0, 1.0>
    }
    
    scale <0.7, 1.0, 1.0>

    pigment { rgbt <1, 1, 1, 1> }
  }


#declare LeafHeight = 0.025;

#declare LilyLeafBase = 
  height_field {
    png "lily-leaf.png"
    water_level 0.01
    
    scale <1.0, LeafHeight, 1.0>
    translate <-0.5, -LeafHeight, -0.5>
    rotate 180*z
    scale <3.5, 1.0, 3.5>

    // This is just to remove those boring warning messages...
    pigment { color rgbt <1, 1, 1, 1> }
    
    finish { phong 0.4 phong_size 60 }
  }


#macro LilyLeaf (ColorIndex)
#local LeafColors = array[3]
#local LeafColors[0] = <0.59, 0.70, 0.55>;
#local LeafColors[1] = <0.33, 0.55, 0.27>;
#local LeafColors[2] = <0.50, 0.72, 0.24>;

object {
  LilyLeafBase

  texture {
    pigment { color rgb LeafColors[ColorIndex] }
  }

  // Add some brown spots to the leaf

  #local SpotColor = <0.64, 0.58, 0.09, 0.4>;
  texture {
    pigment {
      wrinkles
      turbulence 3.8
      color_map {
	[0.0 0.6 color rgbt 1 color rgbt 1]
	[0.6 0.7 color rgbt 1 color rgbt SpotColor]
	[0.7 1.0 color rgbt SpotColor color rgbt SpotColor]
      }
      scale 0.3
    }
  }
}
#end

#macro Waterlily (NumOfPetals, LeafColorIndex)
union {
  sphere {
    <0.0, 0.25, 0.0>, 0.25
    pigment { color rgb <0.89, 0.65, 0.70> }
  }
  
  object {
    LilyLeaf(LeafColorIndex)
    
    scale RRand (0.7, 1.2, leafStream)
  }

  #local NumOfPetals = 8;
  #local Count = 0;
  #local PetalPigment =
  pigment {
    gradient y
    pigment_map {
      [0.3 LilyPetalPigment1]
      [0.6 LilyPetalPigment2 ()]
    }
  }

  #while (Count < NumOfPetals)
    object {
      LilyPetal
      
      texture { pigment { PetalPigment } }
      
      rotate RRand (-10, 10, petalStream) * x
      rotate 360 / NumOfPetals * Count * y
    }

    object {
      LilyPetal

      pigment { PetalPigment }
      
      rotate RRand (-5, 5, petalStream) * x
      rotate 360 / NumOfPetals * (Count + 0.5) * y
      
      scale <0.6, 1.2, 0.6>
    }

    #local Count = Count + 1;
  #end
}
#end

#macro WaterlilyBunch (lilies, lilyRadius, leaves, leafRadius)
union {
  #local Count = 0;
  #while (Count < lilies)
    #local Radius = RRand (0, lilyRadius, lilyStream);
    #local Angle = RRand (0, 360, lilyStream);
    
    #local NewPos = <Radius * cos (Angle), 0.0, Radius * sin (Angle)>;

    object {
      Waterlily (RRand (6, 10, lilyStream), floor (RRand (0, 3, leafStream)))

      scale RRand (0.75, 1.25, lilyStream)
      
      translate NewPos
      rotate RRand (0, 360, lilyStream) * y
    }
    #local Count = Count + 1;
  #end
  
  #local Count = 0;
  #while (Count < leaves)
    #local Radius = RRand (0, leafRadius, leafStream);
    #local Angle = RRand (0, 360, leafStream);
    #local Elevation = floor (RRand (-7, 7, leafStream));
    
    #local NewPos = <Radius * cos (Angle),
    Elevation * LeafHeight - 0.3333333, Radius * sin (Angle)>;

    object {
      LilyLeaf (floor (RRand (0, 3, leafStream)))
      
      translate NewPos
      rotate RRand (0, 360, leafStream) * y
    }
    #local Count = Count + 1;
  #end
 
}
#end
