//=========================================
// Leaf & Tree examples for the MakeTree macro
// (c) 1999 Gilles Tran tran@inapg.inra.fr
//=========================================
// Curved tree with long branches
// The curvature is obtained through the vpush vector <1,-0.8,0>
//-----------------------------------------
// This file calls the MakeTree and MakeLeaf macros
// and defines the textures and parameters
// Set the [dofile] parameter to "true"
// when you want to create the final file
//-----------------------------------------
#include "colors.inc"
//#include "..\macros\maketree\txttree.inc"
#include "..\macros\maketree\maketree.pov" // tree & leaf macro
//=========================================
// Tree macro Parameters
//-----------------------------------------
// These parameters must be declared before calling the tree macro
//-----------------------------------------
#declare dofile=false;    // true creates a tree file ; false otherwise
#declare dotexture=false;  // true creates a textured tree (with the texture following the branch); false otherwise
#declare ftname="..\\macros\\maketree\\gttree5.inc" // file name for tree
#declare fvname="..\\macros\\maketree\\gtfoliage5.inc" // file name for foliage
#declare ffname="..\\macros\\maketree\\gtleaf5.inc" // file name for leaf

#declare colBark=rgb <1,0.8,0.64>; // light brown, white
#declare txtTree=//texture{txtTree_5} // Bark texture
	texture{
		pigment{
			gradient y
			turbulence 0.7
			lambda 4
			color_map{
				[0 color colBark*.3]
				[0.1 color colBark]
				[0.9 color colBark]
				[1 color colBark*.4]
			}
		}
		finish{ambient 0 diffuse .7}
	}
	texture{
		pigment{
			bozo
			turbulence 0.7
			lambda 4
			color_map {
				[0 color colBark*.2]
				[0.1 color colBark*.3]
				[0.3 color colBark*.4]
				[0.4 rgb colBark*.4 transmit 1]//color Clear] //ooh bad, this would interpolate to white.
				[0.9 rgb colBark*.4 transmit 1]//color Clear]
				[1 color colBark*.4]
			}
		}
		finish{ambient 0 diffuse .7}
	}

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
//#declare rsd=211;      // random seed
//#declare rsd=212;      // random seed
#declare rsd=213;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

//-----------------------------------------
// Tree structure parameters        
// test with low level0 and nseg0 (3 or 4)
// High (>=6) recursion levels [level0] gives more complex trees
// High (>=6) segment numbers [nseg0] gives smoother trees
//-----------------------------------------
#declare level0=4;      // recursion level
#declare nseg0=12;       // initial number of branch segments (decreases of one at each level)
#declare nb=5;          // max number of branches per level
#declare dotop=false;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=25;        // initial branch length
#declare rb0=2;         // initial branch radius
#declare ab0=25;        // initial branch angle (x angle between the trunk and the first branch)
#declare qlb=0.9;       // branch length decrease ratio (1=constant length)
#declare qrb=0.4;       // branch radius decrease ratio (1=constant radius)
#declare qab=1;       // branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=1; // probability of branch apparition 
#declare jb=0;        // secondary branches start after this ratio of branch length

#declare fgnarl=0.3;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0.1;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0; // probability to have a twig on a trunk segment

#declare v0=<0,1,0>;    // initial direction - change to give an initial orientation
#declare pos0=<0,0,0>;  // initial trunk position (no need to change this one)

//-----------------------------------------
// constraints parameters
//-----------------------------------------
#declare vpush=<1,-0.8,0>;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity
#declare fpush=1;       // force of push
#declare aboveground=-2; // constrains the branches above this level 
#declare belowsky=1000;  // constrains the branches below this level 

//-----------------------------------------
// root parameters
//-----------------------------------------
#declare rootproba=0;   // probability of root 0=no root ; 1=all [nb] roots
#declare nroot=5;      // number of main roots;
#declare vroot=<1,-0.4,0>; // initial direction of root 
#declare yroot=<0,0.5,0>;   // initial position of root above ground

//-----------------------------------------
// leaf position parameters
//-----------------------------------------
#declare leafproba=0.8;   // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=4;   // level where the leaves start to appear
#declare alz0=40;       // max z angle for leaf
#declare alx0=-20;      // start x angle for leaf
#declare stdalx=40;     // std x angle for leaf
#declare stdlsize=0.4;  // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare colLeaf=rgb <0.6,1,0.3>*0.8; // yellow clear green
#declare txtLeaf=//texture{txtLeaf_1} // Leaf texture
	texture{pigment{colLeaf} finish{ambient 0 diffuse .7 specular 0.3 roughness 0.01}}

#declare lsize=0.2;     // leaf size
#declare seg=30;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=25;          // leaf length
#declare wl=0.4;          // leaf width 
#declare fl=0.2;        // depth of leaf fold
#declare lpow=0.3;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=5;      // number of lobes (individual leaves)
#declare alobes=20;    // angle made by all the lobes
#declare qlobes=0.9;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=3;          // stalk length (0=no stalk)
#declare ws=0.12;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward
//-----------------------------------------
// end of parameters
//=========================================

//=========================================
// Make the tree now !
//-----------------------------------------

#declare aoTree = array[2];

#declare nTree = 0;
#while ( nTree < dimension_size( aoTree, 1 ) )
	#declare aoTree[nTree] =
		object {
		        #if (leafproba>0)
		        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
		                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
		                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
		                        texture{txtLeaf}
		                 #end
		        } 
		        
		        #end              
		        MakeTree()
		        
		        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
		                texture {txtLeaf}
		        #else
		
		                texture {txtTree} // apply tree texture  regardless of the tree structure
		        #end
		        //translate -x*15
		}

	#declare nTree = nTree + 1;
#end//while	




#ifndef(boIncluded)
	//test it under similar conditions to how I'll use it (radiosity, lighting, etc)

	global_settings {
	  assumed_gamma 1.4//1.8
		max_trace_level 5//20
		radiosity {}// Rad_Settings(Radiosity_Fast, on, on) }
	}
	
	#default { pigment { rgb 1 } finish { diffuse 1 ambient 0 } }

	object { aoTree[0] }

	//=========================================
	// Camera & light
	//-----------------------------------------
	#declare PdV=<0, 4 , -110>;
	#declare PdA=<0,25,0>;
	camera {location  PdV direction <0.0 , 0.0 , 1.7 > up y  right x*image_width/image_height look_at   PdA}
	//-----------------------------------------
/*	light_source{PdV color White*0.5  shadowless}
	light_source{<130,40,-200> color White*1.8}
	
	background{color rgb <0.8,0.9,1>}*/
	plane{y,0 pigment{rgb<1,0.7,0.3>*.7}}
	
	light_source {
	//	#declare vLightDir = vnormalize(<1,2,3>);
	//	#declare colLight = rgb <1,.83,.7>;
		#declare vLightDir = vnormalize(<1,1,5>);
		#declare colLight = rgb <1,.83,.7>*1.3;
		vLightDir*1000000 colLight
	  area_light
	  200000*x, 200000*y, // lights spread out across this distance (x * z)
	  4, 4                // total number of lights in grid (4x*4z = 16 lights)
	  adaptive 1          // 0,1,2,3...
	  circular            // make the shape of the light circular
	  orient              // orient light
	}
	
	fog {
	  fog_type 2               // 1=constant, 2=ground_fog
	  distance 6000
	  color rgb <.9,.9,1> transmit 0
	  // (---ground fog---)
	  fog_offset -350//-300         // height of constant fog
	  fog_alt 250            // at fog_offset+fog_alt: density=25%
	  // (---turbulence---)
	  turbulence 1/<200,90,200>//.04  //actually 1/turb scale
	  turb_depth .3		//this is how far the turbulence displaces it.
	}
	
	
	sky_sphere {
		pigment {
			#local fPow = .5;	
			function {
				(
					select( y, -pow(abs(y),fPow), pow(abs(y),fPow) )
				)/2 + .5
			}
			colour_map {
				[.4	rgb 0]
				[.5	rgb 1]
				[1	rgb <.1,.2,.3>]
			}
		}
		//sun highlight
		pigment {
			gradient vLightDir
			scale 2
			translate -vLightDir
			poly_wave 8
			colour_map {
				[0	colLight transmit 1]
				[1	colLight transmit 0]
			}
		}
	}
	
	
	//cloud layers
	//I should point out that by a shear fluke this looks great in this picture!
	//it even looks like the clouds are affected by the terrain in the distance, which is total coincedence! :)
	sphere {
		-.9*y, 1
	
		no_shadow
		hollow on
		//double_illuminate
		
		texture {
			pigment {
				wrinkles
				turbulence .3
				poly_wave .6
				scale .2
				colour_map {
					[0 rgb 1.5	transmit 0]
					[1 rgb 1.5	transmit 1]
				}
			}
			finish { ambient 1 diffuse 0 }
		}
		texture {
			pigment {
				wrinkles
				turbulence .3
				poly_wave .6
				translate -.01*y
				scale .2
				colour_map {
					[0 rgb .5	transmit 0]
					[1 rgb .5	transmit 1]
				}
			}
			finish { ambient 1 diffuse 0 }
		}
		texture {
			pigment {
				wrinkles
				turbulence .3
				poly_wave .6
				translate -.02*y
				scale .2
				colour_map {
					[0 rgb .0 transmit 0]
					[1 rgb .0	transmit 1]
				}
			}
			finish { ambient 1 diffuse 0 }
		}
	
		scale 1000000
	}	

#end