//3'51" 960x540, AA 0.5
#declare Ground = 1;
#declare Planet = 1;
#declare Sky = 1;
#declare Rings = 1;
#declare Camera_Focal = 1;

camera {
  location <0,-49,0>
  look_at <-120,120,1000>
  right x*image_width/image_height
  angle 74
#if(Camera_Focal)
  focal_point <50,50,1000>
  blur_samples 50
  aperture 1
#end 
}

light_source {
  <-1000,500,0>
  color rgb 1
}

//---------- textures definitions ----------// 
#declare Ground_Tex =
  texture {
    pigment {
      wrinkles
      color_map {
        [ 0 color rgb 0 ]
        [ 1 color rgb <1,.5,.3> ]
      } 
      scale .8
    }
    finish {
      specular 1
      roughness .1
      ambient .35 
      diffuse 0
    }
  }
// Ground_Tex

#declare Planet_Tex =
  texture {
    pigment {
      color rgb <0,.7,1> // the basic color 
    }
  }
  texture {
    pigment {
      gradient y
      turbulence .1
      color_map { // light poles, brown equator
        [ 0 color rgbt <.7,1,1,1> ]
        [ 0.25 color rgb <0,.8,1> ]
        [ 0.75 color rgb <.9,.95,1> ]
        [ 1 color rgbt <.7,1,1,1> ]
      }
      scale 500
    }
  }
  texture {
    pigment {
      gradient y
      turbulence .3
      color_map { // white lines
        [ .4 color rgbt 1 ]
        [ .5 color rgbt <1,1,1,.8> ]
        [ .6 color rgbt 1 ]
      }
      scale 100
    }
  }
  texture {
    pigment {
      gradient y
      turbulence .1
      color_map { // big brown lines
        [ 0 color rgbt 1 ]
        [ .5 color rgbt <0,0,.5,.9> ]
        [ 1 color rgbt 1 ]
      }
      scale 150
      translate 30*y
    }
  }
  texture {
    pigment {
      gradient y
      turbulence .1
      color_map { // diffuse yellow lines
        [ .3 color rgbt 1 ]
        [ .5 color rgbt <0,1,1,.9> ]
        [ .7 color rgbt 1 ]
      }
      scale 150 
    }
    finish {
      ambient 0
      diffuse 1
      specular .2
      roughness .08
    }
  }
// Planet_Tex  
  
#declare Sky_Tex = 
  texture {
    pigment {
      bozo
      turbulence 2
      color_map {
        [ 0 color rgb 1 ]
        [ .3 color rgb 1 ]
        [ .4 color rgb 0 ]
        [ 1 color rgb 0]
      } 
      scale 100
    }
  }
// Sky_Tex

#declare Rings_Tex =
  texture {
    pigment {
      onion 
      color_map {
        // the rings begin at .630 and finish at .750
        [ .630 color rgbt <.3,.4,.5,1> ]
        [ .640 color rgb <.3,.4,.5> ]
        [ .680 color rgb <.65,.8,.9> ]
        //[ .685 color rgbf <.9,.8,.65,.2> ] 
        [ .690 color rgbf <.65,.8,.9,.9> ] 
        //[ .695 color rgbf <.9,.8,.65,.2> ] 
        [ .700 color rgb <.65,.8,.9> ]
        [ .705 color rgb <.6,.7,.9> ]
        [ .710 color rgbf <.6,.7,.8,.5> ]
        [ .715 color rgb <.6,.7,.8> ]
        [ .740 color rgb <.3,.4,.5> ]
        [ .750 color rgbt <.3,.4,.5,1> ]
      }
    }
    finish {
      ambient .4
      diffuse 1
    }
    scale 1000
  }
// Rings_Tex  
  
//textures definitions

//---------- Ground ----------//  
#if(Ground)
// the ground 
isosurface {
  function {
    y+sin(x)*sin(z) // some dunes
  }
  threshold 0
  max_gradient 1.1
  contained_by {
    box {
      <-20,-1,-10>,
      <20,1,50>
    }
  }
  texture {
    Ground_Tex
  }
  scale <30,5,20>
  translate -50*y
}
#else
plane {
  y,-50
}
#end
// Ground 

//---------- Planet ----------//
#if(Planet)
// a huge planet ( like Saturn ) in the sky
sphere {
  0, 450
  texture {
    Planet_Tex
  }
  scale <1,.95,1> // it is not a perfect sphere
  rotate <-10,0,-20>
  translate <50,50,1000>
}
#else
sphere {
  <50,50,1000>, 450
  scale <1,.95,1> // it is not a perfect sphere
  pigment {
    color rgb <1,.8,0>
  }
  finish {
    ambient .5
  }
}
#end
// Big Planet

//---------- Sky ----------//
#if(Sky)
// stars in the sky
sphere {
  0,50000
  texture {
    Sky_Tex
  }
}
#else
sky_sphere {
  pigment {
    color rgb 0
  }
}
#end
// Sky

//---------- Rings ----------//
#if(Rings)
//the rings around the big planet
disc {
  0, y, 750, 630
  texture {
    Rings_Tex
  }
  rotate <-10,0,-20>
  translate <50,50,1000>
  double_illuminate
}
#else
disc {
  0, y, 750, 630
  pigment {
    color rgb <0,.8,.9>
  }
  finish {
    ambient .1
    diffuse .9
  }
  rotate <-10,0,-20>
  translate <50,50,1000>
}

#end
//Rings