// Persistence of Vision Ray Tracer Scene Description File
// File: a_moment.pov
// Vers: 3.5
// Desc: for the 12/31/02 IRTC
// Date: 12/30/02
// Auth: Bob Franke
  
#include "colors.inc"  
#include "functions.inc"  
#include "textures.inc"  
#include "finish.inc"     
#include "golds.inc"       

#declare Photons=on;       
global_settings {
  assumed_gamma 2.35
  max_trace_level 50
  #if (Photons)          // global photon block
    photons {            
      count 1000000*2    // alternatively use a total number of photons0
      jitter 1.0         // jitter phor photon rays
    }
  #end
}   
   

light_source {
  <-9,6,-7>*10
  White*2   
  photons {
    refraction on
    reflection on
  }
  area_light
  <10, 0, 0> <0, 0, 10> 
  6, 6              
  adaptive 0          
  jitter              
}  

camera {
  location <0,1,-11>
  look_at <0,0,-3.0>     
  direction 1.3*z
  right     4/3*x      
  
  aperture 0.25           // [0...N] larger is narrower depth of field (blurrier)
  blur_samples 400        // number of rays per pixel for sampling
  focal_point <0,1,-1>    // point that is in focus <X,Y,Z>
  confidence 0.95         // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/200          // [0...1] how precise to calculate (smaller is more accurate)
}


plane {
  y, -2.375
  texture{
    pigment{SteelBlue*3}
    finish  {
      ambient 0.1
      diffuse 0.1
      reflection 0.15
      specular 0.6
      roughness 0.003
    }
    normal {bumps 0.2 turbulence .1 scale <.0025,.002,.0025>}
  }   
}


#declare ice = 
texture {
  pigment { rgbf <0.98, 0.98, 0.98, 0.9> }
  finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.05
    specular .9
    roughness 0.001
  }
}

#declare Glass33 = 
texture {
  pigment { rgbf <0.98, 0.98, 0.98, 0.9> }
  finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.05
    specular 0.5
    roughness 0.006
    phong 1 
    phong_size 400
  }
}


//==============<<< start block of ice >>>==============      
isosurface {
  function { 
    - f_superellipsoid(x,y,z,0.2,0.2) 
    - f_noise3d(x, y, z)*0.4
  }   
  
  contained_by{sphere {0,3}}

  texture { ice } 
  interior {ior 1.5}  
  normal { dents 1 scale .05+.4 turbulence .05 }   
        
  photons {  // photon block for an object
    target 1.0
    refraction on
    reflection on  
  }        
  scale 2.0
  rotate<0,25,0>
}      
//==============<<< end block of ice >>>==============      


// add small puddle of water
merge{ 
  sphere{<0,0,0>, .75 scale<2,.3,1>  rotate<0,75,0> translate<.75,-2.375,-2>} 
  sphere{<0,0,0>, .75 scale<2,.3,1>  rotate<0,100,0> translate<1,-2.375,-2>} 
  texture { ice } 
  interior {ior 1.25}  
 
  photons {  // photon block for an object
    target 1.0
    refraction on
    reflection on  
  }        
}

//=====================<<< start of pocket watch >>>======================
#declare yrot=0; 
union{
  union{
    union{
      #while (yrot < 360) 
        torus { .15625, 0.03125 
          rotate<90,0,0>
          rotate<0,15,0>
          translate<1.5,0,0> 
          rotate<0,yrot,0> 
        }  
        #declare yrot=yrot+1.25-.25;
      #end    
    
      cylinder { <0, -0.1, 0>, <0, 0.1, 0>, 1.6827-.01  }  
      torus { .9+.5, 0.03125 translate<0,.15,0> }  
      texture{T_Gold_1D}  
    } 

    cylinder { <0, -0.1875, 0>, <0, 0.135, 0>, 1+.5  
      pigment{
        image_map {
          gif "face2.gif" 
          map_type 0        
          interpolate 2    
          once           
        }  
        rotate<90,0,0> 
        translate<-.5,0,-.5>
        scale 2.9
      }
    }

    difference{  
      sphere { <0, 0.4, 0>, 1.379  scale<1,.3,1>  }
      sphere { <0, 0.4, 0>, 1.379-.02  scale<1,.3,1>  } 
      box{<3,0,3>,<-3,-2,-3>}  
      texture { Glass33 } 
      interior {ior 1.5}
    }  
    rotate<-90,0,0>   
  } 
  union{  
    #declare yrot=0;
    difference{
      sphere {<0,0,0> ,.23 }  
      #while (yrot < 180)
        torus { 0.23, 0.01 rotate<90,0,0> rotate<0,yrot,0>}
        #declare yrot=yrot+10;
      #end
      scale<1,.75,1>
    } 

    cone { <0, -.35, 0>, 0.13, <0, -.15, 0>, 0.1 }  
    torus { 0.4, 0.04 rotate<90,0,0> 
      scale<1,.75,1>         
      translate<0,0.4*.75,0> 
      rotate<25,0,0>   
      translate<0,-.25,0>
    }  
    texture{T_Gold_1D}
    translate<0,2.0,0>
  }                                    

  rotate<15,30,0>
  translate<-.5,-.25,-0.75> 
  scale 1.0
  photons {  
    target 1.0
    refraction on
    reflection on
  }        
}      
//=====================<<< end of pocket watch >>>======================
  
  
//add some fog  
fog{
  colour rgbft<0.137, 0.4196, 0.5568, 0.0, 0.0>*.4   
  lambda 2.0
  fog_type 1
  fog_offset 0
  fog_alt 15
  octaves 6
  omega 0.5 
  turbulence<0,0,0>
  turb_depth 0.5
  up<0,1,0>
  distance 35
}

// add a couple of background objects  
cone { <25,-2.5,60>, 10, <25, 8.5, 60>, 0 pigment{White*.99} no_shadow}
cone { <-15,-2.5,40>, 10, <-15, 10, 40>, 0 pigment{White*.99} no_shadow}
              

   
   
            
       
       
       
         