// Persistence of Vision Ray Tracer Scene Description File
// File: aha.pov
// Vers: 3.5
// Desc: 
// Date: 12/30/02
// Auth: J Moore

#include "rad_def.inc"
#include "glass.inc"
#include "finish.inc"
#include "metals.inc"
#include "golds.inc"
#include "colors.inc"
#include "functions.inc"
#include "head.inc"

global_settings {max_trace_level 10 adc_bailout 1/128}

camera {
	up y
	right x*image_width/image_height
	location <0.5, 1, -2>
	look_at <0.075, 0.125, 0>
}

light_source {<0.75, -1.5, -6> color rgb <0, 0, 0.1>}

//#declare bkgr=
box {<-10, -10, -10>, <10, 10, 0.1>
	hollow
	pigment {
		agate
		turbulence 0.2 lambda 8 omega 0.2
		color_map {
			[0 rgb <0.85, 0.85, 1>]
			[1 rgb 1.1]
		}
	}
	normal {wrinkles 0.05 turbulence 0.8 omega 0.2 lambda 8}
	finish {
		specular 0.2
		roughness 0.005
		reflection {0.5, 1}
	}
}

//#declare clck=
union {
	
	//face
	cylinder {<0, 0, 0.02>, <0, 0, 0.03>, 1.05
		pigment {rgb 0.1}
		finish {F_MetalB}
	}
	
	//outer ring
	torus {1.05, 0.05 rotate x*90 texture {T_Gold_5E}}
	
	//glass cover
	sphere {0, 1.025
		hollow
		clipped_by {plane {z, 0}}
		scale <1, 1, 0.15>
		pigment {Col_Glass_Bluish}
		finish {F_Glass2}
		interior {ior 1.2}
	}
	
	//clock numbers & ticks
	merge {
		text {
			ttf "mvboli.ttf"
			"12" 0.1, 0
			scale 0.25
			translate <-0.125, -0.125+0.85, 0>
		}
		text {
			ttf "mvboli.ttf"
			"3" 0.1, 0
			scale 0.25
			translate <0.75, -0.1, 0>
		}
		text {
			ttf "mvboli.ttf"
			"6" 0.1, 0
			scale 0.25
			translate <-0.0625, -0.9, 0>
		}
		text {
			ttf "mvboli.ttf"
			"9" 0.1, 0
			scale 0.25
			translate <-0.9, -0.1, 0>
		}

		#declare c=0;
		#while (c<12)
			box {<-0.01, 0.925, 0>, <0.01, 0.985, 0.1> rotate z*c*30}
			#declare c=c+1;
		#end
		
		#declare c=0;
		#while (c<60)
			box {<-0.005, 0.96, 0>, <0.005, 0.985, 0.1> rotate z*c*6}
			#declare c=c+1;
		#end
		
		//hands
		box {<-0.01, -0.2, -0.05>, <0.01, 0.85, -0.04> rotate z*12}
		box {<-0.02, -0.2, -0.04>, <0.02, 0.4, -0.03> rotate z*2}
		
		texture {T_Gold_5E}
	}

	torus {0.01, 0.0025
		rotate x*90
		translate z*-0.05
		texture {T_Chrome_5D}
	}
}

//single arm in swirl
#declare arm=
sphere_sweep {
	#declare numpts=100;
	#declare ang=0;
	#declare angstep=10;
	#declare trans=0;
	#declare transtep=0.05;
	#declare rad=0.075;
	#declare c=0;
	b_spline
	numpts
	#while (c<numpts)
		<cos(radians(ang))*trans, 0, sin(radians(ang))*trans>, rad
		#declare trans=trans+transtep;
		#declare ang=ang+angstep;
		#declare c=c+1;
	#end
}

//swirl
#declare swirl=
merge {
	#declare numarms=6;
	#declare c=0;
	#while (c<numarms)
		object {arm rotate y*360/numarms*c}
	 	#declare c=c+1;
	#end
}

//density of arms in swirl
#declare d_ether=
density {
	wrinkles
	warp {turbulence 0.5 omega 0.8}
	scale 0.1
	density_map {
		[0 rgb 0.75]
		[1 rgb 1.25]
	}
}

//density between arms in swirl
#declare d_outer=
density {
	wrinkles
	warp {turbulence 0.5 omega 0.8}
	scale 0.1
	density_map {
		[0 rgb 0.15]
		[1 rgb 0.25]
	}
}

//swirl density
#declare d_swirl=
density {
	object {
		swirl
		density {d_outer}
		density {d_ether}
	}
	warp {turbulence 0.2 omega 0.2 lambda 8}
}

//main density to feather swirl
#declare d_main=
density {
	spherical
	warp {turbulence 0.1 omega 0.8 lambda 6 octaves 10}
	density_map {
		[0 rgb 0]
		[0.3 d_swirl]
		[1 d_swirl]
	}
}

//color density
#declare d_color=
density {
	spherical
	turbulence 0.2
	scale <1, 0.5, 1>
	density_map {
		[0 rgb 0]
		[0.1 rgb <0.5, 0, 0>]
		[0.15 rgb <0.75, 0.15, 0.15>]
		[0.25 rgb <1, 0.55, 0.55>]
		[0.8 rgb <1, 0.9, 0.9>]
		[1 rgb 3]
	}
}

//#declare head=
object {
	head
	translate <0.275, -0.0925, 0>
	rotate z*-85
	rotate x*10
	rotate y*25
	scale 40
	pigment {rgbft <1, 1, 1, 0.5, 0.9>}
	finish {
		F_Glass1
		irid {0.25 thickness 0.1}
	}
	interior {
		fade_distance 1
		fade_power 1001
		caustics 0.2
		media {
			method 3
			intervals 1
			samples 30, 30
			emission 0.85
			density {d_main}
			density {d_color}
			scale <1.5, 1, 1.5>
		}
	}
	translate <0, -0.7, -3>
}

#declare base=
merge {
	cylinder {<0, 0.1, 0>, <0, 0.3, 0>, 0.1}
	torus {0.1, 0.01 translate y*0.3}
	torus {0.1, 0.01 rotate <0, 0, 5> translate y*0.125}
	torus {0.1, 0.01 rotate <0, 0, 5> translate y*0.15}
	torus {0.1, 0.01 rotate <0, 0, 5> translate y*0.175}
	torus {0.1, 0.01 rotate <0, 0, 5> translate y*0.2}
	torus {0.1, 0.01 rotate <0, 0, 5> translate y*0.225}
	torus {0.1, 0.01 rotate <0, 0, 5> translate y*0.25}
	torus {0.1, 0.01 rotate <0, 0, 5> translate y*0.275}
	torus {0.1025-0.025, 0.025 translate y*0.1}
	cylinder {<0, 0.1, 0>, <0, 0.1-0.025, 0>, 0.1-0.025}
	texture {T_Copper_5D}
	scale <1.05, 1, 1.05>
}

#declare filament=
sphere_sweep {
	cubic_spline
	43
	<0.1, 0.8, 0>, 0.0025
	<0.1, 0.8, 0>, 0.0025
	<0.05, 0.5, 0>, 0.0025
	<0.05, 0.2, 0>, 0.0025
	<0.05, 0.2, 0>, 0.0025
	
	<-0.05, 0.2, 0>, 0.0025
	<-0.05, 0.2, 0>, 0.0025
	<-0.05, 0.5, 0>, 0.0025
	<-0.1, 0.8, 0>, 0.0025
	
	#declare c=-0.08;
	#declare maxc=0.08;
	#declare step=0.005;
	#declare rad=0.025;
	#declare ofs=0.8;
	#while (c<maxc)
		<c, cos(c*300)*rad+ofs, sin(c*300)*rad>, 0.0025
		#declare c=c+step;
	#end
	<0.1, ofs, 0>, 0.0025
	<0.05, 0.5, 0>, 0.0025
	no_shadow
	pigment {rgb 0.1}
	pigment {
		spherical
		scale 0.4
		translate y*0.8
		color_map {
			[0 rgb 0]
			[0.75 rgb 0.5]
			[1 rgb 0.5]
		}
	}
	finish {Luminous}
}

#declare o_bulb=
sphere_sweep {
	b_spline
	5
	<0, 1, 0>, 0.3
	<0, 0.9, 0>, 0.3
	<0, 0.5, 0>, 0.1
	<0, 0.3, 0>, 0.1
	<0, 0.2, 0>, 0.1
}

//#declare bulb=
union {
	object {
		o_bulb
		hollow
		double_illuminate
		pigment {Col_Glass_Clear}
		finish {F_Glass7}
		interior {
			ior 1.2
			fade_power 1
			fade_distance 1001
			media {
				method 3
				intervals 1
				samples 3, 3
				scattering {4, 1.5}
				emission 4
				density {
					wrinkles
					scale 0.1
					density_map {
						[0 rgb 0.15]
						[1 rgb 0.5]
					}
				}
				density {
					spherical
					turbulence 0.4 omega 0.7 lambda 8 octaves 10
					density_map {
						[0 rgb 1]
						[0.5 rgb 1]
						[1 rgb 4]
					}
					scale <0.4, 0.2, 0.2>
					translate y*0.8
				}
			}
		}
	}
	object {base}
	light_source {<0, 0.8, 0>, rgb 0.25 looks_like {object {filament translate y*-0.8}}}
	translate <0, -1, -3>
}

