//Tiles inc file

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#include "Parts\Soap Tile1.inc"                           
#include "Parts\Soap.inc"

#declare Border_Tile = box {<.1,0,.1> <5.9,-.25,11.9> texture {T_Stone10 scale<3,1,2>}}
#declare RBorder_Tile = box {<.1,0,.1> <5.9,-.25,11.9> texture {T_Stone10 scale<3,1,2>} rotate<0,0,90>} 
//Floor border tiles
#declare Tile = union {
//Tiles along left wall
union{
        #declare NrZ = -2;     // start
        #declare EndNrZ = 3; // end
        #while (NrZ< EndNrZ) 

   object{Border_Tile translate<0,0,NrZ*12>} 
   object{Border_Tile translate<36,0,NrZ*12+60>}
   
   object{Border_Tile rotate<0,0,90> translate<0,0,NrZ*12>} 
   object{Border_Tile rotate<0,0,90> translate<36,0,NrZ*12+60>}   
   
 #declare NrZ = NrZ + 1;  // next NrZ
 #end // --------------- end of loop 
 }   

union{
        #declare NrX = 0;     // start
        #declare EndNrX = 3; // end
        #while (NrX< EndNrX) 
   
   object{RBorder_Tile rotate<0,90,0> translate<NrX*12,0,36>} 
   
 #declare NrX = NrX + 1;  // next NrX
 #end // --------------- end of loop 
 }

//Tiles around base of shower   
   object{Border_Tile scale<1,1,.5> rotate<0,-90,0> translate<12,0,30>}
   object{Border_Tile rotate<0,-90,0> translate<24,0,30>}
   object{Border_Tile rotate<0,-90,0> translate<36,0,30>}
   object{Border_Tile scale<1,1,.5> rotate<0,-90,0> translate<42,0,30>}
/*   
   object{Border_Tile scale<1,1,.5> rotate<0,-90,0> translate<12,0,0>}
   object{Border_Tile rotate<0,-90,0> translate<24,0,0>}
   object{Border_Tile rotate<0,-90,0> translate<36,0,0>}
   object{Border_Tile scale<1,1,.5> rotate<0,-90,0> translate<42,0,0>} 
*/
//Tiles around shower
union{
        #declare NrZ = 0;     // start
        #declare EndNrZ = 3; // end
        #while (NrZ< EndNrZ) 

   object{Border_Tile scale<0.66,1,1> translate<0,6,NrZ*12+36>}
   object{Border_Tile scale<0.66,1,1> translate<32,6,NrZ*12+36>} 
   object{RBorder_Tile translate<4,0,NrZ*12+36>}
   object{RBorder_Tile translate<32,0,NrZ*12+36>}
   
 #declare NrZ = NrZ + 1;  // next NrZ
 #end // --------------- end of loop 
 }
 
union{
        #declare NrX = 0;     // start
        #declare EndNrX = 3; // end
        #while (NrX< EndNrX) 
   
   object{RBorder_Tile rotate<0,90,0> translate<NrX*12,0,36>}
   object{RBorder_Tile rotate<0,90,0> translate<NrX*12,0,40>}
   object{RBorder_Tile rotate<0,90,0> translate<NrX*12,0,68>} 
   
 #declare NrX = NrX + 1;  // next NrX
 #end // --------------- end of loop 
#declare Top = union {
        object{Border_Tile scale<0.66,1,1> rotate<0,90,0> translate<4,6,40>}
        object{Border_Tile scale<0.66,1,0.66> rotate<0,90,0> translate<16,6,40>}
        object{Border_Tile scale<0.66,1,1> rotate<0,90,0> translate<20,6,40>}
        }         
object{Top}
object{Top translate<0,0,32>} 
 }
     
   object{Border_Tile scale<1,1,.5> rotate<0,-90,0> translate<12,0,30>}
   object{Border_Tile rotate<0,-90,0> translate<24,0,30>}
   object{Border_Tile rotate<0,-90,0> translate<36,0,30>}
   object{Border_Tile scale<1,1,.5> rotate<0,-90,0> translate<42,0,30>}
   
   object{Border_Tile scale<1,1,.5> rotate<0,-90,0> translate<12,0,0>}
   object{Border_Tile rotate<0,-90,0> translate<24,0,0>}
   object{Border_Tile rotate<0,-90,0> translate<36,0,0>}
   object{Border_Tile scale<1,1,.5> rotate<0,-90,0> translate<42,0,0>} 

//Tiles along base of tub
union{
        #declare NrX = 0;     // start
        #declare EndNrX = 7; // end
        #while (NrX< EndNrX) 

   object{Border_Tile rotate<0,90,0> translate<NrX*12+36,0,72>}
   object{RBorder_Tile rotate<0,90,0> translate<NrX*12+36,0,72>} 
   
 #declare NrX = NrX + 1;  // next NrZ
 #end // --------------- end of loop 
 object{RBorder_Tile scale<1,1,0.33> rotate<0,90,0> translate<36,0,72>}
 }
 
//Floor tile
#declare R1 = seed(36472);
#declare R2 = seed(197);

#declare Large_Tile = 
        prism {
                linear_sweep
                linear_spline
                -.25, 
                0, 
                13,  
                < -6.90,1.41>, < -5.49,0.00>, < -6.90,-1.41>, < -1.41,-6.90>, < 0.00,-5.49>, 
                <1.41,-6.90>, <6.90,-1.41>, <5.49,0.00>, <6.90,1.41>, <1.41,6.90>,
                <0.00,5.49>, <-1.41,6.90>, <-6.90,1.412>
        }
#declare Small_Tile =  box { <-1.88,-.25,-1.88> <1.88,0,1.88> rotate<0,45,0> pigment {GreenCopper *1.5}}

intersection {
       union{
        #declare NrZ = -2;     // start Z
        #declare EndNrZ = 5; // end   Z
        #while (NrZ< EndNrZ) 
        // inner loop
        #declare NrX = 0;     // start X
        #declare EndNrX = 8; // end   X
        #while (NrX< EndNrX) 
     
        object{Large_Tile texture {T_Stone12 scale<2,3,2> rotate<rand(R1)*180,0,rand(R2)*60>} 
                                        translate<NrX*16.971-.126,0,NrZ*16.971-4.241> }
        object{Large_Tile texture {T_Stone12 scale<2,3,2> rotate<rand(R2)*-180,0,rand(R1)*-45>} 
                                        translate<NrX*16.971+8.359,0,NrZ*16.971+4.244> }                             

    #declare NrX = NrX + 1;  // next Nr X
    #end // --------------- end of loop X
 #declare NrZ = NrZ + 1;  // next Nr Z
 #end // --------------- end of loop Z
 
 #declare NrZ1 = -2;     // start Z1
        #declare EndNrZ1 = 4; // end   Z1
        #while (NrZ1< EndNrZ1) 
        // inner loop
        #declare NrX1 = 0;     // start X1
        #declare EndNrX1 = 7; // end   X1
        #while (NrX1< EndNrX1) 
     
        object{Small_Tile translate<NrX1*16.971+16.844,0,NrZ1*16.971+4.244> }                                         
        object{Small_Tile translate<NrX1*16.971+8.359,0,NrZ1*16.971+12.730> }                             

    #declare NrX1 = NrX1 + 1;  // next NrX1
    #end // --------------- end of loop X1
 #declare NrZ1 = NrZ1 + 1;  // next NrZ1
 #end // --------------- end of loop Z1
 }
        union {
        box { <6.12,-10,-17.88> <42.12,10,29.88>}
        box { <42.12,-10,65.88> <113.88,10,-17.88>}
        }

 }






//Wall tiles
#declare WallTile = box {<.1,0,.1> <5.9,-.25,5.9> texture {T_Stone4 scale<3,1,3>} rotate<0,0,90>}
//Left wall tiles       
       union{
        #declare NrZ = 0;     // start Z
        #declare EndNrZ = 13; // end   Z
        #while (NrZ< EndNrZ) 
        // inner loop
        #declare NrY = 0;     // start Y
        #declare EndNrY = 11; // end   Y
        #while (NrY< EndNrY) 
     
        object{WallTile translate<0,NrY*6+6,NrZ*6+30> }                      

    #declare NrY = NrY + 1;  // next Nr Y
    #end // --------------- end of loop Y
 #declare NrZ = NrZ + 1;  // next Nr Z
 #end // --------------- end of loop Z
 } 
//Center wall tiles
        union {
        #declare NrX = 0;     // start X
        #declare EndNrX = 20; // end   X
        #while (NrX< EndNrX) 
        // inner loop
        #declare NrY = 0;     // start Y
        #declare EndNrY = 8; // end   Y
        #while (NrY< EndNrY) 
     
        object{WallTile rotate<0,90,0> translate<NrX*6,NrY*6+24,108> }                      

    #declare NrY = NrY + 1;  // next Nr Y
    #end // --------------- end of loop Y
 #declare NrX = NrX + 1;  // next Nr X
 #end // --------------- end of loop X
 } 

//Tub tiles
//Lower vertical tile pattern
        union{
        #declare NrX = 0;     // start x
        #declare EndNrX = 21; // end   x
        #while (NrX< EndNrX) 
        // inner loop
        #declare NrY = 1;     // start y
        #declare EndNrY = 4; // end   y
        #while (NrY< EndNrY) 
     
        object{WallTile rotate<0,90,0> translate<NrX*6, NrY*6, 72> }  

    #declare NrY = NrY + 1;  // next Nr y
    #end // --------------- end of loop y
 #declare NrX = NrX + 1;  // next Nr x
 #end // --------------- end of loop x
 } 
//Upper vertical tile pattern
        union{
        #declare NrX = 0;     // start x
        #declare EndNrX = 6; // end   x
        #while (NrX< EndNrX) 
        // inner loop
        #declare NrY = 4;     // start y
        #declare EndNrY = 6; // end   y
        #while (NrY< EndNrY) 
     
        object{WallTile rotate<0,90,0> translate<NrX*6, NrY*6, 72> }  

    #declare NrY = NrY + 1;  // next Nr y
    #end // --------------- end of loop y
 #declare NrX = NrX + 1;  // next Nr x
 #end // --------------- end of loop x
 }  
//Vertical wall tile pattern
        union{
        #declare NrZ = 0;     // start z
        #declare EndNrZ = 6; // end   z
        #while (NrZ< EndNrZ) 
        // inner loop
        #declare NrY = 4;     // start y
        #declare EndNrY = 6; // end   y
        #while (NrY< EndNrY) 
     
        object{WallTile translate<36, NrY*6, 72+NrZ*6> }  

    #declare NrY = NrY + 1;  // next Nr y
    #end // --------------- end of loop y
 #declare NrZ = NrZ + 1;  // next Nr Z
 #end // --------------- end of loop Z
 }   
//Top of tub tile
        difference {
        union{
        #declare NrX = 6;     // start x
        #declare EndNrX = 21; // end   x
        #while (NrX< EndNrX) 
        // inner loop
        #declare NrZ = 0;     // start z
        #declare EndNrZ = 6; // end   z
        #while (NrZ< EndNrZ) 
     
        object {WallTile rotate<0,0,90> translate<NrX*6, 24, 72+NrZ*6> }

    #declare NrZ = NrZ + 1;  // next Nr z
    #end // --------------- end of loop z
 #declare NrX = NrX + 1;  // next Nr x
 #end // --------------- end of loop x
  }
 box { <46,2,76> <118,25,104> }
 }
//Shower base tiles
#declare BaseTile = box {<.1,0,.1> <1.9,-.25,1.9> pigment {White} }
       difference {
       union{
        #declare NrX = 0;     // start x
        #declare EndNrX = 14; // end   x
        #while (NrX< EndNrX) 
        // inner loop
        #declare NrZ = 0;     // start z
        #declare EndNrZ = 14; // end   z
        #while (NrZ< EndNrZ) 
     
        object {BaseTile translate<NrX*2+4, 1, NrZ*2+40> }

    #declare NrZ = NrZ + 1;  // next Nr z
    #end // --------------- end of loop z
 #declare NrX = NrX + 1;  // next Nr x
 #end // --------------- end of loop x
 }
 cylinder {<18,-1,54>, <18,4,54>, 3 }
 }

//Soap dish tiles
object {Soap_Dish texture {T_Stone4 scale<3,1,3>} rotate<0,0,0> translate<0.25,30,60>}
object {Soap_Dish texture {T_Stone4 scale<3,1,3>} rotate<0,90,0> translate<96,30,107.75>}

//Soap
object {Soap pigment {rgbf<.8,.6,0,.2>} rotate<0,0,0> translate<0.25,30,60>}
} 


                      