#include "colors.inc"
#include "stones.inc" 
#include "functions.inc"
#include "glass.inc"
#include "woods.inc"


//1. modify T_rock to be more blue
//2. remove normal from ice 1 
//3. decrease intensity of area light

 
 
 
// 2 hrs 42 min = radiosity render time 
//count 300 recursion 4  rad render, +AM2 +R6 HighMSampels = on   -> 4h 30m hrs + 7.8 hrs +  5.3
//count 200 recursion 3  rad render, +AM2 +R4 HighMSampels = on   -> 4h 30m hrs + 7.8 hrs +  5.3

#declare PreTrace = 0;  //0 = compute radiosity only  1 = final render
#include "CaveTextures.inc"

#declare Camera_Pos = <50,19.5,0>;  // standard <0,135,-100>   low  <0,75,-100>   

#declare Rad_Quality = 3;  //3
     
#declare Sun_Pos=<-10,120,300>;    // 
#declare Sun_Color=<1,.1,0>;   //1,1,1
#declare SunBeam_Color=<1,.5,0>;   //1,.5,.3

#global_settings{assumed_gamma 1  
                 max_trace_level 200
             
                 
#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.02
        count 50
        error_bound 0.5
        recursion_limit 1
        brightness 1
        media on
        normal on 
        always_sample off
        save_file "CaveRad1"
     #else 
        load_file "CaveRad1"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.01
        count 120
        error_bound 0.25
        recursion_limit 1
        brightness 1
        media on
        normal on 
        always_sample off
        save_file "CaveRad2"
     #else 
        load_file "CaveRad2"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.005
        count 400   //300
        error_bound 0.1
        recursion_limit 5  //4
        media on
        normal on
        always_sample off
        save_file "CaveRad3"
     #else 
        load_file "CaveRad3"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (4)
  radiosity {             // --- Settings 4 (medium quality, recursion_limit 2) ---
    pretrace_start 0.08
    pretrace_end   0.005
    count 350
    error_bound 0.15
    recursion_limit 2
    media on
    normal on
  }
 #break
 #end

}


camera {
   location Camera_Pos
   up       y
   right    x
   angle    71
   look_at  <43.7,19,20>   //<46,19,20>
}

light_source {  //outside light
   <0,1000,0>   
   color rgb <.2,.2,.2>
   media_interaction off
   media_attenuation off
} 

sky_sphere {  // front lit
   pigment {
           gradient y
           color_map {
            [0 SkyBlue * 1.0]  
            [1 RichBlue] //*1 if sun over head, * .3 if sun on horizon 
                     }
           scale 2
           translate -1
         }
}

//sphere{<57,20,20>,1 pigment{color Red}}
//sphere{<39,18,42>,1 pigment{color Red}}

light_source {  //fill light RIGHT
   <57,19,20>            //50,20,20   
   color rgb <.1,.1,.1>    //<.2,.2,.2>
   media_interaction off
   media_attenuation off
   fade_distance 9
   fade_power 2 
} 

light_source {  //fill light  LEFT
   <39,20,42>            //50,20,20   
   color rgb <.3,.3,.3> //<.2,.2,.2>
   media_interaction off
   media_attenuation off 
   fade_distance 8
   fade_power 2 
} 



light_source {
   <10,100,40>   // light outside shining in  10,17,40
   color rgb <1,1,1>
   media_interaction off
   media_attenuation off
} 

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source {
  0*x                 // light's position (translated below)
  color rgb <.5,.5,.5>      // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <10, 17, 40>   // <x y z> position of light   <10, 17, 40>
  fade_distance 100
  fade_power 2 
}  

//sphere{<-4,17,50>, 1 pigment{color White}} 
 

////////////////////////////////
// Ground Plane
////////////////////////////////

plane { y , 0 
  texture {T_Snow}
  normal{ bozo 2 scale 10}
} 

////////////////////////////////
//Box to define cave floor - Ice / Snow
////////////////////////////////

box { <0,0,0>, <100,11,100> 
  texture{ gradient -x   scale 76
           texture_map{
                       [0.0 Ice]
                       [1.0 T_Snow   ]
                      }
         } 
  hollow
  interior {
            ior 1.55
           }

}

////////////////////////////////
//Box to define cave floor - Fog
////////////////////////////////

box { <1,0,1>, <99,14,99> 
     texture{pigment{rgbt <1,1,1,1>}}
     finish { ambient 1 diffuse 1 }
     hollow on
     interior { media { Media3 }} 
}  



/*
#declare N = 0;
#declare RX = seed(5586);

#while (N < 300)
   sphere{ <10 + (rand(RX) * 10),
             0 + (rand(RX) * 25),
            30 + (rand(RX) * 20)> , .3
           scale <1,1,1>
           texture{ T_Snow}
}
   #declare N=N+1;
#end */ 
 


////////////////////////////////
// Cave bottom
////////////////////////////////

height_field { png "land.png"
               scale <100, 20, 100>     
               translate y*18.999      //19
               material{CaveTex}
               hollow on
} 
              

////////////////////////////////
//Cave Top
////////////////////////////////

height_field { png "land2.png" 
               scale <100, 20, 100>
               material{CaveTex} 
         
               hollow on
}
   

////////////////////////////////
// Stalactite
////////////////////////////////

  sphere_sweep {
    cubic_spline
    6,
    <0, 0, 0>, .1
    <0, 10, 0>, 1
    <0, 20, 0>, 2
    <0, 30, 0>, 3
    <0, 40, 0>, 4
    <0, 50, 0>, 5
    tolerance 0.1
    scale .5     
    material {CaveTex}
    translate<40,13,15>  //35,5,35 near cave front 
    #if (PreTrace = 0)
       finish{ambient 0 
               specular 0.2
               diffuse 0.8
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.0 //.4
               specular 0.2
               diffuse 0.8
              }
  #end
 } 
 
   sphere_sweep {
    cubic_spline
    6,
    <0, 0, 0>,   .2
    <0, 10, 0>, 1.1
    <0, 20, 0>, 2.5
    <0, 30, 0>, 3.5
    <0, 40, 0>, 4.5
    <0, 50, 0>, 5.5
    tolerance 0.1
    scale .5 
  texture{ Ice2 }
  hollow
  interior {
            ior 1.55
           }
    translate<40,12.5,15> //12.2
 } 
 
sphere{<40,17.2,15>, .4   //16.9
       hollow on 
       interior {
                  ior 1.55
                }
       texture{Ice2}
} 


////////////////////////////////
// Fossils
////////////////////////////////

#include "4.pov"
object {Horn
  texture { 
            pigment{ granite scale .2
                    pigment_map{ 
                                [0.0 DarkBrown]
                                [0.5 DarkBrown]
                                [0.5 Flesh]
                                [1.0 Flesh]
                    } 
             }
  }
  normal{granite}
  scale <.17, .17, .17>
  rotate <0, 0, 0>
  rotate <-120, 0, 0> // for handedness 60,200  -120, -70
  translate <47,13.5,25>  //translate <50, 11, 15>
    #if (PreTrace = 0)
       finish{ambient 0 
               specular 0.2
               diffuse 0.8
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.0  //.3
               specular 0.2
               diffuse 0.8
              }
  #end
 }

#include "3.pov"   //by the door
#declare Worm1 = object {
  DWorm
   }
 
object {Worm1
  texture { 
            pigment{ granite scale 2
                    pigment_map{ 
                                [0.0 DarkTan]
                                [0.4 DarkTan]
                                [0.4 Flesh]
                                [1.0 Flesh]
                    } 
             }
  }
  normal{granite scale .2}
  scale <.8,.4,.8>   //scale <.2, .2, .2>
  rotate <90, 0, 0>
  rotate <-90, 0, 0> // for handedness 
  translate <28,20,56>   //translate <49, 20, 16>
    #if (PreTrace = 0)
       finish{ambient 0 
               specular 0.2
               diffuse 0.8
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.0  //.3
               specular 0.2
               diffuse 0.4
              }
  #end
 }  


#include "2.pov"  //on the back wall
#object {
  Worm5
  rotate<-18,0,0>
  scale <1.4,.9,1.4>
  translate<51,17.5,23>   //translate < 51,17,10>
  texture { 
            pigment{ granite scale 1
                    pigment_map{ 
                                [0.0 Quartz]         //gold and flesh
                                [0.4 Quartz]
                                [0.4 Flesh]
                                [1.0 Flesh]
                    } 
             }
  }
  normal{granite scale .2}
    #if (PreTrace = 0)
       finish{ambient 0 
               specular 0.2
               diffuse 0.8
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0  //.18
               specular 0.2
               diffuse 0.8
              }
  #end
  no_shadow
}


#include "1.pov"
object {FanWorm
  texture { 
            pigment{ granite scale .1
                    pigment_map{ 
                                [0.0 DarkGreen]
                                [0.4 DarkGreen]
                                [0.4 Flesh]
                                [1.0 Flesh]
                    } 
             }
  }
  normal{granite}
  scale <.2, .1, .25>
  rotate <0, 0, 0>
  rotate <-90, 0, 0> // for handedness 
  translate <52,12,14>  //translate <53,12,13>
    #if (PreTrace = 0)
       finish{ambient 0 
               specular 0.2
               diffuse 0.8
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.0  //.3
               specular 0.2
               diffuse 0.8
              }
  #end
 }  
 
////////////////////////////////
// Mountains
////////////////////////////////
          
#object{Terrain 
        texture{T_Terrain1}
}  


////////////////////////////////
// Cloud
////////////////////////////////

object {Cloud1 
        translate <-330,50,400>
        interior { media { Media3 }} 
        scale <CloudScale*3,CloudScale*2,CloudScale*3>
        }  
        
////////////////////////////////
// Splash
////////////////////////////////
        

#declare RadiusVal   = .6; // (0 < RadiusVal) outer sphere of influence on other components
#declare StrengthVal = 1.0; // (+ or -) strength of component's radiating density

difference{
blob {
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  sphere { <   1,  0,   0>, RadiusVal, StrengthVal }
  sphere { <   0,  0,   1>, RadiusVal, StrengthVal }
  sphere { <  -1,  0,   0>, RadiusVal, StrengthVal }
  sphere { <   0,  0,  -1>, RadiusVal, StrengthVal }
  sphere { < .71,  0,  .71>, RadiusVal, StrengthVal }
  sphere { <-.71,  0,  .71>, RadiusVal, StrengthVal }
  sphere { <-.71,  0, -.71 >, RadiusVal, StrengthVal }
  sphere { < .71,  0, -.71>, RadiusVal, StrengthVal }

  sphere { <   1+.3,  .4,   0>, RadiusVal-.3, StrengthVal }
  sphere { <   0   ,  .4,   1+.3>, RadiusVal-.2, StrengthVal }
  sphere { <  -1-.3,  .4,   0>, RadiusVal-.3, StrengthVal }
  sphere { <   0,  .3,  -1-.3>, RadiusVal-.2, StrengthVal }
  sphere { < .71+.3,  .4,  .71+.3>, RadiusVal-.3, StrengthVal }
  sphere { <-.71-.3,  .4,  .71+.3>, RadiusVal-.3, StrengthVal }
  sphere { <-.71-.3,  .4, -.71-.3 >, RadiusVal-.2, StrengthVal }
  sphere { < .71+.3,  .4, -.71-.3>, RadiusVal-.3, StrengthVal } 
  sturm
}
box{<-2,-1,-2>, <2,-.1,2>}
  pigment{ color Col_Glass_Old}
  finish {F_Glass8}
  scale <.5,1.1,.5>
  translate <40,11.6,15>   //<50,10,20>
}                    