/////////////////////////////////////
// Textures and Materials
/////////////////////////////////////

#declare Ice = 
           texture {
             pigment { color rgbf <0, .75, .9, 1>
              }
             finish {
               ambient 0.0
               diffuse 0.0
               reflection {
                            0.0, 1.0
                            fresnel on
                           }
               specular 0.4
               roughness 0.003
             }
             normal {
               function {
                 f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2) + sin(x*2.5)*.4
               } .8
               scale 0.13
             } 
             scale 4
           }

#declare Ice1 = 
           texture {
             pigment { color rgbt <0.8, 1, 1.8, 0.7>   //.95 -> 1.5
              }
             finish {
               ambient 0.0
               diffuse 0.5
               reflection {
                            0.0, 1.0
                            fresnel on
                           }
               specular 0.4
               roughness 0.003   //.003
             }
/*            normal {
               function {
                 f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2) + sin(x*2.5)*.4
               } .8       //.2
               scale 0.13  //.13
             }  */
             scale 1       //4 
           }

#declare Ice2 = 
           texture {
             pigment { color rgbt <0.8, 1, 0.90, 0.7>
              }
             finish {
               ambient 0.0
               diffuse 0.0
               reflection {
                            0.0, 1.0
                            fresnel on
                           }
               specular 0.4
               roughness 0.003   //.003
             }
             normal {
               function {
                 f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2) + sin(x*2.5)*.4
               } .2       //.8
               scale 0.13  //.13
             } 
             scale 1       //4
           }

#declare T_Snow=
texture {
  pigment {
    agate
    color_map {
      [0.0 color rgb <0.90, 0.90, 0.90> ]
      [0.5 color rgb <0.70, 0.70, 0.70> ]
      [1.0 color rgb <1.00, 1.00, 1.00> ]
    }
    scale 0.2
    warp { turbulence 0.5 }
  }
  #if (PreTrace = 0)
       finish{ambient 0 
               specular 0.2
               diffuse 0.8
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.0 //.6
               specular 0.2
               diffuse 0.8  //.4
              }
  #end
  normal {
    granite 0.4
    scale 0.5
  }
  scale 1/20 
}


#declare T_Rock=
texture {
  pigment {
    agate
    color_map {
      [0.0 color rgbt <0.50, 0.50, 0.70, 0.6> ]  //50,50,70  change
      [0.5 color rgbt <0.50, 0.50, 0.75, 0.6> ]  //50,50,75  change
      [1.0 color rgbt <0.60, 0.60, 0.75, 0.6> ]  //60,60,75  change
    }
    scale 2
    warp { turbulence 0.5 }
  }
  normal {
    granite 0.6
    scale .1 //0.1
  } 
  scale 1.5  //.5 change
} 


#declare T_Rock1=
texture {
  pigment {
    granite
    color_map {
      [0.0 color rgbt <0.50, 0.50, 0.60, 0.5> ]  //50,50,70  change
      [0.5 color rgbt <0.20, 0.60, 0.80, 0.5> ]  //50,50,75  change
      [1.0 color rgbt <0.90, 0.90, 0.90, 0.5> ]  //60,60,75  change
    }
    scale 1
    warp { turbulence 0.5 }
  }
  #if (PreTrace = 0)
       finish{ambient 0 
               specular 0.2
               diffuse 0.4                
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.0  //.35
               specular 0.2
               diffuse 0.7
              }
  #end

  normal {
    granite 0.6
    scale 3 //0.1
  } 
  scale 1.5  //.5 change
} 

#declare CaveTex= material{

texture { T_Stone1 }

texture {T_Rock1}   // t .5

texture {Ice1}  // t .7  

//------- Dark Orchid Olive & Dark Putty

texture {
pigment
 {granite
  turbulence 0.8
  color_map 
   {[0.000, 0.153   color rgbt <0.439, 0.310, 0.282, 0.9>    // .282
                    color rgbt <0.463, 0.369, 0.259, 0.9>]   // .259
    [0.153, 0.398   color rgbt <0.463, 0.369, 0.259, 0.9>    // .259
                    color rgbt <0.541, 0.369, 0.298, 0.9>]   // .298
    [0.559, 0.729   color rgbt <0.573, 0.424, 0.286, 0.9>    // .286
                    color rgbt <0.494, 0.396, 0.306, 0.9>]   // .306
    [0.729, 1.001   color rgbt <0.494, 0.396, 0.306, 0.9>    // .306
                    color rgbt <0.439, 0.310, 0.282, 0.9>]   // .282
   } 
 } 
  #if (PreTrace = 0)
       finish{ambient 0 
               specular 0.2
               diffuse 0.4                
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.0  //.35
               specular 0.2
               diffuse 0.4
              }
  #end

normal {granite scale 1.5}
}   



} //end of cavetex

///////////////////////////////////////
//Terrain
///////////////////////////////////////
 
#declare T_Terrain1=
texture {
  //slope { -z*0.8 altitude z }
  gradient y scale 400
  texture_map {
    [0.00 T_Rock  ]
    [0.15 T_Snow  ] //.15
    [1.00 T_Snow  ]
  }
} 

#declare Terrain=
            height_field {
            tga "Land1.tga"
            smooth
            rotate y*-90
            scale <400,120,100> 
            translate<-200,-60,400>  //translate  -1000,-2650,3000 scale 3000
          } 


////////////////////////////////////////
// Cloud Vriables
////////////////////////////////////////

#declare CloudScale = 1;
#declare CloudBrightness1 = .1; // .01 - 1: smaller is brighter 
#declare CloudBrightness2 = .08;  // .01 - 1: smaller is brighter 
#declare CloudBrightness3 = .04;  // .01 - 1: smaller is brighter
#declare High_MSamples = 1; //0=off 1=on
#declare NumElements1 = 30;     // 10 - 50
#declare NumElements2 = 40;     // 10 - 50
#declare NumElements3 = 30;     // 10 - 50
#declare R1 = seed(23456);
#declare ElementRadius1 = 15;   //20 - 100
#declare ElementRadius2 = 15;   //20 - 100
#declare ElementRadius3 = 15;   //20 - 100 


////////////////////////////////////////
//  Cloud and Cloud Media
////////////////////////////////////////
#declare Media3 =
media {
	emission .05/CloudScale
	//scattering {1, White extinction CloudBrightness3/CloudScale}
	method 3
	intervals 1
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end
	density {
		gradient y            //gradient y , spherical
		turbulence 1
		color_map {
			[0.0 color rgb <0, 0, 0>]
			[0.5 color rgb <.0, .0, .0>]
			[1.0 color rgb <1, 1, 1>]
		}
	}
        scale 5 //10
}

#declare Media1 =
media {
	emission 0.05/CloudScale
	scattering {1, White extinction CloudBrightness1/CloudScale}
	method 3
	intervals 1
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end
	density {
		spherical
		turbulence .5
		color_map {
			[0.0 color rgb <0, 0, 0>]
			[0.5 color rgb <.1, .1, .1>]
			[1.0 color rgb <1, 1, 1>]
		}
	}
	scale 30
}

#declare Cloud1 = 
  blob { 
     threshold .6
     #declare N=1;
     #while (N<NumElements1)
//        sphere { <rand(R1)*ElementRadius1, rand(R1)*ElementRadius1 , rand(R1)*ElementRadius1>, ElementRadius1,1 
        sphere{ < (rand(R1) * ElementRadius1) + rand(R1), 
                  (rand(R1) * ElementRadius1) + rand(R1), 
                  (rand(R1) * ElementRadius1) + rand(R1) >,
                  ElementRadius1 + rand(R1),1
           scale <.5,1,.5>
           rotate <rand(R1)*180,rand(R1)*180,rand(R1)*180>
        }
        #declare N = N + 1;
     #end 
     texture{pigment{rgbt <1,1,1,1>}}
     finish { ambient 1 diffuse 1 }
     hollow on
     interior { media { Media1 }} 
     sturm  
}
