//	"Innocent Shadow"
//	Written by Mark Slone  slone@hiwaay.net
//	December 2002  
//	IRTC "Frozen Moment" Entry

#include "BrickWall.inc"
#include "Sidewalk.inc"
#include "Parts.inc"
#include "Leaves.inc"
#include "functions.inc"

#version 3.5;

//	1 POV unit ~ 1 foot
//	Created at 999x666  Original AA  Threshold 0.3, Recursion 2, Jitter 0.0

//	Full = 0  Draws simple shapes
//	Full = 1  Draws stucco/mortar as isosurface
//	Full = 2  Draws bricks and other costly details

#declare Full = 2;

#declare Soft = 1;  		//  Soft shadows 0 off, 1 on
#declare 	Softness = 8;   //  4 for fast, 8 for final render (if Soft = 1)
#declare RadOn = 1;  		//  0 none, 1 standard, 2 high quality, recursion... too slow

//	Varied light source brightness and assumed_gamma to lighten image

#declare Bright = 1.15;  //  Brightness factor

global_settings { 

	assumed_gamma 1.6  //  Originally created on a Macintosh (Display gamma 1.8)
	ambient_light rgb <0.01, 0.01, 0.01>  //  1/100th
  	max_trace_level 15  //  5 is the default, more needed for radiosity & transparent leaves

//	Radiosity

#if ( RadOn > 0 )

radiosity {

//	Outdoor sunlight radiosity settings

      pretrace_start 0.08	//  0.08 is default (block size, %)
      count 50				//  Time critical
      nearest_count 4		//  5 (default) - 20 (max) are good
      error_bound 0.8		//  Time critical

//	Fast radiosity

#if ( RadOn = 1 ) 

      recursion_limit 1		//  3 is the default
      pretrace_end 0.04		//  0.04 is default (block size, %)

//	Slow radiosity

#else
      recursion_limit 3		//  3 is the default, 20 maximum
      pretrace_end 0.02		//  0.04 is default (block size, %)
#end

      low_error_factor 0.9  //  *error_bound during pretrace
      gray_threshold 0.0	//  .% you gray out radiant light
      minimum_reuse 0.015	//  0.015 is default (% of the screen width)
      brightness 1.0		//  Overall scene brightness control
      adc_bailout 0.01/2	//  0.01 is default (point contribution is insignificant)

			}
#end
                  }  //  end of global settings
 
//	The girl (444x580 pixels)

#macro Girl(Trans)
box {
        < 0.01, 0.01, 0.01>, < 0.99, 1.3, 0.001>
  pigment {
    image_map {

#if ( Trans = 0 )
        gif "girl.gif"  //  Black mask (modified for dress)
#else
        gif "girlcolor.gif"  //  Not used (visible "ghost" idea)
#end

        once
        map_type 0
        interpolate 2

#if ( Trans = 0 )
        transmit 0, 1.0  //  transparent background (girl.gif)
#else
#local TCount = 0; 
#while ( TCount < 256 )
	transmit TCount, Trans
#local TCount = TCount + 1;
#end

        transmit 227, 1.0  //  transparent background (girlcolor.gif)
#end
             }  //  end of image_map
        scale < 1.0, 1.3063, 1.0 >
           }

  finish { ambient <100, 100, 100>  diffuse 0.0}  //  Full brightness

	scale <2.3, 2.4, 1.0>
	rotate -1.789911*x  //  Angle edge to the sun to hide its shadow on the sidewalk
	translate <3.2, 1.1, -2.5>  //  realistic distance from wall, she's jumped 1.1' up

     }
#end

//	The rope

#macro Rope(Angle, Trans)

difference {
	torus{ 9.0, 0.022 }
	plane { <-1, 0, 0>, 0  rotate  25*y }
	plane { < 1, 0, 0>, 0  rotate -25*y }

	pigment { color rgbt <0,0,0, Trans> }
	rotate 90*x
	scale <1, 1, 0.001>  //  thin to hide shadow on sidewalk

//	Rotate about attach point on pipe:

	translate <-3.804, 8.157, 0>
	rotate Angle*x
	translate < 3.804, -8.157, 0>

	translate <3.4, 10.5, -1.5> 
			}
#end

//	Display the scene

camera {

//  Tilt the camera

  rotate 10*z

  location <6.5, 4, -11>
  right <1.5, 0, 0>
  look_at <6.5, 1, 0>
  angle 55
 		}

//	The sky

sky_sphere {
	pigment {
		gradient y
		color_map {
       		[0.00 color rgb <1.00, 0.90, 0.80>*Bright]  //  Horizon
       		[0.25 color rgb <0.40, 0.50, 0.90>*Bright]  //  Sky
       		[0.50 color rgb <0.30, 0.40, 0.70>*Bright]  //  Straight up
           		   }
         	 }
            }

//  ********  GLOBAL LIGHTS

//	The sun  0.5 degree soft light

light_source {
  <24000, 48000, -1500>
  color rgb < 1.4, 1.25, 1.05 >*Bright
  media_interaction off
  parallel
  point_at <0,0,0>

#if ( Soft > 0 ) 
    	area_light <0, 520, 52>, <0, -52, 520>, Softness, Softness
		adaptive 1
		jitter
		circular
		orient
#end
              }

//	Secondary lights from right and left (very soft)

light_source { <30, 4.5,  -4>  //  Right
	color rgb < 1., 1., 1.>*Bright  
	fade_distance 20
	fade_power 2

#if ( Soft > 0 ) 
    	area_light <0, 1.5, 0>, <0, 0, 1.5>, (Softness*0.5), (Softness*0.5)
		adaptive 0
		jitter
		circular
		orient
#end
			}


light_source { <-20, 2, -2>  //  Left
	color rgb < 1., 1., 1.>*Bright  
	fade_distance 20  //  was 25 
	fade_power 2  //  was 3

#if ( Soft > 0 ) 
    	area_light <0, 1.5, 0>, <0, 0, 1.5>, (Softness*0.5), (Softness*0.5)
		adaptive 0
		jitter
		circular
		orient
#end
			}

//	Weak fill light (for outside doorway)

light_source { <11.5, 2.5, -3>
	color rgb < 1.0, 0.9, 0.9>*Bright  
	fade_distance 2.0
	fade_power 2.0

#if ( Soft > 0 ) 
    	area_light <0, 0.5, 0>, <0, 0, 0.5>, (Softness*0.5), (Softness*0.5)
		adaptive 0
		jitter
		circular
		orient
#end
			  }

//	The mushroom base reflection lighting

light_source {   
	<11, 10, -12>
  	color rgb < 1.5, 1.35, 1.05 >*0.2*Bright

	parallel
	point_at <11, 2, 2>	

#if ( Soft > 0 ) 
    	area_light <0, 0.3, 0>, <0, 0, 0.3>, (Softness*0.5), (Softness*0.5)
		adaptive 1
		jitter
		circular
		orient
#end

projected_through {

//	Window on baseboard

	difference { 
		box { <-0.7, -0.2, -0.01>, <0.7, 0.8, 0.01> }
		box { <-0.6, -1, -0.02>, <0.6, 1, 0.02>  rotate 30*z  translate <-1.1, 0, 0> }
		box { <-0.6, -1, -0.02>, <0.6, 1, 0.02>  rotate 30*z  translate < 1.0, 1, 0> }
		rotate -15*y
		translate <6.0, 2.7, -5>
		 }

					}  //  end of projected_through
			}  //  end of light_source

//	The tunnel floor "reflections" - maybe better with none or one?

light_source {   
	<11, 10, -12>
  	color rgb < 1.5, 1.35, 1.05 >*Bright

	parallel
	point_at <11, 2, 2>	

#if ( Soft > 0 ) 
    	area_light <0, 0.15, 0>, <0, 0, 0.15>, Softness, Softness
		adaptive 1
		jitter
		circular
		orient
#end

projected_through {
	union {

//	Some "slots"

	box { <-0.6, -0.001, -0.04>, <0.6, 0.001, 0.04> 
		rotate -45*y translate <11.0, 4.5, -5>
		 }
	box { <-0.5, -0.001, -0.03>, <0.6, 0.001, 0.03> 
		rotate -45*y translate <11.0, 4.4, -5>
		 }
	box { <-0.4, -0.001, -0.02>, <0.6, 0.001, 0.02> 
		rotate -45*y translate <11.0, 4.3, -5>
		 }
	box { <-0.3, -0.001, -0.01>, <0.6, 0.001, 0.01> 
		rotate -45*y translate <11.0, 4.2, -5>
		 }

	box { <-0.6, -0.001, -0.04>, <0.6, 0.001, 0.04> 
		rotate -45*y translate <11.0, 5.3, -5>
		 }
	box { <-0.5, -0.001, -0.03>, <0.6, 0.001, 0.03> 
		rotate -45*y translate <11.0, 5.2, -5>
		 }
	box { <-0.4, -0.001, -0.02>, <0.6, 0.001, 0.02> 
		rotate -45*y translate <11.0, 5.1, -5>
		 }
	box { <-0.3, -0.001, -0.01>, <0.6, 0.001, 0.01> 
		rotate -45*y translate <11.0, 5.0, -5>
		 }

			}  //  end of union
					}  //  end of projected_through
			}  //  end of light_source

//	********  LIGHT GROUP

light_group {

//	The brick wall

union {

object { 
	BrickWall(9.5, 6, Full) 
	translate <0.0, 0.5, 0>
		}

//	Her shadow (invisible solid image)

object { Girl(0)  no_image  no_reflection }

//  The rope (rotation, transparency for motion blur)

object { Rope( 10, 0.85)  no_image  no_reflection }
object { Rope(  5, 0.80)  no_image  no_reflection }
object { Rope(  0, 0.75)  no_image  no_reflection }
object { Rope( -5, 0.80)  no_image  no_reflection }
object { Rope(-10, 0.85)  no_image  no_reflection }

	pigment { color rgb <5,0,0> }  //  Test color

	}  //  end of union

//	The nuclear flash
//	Only lights the brick wall
//	23.3 degrees up places the girl at 814 meters from the blast epicenter (350 meters up)

light_source { <10, 12, -27>
	color rgb < 1., 1., 1.>*Bright  
	fade_distance 15
	fade_power 2 
	parallel
	point_at <3,0,0>

#if ( Soft > 0 ) 
    	area_light <0, 0.7, 0>, <0, 0, 0.7>, Softness, Softness
		adaptive 1
		jitter
		circular
		orient
#end

			  }  //  end of blast shadow light source

    global_lights on
			}  //  end of blast shadow light group

//	An infinite "ground" for test purposes

object {
	plane { <0,1,0>, -0.5 }
	pigment { color rgb <0.8, 0.8, 0.8> }
		}

//	The (almost) visible girl (image not used)

//object { Girl(0.95)  translate <0.01, 0.01, 0.01>  no_shadow }

//	The pipe (shadows brick wall, but not in light group)
//	Text decal on pipe is very expensive (transparency)

object { Pipe(Full) }

//	The sidewalk

object { Sidewalk(Full) }

//	The flower vase and it's shadow on the sidewalk
//	The leaves, cranes and cenotaph

#if ( Full > 0 )
	object { Leaves }
	object { Tulips  no_shadow }
	object { Tulips  scale <1, 0.2, 1>  no_image  no_reflection }  //  no shadow on wall from flash (scaled short)
	object { Cranes }
	object { Cenotaph }
#end

//	The window

#if ( Full > 0 ) object { Window }  #end

//	The doorway (and "baseboard")

#if ( Full > 0 ) 
	object { BaseBoard }
	object { DoorPillar   scale <1.0, 0.95, 1> }  
	object { DoorPillar  translate <5.2, 0, 0> }  //  right pillar not visible (shadow only)
	object { box {<14.15, 0, 0>,<18, 10, 1>} pigment { color rgb 0 } }  //  block light leak
	object { DoorArch }  

	object { DoorWay  pigment { color rgb <5,0,0> } }  //  includes surrounding
#end

//	The rising sun over door

#if ( Full > 0 ) CopperSun  #end

//	The tree shadow (15.45' high)

#if ( Full > 0 )

object { 
	#include "ShadowTree.inc" 
	texture{ pigment { color rgb 0.3 } }
	scale 0.2
	rotate 45*y
	translate <20.2, 0, -2.7>
		}
#end

//	THE ROOF

//	The second floor (roof)

object { 
	box { <0, 0, 0>, <30, 11.5, 10> }
	pigment { color rgb <1, 0.8, 0.8> }		
	translate <0.2, 7.0, 0>
		}

//	Roof tiles

#local Tile =
difference {
    cylinder { <0,  0,     0>, <0,  0,    2>,    0.3 }
    cylinder { <0.,-0.05, -1.> <0.,-0.05, 3>, 0.3 }
			}

union {

//	First small tiles (left)

#local TileCount = 9.5;
#while (TileCount <14)

	object { Tile  rotate -45*x  
				translate <TileCount, 18.5, -1.0> 
			}
	object { Tile  rotate 180*z  rotate -45*x  
				translate <TileCount + 0.325, 18.45, -0.95>
			} 

#local TileCount = TileCount + 0.65;
#end

//	Large tiles (right)

#local TileCount = 18;
#while (TileCount <24)

#if ( TileCount > 20 )  //  stagger spacing 
	#local TileCount = TileCount + 0.10;
#end

	object { Tile  scale 1.54 rotate -45*x  
				translate <TileCount, 18.5, -1.0> 
			}
	object { Tile  scale 1.54 rotate 180*z  rotate -45*x  
				translate <TileCount + 0.5, 18.45, -0.95>
			} 

#local TileCount = TileCount + 1.0;
#end

//	No tiles (soffit)

	object { box { <0,0,0>, <6, 1, 2> }  translate <13, 18.45, -0.95> }
		
	pigment { color rgb 0 }
	   }  //  end of union
	
//	Black building across the street (reduce blue sky radiance)

object {
	box { <-80, 0, 0>, <80, 80, -20> }  //  Across the street
	pigment { color rgb <0.0, 0.0, 0.0> }
	translate <0, 0, -30>
		}

