
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "woods.inc"
#include "stones.inc"
#include "glass.inc"
#include "metals.inc"

/////////////// textures ////////////////
#local t_frame =
        texture { pigment { Tan }
                normal { bumps 0.1 scale 0.002 }
                finish { ambient 0 diffuse 0.4 roughness 0.1}
        }
#local t_roof =
        texture { pigment { Gray50 }
                normal { bumps 0.1 scale 0.002 }
                finish { ambient 0 diffuse 0.4 roughness 0.1}
        }
#declare t_snow =
texture{
  pigment{rgb <0.9,0.9,0.9>}
//  finish{ambient 0.4 diffuse 0.4 specular 0.0 roughness 0.1}
  finish{ambient 0 diffuse 0.65 roughness 0.1}
  normal{
    average 2
    normal_map{
        [bozo 2 scale .05 turbulence 0.75]
        [bumps 0.4 scale 0.02]
        [bumps .40 scale 0.00001]
    }
  }
}

////////////////// basic house ////////////
#local box_1 = union{
  box{ <0,0,0>, <20,10,25>}
  box{ <0,0,0>, <14.1,14.1,25> rotate z*45 translate x*10}
}
#local roof_1 = difference{
  object{box_1 translate y*.02}
  box{ <-0.1,0,-0.1>, <20.1,10,25.1>}
  box{ <0,0,-0.1>, <14.1,14.1,25.1> rotate z*45 translate <10,-0.2,0>}
  texture{t_roof} 
}
#local box_2 = union{
  box{ <10,0,8>, <23,10,25>}
  box{ <10,0,0>, <23,12,12> rotate x*45 translate <0,10,8> }
}
#local roof_2 = difference{
  object{box_2 translate y*.02}
  box{ <-0.1,0,7.9>, <23.1,10,25.1>}
  box{ <9.9,0,0>, <23.1,12,12> rotate x*45 translate <0,10,8> }
  texture{t_roof} 
}

#declare basic_house= difference{
  union{
    object{box_1 texture{t_frame} translate y*-4}
    object{roof_1 texture{t_snow} scale <1,1,1.04> translate <0,-4,-0.5>}
    object{box_2 texture{t_frame} translate y*-4}
    object{roof_2 texture{t_snow} scale <1.02,1,1> translate y*-4}
  }
    box{ <-0.1,0,0>, <25,4,25.1> translate y*-4}
} 

