
//*Xmas-tree include-file by Remco de Korte 1998 (made for Vic)
// Light addition by Ken Allred 2002

//The xtree-object is a simple firtree, starting at <0,0,0> up to maxheight

//You can change the tree by altering the rand-seed or the height, or by changing the
//tow increment-steps indeicated below. The setting as it is now is working allright for 
//me, changing it can increase the render-time dramatically.

//extra notes:
//- the semi-colons are for v3.1      
//- it may take some time to parse, depending on the parameters (from a few secs to several hours...)
//- you'll get some degenerate CSG-warnings - I don't know how to avoid those and I didn't think
//    it was a very big problem

//comments to remcodek@xs4all.nl


// default
//#declare needle=sphere{<0,0,0>,1 scale<.75,.1,.1> pigment{rgb<.2,.5,.2>}}
//here you can change the size of the needles - they're quite large and a bit 'fat' now 

#declare needle=sphere{<0,0,0>,1 scale<0.50,0.07,0.07> 
texture{ pigment{rgb<1,.8,1>} finish{ambient 0}}
texture{ pigment{rgbt<.2,.5,.2,.7>} finish{ambient 0}}
}

#declare la = array [5000][7]  // light array
#declare lp = 0;               // light pointer
#ifndef (uselights)            // 0= no lights, 1= lights off, 2= lights on
  #declare uselights =0;        
#end
#if (uselights = 1)
#declare red_light=sphere{<0,0,0>,.15 
        texture{ pigment{rgb<1,0,0>} finish{ambient 1}}
}
#declare green_light=sphere{<0,0,0>,.15 
        texture{ pigment{rgb<0,1,0>} finish{ambient 1}}
}
#declare blue_light=sphere{<0,0,0>,.15 
        texture{ pigment{rgb<0,0,1>} finish{ambient 1}}
}
#declare yellow_light=sphere{<0,0,0>,.15 
        texture{ pigment{rgb<1,1,0>} finish{ambient 1}}
}
#declare purple_light=sphere{<0,0,0>,.15 
        texture{ pigment{rgb<1,0,1>} finish{ambient 1}}
}
#end
#if (uselights > 1)
#declare red_light =
        light_source { 0*x color rgb <0.4,0,0>
        fade_distance .07 fade_power 2
        looks_like { sphere { <0,0,0>, .15 pigment { rgbf <1,0,0,1> } finish { specular 1.8}}}
        }
#declare green_light =
        light_source { 0*x color rgb <0,0.3,0>
        fade_distance .07 fade_power 2
        looks_like { sphere { <0,0,0>, .15 pigment {  rgbf <0,1,0,1> } finish { specular 1.8 }}}
        }
#declare blue_light =
        light_source { 0*x color rgb <0,0,0.4>
        fade_distance .07 fade_power 2
        looks_like { sphere { <0,0,0>, .15 pigment {  rgbf <0,0,1,1> } finish { specular 1.8 }}}
        }
#declare yellow_light =
        light_source { 0*x color rgb <0.25,0.25,0>
        fade_distance .07 fade_power 2
        looks_like { sphere { <0,0,0>, .15 pigment {  rgbf <1,1,0,1> } finish { specular 1.8 }}}
        }
#declare purple_light =
        light_source { 0*x color rgb <0.25,0,0.25>
        fade_distance .07 fade_power 2
        looks_like { sphere { <0,0,0>, .15 pigment {  rgbf <1,1,0,1> } finish { specular 1.8 }}}
        }
#end

#macro selectLight( llc )
  #switch (llc)
    #range(.0,.2)
      #declare xlight = purple_light
    #break
    #range(.2,.4)                                            
      #declare xlight = red_light
    #break
    #range(.4,.6)
      #declare xlight = green_light
    #break
    #range(.6,.8)
      #declare xlight = blue_light
    #break
    #range(.8,1)
      #declare xlight = yellow_light
    #break
  #end              
#end

#declare branch_text=texture{pigment{rgb<.5,.4,.2>} normal{bumps.9 turbulence .7 scale .025}}

#declare maxheight=30;

#declare r=seed(777);
#declare l=seed(678);  //light locations
#declare lc=seed(333); //lamp colors

//start the tree:

#declare xtree=union{

//the stem (is that the right word?) of the tree, width at top and foot depending on the height
  cone{<0,0,0>,maxheight/50,<0,maxheight,0>,maxheight/200 texture{branch_text}}

//the top
  sphere{<0,maxheight,0>,maxheight/175 texture{branch_text}} 
  
  #declare cc=maxheight/15;
  
//this starts the branches of at 1/15th of the tree's size off the ground.
  #while (cc<maxheight)
  #declare r1 = rand(r);
//start a branch:  
  union{
    #declare i=0;
    #declare dd=(maxheight*.95-cc)/2.5;

//put needles on the branch:
    #while (i<dd)
    union{
      sphere{<0,0,0>,.2 scale <1,2.5,1> texture{branch_text}}
      #declare j=60*rand(r);
//put the needles all around:
      #while (j<360)
      #declare r2 = rand(r);
        #declare ll=rand(l);
        #switch (ll)
          #range(0,0.975) // controls number of lights
                object{needle translate -x rotate z*-15-i*45/dd rotate y*j+30*rand(r)}
          #break
          #else
            #if (uselights = 0)  // no lights; just put on a needle
              object{needle translate -x rotate z*-15-i*45/dd rotate y*j+30*r2}
            #else                // tree will have lights
              #declare llc=rand(lc);
              selectLight( llc ) // select light color
            #end
            #if (uselights = 1)  // lights will be simple spheres
              object{xlight translate -x rotate z*-15-i*45/dd rotate y*j+30*r2}
            #end
            #if (uselights > 1)  // use real light sources. Will place on tree at end
              #declare la [lp][0] = i;
              #declare la [lp][1] = dd;
              #declare la [lp][2] = j;
              #declare la [lp][3] = r1;
              #declare la [lp][4] = r2;
              #declare la [lp][5] = llc;
              #declare la [lp][6]= cc;
              #declare lp = lp+1;
            #end
        #end
      #declare j=j+60;
      #end

    scale 1-.25*i/dd
    translate y*i
  }

//  #declare i=i+.4;
  #declare i=i+.3;

//the frequency of the needles (~the amount of needles) depends on this step
//if you make it smaller you have more needles and a much more rendertime
  
  #end

rotate z*(-75+cc/2)
//this makes the branch point up a bit (depending on how high it is on the tree)

rotate y*360*r1
//this puts it on the tree somewhere around

translate y*cc
//this puts the branch at its proper height
}

//put some needles on the stem:
  #declare j=0;
  #while (j<360)
    object{needle translate -x rotate z*(-45-15*rand(r)) translate -x*maxheight/400 rotate y*j+30*rand(r) translate y*cc}
  #declare j=j+60;
  #end

#declare cc=cc+.25;

//this step defines the number of branches. 
//There's one branch for each step, but it can be at any side of the tree
//Again, if you make this smaller you'll have more branches, but it'll also render much slower
//You could probably make the tree more realistic by increasing the step towards the top of the tree

#end

}


/////////////////// lights /////////////////

#if (uselights > 1)
  #declare lp = 0;
  #declare ds = dimension_size(la,1);
  #declare lxtree = 
  union{
    #if (uselights = 2)
      #debug "Using Light Group\n"
      light_group {
    #end
    #while (lp < ds)
     #ifndef (la [lp][0])
        #declare lp = ds;
      #else
        #declare i   = la [lp][0];
        #declare dd  = la [lp][1];
        #declare j   = la [lp][2];
        #declare r1  = la [lp][3];
        #declare r2  = la [lp][4]; 
        #declare llc = la [lp][5];
        #declare cc  = la [lp][6];
        selectLight( llc )
        light_source {xlight
          translate -x rotate z*-15-i*45/dd rotate y*j+30*r2
          scale 1-.25*i/dd
          translate y*i
          rotate z*(-75+cc/2)
          rotate y*360*r1
          translate y*cc}
        #declare lp = lp+1;
      #end
    #end
    object {xtree}
    #if (uselights = 2)
      global_lights on
      }
    #end
  }
#else
  #declare lxtree = xtree
#end



//To create a snowy tree take out the pigment of the needle-declaration and use this:


//declare lighttree = object{xtree}

//#declare snowtree=union{
//object{xtree pigment{rgb<.2,.5,.2>}}
//object{xtree pigment{rgb<.95,.975,1>} finish{ambient .7} translate y*.5}
//}

