#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "glass.inc"
#include "metals.inc"

//////////////////////////////////////////////////////////////////////
//                P O R C H   L I G H T         (Ver 1.0)           //
// porchlight.inc by Kenneth Allred, 11/28/02                       //
// the lightbulb was borrowed from bulbsokt.pov by James R. Wilson  //
//////////////////////////////////////////////////////////////////////
#ifndef (Area_Lights)     #local  Area_Lights      = false; #end
#ifndef (UsePhotons)      #local  UsePhotons       = false; #end
#ifndef (PorchLightOn)    #local  PorchLightOn     = false; #end
#ifndef (PorchLightGlass) #local  PorchLightGlass  = false; #end

#local eraser =
  box{ <-.40,0.5,-.40> <.40,1,.40> }// texture { Tinny_Brass finish{ambient 0.4 specular .5}} }
#local pt1 =
  prism { conic_sweep linear_spline
    0.5, 1, 5, <.30,.30>,<-.30,.30>,<-.30,-.30>,<.30,-.30>,<.30,.30>
    scale <1, 1,1>
  }
#local pt2 =
  prism { conic_sweep linear_spline
    0.4, 1, 5, <.30,.30>,<-.30,.30>,<-.30,-.30>,<.30,-.30>,<.30,.30>
    scale <1, 1,1>
  }
#local t_plight = texture { T_Brass_1A finish{ambient 0 specular .5}}
#local t_plbulb = texture {pigment { rgb <1,1,1> } finish { ambient 0 specular 0.5 roughness 0.005}}
#local t_plbulb1 = texture {pigment { rgbt <1,1,1,1> } finish { specular 1.8 roughness 0.5}}

//////////////////////
// Make a Lightbulb //
//////////////////////
#local R1 = 1+3/16;  // bulb radius
#local R2 = 0.5625;  // neck radius
#local h  = 2.3-R1;  // neck height
#local R3 = (2*h*R1+h*h+R2*R2)/(2*(R1-R2));
#local s  = (R1*(R2+R3))/(R1+R3);

#declare bulb =
//union {
  merge {
    sphere { <0,0,0>, R1 }
    difference {
      cylinder { <0,-(R1+h),0>, <0, 0,0>, s }
      torus { R2+R3, R3 translate <0, -(R1+h), 0> }
    }
    cylinder { <0,-(R1+h),0>, <0,0.1-(R1+h),0>, R2 pigment { rgbt <1,1,1,1> } finish { specular 1.8}}
  }
//}
//////////////////////////
// Assemble Porch Light //
//////////////////////////

#declare PorchLight =
union{
  cylinder { 0*y,0.03*y,0.04 texture { t_plight} translate y*1.10}
  sphere { <0, 0, 0> 0.06 texture { t_plight} translate y*1.17}
  difference{   //top cap
    sphere { <0, 0, 0> 0.32 texture { t_plight} scale <1,0.5,1>}
    object{eraser translate -0.95*y}
    translate y*0.95
  }
  sphere { <0, 0, 0> 0.02 texture { t_plight} scale <1,1,1> translate <0.28,1.00,0.28>}
  sphere { <0, 0, 0> 0.02 texture { t_plight} scale <1,1,1> translate <0.28,1.00,-0.28>}
  sphere { <0, 0, 0> 0.02 texture { t_plight} scale <1,1,1> translate <-0.28,1.00,-0.28>}
  sphere { <0, 0, 0> 0.02 texture { t_plight} scale <1,1,1> translate <-0.28,1.00,0.28>}
  difference{   //top plate
    object{pt1 texture { t_plight}}
    object{eraser translate -0.03*y}
  }
  difference{   //middle
    object{pt1 texture { t_plight} scale <1,1,1>}  
    object{pt2 texture { t_plight} scale <0.9,1,1.2>}
    object{pt2 texture { t_plight} scale <1.2,1,0.9>}
  }
  #if(PorchLightGlass)
    difference{  //glass
      object{pt1 texture { pigment { color Clear } finish { F_Glass1 }} scale <.98,1,.98>}  
      object{pt2 texture { pigment { color Clear } finish { F_Glass1 }} translate y*0.02}
      object{eraser translate 0.47*y}
      object{eraser translate -0.47*y}
    }           
  #end
  #if(PorchLightOn)
    #if(Area_Lights)
      light_source { 0*x color rgb <0.5,0.5,0.5>
        fade_distance .5 fade_power 2
        area_light <0, 0, -.06> <0, 0, .06> 4, 4
        adaptive 1 jitter circular orient
        fade_distance 1 fade_power 1
        looks_like { object{bulb texture{t_plbulb1} scale .11 }}
        translate y*0.8
        #if(UsePhotons)
          photons { area_light refraction on reflection on}
        #end
      }
    #else
      light_source { 0*x color rgb <0.5,0.5,0.5>
        fade_distance 1 fade_power 1
        looks_like { object{bulb texture{t_plbulb1} scale .11 }}
        translate y*0.8
        #if(UsePhotons)
          photons { refraction on reflection on}
        #end
      }
    #end
  #else
    object{bulb texture{t_plbulb} scale .11 translate y*0.8}
  #end
  cylinder { 0*y,0.06*y,0.08 texture { t_plight} translate y*0.53}
  difference{  //bottom plate
    object{pt1 texture { t_plight} }
    object{eraser translate 0.03*y}
  }
  difference{  //bottom cap
    sphere { <0, 0, 0> 0.16 texture { t_plight} scale <1,1.6,1>}
    object{eraser translate -0.6*y}
    translate y*0.6
  }
  cylinder { 0*y,0.10*y,0.03 texture { t_plight} translate y*0.26}
  sphere { <0, 0, 0> 0.05 texture { t_plight} translate y*0.24}
  sphere { <0, 0, 0> 0.025 texture { t_plight} scale <1,1.5,1> translate y*0.20}
  cylinder { 0*z,0.38*z,0.04 texture { t_plight} translate <0,0.43,0.08>}
  difference{  //mounting plate
    sphere { <0, 0, 0> 0.15 texture { t_plight}} 
    object{eraser translate <0,-0.75,0.35>}
     scale <2,2,1> translate <0,0.42,0.60>
  }

}
/////////////
// The End //
/////////////
