
default {
  texture {
    pigment { rgb <1,0,0> }
  }
}


global_settings {

  radiosity {             // --- Settings 1 (fast) ---
    pretrace_start 0.08
    pretrace_end   0.02
    count 50
    error_bound 0.5
    recursion_limit 1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <    -10.541,     -36.920,       6.725>
  sky       <    0.00000,     0.00000,     1.00000>
  up        <        0.0,         0.0,         1.0>
  right     <    1.38192,         0.0,         0.0>
  angle         54.40000    // Vertical      40.800
  look_at   <      0.000,       0.827,       5.516>
}


// LIGHTS

light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.534, 0.629, 1.000>*3.0000
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 8, 8
  adaptive 5
  jitter
  fade_distance  100.0
  fade_power 4.0
  scale <9.0, 10.0, 1.0>
  rotate <-90.0, 0.0, -45.0>
  translate  <69.977167, 87.154512, 10.0>
}


light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 1
  jitter
  fade_distance  15.0
  fade_power 4.0
  scale <5.0, 1.0, 1.0>
  translate  <-12.0, 108.0, 23.0>
}


light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  fade_distance  20.0
  fade_power 6.0
  scale <1.0, 4.0, 1.0>
  translate  <0.0, 34.0, -3.2>
}


light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  fade_distance  20.0
  fade_power 4.0
  scale <4.0, 1.0, 1.0>
  translate  <2.5, 16.5, -2.5>
}


light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  20.0
  fade_power 2.0
  translate  <-12.0, 9.0, 21.4>
}

light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  20.0
  fade_power 2.0
  translate  <8.0, 9.0, 21.4>
}

light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  fade_distance  30.0
  fade_power 4.0
  scale <4.0, 1.0, 1.0>
  rotate 45.0*z
  translate  <32.974713, 30.305184, -2.5>
}


light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 1
  jitter
  fade_distance  15.0
  fade_power 4.0
  scale <5.0, 1.0, 1.0>
  translate  <12.0, 108.0, 23.0>
}




// MATERIALS


#declare Muro_bianco = 
   material  // Muro_bianco
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }      
         finish
         {
            ambient 0.0
            diffuse 0.8
            phong_size 0.0
            specular 0.2
            roughness 0.0001
         }
      }
   }



#declare PDB_Tex_CE = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <0.833333, 0.677067, 0.634871>
         }      
         finish
         {
            ambient 0.15
            specular 0.7266
            roughness 0.006139
         }
      }
   }


#declare Crystal = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgbf <0.98, 0.98, 0.98, 0.9>
         }      
         finish
         {
            ambient 0.1
            diffuse 0.1
            phong 1.0
            phong_size 100.0
            specular 0.8
            roughness 0.0003
            reflection 0.1
         }
      }   
      interior
      {
         ior 1.45
      }
   }



#declare _auto_name_no_1_ = 
   texture
   {   
      pigment
      {
         marble
         color_map
         {
            [ 0.0     rgbft <0.831, 0.631, 0.569, 0.0, 0.0> ]
            [ 0.178   rgbft <0.925, 0.831, 0.714, 0.0, 0.0> ]
            [ 0.356   rgbft <0.871, 0.702, 0.659, 0.0, 0.0> ]
            [ 0.525   rgbft <0.831, 0.631, 0.569, 0.0, 0.0> ]
            [ 0.729   rgbft <0.937, 0.882, 0.82, 0.0, 0.0> ]
            [ 1.0     rgbft <0.831, 0.631, 0.569, 0.0, 0.0> ]
         }
         turbulence 0.5
         ramp_wave
      }   
      finish
      {
         ambient 0.2
         crand 0.03
      }
   }
   texture
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.729, 0.502, 0.451, 0.306, 0.0> ]
            [ 0.153   rgbft <0.769, 0.686, 0.592, 0.792, 0.0> ]
            [ 0.398   rgbft <0.843, 0.753, 0.718, 0.396, 0.0> ]
            [ 0.559   rgbft <0.78, 0.667, 0.561, 0.976, 0.0> ]
            [ 0.729   rgbft <0.741, 0.659, 0.576, 0.82, 0.0> ]
            [ 1.0     rgbft <0.729, 0.502, 0.451, 0.306, 0.0> ]
         }
         turbulence 0.6
         ramp_wave
      }   
      finish
      {
         ambient 0.1
         phong 1.0
         phong_size 90.0
      }
   }

#declare T_Stone12 = 
   material  // T_Stone12
   {   
      texture { _auto_name_no_1_ }
   }



#declare _auto_name_no_1_ = 
   texture
   {   
      pigment
      {
         color rgb <0.0, 0.0, 0.0>
      }
   }
   texture
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.996, 0.824, 0.78, 0.412, 0.0> ]
            [ 0.154   rgbft <0.996, 0.698, 0.624, 0.412, 0.0> ]
            [ 0.308   rgbft <0.906, 0.675, 0.553, 0.616, 0.0> ]
            [ 0.444   rgbft <0.996, 0.682, 0.604, 0.412, 0.0> ]
            [ 0.615   rgbft <0.996, 0.824, 0.78, 0.412, 0.0> ]
            [ 0.812   rgbft <0.973, 0.627, 0.627, 0.6, 0.0> ]
            [ 1.0     rgbft <0.996, 0.824, 0.78, 0.412, 0.0> ]
         }
         turbulence 0.6
         ramp_wave
      }   
      finish
      {
         ambient 0.1
         crand 0.03
      }
   }
   texture
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.863, 0.757, 0.596, 0.596, 0.0> ]
            [ 0.144   rgbft <0.925, 0.792, 0.714, 0.349, 0.0> ]
            [ 0.288   rgbft <0.871, 0.702, 0.659, 0.784, 0.0> ]
            [ 0.644   rgbft <0.992, 0.922, 0.659, 0.498, 0.0> ]
            [ 0.983   rgbft <0.902, 0.812, 0.714, 0.722, 0.0> ]
            [ 1.0     rgbft <0.863, 0.757, 0.596, 0.596, 0.0> ]
         }
         turbulence 0.6
         ramp_wave
      }
   }
   texture
   {   
      pigment
      {
         marble
         color_map
         {
            [ 0.0     rgbft <0.0, 0.0, 0.0, 0.6, 0.0> ]
            [ 0.04    rgbft <0.0, 0.0, 0.0, 1.0, 0.0> ]
            [ 0.04    rgbft <0.55, 0.09, 0.09, 0.8, 0.0> ]
            [ 0.97    rgbft <0.329412, 0.329412, 0.329412, 0.9, 0.0> ]
            [ 0.97    rgbft <0.0, 0.0, 0.0, 0.9, 0.0> ]
            [ 1.0     rgbft <0.0, 0.0, 0.0, 1.0, 0.0> ]
         }
         turbulence 0.85
         ramp_wave
      }   
      finish
      {
         ambient 0.1
         phong 1.0
         phong_size 90.0
      }
   }

#declare T_Stone11 = 
   material
   {   
      texture { _auto_name_no_1_ }
   }


#declare Material1 = 
   material  // Material1
   {   
      texture
      {
         checker
            texture
            {            
               pigment
               {
                  granite
                  color_map
                  {
                     [ 0.0     rgbft <1.0, 0.718, 0.541, 0.0, 0.0> ]
                     [ 0.202   rgbft <0.89, 0.651, 0.612, 0.0, 0.0> ]
                     [ 0.298   rgbft <1.0, 0.82, 0.675, 0.0, 0.0> ]
                     [ 0.377   rgbft <0.89, 0.643, 0.612, 0.0, 0.0> ]
                     [ 0.465   rgbft <0.937, 0.729, 0.561, 0.0, 0.0> ]
                     [ 0.544   rgbft <0.878, 0.604, 0.565, 0.0, 0.0> ]
                     [ 0.64    rgbft <0.984, 0.78, 0.655, 0.0, 0.0> ]
                     [ 0.86    rgbft <1.0, 0.863, 0.635, 0.0, 0.0> ]
                     [ 0.982   rgbft <1.0, 0.765, 0.62, 0.0, 0.0> ]
                     [ 1.0     rgbft <1.0, 0.718, 0.541, 0.0, 0.0> ]
                  }
                  turbulence 0.4
                  ramp_wave
               }            
               finish
               {
                  ambient 0.0
                  reflection 0.15
               }
            }
            texture
            {            
               pigment
               {
                  granite
                  color_map
                  {
                     [ 0.0     rgbft <0.804, 0.569, 0.494, 0.0, 0.0> ]
                     [ 0.178   rgbft <0.855, 0.729, 0.584, 0.0, 0.0> ]
                     [ 0.356   rgbft <0.667, 0.502, 0.478, 0.0, 0.0> ]
                     [ 0.525   rgbft <0.859, 0.624, 0.545, 0.0, 0.0> ]
                     [ 0.729   rgbft <0.855, 0.729, 0.584, 0.0, 0.0> ]
                     [ 1.0     rgbft <0.804, 0.569, 0.494, 0.0, 0.0> ]
                  }
                  turbulence 0.5
                  ramp_wave
               }            
               finish
               {
                  ambient 0.0
                  reflection 0.15
               }
            }
      }
   }


#declare Midnight_Sky = 
   material  // Midnight_Sky
   {   
      texture
      {      
         pigment
         {
            bozo
            color_map
            {
               [ 0.0     rgbft <0.25, 0.25, 0.5, 0.0, 0.0> ]
               [ 0.5     rgbft <0.25, 0.25, 0.5, 0.0, 0.0> ]
               [ 0.6     rgbft <0.7, 0.7, 0.7, 0.0, 0.0> ]
               [ 1.0     rgbft <0.3, 0.3, 0.3, 0.0, 0.0> ]
            }
            turbulence 0.3
            ramp_wave
         }
      }
   }


#declare Muro_marrone = 
   material  // Muro_marrone
   {   
      texture
      {      
         pigment
         {
            color rgb <0.833333, 0.677067, 0.634871>
         }      
         finish
         {
            ambient 0.0
            specular 0.7266
            roughness 0.006139
         }
      }
   }


#declare _auto_name_no_1_ = 
   texture
   {   
      pigment
      {
         marble
         color_map
         {
            [ 0.0     rgbft <0.894, 0.886, 0.886, 0.0, 0.0> ]
            [ 0.154   rgbft <0.745, 0.745, 0.753, 0.0, 0.0> ]
            [ 0.308   rgbft <0.902, 0.902, 0.859, 0.0, 0.0> ]
            [ 0.444   rgbft <0.729, 0.706, 0.694, 0.0, 0.0> ]
            [ 0.615   rgbft <0.588, 0.592, 0.635, 0.0, 0.0> ]
            [ 0.803   rgbft <0.608, 0.616, 0.659, 0.0, 0.0> ]
            [ 1.0     rgbft <0.894, 0.886, 0.886, 0.0, 0.0> ]
         }
         turbulence 0.6
         ramp_wave
      }   
      finish
      {
         ambient 0.2
         crand 0.03
      }
   }
   texture
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.31, 0.384, 0.42, 0.631, 0.0> ]
            [ 0.119   rgbft <0.322, 0.369, 0.416, 0.847, 0.0> ]
            [ 0.322   rgbft <0.424, 0.369, 0.42, 0.549, 0.0> ]
            [ 0.449   rgbft <0.373, 0.424, 0.518, 0.965, 0.0> ]
            [ 0.729   rgbft <0.482, 0.573, 0.533, 0.741, 0.0> ]
            [ 1.0     rgbft <0.31, 0.384, 0.42, 0.631, 0.0> ]
         }
         turbulence 0.6
         ramp_wave
      }   
      finish
      {
         ambient 0.1
         phong 1.0
         phong_size 90.0
      }
   }

#declare T_Stone13 = 
   material
   {   
      texture { _auto_name_no_1_ }
   }


#declare _auto_name_no_1_ = 
   texture  // T_Grnt29
   {   
      pigment
      {
         marble
         color_map
         {
            [ 0.0     rgbft <0.784, 0.627, 0.522, 0.0, 0.0> ]
            [ 0.053   rgbft <0.784, 0.627, 0.624, 0.0, 0.0> ]
            [ 0.263   rgbft <0.824, 0.557, 0.376, 0.0, 0.0> ]
            [ 0.281   rgbft <0.643, 0.38, 0.376, 0.0, 0.0> ]
            [ 0.325   rgbft <0.839, 0.722, 0.722, 0.0, 0.0> ]
            [ 0.711   rgbft <0.784, 0.627, 0.522, 0.0, 0.0> ]
            [ 0.798   rgbft <0.769, 0.38, 0.376, 0.0, 0.0> ]
            [ 0.895   rgbft <0.824, 0.557, 0.376, 0.0, 0.0> ]
            [ 0.982   rgbft <0.784, 0.627, 0.522, 0.0, 0.0> ]
            [ 1.0     rgbft <0.784, 0.627, 0.522, 0.0, 0.0> ]
         }
         turbulence 0.5
         ramp_wave
      }
   }
   texture
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.784, 0.627, 0.522, 0.5, 0.0> ]
            [ 0.053   rgbft <0.784, 0.627, 0.624, 0.5, 0.0> ]
            [ 0.263   rgbft <0.824, 0.557, 0.376, 0.5, 0.0> ]
            [ 0.281   rgbft <0.643, 0.38, 0.376, 0.5, 0.0> ]
            [ 0.325   rgbft <0.839, 0.722, 0.722, 0.5, 0.0> ]
            [ 0.711   rgbft <0.784, 0.627, 0.522, 0.5, 0.0> ]
            [ 0.798   rgbft <0.769, 0.38, 0.376, 0.5, 0.0> ]
            [ 0.895   rgbft <0.824, 0.557, 0.376, 0.5, 0.0> ]
            [ 0.982   rgbft <0.784, 0.627, 0.522, 0.5, 0.0> ]
            [ 1.0     rgbft <0.784, 0.627, 0.522, 0.5, 0.0> ]
         }
         turbulence 0.5
         ramp_wave
      }
   }
   texture
   {   
      pigment
      {
         marble
         color_map
         {
            [ 0.0     rgbft <0.0, 0.0, 0.0, 0.6, 0.0> ]
            [ 0.04    rgbft <0.0, 0.0, 0.0, 1.0, 0.0> ]
            [ 0.04    rgbft <0.55, 0.09, 0.09, 0.8, 0.0> ]
            [ 0.97    rgbft <0.329412, 0.329412, 0.329412, 0.9, 0.0> ]
            [ 0.97    rgbft <0.0, 0.0, 0.0, 0.9, 0.0> ]
            [ 1.0     rgbft <0.0, 0.0, 0.0, 1.0, 0.0> ]
         }
         turbulence 0.85
         ramp_wave
      }
   }
   texture
   {   
      pigment
      {
         color rgbf <1.0, 1.0, 0.0, 0.9>
      }   
      finish
      {
         ambient 0.1
         phong 1.0
         phong_size 90.0
      }
   }

#declare T_Stone23 = 
   material
   {   
      texture { _auto_name_no_1_ }
   }


#declare PDB_Tex_X = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <0.625, 0.625, 0.625>
         }      
         finish
         {
            ambient 0.15
            specular 0.7266
            roughness 0.006139
         }
      }
   }


#declare Luce = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }      
         finish
         {
            ambient 1.0
            diffuse 0.0
         }
      }
   }


#declare PDB_Tex_CE_1 = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <0.833333, 0.82, 0.713333>
         }      
         finish
         {
            ambient 0.0
            phong_size 0.0
            specular 0.2
            roughness 0.00001
         }
      }
   }


#declare Blu = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <0.010929, 0.283966, 0.634871>
         }      
         finish
         {
            ambient 0.0
            specular 0.7266
            roughness 0.006139
            crand 0.1
         }
      }
   }


#declare Brass_Metal = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <0.71, 0.65, 0.26>
         }      
         finish
         {
            ambient 0.2
            diffuse 0.7
            brilliance 6.0
            phong 0.75
            phong_size 80.0
            reflection 0.25
         }
      }
   }


#declare AberGranitePR = 
   material
   {   
      texture
      {      
         pigment
         {
            granite
            color_map
            {
               [ 0.0     rgbft <0.2, 0.2, 0.2, 0.0, 0.0> ]
               [ 0.31    rgbft <0.57, 0.53, 0.51, 0.0, 0.0> ]
               [ 1.0     rgbft <0.77, 0.66, 0.64, 0.0, 0.0> ]
            }
            turbulence 0.7
            ramp_wave
         }      
         normal
         {
            bumps , 0.1
            scale  0.2
         }      
         finish
         {
            ambient 0.0
            diffuse 1.0
            crand 0.25
         }
      }
   }


#declare Quadro = 
   material  // Quadro
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               png   "img1.PNG"
               interpolate 2
            }
         }      
         finish
         {
            ambient 0.2
            diffuse 0.8
            reflection 0.1
         }
      }
   }


#declare Silver3 = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <0.94, 0.93, 0.9>
         }      
         finish
         {
            ambient 0.0
            brilliance 0.3
            phong 1.0
            phong_size 100.0
            reflection 0.1
         }
      }
   }


#declare _auto_name_no_1_ = 
   texture
   {   
      pigment
      {
         marble
         color_map
         {
            [ 0.0     rgbft <0.894, 0.886, 0.886, 0.0, 0.0> ]
            [ 0.154   rgbft <0.745, 0.745, 0.753, 0.0, 0.0> ]
            [ 0.308   rgbft <0.902, 0.902, 0.859, 0.0, 0.0> ]
            [ 0.444   rgbft <0.729, 0.706, 0.694, 0.0, 0.0> ]
            [ 0.615   rgbft <0.588, 0.592, 0.635, 0.0, 0.0> ]
            [ 0.803   rgbft <0.608, 0.616, 0.659, 0.0, 0.0> ]
            [ 1.0     rgbft <0.894, 0.886, 0.886, 0.0, 0.0> ]
         }
         turbulence 0.6
         ramp_wave
      }   
      finish
      {
         ambient 0.2
         crand 0.03
      }
   }
   texture
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.31, 0.384, 0.42, 0.631, 0.0> ]
            [ 0.119   rgbft <0.322, 0.369, 0.416, 0.847, 0.0> ]
            [ 0.322   rgbft <0.424, 0.369, 0.42, 0.549, 0.0> ]
            [ 0.449   rgbft <0.373, 0.424, 0.518, 0.965, 0.0> ]
            [ 0.729   rgbft <0.482, 0.573, 0.533, 0.741, 0.0> ]
            [ 1.0     rgbft <0.31, 0.384, 0.42, 0.631, 0.0> ]
         }
         turbulence 0.6
         ramp_wave
      }
   }
   texture
   {   
      pigment
      {
         color rgbf <0.752941, 0.752941, 0.752941, 0.5>
      }   
      finish
      {
         ambient 0.15
         phong 0.5
         phong_size 150.0
      }
   }

#declare ColumnTexture = 
   material
   {   
      texture { _auto_name_no_1_ }
   }


#declare Muro_bianco_1 = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }      
         finish
         {
            ambient 0.0
            diffuse 0.8
            specular 0.309333
            roughness 0.006177
            reflection 0.1
         }
      }
   }


#declare Grey_Blue_Alabaster = 
   material
   {   
      texture
      {      
         pigment
         {
            bozo
            color_map
            {
               [ 0.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
               [ 0.2     rgbft <0.9, 0.9, 1.0, 0.0, 0.0> ]
               [ 0.4     rgbft <0.8, 0.8, 0.9, 0.0, 0.0> ]
               [ 0.6     rgbft <0.7, 0.7, 0.8, 0.0, 0.0> ]
               [ 0.8     rgbft <0.65, 0.65, 0.7, 0.0, 0.0> ]
               [ 1.0     rgbft <0.7, 0.7, 0.8, 0.0, 0.0> ]
            }
            turbulence 1.2
            ramp_wave
         }      
         finish
         {
            ambient 0.0
            phong 1.0
         }
      }
   }


#declare T1 = 
   material  // T1
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               png   "fl.png"
               interpolate 2
            }
         }      
         finish
         {
            ambient 1.0
            diffuse 0.0
            phong_size 0.0
         }
      }
   }


//
// REFERENCED OBJECTS
//

#declare Cylndr027 = object {
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.2>
    translate  <1.0, 0.0, -0.1>
  }
}
#declare CSG021 = difference {
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
  }
  object { Cylndr027 }
  object { // Cylndr028 -> Cylndr027
    Cylndr027
    rotate -16.0*z
    translate  <0.004664, 0.016818, 0.0>
  }
  object { // Cylndr029 -> Cylndr027
    Cylndr027
    rotate -32.0*z
    translate  <0.017977, 0.029919, 0.0>
  }
  object { // Cylndr030 -> Cylndr027
    Cylndr027
    rotate -48.0*z
    translate  <0.037976, 0.036038, 0.0>
  }
  object { // Cylndr031 -> Cylndr027
    Cylndr027
    rotate -64.0*z
    translate  <0.061629, 0.032769, 0.0>
  }
  object { // Cylndr032 -> Cylndr027
    Cylndr027
    rotate -80.0*z
    translate  <0.085171, 0.018882, 0.0>
  }
  object { // Cylndr033 -> Cylndr027
    Cylndr027
    rotate -96.0*z
    translate  <0.104528, -0.005478, 0.0>
  }
  object { // Cylndr034 -> Cylndr027
    Cylndr027
    rotate -112.0*z
    translate  <0.115788, -0.038742, 0.0>
  }
  object { // Cylndr035 -> Cylndr027
    Cylndr027
    rotate -128.0*z
    translate  <0.115661, -0.078015, 0.0>
  }
  object { // Cylndr036 -> Cylndr027
    Cylndr027
    rotate -144.0*z
    translate  <0.10191, -0.119322, 0.0>
  }
  object { // Cylndr037 -> Cylndr027
    Cylndr027
    rotate -160.0*z
    translate  <0.073667, -0.15798, 0.0>
  }
  object { // Cylndr038 -> Cylndr027
    Cylndr027
    rotate -176.0*z
    translate  <0.031638, -0.189063, 0.0>
  }
  object { // Cylndr039 -> Cylndr027
    Cylndr027
    rotate 168.0*z
    translate  <-0.021852, -0.207912, 0.0>
  }
  object { // Cylndr040 -> Cylndr027
    Cylndr027
    rotate 152.0*z
    translate  <-0.082978, -0.210653, 0.0>
  }
  object { // Cylndr041 -> Cylndr027
    Cylndr027
    rotate 136.0*z
    translate  <-0.146686, -0.194658, 0.0>
  }
  object { // Cylndr042 -> Cylndr027
    Cylndr027
    rotate 120.0*z
    translate  <-0.207107, -0.158919, 0.0>
  }
  object { // Cylndr043 -> Cylndr027
    Cylndr027
    rotate 104.0*z
    translate  <-0.258078, -0.10427, 0.0>
  }
  object { // Cylndr044 -> Cylndr027
    Cylndr027
    rotate 88.0*z
    translate  <-0.293719, -0.033465, 0.0>
  }
  object { // Cylndr045 -> Cylndr027
    Cylndr027
    rotate 72.0*z
    translate  <-0.309017, 0.048943, 0.0>
  }
  object { // Cylndr046 -> Cylndr027
    Cylndr027
    rotate 56.0*z
    translate  <-0.300374, 0.136888, 0.0>
  }
  object { // Cylndr047 -> Cylndr027
    Cylndr027
    rotate 40.0*z
    translate  <-0.266044, 0.223238, 0.0>
  }
  object { // Cylndr048 -> Cylndr027
    Cylndr027
    rotate 24.0*z
    translate  <-0.206439, 0.30037, 0.0>
  }
  object { // Cylndr049 -> Cylndr027
    Cylndr027
    rotate 8.0*z
    translate  <-0.124243, 0.360827, 0.0>
  }
  object { // Cylndr050 -> Cylndr027
    Cylndr027
    rotate -8.0*z
    translate  <-0.024342, 0.397992, 0.0>
  }
}
#declare CSG022 = union { // CSG022
  object { CSG021 }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.1>
    translate  0.4*z
  }
  superellipsoid { // SuperQ014
    <0.1, 0.1>
    scale <1.3, 1.3, 0.2>
    translate  0.2*z
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.1>
    translate  6.0*z
  }
  superellipsoid { // SuperQ015
    <0.1, 0.1>
    scale <1.3, 1.3, 0.2>
    translate  6.3*z
  }
  material {
    AberGranitePR
  }
  translate  <16.5, 35.0, -19.9>
}
#declare Colonna = union { // Colonna
  superellipsoid { // SuperQ003
    <0.1, 0.1>
    material {
      Muro_bianco
    }
    scale <2.0, 2.5, 12.0>
    translate  <15.2, 18.9, 12.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      Muro_bianco
    }
    scale <2.5, 2.0, 12.0>
    translate  <15.210857, 18.903738, 12.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      Muro_bianco
    }
    scale <1.0, 1.0, 12.0>
    translate  <13.5, 19.0, 12.0>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      Muro_bianco
    }
    scale <1.0, 1.0, 12.0>
    translate  <17.0, 19.0, 12.0>
  }
}
#declare Cube023 = object {
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 8.0>
    translate  34.0*z
    scale <2.0, 12.0, 1.0>
    translate  118.0*y
  }
}


#declare Colonna1 = object {
  object { // Colonna1 -> Colonna
    Colonna
    translate  80.0*y
  }
}


#declare SuperQ006 = object {
  superellipsoid { // SuperQ006
    <0.1, 0.1>
    material {
      Muro_marrone
    }
    scale <0.1, 1.5, 8.0>
    translate  <15.0, 20.0, -12.0>
  }
}
#declare SuperQ010 = object {
  superellipsoid { // SuperQ010
    <0.1, 0.1>
    material {
      Muro_marrone
    }
    scale <16.5, 1.5, 0.1>
    translate  <-0.5, 20.0, -4.8>
  }
}


#declare Sphere001 = object {
  sphere { // Sphere001
    <0,0,0>,1
    scale <2.0, 2.0, 0.6>
    translate  <-12.0, 9.0, 21.0>
  }
}


#declare Cylndr003 = object {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 2.4, 44.0>
    translate  <0.0, -2.4, -22.0>
    scale <1.0, 0.9, 1.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <9.5, -7.0, 0.0>
  }
}






#declare Torus002 = object {
  torus { // Torus002
    1.8, 0.2  rotate -x*90
  }
}



//
// OBJECTS
//

difference { // CSG025
  superellipsoid { // SuperQ021
    <0.1, 0.1>
    scale <4.0, 4.0, 3.0>
    translate  <0.0, 65.0, 3.2>
  }
  superellipsoid { // SuperQ022
    <0.1, 0.1>
    scale <3.5, 0.2, 2.5>
    translate  <0.0, 61.0, 3.2>
  }
  material {
    ColumnTexture
  }
}


union { // Pied
  superellipsoid { // SuperQ020
    <0.1, 0.1>
    scale <10.0, 10.0, 0.2>
    translate  <0.0, 65.0, 0.2>
  }
  material {
    ColumnTexture
  }
}




difference { // CSG024
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      PDB_Tex_CE_1
    }
    scale <55.0, 1.0, 12.0>
    rotate -45.0*z
    translate  <69.572895, 81.0, 12.0>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    material {
      PDB_Tex_CE_1
    }
    scale <10.0, 2.0, 10.0>
    rotate -45.0*z
    translate  <66.618077, 83.733207, 10.0>
  }
}


object { // CSG023 -> CSG022
  CSG022
  rotate <0.0, -0.0, -0.0>
  translate  20.0*y
}


box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  material {
    Blu
  }
  scale <55.0, 4.0, 0.5>
  rotate 45.0*z
  translate  <49.178481, 38.740104, -20.4>
}


object { // Colonna3 -> Colonna
  Colonna
  translate  -38.0*x
}


#declare CSG003 = union {
  object { Cube023 }
  object { // Cube024 -> Cube023
    Cube023
    rotate -26.0*z
    translate  <-27.150263, 8.062521, 0.0>
  }
  object { // Cube025 -> Cube023
    Cube023
    rotate 26.0*z
    translate  <27.277435, 8.013317, 0.0>
  }
  object { // Cube026 -> Cube023
    Cube023
    rotate -50.0*z
    translate  <-44.822212, 27.152797, 0.0>
  }
  object { // Cube029 -> Cube023
    Cube023
    rotate 50.0*z
    translate  <44.882435, 26.986184, 0.0>
  }
  object { // Cube030 -> Cube023
    Cube023
    rotate -70.0*z
    translate  <-51.360545, 45.135218, 0.0>
  }
  object { // Cube035 -> Cube023
    Cube023
    rotate 70.0*z
    translate  <50.817811, 45.424024, 0.0>
  }
}
difference { // CSG004
  object { CSG003 }
  sphere { // Sphere005
    <0,0,0>,1
    scale <65.0, 45.0, 10.0>
    translate  <0.0, 70.0, 30.0>
  }
  material {
    Muro_bianco
  }
}


lathe { // RotSweep001
  linear_spline
  4  // control points
  <2.3, 0.0>,
  <2.2, 0.3>,
  <1.5, 0.7>,
  <0.0, 1.0>
  rotate <90,0,90>
  material {
    Muro_bianco
  }
  scale <30.0, 25.0, 20.0>
  translate  <0.0, 65.0, 26.0>
}


box { // Cube021
  <-1, -1, -1>, <1, 1, 1>
  material {
    Luce
  }
  no_shadow
  scale <5.0, 1.5, 0.4>
  translate  <-12.0, 108.0, 23.6>
}




union { // Group001
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      PDB_Tex_CE_1
    }
    scale <30.0, 1.0, 12.0>
    translate  <0.0, 120.0, 12.0>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    material {
      PDB_Tex_CE_1
    }
    scale <55.0, 1.0, 12.0>
    rotate 45.0*z
    translate  <-69.5, 81.0, 12.0>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 13.0, 1.0>
    translate  <0.0, 108.0, 25.0>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <35.0, 13.0, 1.0>
    rotate -45.0*z
    translate  <51.0, 92.8, 25.0>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <35.0, 13.0, 1.0>
    rotate 45.0*z
    translate  <-51.0, 92.8, 25.0>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 4.0, 2.0>
    translate  <30.0, 94.8, 24.0>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 4.0, 2.0>
    translate  <-30.0, 94.8, 24.0>
  }
  material {
    Muro_bianco
  }
}


object { // Colonna2 -> Colonna1
  Colonna1
  translate  -31.0*x
}


object { Colonna1 }


prism { // TransSweep001
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <3.0, 1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    Muro_bianco_1
  }
  scale <20.0, 20.0, 1.0>
  translate  <-0.610116, 41.487877, -1.0>
}




difference { // CSG002
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      PDB_Tex_X
    }
    scale <20.0, 20.0, 10.0>
    translate  <0.0, 40.5, -11.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      PDB_Tex_X
    }
    scale <19.0, 20.0, 9.0>
    translate  <0.0, 39.0, -12.0>
  }
  material {
    Muro_bianco
  }
}


#declare CSG009 = difference {
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    material {
      Muro_bianco
    }
    scale <20.0, 1.0, 10.0>
    translate  <0.0, 20.0, -10.0>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    material {
      Muro_bianco
    }
    scale <16.0, 1.2, 8.0>
    translate  <-0.5, 20.0, -12.5>
  }
}
#declare Porta = union {
  object { CSG009 }
  superellipsoid { // SuperQ005
    <0.1, 0.1>
    material {
      Muro_marrone
    }
    scale <0.8, 1.4, 8.0>
    translate  <15.5, 20.0, -12.0>
  }
  object { SuperQ006 }
  object { // SuperQ007 -> SuperQ006
    SuperQ006
    rotate 0.0*z
    translate  0.5*x
  }
  object { // SuperQ008 -> SuperQ006
    SuperQ006
    rotate 0.0*z
    translate  1.0*x
  }
  superellipsoid { // SuperQ009
    <0.1, 0.1>
    material {
      Muro_marrone
    }
    scale <16.5, 1.4, 0.6>
    translate  <-0.5, 20.0, -4.5>
  }
  object { SuperQ010 }
  object { // SuperQ011 -> SuperQ010
    SuperQ010
    rotate -0.0*x
    translate  0.3*z
  }
  object { // SuperQ012 -> SuperQ010
    SuperQ010
    rotate -0.0*x
    translate  0.6*z
  }
}
#declare Porta_2 = difference {
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      Muro_bianco
    }
    scale <2.0, 22.0, 11.0>
    rotate 45.0*z
    translate  <63.6, 32.4, 11.0>
  }
  superellipsoid { // SuperQ004
    <0.1, 0.1>
    scale <4.0, 19.0, 11.0>
    rotate 45.0*z
    translate  <63.6, 32.4, 9.0>
  }
  material {
    Muro_bianco
  }
}
union { // Muro_2
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    material {
      Muro_bianco
    }
    scale <44.0, 1.0, 10.0>
    rotate 45.0*z
    translate  <50.393099, 50.830659, -10.0>
  }
  object { Porta }
  object { Porta_2 }
}






#declare Soffitto = union {
  superellipsoid { // SuperQ001
    <0.1, 0.1>
    material {
      Muro_bianco
    }
    scale <19.0, 19.0, 0.2>
    translate  <0.0, -4.0, 21.3>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      Muro_bianco
    }
    scale <20.0, 20.0, 0.5>
    translate  <0.0, -4.0, 21.8>
  }
  superellipsoid { // SuperQ002
    <0.1, 0.1>
    material {
      Muro_bianco
    }
    scale <30.0, 19.0, 0.2>
    rotate 45.0*z
    translate  <40.5, 12.0, 21.3>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      Muro_bianco
    }
    scale <30.0, 20.0, 0.5>
    rotate 45.0*z
    translate  <40.5, 12.0, 21.8>
  }
}
#declare CSG007 = union {
  object { Sphere001 }
  object { // Sphere002 -> Sphere001
    Sphere001
    translate  10.0*x
  }
  object { // Sphere003 -> Sphere001
    Sphere001
    translate  20.0*x
  }
  object { // Sphere004 -> Sphere001
    Sphere001
    translate  30.0*x
  }
  material {
    Muro_bianco
  }
}
difference { // CSG008
  object { Soffitto }
  object { CSG007 }
}


#declare CSG001 = union {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 25.0, 0.5>
    translate  <30.0, -25.0, -0.5>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 20.0, 0.5>
    rotate 45.0*z
    translate  <35.0, 12.0, -0.5>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 20.0, 0.5>
    translate  -0.5*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Muro_bianco
    }
    scale <21.0, 14.0, 5.0>
    translate  <10.0, -7.0, 0.0>
  }
  material {
    Material1
    scale 4.0
  }
}
#declare CSG006 = union {
  object { Cylndr003 }
  object { // Cylndr004 -> Cylndr003
    Cylndr003
    rotate -10.0*z
    translate  <1.359864, 1.543312, 0.0>
  }
  object { // Cylndr005 -> Cylndr003
    Cylndr003
    rotate -20.0*z
    translate  <2.967061, 2.82704, 0.0>
  }
  object { // Cylndr006 -> Cylndr003
    Cylndr003
    rotate -30.0*z
    translate  <4.772759, 3.812178, 0.0>
  }
  object { // Cylndr007 -> Cylndr003
    Cylndr003
    rotate -40.0*z
    translate  <6.722091, 4.468793, 0.0>
  }
  object { // Cylndr008 -> Cylndr003
    Cylndr003
    rotate -50.0*z
    translate  <8.755829, 4.776935, 0.0>
  }
  object { // Cylndr009 -> Cylndr003
    Cylndr003
    rotate -60.0*z
    translate  <10.812178, 4.727241, 0.0>
  }
  object { // Cylndr010 -> Cylndr003
    Cylndr003
    rotate -70.0*z
    translate  <12.828657, 4.321221, 0.0>
  }
  object { // Cylndr011 -> Cylndr003
    Cylndr003
    rotate -80.0*z
    translate  <14.743997, 3.571211, 0.0>
  }
  object { // Cylndr012 -> Cylndr003
    Cylndr003
    rotate -90.0*z
    translate  <16.5, 2.5, 0.0>
  }
  object { // Cylndr013 -> Cylndr003
    Cylndr003
    rotate -100.0*z
    translate  <18.043312, 1.140136, 0.0>
  }
  object { // Cylndr014 -> Cylndr003
    Cylndr003
    rotate -110.0*z
    translate  <19.32704, -0.467061, 0.0>
  }
  object { // Cylndr015 -> Cylndr003
    Cylndr003
    rotate -120.0*z
    translate  <20.312178, -2.272759, 0.0>
  }
  object { // Cylndr016 -> Cylndr003
    Cylndr003
    rotate -130.0*z
    translate  <20.968793, -4.222091, 0.0>
  }
  object { // Cylndr017 -> Cylndr003
    Cylndr003
    rotate -140.0*z
    translate  <21.276935, -6.255829, 0.0>
  }
  object { // Cylndr018 -> Cylndr003
    Cylndr003
    rotate -150.0*z
    translate  <21.227241, -8.312178, 0.0>
  }
  object { // Cylndr019 -> Cylndr003
    Cylndr003
    rotate -160.0*z
    translate  <20.821221, -10.328657, 0.0>
  }
  object { // Cylndr020 -> Cylndr003
    Cylndr003
    rotate -170.0*z
    translate  <20.071211, -12.243997, 0.0>
  }
}
#declare Ogg_1_1 = difference {
  object { CSG001 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 13.0, 7.0>
    translate  <10.0, -7.0, -1.5>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 20.0, 4.0>
    translate  <30.0, -27.0, 2.0>
  }
  object { CSG006 }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <20.5, 13.5, 6.0>
    translate  <10.0, -7.0, -1.5>
  }
  material {
    Muro_bianco
  }
}
union { // Balcone
  object { Ogg_1_1 }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    material {
      Muro_bianco
    }
    scale <0.5, 15.0, 3.0>
    translate  <-10.5, -22.0, 2.0>
  }
}


object { Colonna }


union { // CSG005
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 25.0, 0.5>
    translate  <30.0, -5.0, -0.5>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <55.0, 20.0, 0.5>
    rotate 45.0*z
    translate  <58.0, 30.0, -0.5>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <19.0, 19.5, 0.2>
    translate  <0.0, 39.5, -0.1>
  }
  material {
    Material1
    scale 4.0
  }
  translate  -20.0*z
}








box { // Cube022
  <-1, -1, -1>, <1, 1, 1>
  material {
    Luce
  }
  no_shadow
  scale <5.0, 1.5, 0.4>
  translate  <12.0, 108.0, 23.6>
}


object { CSG022 }


union { // Group002
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    material {
      Quadro
      scale <2.0, 2.0, 1.0>
      rotate 90.0*x
      translate <-1.000000, 0.000000, -1.000000>
    }
    scale <4.0, 0.05, 3.0>
  }
  superellipsoid { // SuperQ016
    <0.1, 0.1>
    scale <4.2, 0.1, 0.1>
    translate  3.0*z
  }
  superellipsoid { // SuperQ017
    <0.1, 0.1>
    scale <4.2, 0.1, 0.1>
    translate  -3.0*z
  }
  superellipsoid { // SuperQ018
    <0.1, 0.1>
    scale <0.1, 0.1, 3.0>
    translate  -4.1*x
  }
  superellipsoid { // SuperQ019
    <0.1, 0.1>
    scale <0.1, 0.1, 3.0>
    translate  4.1*x
  }
  material {
    Muro_marrone
  }
  scale <2.0, 1.0, 1.0>
  rotate 45.0*z
  translate  <32.11996, 31.001109, -9.5>
}


union { // CSG026
  object { Torus002 }
  object { // Torus003 -> Torus002
    Torus002
    scale <0.95, 0.95, 1.1>
    rotate <-5.0, -16.0, -10.0>
    translate  0.2*z
  }
  object { // Torus004 -> Torus002
    Torus002
    scale <0.9025, 0.9025, 1.21>
    rotate <-10.0, -32.0, -20.0>
    translate  0.4*z
  }
  object { // Torus005 -> Torus002
    Torus002
    scale <0.857375, 0.857375, 1.331>
    rotate <-15.0, -48.0, -30.0>
    translate  0.6*z
  }
  object { // Torus006 -> Torus002
    Torus002
    scale <0.814506, 0.814506, 1.4641>
    rotate <-20.0, -64.0, -40.0>
    translate  0.8*z
  }
  object { // Torus007 -> Torus002
    Torus002
    scale <0.773781, 0.773781, 1.61051>
    rotate <-25.0, -80.0, -50.0>
    translate  1.0*z
  }
  object { // Torus008 -> Torus002
    Torus002
    scale <0.735092, 0.735092, 1.771561>
    rotate <150.0, -84.0, 120.0>
    translate  1.2*z
  }
  object { // Torus009 -> Torus002
    Torus002
    scale <0.698337, 0.698337, 1.948717>
    rotate <145.0, -68.0, 110.0>
    translate  1.4*z
  }
  object { // Torus010 -> Torus002
    Torus002
    scale <0.66342, 0.66342, 2.143589>
    rotate <140.0, -52.0, 100.0>
    translate  1.6*z
  }
  object { // Torus011 -> Torus002
    Torus002
    scale <0.630249, 0.630249, 2.357948>
    rotate <135.0, -36.0, 90.0>
    translate  1.8*z
  }
  object { // Torus012 -> Torus002
    Torus002
    scale <0.598737, 0.598737, 2.593742>
    rotate <130.0, -20.0, 80.0>
    translate  2.0*z
  }
  object { // Torus013 -> Torus002
    Torus002
    scale <0.5688, 0.5688, 2.853117>
    rotate <125.0, -4.0, 70.0>
    translate  2.2*z
  }
  object { // Torus014 -> Torus002
    Torus002
    scale <0.54036, 0.54036, 3.138428>
    rotate <120.0, 12.0, 60.0>
    translate  2.4*z
  }
  object { // Torus015 -> Torus002
    Torus002
    scale <0.513342, 0.513342, 3.452271>
    rotate <115.0, 28.0, 50.0>
    translate  2.6*z
  }
  object { // Torus016 -> Torus002
    Torus002
    scale <0.487675, 0.487675, 3.797498>
    rotate <110.0, 44.0, 40.0>
    translate  2.8*z
  }
  object { // Torus017 -> Torus002
    Torus002
    scale <0.463291, 0.463291, 4.177248>
    rotate <105.0, 60.0, 30.0>
    translate  3.0*z
  }
  object { // Torus018 -> Torus002
    Torus002
    scale <0.440127, 0.440127, 4.594973>
    rotate <100.0, 76.0, 20.0>
    translate  3.2*z
  }
  material {
    Silver3
  }
  scale <1.5, 1.5, 2.0>
  translate  <0.0, 65.0, 6.5>
}


difference { // CSG010
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.8, 9.0>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 1.0, 4.0>
    translate  <8.0, 0.0, -4.5>
  }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 1.0, 4.0>
    translate  <8.0, 0.0, 4.5>
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 1.0, 4.0>
    translate  <-8.0, 0.0, -4.5>
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 1.0, 4.0>
    translate  <-8.0, 0.0, 4.5>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 4.0>
    translate  <-3.5, 0.0, -4.5>
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 4.0>
    translate  <-3.5, 0.0, 4.5>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 4.0>
    translate  <3.5, 0.0, -4.5>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 4.0>
    translate  <3.5, 0.0, 4.5>
  }
  material {
    Muro_marrone
  }
  scale <1.0, 1.0, 1.1>
  rotate -45.0*z
  translate  <66.592974, 83.705551, 10.0>
}


lathe { // RotSweep002
  quadratic_spline
  6  // control points
  <0.0, -1.0>,
  <0.0, -1.0>,
  <0.8, -1.0>,
  <1.4, 0.3>,
  <1.0, 0.7>,
  <0.0, 1.1>
  rotate <90,0,90>
  material {
    Grey_Blue_Alabaster
  }
  translate  <16.5, 35.0, -12.4>
}


box { // Cube055
  <-1, -1, -1>, <1, 1, 1>
  material {
    T1
    scale <2.0, 2.0, 1.0>
    rotate 90.0*x
    translate <-1.000000, 0.000000, -1.000000>
  }
  no_shadow
  scale <10.0, 0.2, 10.0>
  rotate -45.0*z
  translate  <67.505638, 84.625675, 10.0>
}


box { // Cube045
  <-1, -1, -1>, <1, 1, 1>
  material {
    PDB_Tex_CE_1
  }
  scale <55.0, 1.0, 12.0>
  rotate -45.0*z
  translate  <69.572895, 81.0, -12.0>
}


