/* SKIING.POV - Programmed by Maarten Hofman */
/* 071102: Started programming */
/* 081102: Attempt to add clasps to the boots */
/* 111102: Worked a little bit on the textures of heightfields */
/* 121102: Added cabin */
/* 131102: Added ski lift, person skiing */
/* 141102: Updated comments */

#include "colors.inc"
#include "finish.inc"  
#include "metals.inc"  
#include "skies.inc"
#include "woods.inc"

light_source { <-100,100,100> color White }
light_source { <-99,99,99> color White }
                       
camera { 
/*    
  aperture 0.15 
  focal_point <10,4.7,10>    
  blur_samples 100  
  variance 0.0001
*/      
  location <1,5,1>
  look_at <10,4.7,10>
/* 
  location <15,10,15>
  look_at <20,5,20>
*/
}

sky_sphere {
  S_Cloud2
}
         
#declare skicolour = texture {
  pigment {
    gradient z
    color_map {
      [0.0 Red]
      [0.3 White]
      [0.7 White]
      [1.0 Red]
    }
  }
  finish { 
    reflection { 0.2 }
  }
}

#declare skicolour2 = texture {
  pigment {
    gradient z
    color_map {
      [0.0 Blue]
      [0.3 White]
      [0.7 White]
      [1.0 Blue]
    }
  }
  finish { 
    reflection { 0.2 }
  }
}

#declare bootcolour = texture {
  pigment {   
    agate
    color_map {
      [0.0 Khaki]
      [0.1 Yellow]
    }   
    scale <0.1,0.1,0.1>
  }
  finish {
    Phong_Shiny
  }
}

#declare bootcolour2 = texture {
  pigment {   
    agate
    color_map {
      [0.0 Khaki]
      [0.1 Cyan]
    }   
    scale <0.1,0.1,0.1>
  }
  finish {
    Phong_Shiny
  }
}

#declare skiendbase = difference {
  cylinder {
    <0,1,-0.23>,
    <0,1,0.23>,1.05
  }          
  cylinder {
    <0,1,-1>,
    <0,1,1>,1
  }
  box {
    <-2,0.5,-2>,
    <2,2,2>
  }
  box {
    <0,-2,-2>,
    <-2,2,2>
  }
}

#declare skiend = intersection {
  object {
    skiendbase
  }
  cylinder {
    <0,-1,0>
    <0,1,0>,0.25
    scale <3,1,1>
  }
  texture {
    skicolour
  }
}

#declare skiend2 = intersection {
  object {
    skiendbase
  }
  cylinder {
    <0,-1,0>
    <0,1,0>,0.25
    scale <3,1,1>
  }
  texture {
    skicolour2
  }
}

#declare skifrontbase = difference {
  cylinder {
    <0,0.1,0>,
    <0,0.15,0>,0.3
  }
  cylinder {
    <-0.2,0,0>,
    <-0.2,1,0>,0.32
  }
  pigment {
    White
  }
  finish {
    Phong_Shiny
  }
}

#declare skifront = union {
  superellipsoid {
    <0.25,0.25>
    scale <0.2,0.1,0.08>
    translate <0.2,0.1,0>
    pigment {
      Red
    }
  }  
  object {
    skifrontbase
    translate <-0.1,0,0>
  }
}

#declare skibackbase = difference {
  cylinder {
    <0,0,0>,
    <0,0.2,0>,0.2
    scale <2,1,1>
  }
  box {
    <0,-1,-1>,
    <1,1,1>
  }
  pigment {
    White
  }
  finish {
    Phong_Shiny
  }
}

#declare skibackhandle = union {
  cylinder {
    <0,0,-0.24>,
    <0,0,0.24>,0.02
    texture {
      T_Chrome_2B
    }
  }
  cylinder {
    <0,0,-0.24>,
    <0.48,0,-0.24>,0.02
    texture {
      T_Chrome_2B
    }
  }
  cylinder {
    <0,0,0.24>,
    <0.48,0,0.24>,0.02
    texture {
      T_Chrome_2B
    }
  }
  cone {
    <0.5,0,-0.24>,0.04,
    <0,0,-0.24>,0
    pigment {
      Black
    }
  }
  cone {
    <0.5,0,0.24>,0.04,
    <0,0,0.24>,0
    pigment {
      Black
    }
  }
}
  
#declare skiback = union {
  object {
    skibackbase
  }
  superellipsoid {
    <0.25,0.25>
    scale <0.2,0.02,0.1>
    translate <-0.35,0.15,0>
    pigment {
      Red
    }
  }
  object {
    skibackhandle
    rotate <0,0,135>
    translate <-0.1,0.1,0>
  }
}

#declare skiback2 = union {
  object {
    skibackbase
  }
  superellipsoid {
    <0.25,0.25>
    scale <0.2,0.02,0.1>
    translate <-0.35,0.15,0>
    pigment {
      Red
    }
  }
  superellipsoid {
    <0.25,0.25>
    scale <0.1,0.02,0.1>
    rotate <0,0,30>
    translate <0.1,0.1,0>
    pigment {
      Black
    }
  }

  object {
    skibackhandle
    rotate <0,0,-135>
    translate <-0.1,0.1,0>
  }
}

#declare ski = union {
  box {
    <-4,0,-0.23>,
    <4,-0.05,0.23>
    texture {
      skicolour
    }
  }
  object {
    skiend
    translate <4,0,0>
  }
  object {
    skiback
    translate <-0.45,0,0>
  }
  object {
    skifront
    translate <0.5,0,0>
  }
  superellipsoid {
    <0.25,0.25>
    scale <1.1,0.04,0.1>
    texture {
      T_Chrome_2B
    }
  }
}

#declare ski2 = union {
  box {
    <-4,0,-0.23>,
    <4,-0.05,0.23>
    texture {
      skicolour
    }
  }
  object {
    skiend
    translate <4,0,0>
  }
  object {
    skiback2
    translate <-0.45,0,0>
  }
  object {
    skifront
    translate <0.5,0,0>
  }
  superellipsoid {
    <0.25,0.25>
    scale <1.1,0.04,0.1>
    texture {
      T_Chrome_2B
    }
  }
}

#declare ski3 = union {
  box {
    <-4,0,-0.23>,
    <4,-0.05,0.23>
    texture {
      skicolour2
    }
  }
  object {
    skiend2
    translate <4,0,0>
  }
  object {
    skiback2
    translate <-0.45,0,0>
  }
  object {
    skifront
    translate <0.5,0,0>
  }
  superellipsoid {
    <0.25,0.25>
    scale <1.1,0.04,0.1>
    texture {
      T_Chrome_2B
    }
  }
}

#declare ski4 = union {
  box {
    <-4,0,-0.23>,
    <4,-0.05,0.23>
    texture {
      skicolour2
    }
  }
  object {
    skiend2
    translate <4,0,0>
  }
  object {
    skiback
    translate <-0.45,0,0>
  }
  object {
    skifront
    translate <0.5,0,0>
  }
  superellipsoid {
    <0.25,0.25>
    scale <1.1,0.04,0.1>
    texture {
      T_Chrome_2B
    }
  }
}

#declare clasp = union {
  superellipsoid {
    <0.25,1>
    scale <0.03,0.04,0.12>
    pigment {
      Black
    }
  } 
  superellipsoid {
    <0.25,1>
    scale <0.032,0.01,0.14>
    translate <0,0.01,0>
    texture {
      T_Chrome_2C
    }    
  }
} 
                    
#declare boot = union {
  superellipsoid {
    <0.25,0.5>
    scale <0.5,0.12,0.25>   
    texture {
      bootcolour
    }
  }                   
  superellipsoid {
    <0.25,0.5>
    scale <0.5,0.15,0.25>
    rotate <0,0,-10>
    translate <0,0.1,0>
    texture {
      bootcolour
    }
  }                   
  cone {
    <-0.28,0.13,0>,0.28,
    <0.1,1,0>,0.2
    texture {
      bootcolour
    }
  }
  superellipsoid {
    <0.25,0.5>
    scale <0.52,0.02,0.27>
    translate <0,-0.1,0>
    pigment {
      DarkBrown
    }
  }
  cylinder {
    <-0.2,0.15,0.29>,
    <-0.2,0.15,-0.29>,0.05
    pigment {
      Gray
    }
  }
  object {
    clasp
    translate <0.35,0.19,0>
  }            
  object {
    clasp
    translate <0.2,0.22,0>
  }
  object {
    clasp
    rotate <0,0,70>
    translate <0.14,0.5,0>
  } 
  object {
    clasp
    rotate <0,0,70>
    translate <0.19,0.65,0>
  } 
  object {
    clasp
    rotate <0,0,70>
    translate <0.24,0.8,0>
  }
}

#declare boot2 = union {
  superellipsoid {
    <0.25,0.5>
    scale <0.5,0.12,0.25>   
    texture {
      bootcolour2
    }
  }                   
  superellipsoid {
    <0.25,0.5>
    scale <0.5,0.15,0.25>
    rotate <0,0,-10>
    translate <0,0.1,0>
    texture {
      bootcolour2
    }
  }                   
  cone {
    <-0.28,0.13,0>,0.28,
    <0.1,1,0>,0.2
    texture {
      bootcolour2
    }
  }
  superellipsoid {
    <0.25,0.5>
    scale <0.52,0.02,0.27>
    translate <0,-0.1,0>
    pigment {
      DarkBrown
    }
  }
  cylinder {
    <-0.2,0.15,0.29>,
    <-0.2,0.15,-0.29>,0.05
    pigment {
      Gray
    }
  }
  object {
    clasp
    translate <0.35,0.19,0>
  }            
  object {
    clasp
    translate <0.2,0.22,0>
  }
  object {
    clasp
    rotate <0,0,70>
    translate <0.14,0.5,0>
  } 
  object {
    clasp
    rotate <0,0,70>
    translate <0.19,0.65,0>
  } 
  object {
    clasp
    rotate <0,0,70>
    translate <0.24,0.8,0>
  }
}

/* Scene */
object {   
  boot        
  rotate <0,0,30>
  translate <10,10,10>        
}                     
                   
object {
  boot           
  rotate <0,0,25>
  translate <10,9.6,9>
}
                 
object {
  ski            
  rotate <0,0,30>
  translate <10,10-0.14,10>
}

object {
  ski2         
  rotate <20,40,60>
  translate <10,5,9>
}

#declare grads = pigment {
  gradient y
  color_map {
    [0.0 Sienna ]
    [0.5 White ]
  }
  scale <25,25,25>
}

height_field {
  png "height4.png"
  smooth       
  scale <800,300,800>
  pigment {
    bozo
    pigment_map {
      [0.0 DarkBrown ]
      [0.4 grads ]
    }     
    scale <10,10,10>
  }    
  finish {
    ambient <0,0.10,0>
  }            
  rotate <0,30,0>
  translate <-140,-60,100>       
}

#declare snow = texture {
  pigment {
    White
    /*
    bozo
    color_map {
      [0.0 Black]
      [0.2 Gray]
      [0.4 White]
    } 
    */
  }
  normal {
    bumps 0.5
    scale 4
  }
  finish {
    ambient 0.4
  }
}

height_field {
  tga "heightfield.tga"
  smooth
  scale <100,1,100>
  texture {
    snow
  }
}

#declare roof = union {
  box {
    <0,0,0>,
    <30,1,30>
    texture {
      gradient x
      texture_map {
        [0.0 T_Wood4]
        [0.5 T_Wood3]
      } 
      scale 5
    }
  }
  superellipsoid {
    <0.4,0.4>
    scale <15,0.5,15>
    translate <15,0.7,15>
    texture {
      snow
    }
  }
}

#declare cabinbase = union {
  box {
    <0,0,0>,
    <30,15,30>
    texture {
      T_Wood2
    }
  }
  object { 
    roof
    rotate <0,0,20>
    translate <-10,11,0>
  }
  object {
    roof
    rotate <0,0,-20>
    translate <18,21,0>    
    texture {
      T_Wood3
    }
  }
}

#declare cabin = difference {
  object {
    cabinbase
  }
  box {
    <-31,-1,-1>,
    <17,30,15>      
    texture {
      T_Wood2
    }
  }
  box {
    <16,1,5>,
    <18,10,8>
    pigment {
      Black
    }
  }      
  box {
    <16,8,2>,
    <18,10,4>
    pigment {
      Black
    }
  }
  box {
    <16,8,9>,
    <18,10,11>
    pigment {
      Black
    }
  }
  box {
    <29,5,20>,
    <31,7,24>
    pigment {
      Black
    }
  }

}

#declare picknicktable = union {
  box {
    <0,1.9,0>,
    <4,2,1>
  }
  box {
    <0,2.9,1>,
    <4,3,4>
  }
  box {
    <0,1.9,4>,
    <4,2,5>
  }
  cylinder {
    <1,0,0.5>,
    <1,1.9,0.5>,0.3
  }
  cylinder {
    <3,0,0.5>,
    <3,1.9,0.5>,0.3
  }
  cylinder {
    <1,0,4.5>,
    <1,1.9,4.5>,0.3
  }
  cylinder {
    <3,0,4.5>,
    <3,1.9,4.5>,0.3
  }
  cylinder {
    <1,0,2.5>,
    <1,2.9,2.5>,0.4
  }
  cylinder {
    <3,0,2.5>,
    <3,2.9,2.5>,0.4
  }
  texture {
    T_Wood5
  }
  scale <2,2,2>
}

#declare height = -7;

object {
  cabin  
  scale <1,0.9,1>
  translate <200,height,50>
}

cone {
  <200,height,50>,40
  <200,-100,50>,200
  texture {
    snow
  }
}

object {
  picknicktable
  translate <200,height,50>
}

object {
  picknicktable
  rotate <0,90,0>
  translate <180,height,70>
}

object {
  picknicktable
  rotate <0,90,0>
  translate <220,height,50>
}

object {
  ski3
  rotate <20,0,90>
  translate <191,height+3,42>
}                 

object {
  ski3
  rotate <-10,0,90>
  translate <190,height+4,40>
}

#include "spray.pov"

/* Ski lift */
#declare pole = union {
  cylinder {
    <0,0,0>,
    <0,6,0>,2
    pigment {
      Blue
    }
    finish {
      Phong_Shiny
    }
  }
  cylinder {
    <0,0,0>,
    <0,25,0>,1
    texture {
      T_Chrome_2B
    }
  }
  cylinder {
    <-6,25,0>,
    <6,25,0>,0.5
    texture {
      T_Chrome_2B
    }
  }
  cylinder {
    <-6,25,-3>,
    <-6,25,3>,0.5
    texture {
      T_Chrome_2B
    }
  }
  cylinder {
    <6,25,-3>,
    <6,25,3>,0.5
    texture {
      T_Chrome_2B
    }
  }
  cylinder { <-6.2,24.5,-2.5>,<-5.8,24.5,-2.5>,0.5 pigment { DarkBrown } }
  cylinder { <-6.2,24.5,-1.5>,<-5.8,24.5,-1.5>,0.5 pigment { DarkBrown } }
  cylinder { <-6.2,24.5,-0.5>,<-5.8,24.5,-0.5>,0.5 pigment { DarkBrown } }
  cylinder { <-6.2,24.5, 0.5>,<-5.8,24.5, 0.5>,0.5 pigment { DarkBrown } }
  cylinder { <-6.2,24.5, 1.5>,<-5.8,24.5, 1.5>,0.5 pigment { DarkBrown } }
  cylinder { <-6.2,24.5, 2.5>,<-5.8,24.5, 2.5>,0.5 pigment { DarkBrown } }
  cylinder { < 6.2,24.5,-2.5>,< 5.8,24.5,-2.5>,0.5 pigment { DarkBrown } }
  cylinder { < 6.2,24.5,-1.5>,< 5.8,24.5,-1.5>,0.5 pigment { DarkBrown } }
  cylinder { < 6.2,24.5,-0.5>,< 5.8,24.5,-0.5>,0.5 pigment { DarkBrown } }
  cylinder { < 6.2,24.5, 0.5>,< 5.8,24.5, 0.5>,0.5 pigment { DarkBrown } }
  cylinder { < 6.2,24.5, 1.5>,< 5.8,24.5, 1.5>,0.5 pigment { DarkBrown } }
  cylinder { < 6.2,24.5, 2.5>,< 5.8,24.5, 2.5>,0.5 pigment { DarkBrown } }    
}

object {
  pole
  translate <300,-20,75>
}                  

object {
  pole
  translate <300,-15,175>
}

#declare seat = union {
  cylinder {
    <-2,0,0>,
    <-2,-10,0>,0.3
    pigment {
      Black
    }
  }
  cylinder {
    <0,0,0>,
    <-2,0,0>,0.3
    pigment {
      Black
    }
  }
  cylinder {
    <-2,-10,0>,
    <-2,-11,0>,1
    pigment {
      Black
    }
  }
}
  
cylinder {
  <306,5,78>,
  <306,10,172>,0.2
  pigment {
    Black
  }
}

cylinder {
  <294,5,78>,
  <294,10,172>,0.2
  pigment {
    Black
  }
}

object {
  seat       
  rotate <20,0,0>
  translate <306,6,100>
}
object {
  seat          
  rotate <0,20,0>
  translate <294,7.5,125>
}
object {
  seat           
  rotate <0,0,20>
  translate <306,9,150>
}

object {
  seat        
  rotate <20,20,0>
  translate <294,10,175>
}

cylinder {
  <300,-10,200>,
  <306,10,178>,0.2
  pigment {
    Black
  }
}

cylinder {
  <300,-10,200>,
  <294,10,178>,0.2
  pigment {
    Black
  }
}

cylinder {
  <306,5,78>,
  <306,-25,-100>,0.2
  pigment {
    Black
  }
}

cylinder {
  <294,5,78>,
  <294,-25,-100>,0.2
  pigment {
    Black
  }
}

#declare stick = union {
  cylinder {
    <0,-1,0>,
    <0,3,0>,0.05
    texture {
      T_Chrome_2B
    }
  }
  cylinder {
    <0,-0.7,0>,
    <0,-0.65,0>,0.3
    pigment {
      White
    }
  }
  cylinder {
    <0,2.5,0>,
    <0,3,0>,0.2
    pigment {
      White
    }
  }
  sphere {
    <0,0,0>,0.2
    scale <2,1,1>
    translate <0,2.7,0>
    pigment {
      Black
    }                
  }
}

#declare clothes = texture {
  pigment {  
    DarkPurple
  }           
  normal {
    ripples 0.5
    scale 0.1
  }
}

#declare skiman = union {
  object {
    ski4
  }
  object {
    ski4
    translate <0,0,1>
  }
  object {
    boot2
    translate <0,0.14,0>
  }
  object {
    boot2
    translate <0,0.14,1>
  }
  superellipsoid {
    <0.5,0.5>
    scale <0.25,0.5,0.25>
    rotate <0,0,-25>
    translate <0.2,1.4,0> 
    texture {
      clothes
    }
  }
  superellipsoid {
    <0.5,0.5>
    scale <0.25,0.5,0.25>
    rotate <0,0,-25>
    translate <0.2,1.4,1> 
    texture {
      clothes
    }
  }
  superellipsoid {
    <0.5,0.5>
    scale <0.25,1,0.25>
    rotate <0,0,30>
    translate <0,2.4,0> 
    texture {
      clothes
    }
  }
  superellipsoid {
    <0.5,0.5>
    scale <0.25,1,0.25>
    rotate <0,0,30>
    translate <0,2.4,1> 
    texture {
      clothes
    }
  }
  sphere {
    <-0.4,3,0.25>,0.5
    texture {
      clothes
    }
  }
  sphere {
    <-0.4,3,0.75>,0.5
    texture {
      clothes
    }
  }
  superellipsoid {
    <0.4,0.9>
    scale <0.5,1.3,0.9>
    rotate <0,0,-20>
    translate <0,4.3,0.5> 
    texture {
      clothes
    }
  }
  sphere {
    <0,0,0>,0.5
    scale <1,1.5,1>
    translate <0.5,6,0.5>
    pigment {
      DarkBrown
    }
  }
  superellipsoid {  
    <0.6,0.6>
    scale <0.2,0.75,0.2>
    rotate <0,0,40>
    rotate <40,0,0>
    translate <0.6,5,-0.3>
    texture {
      clothes
    }
  }
  superellipsoid {  
    <0.6,0.6>
    scale <0.2,0.75,0.2>
    rotate <0,0,40>
    rotate <-40,0,0>
    translate <0.6,5,1.3>
    texture {
      clothes
    }
  }
  superellipsoid {  
    <0.6,0.6>
    scale <0.2,0.75,0.2>
    rotate <0,0,90>
    translate <1.9,4.5,-0.5>
    texture {
      clothes
    }
  }
  superellipsoid {  
    <0.6,0.6>
    scale <0.2,0.75,0.2>
    rotate <0,0,90>
    translate <1.9,4.5,1.5>
    texture {
      clothes
    }
  }
  object {
    stick
    translate <2.9,1.8,1.5>
  }
  object {
    stick  
    translate <0,-3,0>
    rotate <0,0,10>
    translate <0,3,0>
    translate <2.9,1.8,-0.5>
  }  
}

object {
  skiman 
  rotate <0,-10,0>
  translate <20,0.5,50>
}
