// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.5
// Desc:IRTC  SEPTEMBRE 2001   
// Date:
// Auth:
//+w2048 +h1536
//----------------------------------------------------------------------
#version 3.5;
//----------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#declare SD=seed(125);
//----------------------------------------------------------------------
#declare MESH=yes;
//----------------------------------------------------------------------
global_settings {
  assumed_gamma 1
  ambient_light .3
  //max_trace_level 25
}
//--CAMERA--------------------------------------------------------------

camera {location <-1, -.1, -3.5> right x*image_width/image_height look_at <0, .3, 0> angle 15}

//Light
//light_source {<10, 20, -100> White*.5}
light_source {<-10, 15, -2>  White*2 spotlight radius .2 falloff 2 tightness 20 point_at 0 media_interaction on}
light_source {< 10, 15,  2>  White*2 spotlight radius .2 falloff 2 tightness 20 point_at 0 media_interaction on}

//Media 
#declare Atmosphere=media {
  method 3// jitter .3
  intervals 1 
  samples 1,1
  emission  .01
}
                    
//Sky
//background {SlateBlue*.3}
#declare Fumee=media{
     method 3 
     intervals 1 
     samples 1,1 
     emission 5
 density { spherical
           density_map {
                 [0 Black]
                 [.8  spiral2 20  color_map {[0 Red][.5 Black ] } scale 0.5 rotate x*90]
                 [1. leopard color_map {[0 Orange][.4 Black ]} scale 2]
           }         
           turbulence .8
    } 
}
box {<-20,-20,-10><20,20,4> pigment {rgbf 1} interior {media {Fumee}} no_shadow hollow}

box {<-30,-5,-20><30,5,5>
    pigment { 
    gradient x
       color_map{
       [0.1 color rgb <0.835,0.412,0.259> ]
       [0.2 color rgb <0.592,0.620,0.624> ]
       }
       scale 20
       rotate -z*20
       translate -x*2
      }
    interior {media {Atmosphere}}
    finish{ambient .6 diffuse .6 reflection .3}  
    no_shadow
    hollow
}

//----------------------------------------------------------------------
 #macro DebugMaxBox(Obj)//For Works
 #local C1 = min_extent (Obj);
 #local C2 = max_extent (Obj);
 #debug concat ("MinBox <",str(C1.x,0,2),",",str(C1.y,0,2),",",str(C1.z,0,2),">\n")
 #debug concat ("MaxBox <",str(C2.x,0,2),",",str(C2.y,0,2),",",str(C2.z,0,2),">\n")
 #end
//----------------------------------------------------------------------
                        
#declare T_Femme=texture{pigment{Wheat+Orange*.5}
     finish {
         ambient 0.15
     //    brilliance 5
         diffuse 0.6
     //    metallic
      //   specular 0.80
     //    roughness 1/100
      //   reflection 0.065
          }
     }
#declare T_Homme=texture{
                pigment {bozo color_map {[0.4 Orange+White*.5 ][.45 Red*.3]}turbulence .3 scale .05}
                finish {ambient 0.3 diffuse .6  reflection .01}
     }
#declare T_Cheval=texture{pigment {leopard color_map {[0.0 Grey][1 Wheat]} turbulence .3 scale .1}
                        finish {ambient 0.3 diffuse .6  reflection .01}
                        }
#declare T_Pique=texture{Aluminum}
#declare T_Squelette=texture{pigment {bozo color_map {[0.0 White][1 Wheat]} turbulence .3 scale .01}}                        
//----------------------------------------------------------------------

#if(MESH)
     //-- Declaration des Objects --------------------------------------
     #include "mesh\fem_o.inc"//seuil
     #declare Object_Femme=object{Fem texture {T_Femme} scale .2 } 
     
     #include "mesh\Cheval_o.inc"
     #declare Object_Cheval=object{Cheval texture {T_Cheval} scale .2 rotate y*90}   
     
     #include "mesh\homme_o.inc" //plafond
     #declare Object_Homme=object{Homme texture {T_Homme} scale .2 } 
     
     #include "mesh\squelette_o.inc" //plafond
     #declare Object_Squelette=object{Squelette texture {T_Squelette} scale .35 } 
     
     #include "mesh\Fleches_o.inc" //plafond
     #declare Object_Fleches=object{Fleches texture {T_Pique} scale .005 } 
     
     //-- Initialisation Tableau D'objet ----------------------------------
     #declare NbrObject=5;
     #declare TabObject=array[NbrObject]{ Object_Femme,Object_Homme,Object_Cheval,Object_Squelette,Object_Fleches}
     
     //-- Seuil Pour Randomize ---------------------------------------------
     #declare Seed=seed(173);//Randomise
     #declare SeuilBas=.6;//Femme
     #declare SeuilMilieu=.85;//Homme
     #declare SeuilHaut=.90;//Cheval
     #declare SeuilFin=.95;//Squelette     
      
     // Macro Sort_Object     
    //-------------------
      #macro Sort_Object()
        #local Rd=rand(Seed);
        #switch(Rd)
             #range(0,SeuilBas)
                    #declare SingleObject=object {Insert_Object(NbrObject,0)scale rand(Rd)*1.2}
             #break 
             #range(SeuilBas,SeuilMilieu)     
                   #declare SingleObject=object {Insert_Object(NbrObject,1)scale rand(Rd)*1.2}
             #break
             #range(SeuilMilieu,SeuilHaut)     
                  #declare SingleObject=object {Insert_Object(NbrObject,2)scale rand(Rd)*1.2}
             #break       
             #range(SeuilHaut,SeuilFin)     
                   #declare SingleObject=object {Insert_Object(NbrObject,3)scale rand(Rd)*1.2}
             #break     
             #else
                  #declare SingleObject=object {Insert_Object(NbrObject,4) }
        #end
     #end
     
     // Macro Creation du PCM
     //----------------------
     #include "pcm_plus.mcr"
          #macro create_mesh () object_mesh (Object_Femme)#end
          #declare Mesh1 = read_mesh ("glauque_final.pcm")// glauque_6.pcm
          #declare Warum= object { Mesh1 }
     
     // AFFICHAGE    
     //----------------------------------------------------------------------     
          object {Warum  scale <1,1,-1> rotate y*-90}
          
      //----------------------------------------------------------------------     
      // For Work
      //--------
     DebugMaxBox(Warum)   
     
    #else //If_Mesh for Work
          box{<-0.30,-0.22,-0.44><0.39,0.71,0.45> texture {T_Homme} scale <.3,.1,.5>}
      
#end // IF_Mesh

//----------------------------------------------------------------------
// END_OF_FILE /////////////////////////////////////////////////////////
//----------------------------------------------------------------------


