#version 3.5;
#include "plant_19.inc"
#include "empty_fruit.inc"

#declare Radiosity = yes;

#if (Radiosity)
  global_settings {
    
    max_trace_level 17
    assumed_gamma 1

    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35
  
      nearest_count 5
      error_bound 0.2
      recursion_limit 3
  
      low_error_factor .5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1
      normal on
      adc_bailout 0.01/2
      }
    }
#else
  global_settings { max_trace_level 17 }
#end

camera  {
  up y/2
  right x
  location 1.5*<1.5,0,-1>
  look_at <-2.5,0,0>
  angle 40
  }

light_source {
  <-60,60,-60>
  color rgb 1.2*<1,1,1>
  parallel 
  point_at <0,0,0>
  }

// ----------------------------------------textures, materials


#declare Island_Tex = material {
  texture {
    pigment {
      granite
      turbulence .5
      omega .6
      lambda 2
      color_map {
        [.05 rgb <.4,.5,.2>] 
        [.2 rgb <.1,.2,.05>]
        [.5 rgb <.4,.5,.3>] 
        }
      scale .1*<1,.5,1>
      }
    finish {ambient 0}
    }
  texture {
    pigment {
      gradient y
      color_map {
        [.2 rgb <.85,.8,.7>]
        [.7 rgb <.1,.1,.1>]
        [.85 rgbt <0,0,0,1>]
        }
      }
    normal {
      gradient y
      normal_map {
        [.2 granite 0]
        [.82 dents .5 turbulence .2 scale .00675*<1,1,1>]
        [.9 granite .5 turbulence .5 omega .6 lambda 2 scale .1*<1,.5,1>]
        }
      }
    finish {ambient 0}
    }
  }

#declare bright = .75;

#declare step = 1/36;

#declare R = .5/pi;
#declare H = .0125;

#declare Wall_Tex = material {
  texture {
    pigment {
      crackle
      turbulence .5
      omega .6
      lambda 2
      color_map {
        [.05 rgb bright*<.8,.7,.6>] 
        [.2 rgb bright*<1,.9,.8>]
        [.5 rgb bright*<.9,.8,.7>] 
        }
      scale .1*<1,1/H,1>
      }
    finish {ambient 0}
    }
  texture {
    pigment {
      gradient y
      color_map {
        [.315 rgb bright*<.9,.875,.825>]
        [.325 rgbt <0,0,0,1>]
        }
      }
    normal {
      gradient y
      normal_map {
        [.315 dents .5 turbulence .2 scale .00675*<1,1/H,1>]
        [.325 granite .5 turbulence .2 scale .0125*<1,1/H,1>]
        }
      }
    finish {ambient 0}
    }
  }

// ----------------------------------------height_fields

#declare Island = object {
  height_field {png "island.png" smooth}
  material {Island_Tex}
  translate <-.5,0,-.5>
  scale <40,2.5,40>
  translate <-72,-2,9>
  }

#declare Wall1 = object {
  height_field {png "stone5.png" smooth scale <1,1,1>}
  }
#declare Wall2 = object {
  height_field {png "stone6.png" smooth scale <1,1,1>}
  }

// ----------------------------------------objects

#declare bright = .33; 

#declare Wall = object {
  height_field {png "stone2.png"
    smooth
    texture {
      pigment {
      crackle
      turbulence .5
      omega .6
      lambda 2
      color_map {
        [.05 rgb bright*<.8,.7,.6>] 
        [.2 rgb bright*<1,.9,.8>]
        [.5 rgb bright*<.9,.8,.7>] 
        }
      scale .1
      }
      finish {ambient 0}
      }
    texture {
      pigment {
        gradient y
        color_map {
          [0.31 rgb bright*<1,.9,.7>]
          [0.32 rgbf <1,1,1,1>]
          }
        }
      normal {
        gradient y
        normal_map {
          [0.31 dents .75 turbulence .2 scale .00675]
          [0.32 granite .5 turbulence .2 scale .0125]
          }
        }
      finish {ambient 0}
      }
    translate <-.5,0,-.5>
    scale <1,.025,1>
    rotate -x*90
    }
  }
  
    
#declare Tower = object {  
  merge {
    #declare A = 0;
    #while (A < 1)
      intersection {
        object {Wall1
          material {Wall_Tex}
          translate <-(.5*step+A),0,-.5>
          scale <1,H,1>
          }
        object {Wall1
          material {Wall_Tex}
          translate <-(.5*step+A),-.01,-.5>
          scale <1,-H,1>
          }
        plane {x, 0
          material {Wall_Tex translate -x*.5*step-A}
          rotate -z*180*step
          translate -y*R
          }
        plane {-x, 0
          material {Wall_Tex translate -x*.5*step-A}
          rotate z*180*step
          translate -y*R
          }        
        rotate x*90
        translate <0,0,R>
        rotate y*360*A
        }
      #declare A = A+step;
    #end
    scale <1.5,1,1.5>
    }
  }  

#declare Border1 = object {
  intersection {
    object {Wall2
      material {Wall_Tex}
      translate <-.5,-.01,-.25>
      scale <1,H,1>
      }
    object {Wall2
      material {Wall_Tex}
      translate <-.5,0,-.25>
      scale <1,-H,1>
      }
    plane {z, .5
      material {Wall_Tex}
      }
    rotate x*90
    scale <1.5,1,1.5>
    }
  }
 

// ----------------------------------------szene
// ---------------------------------------------
// ---------------------------------------------
  
intersection {
        object {Wall}
        object {Wall scale y*-1 rotate x*90 translate z*.2 translate y*.2}
        }

object {Wall
  scale y*-1
  translate y*-1
  }
object {Island}

union {
  object {Tower rotate -y*45 translate <.75+.75/pi,0,0>}
  object {Tower rotate y*45 translate <-.75-.75/pi,0,0>}
  object {Tower rotate y*135 translate <-.75-.75/pi,0,1.5+1.5/pi>}
  object {Tower rotate -y*135 translate <.75+.75/pi,0,1.5+1.5/pi>}
  object {Border1}
  object {Border1 rotate y*90 translate <-.75-.75/pi,0,.75+.75/pi>}
  object {Border1 rotate y*180 translate <0,0,1.5+1.5/pi>}
  object {Border1 rotate -y*90 translate <.75+.75/pi,0,.75+.75/pi>}
  scale 4
  rotate y*-50
  translate <-70,2.2,9>
  }
  
#declare x1 = .4;
#declare y1 = .5;
#declare f1 = .002;
#declare x2 = .6;
#declare y2 = .5;
#declare f2 = .0018;
#declare x3 = .4504;
#declare y3 = .51;
#declare f3 = .001;
#declare x4 = .4684;
#declare y4 = .5152;
#declare f4 = .0008;
#declare x5 = .468;
#declare y5 = .624;
#declare f5 = .0006;
#declare x6 = .4812;
#declare y6 = .578;
#declare f6 = .0006;

merge {
  intersection {
    height_field {
      function 3000,3000 {
        .5+
        sin(1/f1*sqrt(pow(x-x1,2)+pow(y-y1,2)))*100*f1/pow((2+200*sqrt(pow(x-x1,2)+pow(y-y1,2))),1.5)+
        sin(1/f2*sqrt(pow(x-x2,2)+pow(y-y2,2)))*100*f2/pow((2+200*sqrt(pow(x-x2,2)+pow(y-y2,2))),1.5)+
        sin(1/f3*sqrt(pow(x-x3,2)+pow(y-y3,2)))*100*f3/pow((2+200*sqrt(pow(x-x3,2)+pow(y-y3,2))),1.5)+
        sin(1/f4*sqrt(pow(x-x4,2)+pow(y-y4,2)))*100*f4/pow((2+200*sqrt(pow(x-x4,2)+pow(y-y4,2))),1.5)+
        sin(1/f5*sqrt(pow(x-x5,2)+pow(y-y5,2)))*100*f5/pow((2+200*sqrt(pow(x-x5,2)+pow(y-y5,2))),1.5)+
        sin(1/f6*sqrt(pow(x-x6,2)+pow(y-y6,2)))*100*f6/pow((2+200*sqrt(pow(x-x6,2)+pow(y-y6,2))),1.5)
        }
      smooth
      translate <-.5,0,-.5>
      scale <5,.02,5>
      }
    plane {y,1}
    }
  intersection {
    plane {y,.01
      pigment {rgbft <.85,.8,.7,.2,.65>}
      interior {
        ior 1.33
        fade_distance .01 
        fade_power 1
        fade_color <.85,.8,.7>
        }
      finish {
        conserve_energy
        ambient 0.0
        diffuse 0.0
        specular 1.0
        roughness 0.0005
        reflection {.3, .6}
        }
      normal {granite .1 scale .5*<1,.025,1>}
      }
    box {<-2.5,-5,-2.5>,<2.5,1,2.5> inverse}
    pigment {rgbft <.85,.8,.7,.2,.65>}
    interior {
      ior 1.33
      fade_distance .01 
      fade_power 1
      fade_color <.85,.8,.7>
      }
    finish {
      conserve_energy
      ambient 0.0
      diffuse 0.0
      specular 1.0
      roughness 0.0005
      reflection {.3, .6}
      }
    }
  pigment {rgbft <.85,.8,.7,.2,.65>}
  interior {
    ior 1.33
    fade_distance .01 
    fade_power 1
    fade_color <.85,.8,.7>
    }
  finish {
    conserve_energy
    ambient 0.0
    diffuse 0.0
    specular 1.0
    roughness 0.0005
    reflection {.3, .6}
    }
  translate <0,-.25,0>
  }

// ----------------------------------------sky (planned with multiple planes but too hard to render)

#declare c=.5;
#while (c<1)
  #declare stre=sin(pi*c);
  mesh {
    triangle {<-2000, 20+3*c, -300>, <300, 20+3*c, -300>, <300, 10+3*c, 3000>}
    triangle {<-2000, 20+3*c, -300>, <-2000, 20+3*c, 3000>, <300, 20+3*c, 3000>}
    pigment {
      bozo
      turbulence .5
      octaves 5
      omega .8
      lambda 2
      color_map {
        [0.5 rgbt <1,1,1,1>]
        [0.85 rgbt <1,1,1,1-.5*stre>]
        }
      rotate x*90
      rotate y*90
      scale 40
      }
    finish {ambient 0}
    }
    #declare c=c+1;
#end


plane {-y, -40
  pigment {
    rgb <.6,.7,.8>
    }
  finish {ambient 1}
  no_shadow
  }

// ----------------------------------------plants

// --> touchin' birch

#declare rnd = seed (3498857345);
#declare min_rad = .001;
#declare len = <.06,.5,.01>;
#declare sta_len = <.02,0,0>;
#declare lf_siz = 1.6*<.5,150,50>;
#declare lf_ang = <120,.95>;
#declare max_var = .2;
#declare rd = .96;
#declare bra_c = 1;
#declare ct_m = <1,2>;
#declare tru = <.95,.1,5>;
#declare bra = <.5,.2,60>;
#declare light = <0,10,-1>;
#declare light_s = .15;
#declare grv_s = <.1,.5,2>;

  
#include "birch_elem.inc"
#include "birch_leaf.inc"
  
union {
  plant (.04,.04,<0,0,0>,<0,0,-1>,10,1)
  scale .3
  translate <-.17,-.125,0>
  }
  
// --> random green

#macro element (ori, old_rad, fin, rad)
    union {
      cone {ori, old_rad, fin, rad}
      sphere {ori, old_rad}
      material {branch_mat}
      }
#end

#declare C = 0;
#while (C < 100)
  #declare len = <.03*rand(rnd),1+5*rand(rnd),.03*rand(rnd)>;
  #declare sta_len = <.0001,int(4*rand(rnd)),0>;
  #declare lf_siz = <0,300+300*rand(rnd),50+100*rand(rnd)>;
  #declare lf_ang = <10+70*rand(rnd),rand(rnd)>;
  #declare max_var = .1+.25*rand(rnd);
  #declare rd = .96+.02*rand(rnd);
  #declare bra_c = 1+int(rand(rnd));
  #declare ct_m = <1+5*rand(rnd),4*rand(rnd)>;
  #declare tru = <.75+.25*rand(rnd),0,20*rand(rnd)>;
  #declare bra = <.25+.5*rand(rnd),.15*rand(rnd),10+30*rand(rnd)>;
  #declare light_s = .5*rand(rnd);
  #declare grv_s = <.25+.5*rand(rnd),.5+.5*rand(rnd),.5*rand(rnd)>;
  #declare name = int(3.999999*rand(rnd));
  
  #if (name = 0)
    #include "wiese11_leaf.inc"
  #end
  #if (name = 1)
    #include "nessel_leaf.inc"
  #end
  #if (name = 2)
    #include "gras_leaf.inc"
  #end
  #if (name = 3)
    #include "wiese12_leaf.inc"
  #end
  
  #declare branch_mat = material {  
    texture {
      pigment {rgb <.15+.2*rand(rnd),.2+.2*rand(rnd),.1*rand(rnd)>}
      normal {granite .2+.2*rand(rnd) scale .125*<.25,.25,.25>}
      finish {ambient 0}
      }
    }

  #declare R = .002+.0037*rand(rnd);
  union {
    plant (R,R,<0,0,0>,<1-2*rand(rnd),.2*rand(rnd)-.01,-.4-.6*rand(rnd)>,1+5*rand(rnd),1)
    scale .3
    
    translate <.015-.03*rand(rnd),.015+.03*rand(rnd),0>
    translate <-.17,-.125,0>
    }
  #declare C = C+1;
#end

#declare C = 0;
#while (C < 22)
  #declare len = <.03*rand(rnd),1+5*rand(rnd),.03*rand(rnd)>;
  #declare sta_len = <.0001,int(4*rand(rnd)),0>;
  #declare lf_siz = <0,300+300*rand(rnd),50+100*rand(rnd)>;
  #declare lf_ang = <10+70*rand(rnd),rand(rnd)>;
  #declare max_var = .1+.25*rand(rnd);
  #declare rd = .96+.02*rand(rnd);
  #declare bra_c = 1+int(rand(rnd));
  #declare ct_m = <1+5*rand(rnd),4*rand(rnd)>;
  #declare tru = <.75+.25*rand(rnd),0,20*rand(rnd)>;
  #declare bra = <.25+.5*rand(rnd),.15*rand(rnd),10+30*rand(rnd)>;
  #declare light_s = .5*rand(rnd);
  #declare grv_s = <.25+.75*rand(rnd),.5+.75*rand(rnd),rand(rnd)>;
  #declare name = int(3.999999*rand(rnd));
  
  #if (name = 0)
    #include "wiese11_leaf.inc"
  #end
  #if (name = 1)
    #include "nessel_leaf.inc"
  #end
  #if (name = 2)
    #include "gras_leaf.inc"
  #end
  #if (name = 3)
    #include "wiese12_leaf.inc"
  #end
  
  #declare branch_mat = material {
   texture {
    pigment {rgb <.15+.2*rand(rnd),.2+.2*rand(rnd),.1*rand(rnd)>}
    normal {granite .2+.2*rand(rnd) scale .125*<.25,.25,.25>}
    finish {ambient 0}
   }
  }
  
  #declare R = .002+.004*rand(rnd);
  union {
    plant (R,R,<0,0,0>,<1-2*rand(rnd),.2*rand(rnd)-.01,-.4-.6*rand(rnd)>,1+5*rand(rnd),1)
    scale .3
    
    translate <.01-.02*rand(rnd),.01+.02*rand(rnd),0>
    translate <-.25,-.17,0>
    }
  #declare C = C+1;
#end

#declare C = 0;
#while (C < 20)
  #declare len = <.03*rand(rnd),1+5*rand(rnd),.03*rand(rnd)>;
  #declare sta_len = <.0001,int(4*rand(rnd)),0>;
  #declare lf_siz = <0,300+300*rand(rnd),50+100*rand(rnd)>;
  #declare lf_ang = <10+70*rand(rnd),rand(rnd)>;
  #declare max_var = .1+.25*rand(rnd);
  #declare rd = .96+.02*rand(rnd);
  #declare bra_c = 1+int(rand(rnd));
  #declare ct_m = <1+5*rand(rnd),4*rand(rnd)>;
  #declare tru = <.75+.25*rand(rnd),0,20*rand(rnd)>;
  #declare bra = <.25+.5*rand(rnd),.15*rand(rnd),10+30*rand(rnd)>;
  #declare light_s = .6*rand(rnd);
  #declare grv_s = <.25+.75*rand(rnd),.5+.75*rand(rnd),rand(rnd)>;
  #declare name = int(2.999999*rand(rnd));
  
  #if (name = 0)
    #include "wiese11_leaf.inc"
  #end
  #if (name = 1)
    #include "gras_leaf.inc"
  #end
  #if (name = 2)
    #include "wiese12_leaf.inc"
  #end
  
  #declare branch_mat = material {
   texture {
    pigment {rgb <.15+.2*rand(rnd),.2+.2*rand(rnd),.1*rand(rnd)>}
    normal {granite .2+.2*rand(rnd) scale .125*<.25,.25,.25>}
    finish {ambient 0}
   }
  }
  #declare R = .001+.003*rand(rnd);
  union {
    plant (R,R,<0,0,0>,<1-2*rand(rnd),.2*rand(rnd)-.01,-.4-.6*rand(rnd)>,1+5*rand(rnd),1)
    scale .3
    
    translate <.01-.02*rand(rnd),.01-.02*rand(rnd),0>
    translate <.11,.08,0>
    }
  #declare C = C+1;
#end

// --> flowers

#declare R_min = .5;
#declare R_max = 1;  
#declare A_step = .2;
#declare R_step = .1;

#declare rnd = seed (0);
#declare min_rad = .002;
#declare len = <.015,10,.015>;
#declare sta_len = <.0001,0,0>;
#declare lf_siz = <0,200,75>;
#declare lf_ang = <100,.5>;
#declare max_var = .2;
#declare rd = .95;
#declare bra_c = 1;
#declare ct_m = <100,0>;
#declare tru = <0,0,0>;
#declare bra = <.1,0,20>;
#declare light = <0,1,-1>;
#declare light_s = .2;
#declare grv_s = <.1,1,0>;

#declare Blatt = object {
  intersection {
    sphere {<0,0,-1>, 1
      }
    sphere {<0,0,-1>, .999999
      inverse
      }
    cylinder {<0,0,-.1>, <0,0,0>, .1
      scale <1,4,1>
      hollow on
      }
    translate y*.2
    }
  }

#declare leaf = object {
  union {
    sphere {<0,0,0>, R_min
      scale <1,.25,1>
      pigment {rgb <.5,.45,.2>}
      finish {ambient 0}
      normal {dents 2 scale .01}
      }
    #declare R = R_min;
    #while (R < R_max)
      #declare A = 0;
      #while (A < 360)
        object {Blatt
          pigment {rgb <1,.75+.25*rand(rnd),.5*rand(rnd)>}
          finish {ambient 0}
          scale <1+rand(rnd),1+rand(rnd),1+rand(rnd)>*R
          rotate x*(90-600*(1-sqrt(R))+R_step*rand(rnd)*200)
          translate z*R_min
          rotate y*(A+A_step*rand(rnd)*200)
          }
        #local A = A+360/(2*pi*R/A_step);
      #end
      #local R = R+R_step;
    #end
    scale .1
    rotate -x*90
    }
  }

#declare branch_mat = material {
 texture {
  pigment {rgb <.25,.3,.1>}
  normal {granite .5 scale .125*<.25,.1,.25>}
  finish {ambient 0}
  }
 }

#declare C = 0;
#while (C < 3)
  #declare rad = .003+.002*rand(rnd);
  #declare light_s = .15+.1*rand(rnd);
  #declare grv_s = <.1,.5+.5*rand(rnd),.5*rand(rnd)>;
  union {
    plant (rad,rad,<0,0,0>,<.6-1.2*rand(rnd),1.2*rand(rnd)-.2,-.8*rand(rnd)-.2>,5+5*rand(rnd),1)
    scale .2
    translate <.01-.02*rand(rnd),.01-.02*rand(rnd),0>
    translate <.11,.08,0>
    }
  #declare C = C+1;
#end

// --> tan trees

#declare rnd = seed (100);
#declare min_rad = .001;
#declare len = <.03,3,0>;
#declare sta_len = <.000001,0,0>;
#declare lf_siz = <.15,500,100>;
#declare lf_ang = <20,1>;
#declare max_var = .125;
#declare rd = .96;
#declare bra_c = 8;
#declare ct_m = <4,2>;
#declare tru = <.9,0,0>;
#declare bra = <.25,.5,90>;
#declare light = <0,100,0>;
#declare light_s = .1;
#declare grv_s = <.2,.25,.25>;

#declare branch_tex = texture {
  pigment {rgb <.3,.25,.1>}
  normal {granite .5 scale .5*<.25,.25,.25>}
  finish {ambient 0}
  }
#declare branch_tex1 = texture {
  pigment {rgb <.4,.6,.3>}
  normal {granite .5 scale .5*<.25,.25,.25>}
  finish {ambient 0}
  }

#macro element (ori,o_rad,fin,f_rad)
  cone {ori,o_rad,fin,f_rad
    texture {branch_tex}
    }

  #if (o_rad < 8*min_rad)
    cone {ori,o_rad+6*min_rad,fin,f_rad+14*min_rad
      texture {branch_tex1}
      }
  #end

#end

#include "empty_leaf.inc"
#include "empty_fruit.inc"

#declare c = 0;
#while (c < 8)
        union {
          #declare direct = <0,1,0>;
          #declare pos = trace(Island,<-70+5*rand(rnd),2,1+5*rand(rnd)>,<0,-1,0>,direct);
          #declare stamm = .01+.03*rand(rnd);
          plant (stamm,stamm,<0,0,0>,direct,6+8*rand(rnd),1)
          translate pos
          }
         #declare c = c+1;
#end

// --> far birches (lower lod)

#declare rnd = seed (0);
#declare min_rad = .001;
#declare len = <.06,.5,.01>;
#declare sta_len = <.02,0,0>;
#declare lf_siz = 1.6*<.5,150,50>;
#declare lf_ang = <120,.95>;
#declare max_var = .2;
#declare rd = .96;
#declare bra_c = 1;
#declare ct_m = <1,2>;
#declare tru = <.95,.1,5>;
#declare bra = <.5,.2,60>;
#declare light = <0,100,0>;
#declare light_s = .15;
#declare grv_s = <.1,.5,2>;

  
#include "birch_elem.inc"
#include "birch_leaf_lod.inc"

#declare c = 0;  
#while (c < 13)
        union {
          #declare direct = <0,1,0>;
          #declare pos = trace(Island,<-70+6*rand(rnd),2,15+6*rand(rnd)>,<0,-1,0>,direct);
          #declare stamm = .01+.03*rand(rnd);
          plant (stamm,stamm,<0,0,0>,direct,6+8*rand(rnd),1)
          translate pos
          }
         #declare c = c+1;
#end  

plane {y,-2
        pigment {rgb <.85,.8,.7>}
        finish {ambient 0}
        }

fog {
  distance 300
  color rgb <1,.6,.4>
  }
