#local MetalTex =
texture
{
    pigment { color rgb <0.34, 0.36, 0.3> }

    finish { specular 0.7 roughness 0.6 metallic reflection { 0.3 metallic } }

    normal
    {
        average
        normal_map
        {
            [1.0 wrinkles 0.4 scale 0.01 ]
            [1.0 bozo 1 scale 0.07 ]
        }
    }
}

#local MinRadius = 0.4;
#local MaxRadius = 0.5;

#local Body =
union
{
    difference
    {
        cone
        {
            0, MinRadius, 1*y, MaxRadius
        }
        
        union
        {
            cone
            {
                0.1*y, MinRadius - 0.03, 1.001*y, MaxRadius - 0.03
            }

            #local i = 0.7;
            #while (i < 0.8)
                torus
                {
                    MinRadius + i * (MaxRadius - MinRadius), 0.005
                    scale <1, 4, 1>
                    translate i * y
                }
                #declare i = i + 0.03;
            #end
        }
    }
    
    torus
    {
        MaxRadius, 0.015
        scale <1, 2/3, 1>
        translate 1*y
    }
}

#local HandleRadius = 0.015;
#local Handle =
object
{
    sphere_sweep
    {
        b_spline
        8,
        
        <               0, 0.0, 0>, HandleRadius
        <      -MinRadius, 0.0, 0>, HandleRadius
        <-MaxRadius - 0.1, 0.0, 0>, HandleRadius
        <-MaxRadius - 0.2, 0.7, 0>, HandleRadius
        < MaxRadius + 0.2, 0.7, 0>, HandleRadius
        < MaxRadius + 0.1, 0.0, 0>, HandleRadius
        <       MinRadius, 0.0, 0>, HandleRadius
        <               0, 0.0, 0>, HandleRadius
    }

    rotate -140*x    
    translate 0.9*y
}

#declare Bucket =
union
{
    object { Body }
    object { Handle }
    
    texture { MetalTex }
}


///////////////////////////////////////////////////////////

/*
global_settings
{
    max_trace_level 10
}

camera
{
    location <1, 1.5, -2>
    look_at <0, 0.5, 0>
}

light_source
{
    <-10, 20, -30>
    color rgb 1
}

light_source
{
    <10, 5, -30>
    color rgb 0.3
}

plane
{
    y, 0
    pigment { color rgb 0.7 }
}

object
{
    Bucket
    rotate 20*y
}
*/
