#ifndef (CHAIR_SET_INCLUDED)
#declare CHAIR_SET_INCLUDED = 1;

#declare IMPORT_SPATCH = 1;
#include "chair.inc"
#include "table.inc"

#include "rand.inc"

#local RndSeed = seed (16);

#local MotiveHeight = 0.5;
#local MotiveDepression = 0.55; // Percent

#local MotiveXLen = 3.65;
#local MotiveZLen = 3.65;
#local MotiveXBorder = 0.3;
#local MotiveZBorder = 0.3;

#local MotiveXLines = 40;
#local MotiveZLines = 40;

// Mean radius of a line
#local MotiveRadius = 0.75 *
    min((MotiveXLen - 2 * MotiveXBorder) / MotiveXLines,
        (MotiveZLen - 2 * MotiveZBorder) / MotiveZLines);

#macro CreateLine (start_x, start_z, end_x, end_z)
    sphere_sweep
    {
        cubic_spline
        7,
        
        <end_x, MotiveHeight * MotiveDepression, end_z>
            + <MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed)>,
            MotiveRadius,
        <end_x, 0, end_z>
            + <MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed)>,
            MotiveRadius,
        <start_x, 0, start_z>
            + <MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed)>,
            MotiveRadius,
        <start_x, MotiveHeight, start_z>
            + <MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed)>,
            MotiveRadius,
        <end_x, MotiveHeight * MotiveDepression, end_z>
            + <MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed)>,
            MotiveRadius,
        <end_x, 0, end_z>
            + <MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed)>,
            MotiveRadius,
        <end_x, -MotiveHeight, end_z>
            + <MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed), MotiveRadius * SRand (RndSeed)>,
            MotiveRadius
    }
#end

#local LineSet =
union
{
    #local X = 0;
    #while (X < MotiveXLines / 2)
        object
        {
            #local XPos = MotiveXBorder +
                (MotiveXLen - 2 * MotiveXBorder) * X / MotiveXLines;
            #local ZPos = MotiveZBorder +
                (MotiveZLen - MotiveZBorder) * X / MotiveXLines;
            CreateLine (XPos, 0, XPos, ZPos)
        }
                
        #declare X = X + 1;
    #end
    
    #while (X < MotiveXLines)
        object
        {
            #local XPos = MotiveXBorder +
                (MotiveXLen - 2 * MotiveXBorder) * X / MotiveXLines;
            #local ZPos = MotiveZBorder +
                (MotiveZLen - MotiveZBorder) * (1 - X / MotiveXLines);
            CreateLine (XPos, 0, XPos, ZPos)
        }
                
        #declare X = X + 1;
    #end

    translate <-MotiveXLen/2, 0, -MotiveZLen/2>
    texture
    {
        pigment
        {
            agate
            pigment_map
            {
                [0.7 color rgb <0.65, 0.52, 0.25>]
                [1.0 color rgb <0.50, 0.43, 0.24>]                
            }
            rotate 90*y
            scale 0.4
        }
        
        normal
        {
            wrinkles 1.7
            turbulence 0.6
            scale 0.05
        }
    }
}

// box { <-1.5, 3.0, -1.8>, <1.8, 3.3, 1.6> }

#local ChairLines =
union
{
    object { LineSet }
    object { LineSet rotate 90*y }
    object { LineSet rotate 180*y }
    object { LineSet rotate 270*y }
    
    pigment { color rgb 1 }
    translate <0, 3.0, 0>
}

#local Wood1Pigment =
pigment
{
    wood
    scale 0.2
    turbulence 0.5
    rotate 17*x
    rotate -28*y
    
    color_map
    {
        [0.5 color rgb <0.58, 0.20, 0.12> * 0.8]
        [0.5 1.0 color rgb <0.83, 0.61, 0.28> * 0.8 color rgb <0.58, 0.20, 0.12> * 0.8]
    }
}

#local Wood2Pigment =
pigment
{
    wood
    scale 0.1
    turbulence 0.9
    rotate -62*x
    rotate 71*y
    
    color_map
    {
        [0.0 0.5 color rgb <0.29, 0.10, 0.06> * 0.8 color rgb <0.42, 0.32, 0.14> * 0.8]
        [0.5 1.0 color rgb <0.42, 0.32, 0.14> * 0.8 color rgb <0.29, 0.10, 0.06> * 0.8]
    }
}

#local FrameworkTex =
texture
{
    pigment
    {
        average
        pigment_map
        {
            [0.25 Wood1Pigment]
            [0.50 Wood2Pigment]
            [0.75 color rgb <0.58, 0.20, 0.12> * 0.6] // Dark spots
        }
        scale 0.4
    }

    normal
    {
        wrinkles 0.6
        turbulence 0.7
        scale 0.1
    }
    
    finish
    {
        specular 0.2
    }
}

#local ClothTex =
texture
{
    uv_mapping pigment
    {
        image_map
        {
            png "tartan.png"
            interpolate 2
            // filter all 0.1
        }            
        scale 2
    }
    
    normal
    {
        wrinkles
        scale 0.01
    }
}

#declare Chair =
union
{
    object { ChairFramework texture { FrameworkTex } }
    
    object { ChairLines }
    scale 0.35
}

#declare ChairWithCloth =
union
{
    object { ChairFramework texture { FrameworkTex } }
    light_group
    {
        object { Cloth double_illuminate texture { ClothTex } }
        light_source { <1, 6, 2> color rgb 0.1 }
        global_lights on
    }
    
    object { ChairLines }
    scale 0.35
}


#declare Table =
union
{
    object { TableTop texture { FrameworkTex } }
    object { TableBase texture { FrameworkTex rotate 30*x } }
    object { TableLegs texture { FrameworkTex rotate -6*z } }

    scale 1.2
}


/*
background { color rgb 0.3 }

camera
{
    //orthographic
    location <2, 4, 2>
    look_at <0, 2, 6>
}

object
{
    Chair
    scale 0.6
    translate <0, 0, 6>
}

light_source
{
    <-10, 10, -5>
    color rgb 1
}
*/

#end /* CHAIR_SET_INCLUDED */
