#include "rand.inc"

/*
camera
{
    location <0, 1, -7>
    look_at <0, 1, 0>
}

light_source
{
    <-10, 20, -30>
    color rgb 1
}

plane
{
    y, 0
    pigment { color rgb <0.5, 0.4, 0.4> }
}
*/


////////////////////////////////////////////////////////////////////////////////////////

#local LadderTex =
texture
{
    pigment
    {
        wood
        warp { turbulence 0.4 }
        
        color_map
        {
            [0.6 color rgb <0.70, 0.7, 0.65>]
            [1.0 color rgb <0.20, 0.17, 0.16>]
        }
    }
    
    normal
    {
        wood 0.1
        turbulence 0.4
    }    
    
    rotate 90*x
    scale 0.02
}


#declare Ladder =
union
{
    cylinder
    {
        <-0.1, 0, 0>, <-0.1, 1, 0>, 0.02
        texture { LadderTex }
    }

    cylinder
    {
        <0.1, 0, 0>, <0.1, 1, 0>, 0.02
        texture { LadderTex }
    }
    
    #local Step = 1;
    #local StepNum = 6;
    #local StepSeed = seed (9);
    #while (Step <= StepNum)
        cylinder
        {
            #local curY = Step / (StepNum + 1);
            <-0.1, curY + RRand(-0.015, 0.015, StepSeed), 0>,
            < 0.1, curY + RRand(-0.015, 0.015, StepSeed), 0>, 0.015

            texture { LadderTex rotate 90*z }
        }
        
        #declare Step = Step + 1;
    #end
}

object
{
    Ladder
    scale 2
}
