#ifndef (ROUNDED_PLATE_INC)
#declare ROUNDED_PLATE_INC = 1;

#macro CuttedCylinder (Radius)
difference
{
    cylinder { <-Radius, 0, 0>, <1 + Radius, 0, 0>, Radius }
    
    union {
        box 
        {
            -Radius * 1.5, <0, Radius * 1.5, Radius * 1.5>
            rotate 45*y 
        }

        box 
        { 
            <0, -Radius * 1.5, -Radius * 1.5>, Radius * 1.5
            rotate -45*y 
            translate <1, 0, 0>
        }
    }
    
    translate <-0.5, 0, 0>
}
#end

// Half cylinder with two "cutted" edges
// going from <-0.5,0,0> to <0.5,0,0> with Radius

#macro HalvedCuttedCylinder (Radius)
difference
{
    object { CuttedCylinder (Radius) }

    box
    {
            <-0.5 - Radius, -Radius, 0>, <0.5 + Radius, Radius, Radius>
    }
}
#end

// Create a rounded border going from <-0.5, -Border_radius, -0.5> to
// <0.5, Border_radius, 0.5>.

#macro RoundedBorder (Border_radius)
union
{
    object 
    { 
        CuttedCylinder (Border_radius) 
        translate <0, 0, -0.5> 
    }
    
    object 
    { 
        CuttedCylinder (Border_radius) 
        rotate 180*y 
        translate <0, 0, 0.5> 
    }
    
    object 
    { 
        CuttedCylinder (Border_radius) 
        rotate 90*y 
        translate <-0.5, 0, 0> 
    }
    
    object 
    { 
        CuttedCylinder (Border_radius) 
        rotate -90*y 
        translate <0.5, 0, 0> 
    }
}
#end

// Create a plate with a rounded border going from -0.5 to 0.5

#macro RoundedPlate (Border_radius, Border_texture, Plate_texture)
union
{
    union
    {
        object 
        { 
            HalvedCuttedCylinder (Border_radius) 
            translate <0, 0, -0.5> 
        }
        
        object 
        { 
            HalvedCuttedCylinder (Border_radius) 
            rotate 180*y 
            translate <0, 0, 0.5> 
        }
        
        object 
        { 
            HalvedCuttedCylinder (Border_radius) 
            rotate 90*y 
            translate <-0.5, 0, 0> 
        }
        
        object 
        { 
            HalvedCuttedCylinder (Border_radius) 
            rotate -90*y 
            translate <0.5, 0, 0> 
        }
        
        texture { Border_texture }
    }
    
    box
    {
        -0.5, 0.5 scale <1, 2 * Border_radius, 1>
        texture { Plate_texture }
    }
}
#end

#end // #ifdef (ROUNDED_PLATE_INC)
