#include "functions.inc"

#local BoardLength = 1*3;
#local BoardHeight = 0.075*3;
#local BoardWidth = 0.2*3;

#local WoodFunction =
function
{
    pigment
    {
        wood
        turbulence 0.2
        color_map
        {
            [0 color rgb 0]
            [1 color rgb 1]
        }
        rotate 90*y
        scale <BoardLength, BoardHeight, BoardWidth>
    }
}

#local Board =
isosurface
{
    function { max (pow((2*x/BoardLength), 8) + pow((2*y/BoardHeight), 8) + pow((2*z/BoardWidth), 8) - 1,
       - 0.3*(WoodFunction (10*x, 10*y, 10*z).gray - 0.5 - 2*0.1)) }
       
    contained_by
    {
        box
        {
            - <BoardLength, BoardHeight, BoardWidth>/2,
            <BoardLength, BoardHeight, BoardWidth>/2
        }
    }
    max_gradient 144.1
}

#declare Shelf =
union
{
    object { Board translate <-0.05, 0.02, -3*BoardWidth/2> }
    object { Board scale -1 translate <0, -0.01, -BoardWidth/2> }
    
    object { Board scale <1, 0.7, 0.3> rotate 90*y translate <-0.3, -BoardHeight/2 * 1.3, 0> }
    object { Board scale <1, 0.7, 0.3> rotate 90*y translate < 1, -BoardHeight/2 * 1.3, 0> }
    
    //pigment { color rgb <0.535164, 0.375006, 0.292973> }
    pigment { color rgb <0.39, 0.28, 0.15> }
}


////////////////////////////////////////////////////////////////////////////////////////////////////

/*
camera
{
    location <1, 1, -5>
    look_at <0, 1, 0>
}

light_source
{
    <-10, 20, -30>
    color rgb 1
}

light_source
{
    <10, 5, -30>
    color rgb 0.3
}

object
{
    Shelf
    rotate 10*y
}
*/