#declare WallHeight = 10;
#declare DoorHeight = 8;

#local LightFactor = 1.4;

#local DarkBandPigment =
pigment
{ 
    bozo
    color_map
    {
        [0.4 color rgb (<0.20, 0.18, 0.15> * LightFactor) transmit 0.3]
        [1.0 color rgb (<0.20, 0.18, 0.15> * LightFactor) transmit 0.8]
    }
    scale 0.05
}

#local DustSpot = function { pattern { granite warp { turbulence 3 } scale 0.9 } }
//#local DustWrinkles = function { pattern { wrinkles warp { turbulence 2 } scale 0.02 } }
#local DustWrinkles = function { pattern { agate warp { turbulence 2 } scale 0.15 } }

#local WallTexture =
    texture
    {
        finish
        {
            ambient 0
            // brilliance 4
            specular 0.1
        }
        
        #ifdef (FAST_WALLS)
        
            normal { agate 1 turbulence 2 scale 0.05 }
            
        #end
        
        pigment
        {
            function { DustSpot (x, y, z) }
            color_map
            {
                [0.7 color rgb <0.89, 0.67, 0.55> * LightFactor]
                [1.0 color rgb <0.79, 0.59, 0.48> * 0.8 * LightFactor]
            }
        }
    }
    
    texture
    {
        pigment
        {
            bozo
            warp { turbulence 0.6 }
            color_map
            {
                [0.5 color rgb (<0.70, 0.51, 0.42> * LightFactor) transmit 1]
                [1.0 color rgb (<0.70, 0.51, 0.42> * 0.75 * LightFactor)]
            }
            scale 0.2
        }
    }
    
    texture
    {
        pigment
        {
            gradient y
            pigment_map
            {
                [0 DarkBandPigment ]
                [0.08 color rgb <0.20, 0.18, 0.15> * LightFactor transmit 1]
            }
        }
    }

    texture
    {
        pigment
        {
            gradient x
            pigment_map
            {
                [0 DarkBandPigment]
                [0.05 color rgb <0.20, 0.18, 0.15> * LightFactor transmit 1]
                [0.95 color rgb <0.20, 0.18, 0.15> * LightFactor transmit 1]
                [1.0 DarkBandPigment]
            }
        }
    }

// WallTexture ends here

#ifdef (FAST_WALLS)

    #local Wall = 
    box
    {
        <0, 0, 0>, <1, 1, 1>
        
        texture { WallTexture }
    }

#else

    #local Wall = 
    isosurface
    {
        function { - (z + 0.025 * DustSpot (x, y, z) + 0.05 * DustWrinkles (x, y, z)) }
        contained_by { box { <0, 0, -0.12>, <1, 1, 1> } }
        accuracy 0.02
        max_gradient 46.1
        
        texture { WallTexture }
    }

#end


/*         6
 *      +-----| 7 |------+
 *      |                |
 *      -                |
 *      9                |
 *   8  -                |
 *      |                |
 *      |                |
 *      |                |
 *      |  1             |
 *      +-----| 2 |------+
 *      |                |
 *      |                |
 *      -                |
 *      5                | 3
 *      _                |
 *      |                |
 * z 4  |                |
 * ^    |                |
 * |    |       10       |
 * |    +----------------+
 * |
 * +------> x
 *
 */
union
{
    difference
    {
        object // 1
        {
            Wall scale <12, WallHeight, 1> translate <-5, 0, 11>
        }
        
        box // 2
        {
            <-1, -2, 10>, <3, DoorHeight, 13>
        }

        texture
        {
            WallTexture
            scale <12, WallHeight, 1.0>
            translate <-4, 0, 0>
        }
    }
    
    box // 3
    {
        <16, -1, -10>, <17, WallHeight, 23>
        
        texture
        {
            WallTexture
            rotate 90*y
            scale <1.0, WallHeight, 30>
            translate <0, 0, -10>
        }
    }
    
    difference
    {
        object // 4
        {
            Wall rotate -90*y scale <1, WallHeight, 21.005> translate <-4, 0, -10>
        }
        
        box // 5
        {
            <-6, 2.5, 5>, <-3, 8, 9>
        }
        
        texture
        {
            WallTexture

            rotate -90*y
            scale <1.0, WallHeight, -21>
            translate <0, 0, -10>
        }
    }

    difference
    {    
        object // 6
        {
            Wall scale <12, WallHeight, 1> 
        }

        box // 7
        {
            <4, -2, -2>, <8, DoorHeight, 2>
        }
        
        texture
        {
            WallTexture
            // finish { ambient 0 diffuse 0.5 }
            scale <-12, WallHeight, 1.0>
            translate <-5, 0, 0>
        }
        translate <-5, 0, 22>
    }
    
    // Stone at the base of door #7    
    isosurface
    {
        function { y - 1 + pow(z,6) + 0.1*f_agate (x*5, y*5, z*5) }
        contained_by { box { <0, 0, -1>, <1, 1.1, 1> } }
        max_gradient 13.5
        
        scale <4, 0.1, 0.5>
        translate <-1, 0, 22.5>
        
        texture
        {
            pigment { color rgb 0.6 }
            finish { specular 0.7 roughness 0.3 }
        }
    }

    
    difference
    {
        box // 8
        {
            <-5, -1, 12>, <-4, WallHeight, 23>
        }

        box // 9
        {
            <-6, 2.5, 14>, <-3, 8, 19>
        }

        texture
        {
            WallTexture
            rotate 90*y
            scale <1.0, WallHeight, 8>
            translate <0, 0, -12>
        }
    }
    
    box // 10
    {
        <-4, -1, -1>, <16, WallHeight, -2>
        texture
        {
            WallTexture
            scale <20, WallHeight, 1.0>
            translate <-4, 0, 0>
        }
    }


    box // Roof
    {
        <-4, WallHeight, -2>, <16, WallHeight + 1, 23>

        texture
        {
            pigment
            {
                granite
                color_map
                {
                    [0 0.8 color rgb <214, 199, 149>/255 color rgb <214, 199, 149>/255]
                    [0.8 1.0 color rgb <0.7, 0.6, 0.4> color rgb <0.6, 0.5, 0.2>]
                }
                scale 0.06
            }
            
            normal
            {
                granite
                scale 0.06
            }

            scale <14, 1.0, 31>            
        }
    }
    
}
