#declare TrebMaterial =
material {
                  texture{T_Wood9 rotate <0,90,0> scale .55}
                  texture {
                           pigment {
                                     bozo scale .35         
                                     color_map {                    
                                                [0.0 color rgbt <0.36, 0.25, 0.20, 0.5> ]  
                                                [0.5 color rgbt <0.59, 0.41, 0.31, 0.5> ]  
                                                [1.0 color rgbt <0.00, 0.00, 0.00, 0.5> ] 
                                               }
                                   }
                          
                  #if (PreTrace = 0)
                       finish{ambient 0 
                             }
                  #else
                       finish {
                               ambient 0
                               diffuse 0.8 
                              }
                  #end
                  normal{wrinkles 8.0 scale .1}
                  } 
} 

#declare Water = material {
           texture {
             pigment { color rgbf <.8,.8,.8,.7>}    //<.8, .8, .8, .65> }
             finish {
               ambient 0.0
               diffuse 0.0
               reflection {
                            0.1, 1.0
                            fresnel on
                           }
               specular 0.4
               roughness 0.003
             }
           }
           interior {
             ior 1.3
           }
         }


#declare WoodFireMaterial =
material{
            texture{T_Wood9 rotate <0,90,0> scale .4}
            texture {
                     pigment {
                              crackle 
                              color_map {
                                         [0.0 color rgbt <.0, .0, .0, .0>]
                                         [0.3 color rgbt <.5, .5, .5, .0>]
                                         [0.3 color rgbt <.4, .0, .0, .0>]
                                         [0.8 color rgbt <.4, .0, .0, .0>]
                                         [1.0 color rgbt <.5, .5, .5, .0>]
                                        }
                             } scale .8
                    }         
       }

         
// Ground Texture   
#declare T_Snow=
texture {
  pigment {
    agate
    color_map {
      [0.0 color rgb <0.90, 0.90, 0.90> ]
      [0.5 color rgb <0.70, 0.70, 0.70> ]
      [1.0 color rgb <1.00, 1.00, 1.00> ]
    }
    scale 0.2
    warp { turbulence 0.5 }
  }
  #if (PreTrace = 0)
       finish{ambient 0
             }
  #else
       finish {ambient <0.8, 0.9 1.4>*0.35 //.6
               specular 0.2
               diffuse 0.8  //.4
              }
  #end
  normal {
    granite 0.4
    scale 0.5
  }
  scale 1/20 
}

#declare FireLog =
       box{<-18 * Feet,-1 * Feet,-1 * Feet> , <18 * Feet,1 * Feet,1 * Feet>
           material{WoodFireMaterial}
       #if (PreTrace = 0)
            finish{ambient 0 
                  }
       #else
            finish {
                    ambient .35
                    diffuse 0.1 
                   }
       #end
       normal{wrinkles 5.0 scale .3}
          }


#declare Plank1 =
       box{<-18 * Feet,-1 * Feet,-1 * Feet> , <18 * Feet,1 * Feet,1 * Feet>
            texture{T_Wood9 rotate <0,90,0> scale .4}
            texture {
                      pigment {
                                bozo scale .6         
                                color_map {
                                           [0.0 color rgbt <0.86, 0.58, 0.44, 0.5> ]  
                                           [0.3 color rgbt <0.59, 0.41, 0.31, 0.5> ]  
                                           [1.0 color rgbt <0.00, 0.00, 0.00, 0.5> ] 
                                          }
                              }
                     }
       #if (PreTrace = 0)
            finish{ambient 0 
                  }
       #else
            finish {
                    ambient 0
                    diffuse 0.8 
                   }
       #end
       normal{wrinkles 5.0 scale .3}
       }

#declare Plank2 =
       box{<-18 * Feet,-1 * Feet,-1 * Feet> , <18 * Feet,1 * Feet,1 * Feet>
            texture{T_Wood9 rotate <0,90,0> scale .5}
            texture {
                      pigment {
                                bozo scale .3         
                                color_map {
                                           [0.0 color rgbt <0.86, 0.58, 0.44, 0.5> ]  
                                           [0.3 color rgbt <0.59, 0.41, 0.31, 0.5> ]  
                                           [1.0 color rgbt <0.00, 0.00, 0.00, 0.5> ] 
                                          }
                              }
                     }
       #if (PreTrace = 0)
            finish{ambient 0 
                  }
       #else
            finish {
                    ambient 0
                    diffuse 0.8 
                   }
       #end
       normal{wrinkles 5.0 scale .3}
       }

#declare Plank3 =
       box{<-18 * Feet,-1 * Feet,-1 * Feet> , <18 * Feet,1 * Feet,1 * Feet>
            texture{T_Wood9 rotate <0,90,0> scale .45}
            texture {
                      pigment {
                                bozo scale .4         
                                color_map {
                                           [0.0 color rgbt <0.86, 0.58, 0.44, 0.5> ]  
                                           [0.3 color rgbt <0.59, 0.41, 0.31, 0.5> ]  
                                           [1.0 color rgbt <0.00, 0.00, 0.00, 0.5> ] 
                                          }
                              }
                     }
       #if (PreTrace = 0)
            finish{ambient 0 
                  }
       #else
            finish {
                    ambient 0
                    diffuse 0.8 
                   }
       #end
       normal{wrinkles 5.0 scale .3}
       }

#declare Plank4 =
       box{<-18 * Feet,-1 * Feet,-1 * Feet> , <18 * Feet,1 * Feet,1 * Feet>
            texture{T_Wood9 rotate <0,90,0> scale .55}
            texture {
                      pigment {
                                bozo scale .5         
                                color_map {
                                           [0.0 color rgbt <0.36, 0.25, 0.20, 0.5> ]  
                                           [0.3 color rgbt <0.59, 0.41, 0.31, 0.5> ]  
                                           [1.0 color rgbt <0.00, 0.00, 0.00, 0.5> ] 
                                          }
                              }
                     }
       #if (PreTrace = 0)
            finish{ambient 0 
                  }
       #else
            finish {
                    ambient 0
                    diffuse 0.8 
                   }
       #end
       normal{wrinkles 5.0 scale .3}
       }

#declare Arm =
      difference{
         box{<-30 * Feet,-1 * Feet,-1 * Feet> , <30 * Feet,1 * Feet,1 * Feet>
             material{ TrebMaterial }
         }
         box{<-28 * Feet,.1 * Feet,-1.1 * Feet> , <-32 * Feet,2 * Feet,1.1 * Feet> }
         cutaway_textures
      }
   
  
#declare Bucket = 
  merge{
  difference{
              box{<-4 * Feet,-3 * Feet, -4 * Feet> , <4 * Feet,4 * Feet, 4 * Feet>
                  material{ TrebMaterial }
              }
             
              box{<-3 * Feet,-2 * Feet, -3 * Feet> , <3 * Feet,5 * Feet, 3 * Feet>}
              cutaway_textures
            }
  
   prism {                                
           linear_sweep  // or conic_sweep for tapering to a point
           linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
           -0.3,         // height 1
           -0.1,         // height 2
            4,           // number of points
            // (--- the <u,v> points ---)
           < -4 * Feet,-4 * Feet>, < -4 * Feet,4 * Feet>, < 7 * Feet,0 * Feet>, < -4 * Feet,-4 * Feet>
            material{ TrebMaterial }
            rotate<90,0,90>
            translate<0 * Feet,8 * Feet,-2 * Feet>
    }
   prism {                                
           linear_sweep  // or conic_sweep for tapering to a point
           linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
            1.3,         // height 1
            1.5,         // height 2
            4,           // number of points
            // (--- the <u,v> points ---)
           < -4 * Feet,-4 * Feet>, < -4 * Feet,4 * Feet>, < 7 * Feet,0 * Feet>, < -4 * Feet,-4 * Feet>
            material{ TrebMaterial }
            rotate<90,0,90>
            translate<0 * Feet,8 * Feet,-2 * Feet>
    }
  }
   
                    
#declare Axle = 
       cylinder { <0 * Feet, 0 * Feet, -11 * Feet>, <0 * Feet, 0 * Feet, 11 * Feet>, .5 * Feet 
            texture{T_Wood4 rotate<0,0,90>}
                }

#declare TopBar = 
       cylinder { <0 * Feet, 0 * Feet, -9 * Feet>, <0 * Feet, 0 * Feet, 9 * Feet>, 0.7 * Feet 
            texture{T_Wood4 rotate<0,0,90>}
                }

#declare BucketSupport = 
       cylinder { <0 * Feet, 0 * Feet, -4 * Feet>, <0 * Feet, 0 * Feet, 4 * Feet>, 0.6 * Feet 
            texture{T_Wood4 rotate<0,0,90>}
                }
                
#declare Wheel =
       cylinder { <0 * Feet, 0 * Feet, -1 * Feet>, <0 * Feet, 0 * Feet, 1 * Feet>, 5 * Feet 
                 material{ TrebMaterial }
             }
             
#declare Rope1 =

sphere_sweep {
  //linear_spline                 // linear curve
  cubic_spline                // alternative spline curves
  //b_spline
  11,                            // number of specified sphere positions
  <  20  * Feet, 6.5 * Feet, -4 * Feet>, 0.9 * Feet                // position, radius
  <  12  * Feet, 6.5 * Feet, -4 * Feet>, 0.9 * Feet                // position, radius
  <   8  * Feet, 6.5 * Feet, -4 * Feet>, 0.9 * Feet                 // ...
  <   4  * Feet, 6.5 * Feet, -4 * Feet>, 0.9 * Feet
  < -21  * Feet, 8   * Feet, -2 * Feet>, 0.9 * Feet
  < -23  * Feet, 10.6 * Feet, 0 * Feet>, 0.9 * Feet
  < -21  * Feet, 8   * Feet,  2 * Feet>, 0.9 * Feet
  <   4  * Feet, 6.5 * Feet,  4 * Feet>, 0.9 * Feet
  <   8  * Feet, 6.5 * Feet,  4 * Feet>, 0.9 * Feet                 // ...
  <  12  * Feet, 6.5 * Feet,  4 * Feet>, 0.9 * Feet                // position, radius
  <  20  * Feet, 6.5 * Feet,  4 * Feet>, 0.9 * Feet                // position, radius
  tolerance 0.001             // optional 
  pigment{spiral2 3 scale .7} 
}


#declare Rope2 =

#merge {
sphere_sweep {
  cubic_spline                // alternative spline curves
  9,                            // number of specified sphere positions
  < -65  * Feet, 15 * Feet, -4 * Feet>, 0.9 * Feet                // position, radius
  < -59  * Feet, 18  * Feet, -4 * Feet>, 0.9 * Feet                 // ...
  < -55  * Feet, 25  * Feet, -4 * Feet>, 0.9 * Feet
  < -45  * Feet, 35  * Feet, -2 * Feet>, 0.8 * Feet
  < -35  * Feet, 39  * Feet,  0 * Feet>, 0.7 * Feet
  < -45  * Feet, 35  * Feet,  2 * Feet>, 0.8 * Feet
  < -55  * Feet, 25  * Feet,  4 * Feet>, 0.9 * Feet
  < -59  * Feet, 18  * Feet,  4 * Feet>, 0.9 * Feet                 // ...
  < -65  * Feet, 15 * Feet,  4 * Feet>, 0.9 * Feet                // position, radius
  tolerance 0.001             // optional 
  pigment{spiral2 1 scale .7} 
}

cylinder {
  <-55 * Feet,  16 * Feet, 4.5 * Feet> , <-54 * Feet, 25 * Feet, 4.5 * Feet> 1 * Feet 
  pigment{spiral2 1 scale .7} 
}
cylinder {
  <-63 * Feet,  20 * Feet, 4 * Feet> , <-54 * Feet, 25 * Feet, 4.5 * Feet> 1 * Feet 
  pigment{spiral2 1 scale .7} 
}

}


#declare Trebuchet1 = 
merge{
//      Base 
        #object{Plank1 translate<0 * Feet,5 * Feet,-6 * Feet>}
        #object{Plank2 translate<0 * Feet,5 * Feet,-3 * Feet>}
        #object{Plank3 translate<0 * Feet,5 * Feet, 0.0 * Feet>}
        #object{Plank4 translate<0 * Feet,5 * Feet, 3 * Feet>}
        #object{Plank1 translate<0 * Feet,5 * Feet, 6 * Feet>}
//      Axles
        #object{Axle translate<  12 * Feet, 5 * Feet,0 * Feet>}
        #object{Axle translate< -12 * Feet, 5 * Feet,0 * Feet>}
        #object{TopBar translate< 0 * Feet,43 * Feet,0 * Feet>}
        #object{BucketSupport translate< 8 * Feet,54.5 * Feet,0 * Feet>}
//      Wheels
        #object{Wheel rotate<0,0,30> translate<  12 * Feet,5 * Feet, 9 * Feet>}
        #object{Wheel translate< -12 * Feet,5 * Feet,-9 * Feet>}                        
        #object{Wheel rotate<0,0,70> translate<  12 * Feet,5 * Feet,-9 * Feet>}
        #object{Wheel rotate<0,0,200> translate< -12 * Feet,5 * Feet, 9 * Feet>} 
//      Angled Supports
        #object{Plank1 scale <1.2,1,.8> rotate<0,0, 68> translate<-8 * Feet,25 * Feet,-6 * Feet>}
        #object{Plank3 scale <1.2,1,.8> rotate<0,0,-68> translate<8 * Feet,25 * Feet,-6 * Feet>}
        #object{Plank2 scale <1.2,1,.8> rotate<0,0, 68> translate<-8 * Feet,25 * Feet, 6 * Feet>}
        #object{Plank4 scale <1.2,1,.8> rotate<0,0,-68> translate<8 * Feet,25 * Feet, 6 * Feet>}
//      Vertical Supports 
        #object{Plank1 scale <1.1,1,.8> rotate<0,0, 90> translate<0 * Feet,23.5 * Feet,-6 * Feet>}
        #object{Plank4 scale <1.1,1,.8> rotate<0,0, 90> translate<0 * Feet,23.5 * Feet, 6 * Feet>}
//      Horizontal Supports 
        #object{Plank1 scale <.4,1,.8> translate<0 * Feet,25 * Feet,-5.99 * Feet>}
        #object{Plank4 scale <.4,1,.8> translate<0 * Feet,25 * Feet, 6.01 * Feet>}
//      Arm
        #object{Arm rotate<0,0,55> translate<-7 * Feet,33 * Feet,0 * Feet>} 
//      Bucket
        #object{Bucket translate<8 * Feet, 43 * Feet,0 * Feet>}
//      Rope 
        #object{Rope1 translate<0 * Feet, 0 * Feet,0 * Feet>}

}                                                                 
#declare Trebuchet2 = 
merge{
//      Base     
        #object{Plank1 translate<0 * Feet,5 * Feet,-6 * Feet>}
        #object{Plank2 translate<0 * Feet,5 * Feet,-3 * Feet>}
        #object{Plank3 translate<0 * Feet,5 * Feet, 0.0 * Feet>}
        #object{Plank4 translate<0 * Feet,5 * Feet, 3 * Feet>}
        #object{Plank1 translate<0 * Feet,5 * Feet, 6 * Feet>}
//      Axles
        #object{Axle translate<  12 * Feet, 5 * Feet,0 * Feet>}
        #object{Axle translate< -12 * Feet, 5 * Feet,0 * Feet>}
        #object{TopBar translate< 0 * Feet,43 * Feet,0 * Feet>}
        #object{BucketSupport translate< 19 * Feet,32 * Feet,0 * Feet>}
//      Wheels
        #object{Wheel rotate<0,0,30> translate<  12 * Feet,5 * Feet, 9 * Feet>}
        #object{Wheel translate< -12 * Feet,5 * Feet,-9 * Feet>}                        
        #object{Wheel rotate<0,0,70> translate<  12 * Feet,5 * Feet,-9 * Feet>}
        #object{Wheel rotate<0,0,200> translate< -12 * Feet,5 * Feet, 9 * Feet>} 
//      Angled Supports
        #object{Plank1 scale <1.2,1,.8> rotate<0,0, 68> translate<-8 * Feet,25 * Feet,-6 * Feet>}
        #object{Plank3 scale <1.2,1,.8> rotate<0,0,-68> translate<8 * Feet,25 * Feet,-6 * Feet>}
        #object{Plank2 scale <1.2,1,.8> rotate<0,0, 68> translate<-8 * Feet,25 * Feet, 6 * Feet>}
        #object{Plank4 scale <1.2,1,.8> rotate<0,0,-68> translate<8 * Feet,25 * Feet, 6 * Feet>}
//      Vertical Supports 
        #object{Plank1 scale <1.1,1,.8> rotate<0,0, 90> translate<0 * Feet,23.5 * Feet,-6 * Feet>}
        #object{Plank4 scale <1.1,1,.8> rotate<0,0, 90> translate<0 * Feet,23.5 * Feet, 6 * Feet>}
//      Horizontal Supports 
        #object{Plank1 scale <.4,1,.8> translate<0 * Feet,25 * Feet,-5.99 * Feet>}
        #object{Plank4 scale <.4,1,.8> translate<0 * Feet,25 * Feet, 6.01 * Feet>}
//      Arm
        #object{Arm rotate<0,0,10> translate<-7 * Feet,43 * Feet,0 * Feet>} 
//      Bucket
        #object{Bucket translate<19 * Feet, 32 * Feet,0 * Feet>}
//      Rope 
        #object{Rope2 translate<0 * Feet, 0 * Feet,0 * Feet>}

}                                                                 

#declare Fire1 =
union {
        #object{FireLog                translate<-18 * Feet,1 * Feet,-18 * Feet>}
        #object{FireLog                translate<-18 * Feet,1 * Feet, 18 * Feet>}
        #object{FireLog                translate<-18 * Feet,1 * Feet, -6 * Feet>}
        #object{FireLog                translate<-18 * Feet,1 * Feet,  6 * Feet>}

        #object{FireLog rotate<0,90,0> translate<  0 * Feet,1 * Feet,  0 * Feet>}
        #object{FireLog rotate<0,90,0> translate<-36 * Feet,1 * Feet,  0 * Feet>}
        #object{FireLog rotate<0,90,0> translate<-12 * Feet,1 * Feet,  0 * Feet>}
        #object{FireLog rotate<0,90,0> translate<-24 * Feet,1 * Feet,  0 * Feet>}

        #object{FireLog scale <2,1,1> rotate< -135,   0, 135> translate<  0 * Feet,1 * Feet,   0* Feet>}
        #object{FireLog scale <2,1,1> rotate<   90,   0,  45> translate<-36 * Feet,1 * Feet,   0 * Feet>}        
        #object{FireLog scale <2,1,1> rotate<    0,  45,  90> translate<-18 * Feet,1 * Feet,  18 * Feet>}
        #object{FireLog scale <2,1,1> rotate<    0, -45,  90> translate<-18 * Feet,1 * Feet, -18 * Feet>}
        
        #object{FireLog scale <2,1,1> rotate<-45, 45,-45> translate<  0 * Feet,1 * Feet,  -18 * Feet>}
        #object{FireLog scale <2,1,1> rotate<  0,-45, 45> translate<-36 * Feet,1 * Feet,  -18 * Feet>}        
        #object{FireLog scale <2,1,1> rotate<  0, 45, 45> translate<-36 * Feet,1 * Feet,   18 * Feet>}
        #object{FireLog scale <2,1,1> rotate<-45,-45,-45> translate<  0 * Feet,1 * Feet,   18 * Feet>}

// Fire Light Sources
        light_source {
        0*x                  // light's position (translated below)
        color rgb <1,.25,0> * 0.8    // light's color
//        area_light <2, 0, 0>, <0, 2, 0>, 2, 2
//        adaptive 1
//        jitter
        fade_distance 12  //12 -> 20
        fade_power 2
        translate <0 * Feet, 3 * Feet, -9 * Feet>
        }  

        //Fire media box
        #declare RadiusVal   = 8.0; // (0 < RadiusVal) outer sphere of influence on other components
        #declare StrengthVal = 10.0; // (+ or -) strength of component's radiating density

        blob {
            // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
            threshold .3
            sphere { < -25 * Feet,   6 * Feet,      5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { <  -8 * Feet,   6 * Feet,     -5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -25 * Feet,   6 * Feet,     -5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { <  -8 * Feet,   6 * Feet,      5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -18 * Feet,   6 * Feet,      0 * Feet>, 12 * Feet, StrengthVal }
            texture{pigment{color rgbt <1,1,1,1>}}
            hollow on    
            interior {
               media {
//                   emission .2
                   scattering {1, rgb <1,.25,0> extinction 1.0}
                   intervals 1
                   samples 5
                   method 3
                   density {
                            bozo scale .5           
                            turbulence 1 omega .7    
                            color_map {
                                       [0.0 color rgb <0, 0, 0>]
                                       [0.5 color rgb <.1, .1, .1>]
                                       [1.0 color rgb < 1, 1, 1>]
                                      }
                            }
               } //end media
           } //end interior 
           scale 1
        } 

        blob {
            // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
            threshold .5
            sphere { < -20 * Feet,   8 * Feet,      5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -10 * Feet,   8 * Feet,     -5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -20 * Feet,   8 * Feet,     -5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -10 * Feet,   8 * Feet,      5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -18 * Feet,   8 * Feet,      0 * Feet>, 12 * Feet, StrengthVal }
            texture{pigment{color rgbt <1,1,1,1>}}
            hollow on    
            interior {
               media {
                   emission .2
//                   scattering {1, rgb <1,.25,0> extinction 1.0}
                   intervals 1
                   samples 5
                   method 3
                   density {
                            marble            
                            turbulence .5 omega .7    
                            color_map {
                                       [0.0 color rgb <0, 0, 0>]
                                       [0.5 color rgb <.1, .1, .1>]
                                       [1.0 color rgb < 1, 1, 1>]
                                      }
                            }
                  scale 1
               } //end media
           } //end interior 
        }  
        scale .5 
} 

#declare Fire2 =
union {
        #object{FireLog                translate<-18 * Feet,1 * Feet,-18 * Feet>}
        #object{FireLog                translate<-18 * Feet,1 * Feet, 18 * Feet>}
        #object{FireLog                translate<-18 * Feet,1 * Feet, -6 * Feet>}
        #object{FireLog                translate<-18 * Feet,1 * Feet,  6 * Feet>}

        #object{FireLog rotate<0,90,0> translate<  0 * Feet,1 * Feet,  0 * Feet>}
        #object{FireLog rotate<0,90,0> translate<-36 * Feet,1 * Feet,  0 * Feet>}
        #object{FireLog rotate<0,90,0> translate<-12 * Feet,1 * Feet,  0 * Feet>}
        #object{FireLog rotate<0,90,0> translate<-24 * Feet,1 * Feet,  0 * Feet>}

        #object{FireLog scale <2,1,1> rotate< -135,   0, 135> translate<  0 * Feet,1 * Feet,   0* Feet>}
        #object{FireLog scale <2,1,1> rotate<   90,   0,  45> translate<-36 * Feet,1 * Feet,   0 * Feet>}        
        #object{FireLog scale <2,1,1> rotate<    0,  45,  90> translate<-18 * Feet,1 * Feet,  18 * Feet>}
        #object{FireLog scale <2,1,1> rotate<    0, -45,  90> translate<-18 * Feet,1 * Feet, -18 * Feet>}
        
        #object{FireLog scale <2,1,1> rotate<-45, 45,-45> translate<  0 * Feet,1 * Feet,  -18 * Feet>}
        #object{FireLog scale <2,1,1> rotate<  0,-45, 45> translate<-36 * Feet,1 * Feet,  -18 * Feet>}        
        #object{FireLog scale <2,1,1> rotate<  0, 45, 45> translate<-36 * Feet,1 * Feet,   18 * Feet>}
        #object{FireLog scale <2,1,1> rotate<-45,-45,-45> translate<  0 * Feet,1 * Feet,   18 * Feet>}

// Fire Light Sources
        light_source {
        0*x                  // light's position (translated below)
        color rgb <1,.25,0>    // light's color
        area_light <3, 0, 0>, <0, 3, 0>, 3, 3
        adaptive 1
        jitter
        fade_distance 12  //12 -> 20
        fade_power 2
        translate <0 * Feet, 3 * Feet, -9 * Feet>
        }  

        //Fire media box
        #declare RadiusVal   = 8.0; // (0 < RadiusVal) outer sphere of influence on other components
        #declare StrengthVal = 10.0; // (+ or -) strength of component's radiating density
        blob {
            // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
            threshold .3
            sphere { < -25 * Feet,   6 * Feet,      5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { <  -8 * Feet,   6 * Feet,     -5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -25 * Feet,   6 * Feet,     -5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { <  -8 * Feet,   6 * Feet,      5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -18 * Feet,   6 * Feet,      0 * Feet>, 12 * Feet, StrengthVal }
            texture{pigment{color rgbt <1,1,1,1>}}
            hollow on    
            interior {
               media {
//                   emission .2
                   scattering {1, rgb <1,.25,0> extinction 1.0}
                   intervals 1
                   samples 5
                   method 3
                   density {
                            bozo scale .5           
                            turbulence 1 omega .7    
                            color_map {
                                       [0.0 color rgb <0, 0, 0>]
                                       [0.5 color rgb <.1, .1, .1>]
                                       [1.0 color rgb < 1, 1, 1>]
                                      }
                            }
               } //end media
           } //end interior 
           scale 1
        } 

        blob {
            // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
            threshold .5
            sphere { < -20 * Feet,   8 * Feet,      5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -10 * Feet,   8 * Feet,     -5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -20 * Feet,   8 * Feet,     -5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -10 * Feet,   8 * Feet,      5 * Feet>, RadiusVal * Feet, StrengthVal }
            sphere { < -18 * Feet,   8 * Feet,      0 * Feet>, 12 * Feet, StrengthVal }
            texture{pigment{color rgbt <1,1,1,1>}}
            hollow on    
            interior {
               media {
                   emission .2
//                   scattering {1, rgb <1,.25,0> extinction 1.0}
                   intervals 1
                   samples 5
                   method 3
                   density {
                            marble            
                            turbulence .5 omega .7    
                            color_map {
                                       [0.0 color rgb <0, 0, 0>]
                                       [0.5 color rgb <.1, .1, .1>]
                                       [1.0 color rgb < 1, 1, 1>]
                                      }
                            }
                  scale 1
               } //end media
           } //end interior 
        }
        scale .5 
} 

#declare RGrass=
       sphere_sweep {
       b_spline
       5,
       <  0.0,  0.0, 0>,0.2  
       <  0.2,  0.2, 0>,0.4
       <  0.4,  0.4, 0>,0.6
       <  0.6,  0.6, 0>,0.8
       <  0.8,  0.8, 0>,1.0
       tolerance .000001
         texture{ pigment{ bozo scale 1   //30
                           color_map{
                                     [0.0 rgb <  .36,  .25,  .20,>]
                                     [0.1 rgb <  .36,  .25,  .20,>]
                                     [0.1 rgb <  .13,  .31,  .31,>]
                                     [0.2 rgb <  .13,  .31,  .31,>]
                                     [0.2 rgb <  .85,  .85,  .43,>]
                                     [1.0 rgb <  .85,  .85,  .43,>] 
                                    }
                          }
                  normal {bozo scale .5}
                } 
         texture{ pigment{ crackle scale 1
                           color_map{
                                     [0.0 rgbf <  .36,  .25,  .20, .6>]
                                     [0.2 rgbf <  .36,  .25,  .20, .6>]
                                     [0.2 rgbf <  .31,  .31,  .18, .6>]
                                     [0.3 rgbf <  .31,  .31,  .18, .6>]
                                     [0.3 rgbf <  .85,  .85,  .43, .6>]
                                     [1.0 rgbf <  .85,  .85,  .43, .6>]
                                    } warp{turbulence .5}
                          } 
                 normal {crackle scale .5 }
                } 
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient 0  diffuse .2 }
        #end 
        double_illuminate 
        no_shadow
       }

// Draw Grass

#macro Draw_Grass(Scale)
   #declare Reed = #object{RGrass
                 scale <Scale/13, Scale, Scale/13> 
                 }

      #declare N = 0; 

      #while (N<1500)    
                
         #object{Reed 
                 scale <1, 1 + rand(R1) * 2, 1>
                 rotate x*(rand(R1) * 30) 
                 rotate y*(rand(R1) * 360)
                 rotate z*(rand(R1) * 30)  
                 translate <(-10 + (rand(R1) * 490)) * Feet, (-7 - (2*rand(R1))) * Feet,(-28 - (20 * rand(R1))) * Feet>
                 }
         #object{Reed 
                 scale <1, 1 + rand(R1) * 2, 1>
                 rotate x*(rand(R1) * 30) 
                 rotate y*(rand(R1) * 360)
                 rotate z*(rand(R1) * 30)  
                 translate <(-10 + (rand(R1) * 490)) * Feet, (-7 - (2*rand(R1))) * Feet,(28 + (20 * rand(R1))) * Feet>
                 }
         #object{Reed 
                 scale <1, 1 + rand(R1) * 2, 1>
                 rotate x*(rand(R1) * 30) 
                 rotate y*(rand(R1) * 360)
                 rotate z*(rand(R1) * 30)  
                 translate <(490 + (rand(R1) * 20)) * Feet, -7 * Feet,(-50 + (200 * rand(R1))) * Feet>
                 }
         #object{Reed 
                 scale <1, 1 + rand(R1) * 2, 1>
                 rotate x*(rand(R1) * 30) 
                 rotate y*(rand(R1) * 360)
                 rotate z*(rand(R1) * 30)  
                 translate <(-10 + (rand(R1) * 800)) * Feet, -8 * Feet,(-28 - (500 * rand(R1))) * Feet> //450 -> 800
                 }
         #declare N = N + 1; 
      #end // wile n
#end

#macro Draw_Stars(Scale)      
// Stars
   #declare N = 0;
   #declare R1 = seed(43247);
   #while (N<65)    

      sphere{<2500,rand(R1) * 500, (200 - (rand(R1) * 1700))> 2.0
              #declare Color = rand(R1);
              #if(Color <= .2) 
                   pigment{color rgb< .6, .6 , 1> } 
                   #else #if ((Color>.2) & (Color <= .4))
                       pigment{color rgb< 1.0 , 1.0 , 0.4> }
                       #else #if ((Color>.4) & (Color <= .6))
                            pigment{color rgb< 1.0 , 0.6 , 0.6> }
                            #else #if ((Color>.6) & (Color <= .8))
                                 pigment{color rgb< 0.5 , 0.5 , 0.5> }
                                 #else
                                      pigment{color rgb<1,1,1> }
                            #end
                       #end
                  #end
              #end              
              finish{ambient 1 diffuse 1}
            }
      #declare N = N + 1;      
   #end
#end 

#macro Draw_Moon(Scale)   
// Moon
   sphere{ <0,0,0> 17  //15
           texture{pigment{color rgb<1,0,0>}}
           texture{
                    pigment{
                    image_map{ png "moon.png"   
                               map_type 1
                               interpolate 2
                               filter all .99
                             }
                    }
           } 
           finish{ambient .8 diffuse 1} 
           rotate <-20,-10,0>  //35
           translate Moon_Pos 
          } 
#end

#macro Draw_Rocks(Scale)
#declare T_Rock=
texture {
  pigment {
    crackle metric 1 form<0.8,0,0>
    color_map {
      [0.2 color rgb <0.55, 0.50, 0.50> ]
      [0.6 color rgb <0.75, 0.50, 0.60> ]
      [1.0 color rgb <0.70, 0.60, 0.60> ]
    }
    scale 20
    warp { turbulence 0.5 }
  }
  #if (PreTrace = 0)
       finish{ambient 0 
             }
  #else
       finish {ambient <0.8, 0.9, 1.4>*0.35
               diffuse 0.8
              }
  #end

  normal {
    granite 0.6
    scale 10 //0.1
  }
  scale 1/7
} 


   #declare Rock = superellipsoid { <0.5, 0.7> 
                   texture{T_Rock}
/*                   #if (PreTrace = 0)
                       finish{0
                             }
                   #else
                       finish {ambient <0.8, 0.9, 1.4>*.35
                               diffuse .4
                              }
                   #end */
//                 double_illuminate
         }
         
   #object{Rock scale<4 * Feet, 3.3 * Feet, 5 * Feet> 
                rotate<0,0,0> 
                translate<100 * Feet,4 * Feet,-66 * Feet>} //65    
   #object{Rock scale<4 * Feet, 3 * Feet, 5 * Feet> 
                rotate<40,0,0> 
                translate<350 * Feet,18 * Feet,-118 * Feet>} 
                    
#end
   
#macro Draw_Arrows(Scale)

#declare Arrow = 
#merge {

   cylinder{<0 * Feet,0 * Feet,-3 * Feet>,<0 * Feet,0 * Feet,3 * Feet>, 0.3 * Feet
             material{TrebMaterial scale .1}
             finish{ambient .2}
   }


     triangle {
                <0 * Feet, 1 * Feet,-3 * Feet>,  // <Vertex1>
                <0 * Feet, 0 * Feet,-4 * Feet>,  // <Vertex2>
                <0 * Feet,-1 * Feet,-3 * Feet>   // <Vertex3>
                pigment{color Bronze2}
                finish{ambient .2}
     }

     polygon {
                4, // number of points
                <-3 * Feet,0.3 * Feet>,
                <-1 * Feet,0.3 * Feet>, 
                <-2 * Feet,1.3 * Feet>, 
                <-4 * Feet,1.3 * Feet>
//                <-3 * Feet,0.3 * Feet>,
                pigment{color Bronze2}
                finish{ambient .2}
                rotate<0,90,0>
     }
     polygon {
                4, // number of points
                <-3 * Feet,-0.3 * Feet>,
                <-1 * Feet,-0.3 * Feet>, 
                <-2 * Feet,-1.3 * Feet>, 
                <-4 * Feet,-1.3 * Feet>
//                <-3 * Feet,-0.3 * Feet>,
                pigment{color Bronze2}
                finish{ambient .2}
                rotate<0,90,0>
     }
     no_shadow
}

   #declare R1 = seed(4737);

   #declare N = 0;
   #while (N<100)
      #declare X =  (rand(R1) * 350);
      #declare Z =   - (rand(R1) * 150);
      #declare Y =  (0.9 * Z) + 30;   
      #object{Arrow rotate<-45,0,0> translate<X,Y,Z>}
      #declare N = N + 1;      
   #end   


#end 

#macro Draw_Man(Scale)   
// Man
   box{<0,0,0>,<1,1,1> 
           texture{pigment{rgbt <1,1,1,1>}}
           texture{
                    pigment{
                    image_map{ gif "horseman1.gif"
                               filter 0,1
                               map_type 0
                               interpolate 2
                               once
                             }
                    }
           } 
           finish{ambient .25} 
           scale <15*Feet,20 * Feet,.1 * Feet>  //15,20,.1
           rotate<0,115,0> //100
           translate <70 * Feet, -3 * Feet, -60 * Feet>  //70,-3,-60
          } 
   box{<0,0,0>,<1,1,1> 
           texture{pigment{rgbt <1,1,1,1>}}
           texture{
                    pigment{
                    image_map{ gif "soldier1.gif"
                               filter 0,1
                               map_type 0
                               interpolate 2
                               once
                             }
                    }
           } 
           scale <10*Feet,15 * Feet,.1 * Feet>  //15,20,.1
           rotate<0,115,0> //100
           translate <350 * Feet, -3 * Feet, -81 * Feet>  
          } 
   box{<0,0,0>,<1,1,1> 
           texture{pigment{rgbt <1,1,1,1>}}
           texture{
                    pigment{
                    image_map{ gif "soldier1.gif"
                               filter 0,1
                               map_type 0
                               interpolate 2
                               once
                             }
                    }
           } 
           scale <10*Feet,15 * Feet,.1 * Feet>  //15,20,.1
           rotate<0,115,0> //100
           translate <210 * Feet, -3 * Feet, -82 * Feet>  
          } 

#end 

#macro Draw_Bushes(Scale)

#declare Bushes2 = 
merge{
   #local N5 = 0; 
   #declare Scale = 7;

   #while (N5<70)
      #object{RGrass 
              scale <Scale/10, Scale, Scale/10> 
              rotate x*(rand(R1) * 90) 
              rotate y*(rand(R1) * 360)
              rotate z*(rand(R1) * 90)  
              translate <0,rand(R1) * 10,0>
              } 
      #local N5=N5+1;
   #end
}

   #declare R1 = seed(33456);  

   #local N4 = 0; 

   #while (N4<15)
      #object {Bushes2
               translate <(700 + (rand(R1) * 1000)) * Feet, 
                          - 3 * Feet,
                          -25 - (rand(R1) * 800) * Feet>
               scale <1, .4 ,1 >
      }         
      #local N4=N4+1;
   #end   


#end