//=========================================
// Straight wall and round wall macro for Pov-ray 3.1 & higher
// (c) 1999  tran@inapg.inra.fr
//-----------------------------------------
// This file contains 2 macros to build stone & brick walls
//
// The brick can be a box or an ellipsoid
// These macros make quite simplistic walls
// You may need to modify them, particularly the texture part
//-----------------------------------------
#macro MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
// MakeWall : creates a brick wall in the x-y plane, starting at <0,0,0>
// of length xWall and height yWall
/*
#declare typeWall=1;            // 1=box ; 2=ellipsoid
#declare pEllipsoid=0.1;        // usual ellipsoid parameter
#declare xWall=50;             // wall length in x
#declare yWall=20;              // wall height in y
#declare eMortar=0.3;           // mortar thickness
#declare eWall=-0.9;             // mortar depth
#declare xBrickMin=1.2;             // min brick length
#declare xBrickMax=3;             // max brick length
#declare yBrickMin=0.5;             // min brick height
#declare yBrickMax=1.7;             // max brick height
#declare seedWall=200;              // seed wall
#declare srd1=0.3;                  // randomness amount for brick position (0=no random)
#declare srd2=0.3;                  // randomness amount for brick rotation (0=no random)
#declare srdcol=0.6;                // randomness amount for color (0=no random)
#declare patternWall=1;             // y color gradient for wall texture
                                    // 0=uniform color (no texture)
                                    // 1=no color gradient
                                    // 2=from dark to light (up)
                                    // 3=from light to dark (down)
                                    // note : the mortar has no gradient

#declare pigWall=rgb<0.89,0.9,0.95>*1.2;    // wall main color
#declare txtMortar=texture{pigment{rgb<0.89,0.9,0.95>*1.6}} // mortar texture
*/
//-----------------------------------------
        #local R1=seed(seedWall);                        
        #switch (typeWall)
                #case (1)                     
                        #local Brick=box{-1,1}
                #break                        
                #case (2)
                        #local Brick=superellipsoid{<pEllipsoid,pEllipsoid>}
                #break                        
        #end                
        union{                       
                box{0,<xWall,yWall,1> 
                texture{txtMortar}
                finish{ambient 0.01 specular 0.1 roughness 0.05}  
                translate eWall*z
                }
                union{
                #local yFlag=0;       
                #local yMax=0;
                #local yPos=(yBrickMin+yBrickMax)*0.5+eMortar;   
                #local yBrick=0;
                #local nRow=0;
                #while (yPos<=yWall)
                #local nRow=nRow+1;
                #warning concat("row ",str(nRow,0,0),"\n")
                #if (yFlag=0)
                        #local xPos=0;
                #else
                        #local xPos=0.0001;
                #end
                        #while (xPos<=xWall)
                                #switch (patternWall)
                                        #case (1) // no gradient
                                                #local spatternWall=1;
                                                #break            
                                        #case (2) // gradient y up
                                                #local spatternWall=(yPos+0.2)/(yWall-0.2);
                                                #break            
                                        #case (3) // gradient y down
                                                #local spatternWall=1-((yPos+0.2)/(yWall-0.2));
                                                #break                               
                                #end
                                #local txtBrick=texture{
                                        pigment{
                                                #if (patternWall>0)
                                                        crackle // replace if necessary
                                                        turbulence 0.5
                                                        color_map{
                                                                [0 color pigWall*(0.5+(1+srdcol*rand(R1)))*0.5*spatternWall]
                                                                [1 color pigWall*(0.5+(1+srdcol*rand(R1)))*spatternWall]
                                                        }
                                                #else
                                                        color pigWall   // uniform color
                                                #end
                                                
                                        }                          
                                                
                                        // add normal if necessary
                                        finish{ambient 0.01 specular 0.1 roughness 0.05}
                                        scale xBrickMax*0.1 
                                        translate xPos+yPos
                                }
                                #local xBrick=(xBrickMin+xBrickMax)*0.5*(rand(R1)*srd1+1);
                                #local xBrick=max(min(xBrick,xBrickMax),xBrickMin);  
                                #if (xPos+2*xBrick>xWall)
                                        #local xBrick=(xWall-xPos)*0.5;
                                #end
                                #local yBrick=(yBrickMin+yBrickMax)*0.5*(rand(R1)*srd1+1);
                                #local yBrick=max(min(yBrick,yBrickMax),yBrickMin);
                                #local rBrick=<rand(R1)-0.5,rand(R1)-0.5,0>*20*srd2;
                                #if (yFlag=0 & xPos=0) 
                                        #local xPos=xBrick*0.5;
                                        object{Brick rotate rBrick scale <xBrick*0.5,yBrick+eMortar*(rand(R1)-0.5)*srd1*0.5,1> translate <xPos,yPos,0> texture{txtBrick}}
                                        #local xPos=xPos+xBrick*0.5 + eMortar*(1+rand(R1)*srd1);
                                #else  
                                        #local xPos=xPos+xBrick;
                                        object{Brick rotate rBrick scale <xBrick,yBrick + eMortar*(rand(R1)-0.5)*srd1*0.5,1> translate <xPos,yPos,0> texture{txtBrick}}
                                        #local xPos=xPos+xBrick + eMortar*(1+rand(R1)*srd1);
                                #end
                        #end    
                        #if (yPos+yBrick>yMax)
                                #local yMax=yPos+yBrick;
                        #end
                        #local yPos=yPos+(yBrickMin+yBrickMax)+eMortar*(1+rand(R1)*srd1);
                        #if (yFlag=0) #local yFlag=1; #else #local yFlag=0; #end
                #end                   
                scale <1,yWall/yMax,1>
                }

                
        }
#end
//-----------------------------------------
// MakeRoundWall macro
// MakeRoundWall : creates a round wall of radius rWall and height yWall, centered on <0,0,0>
// the wall goes from -tetaWall/2 to tetaWall/2
//-----------------------------------------
#macro MakeRoundWall(typeWall,pEllipsoid,tetaWall,yWall,rWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
//-----------------------------------------
/*
#declare tetaWall=90;              // angle (360 = round tower)
#declare rWall=20;                 // radius
*/
//-----------------------------------------

        #local R1=seed(seedWall);                        
        #local xWall=rWall*radians(tetaWall);
        #switch (typeWall)
                #case (1)                     
                        #local Brick=box{-1,1}
                #break                        
                #case (2)
                        #local Brick=superellipsoid{<pEllipsoid,pEllipsoid>}
                #break                        
        #end                
        union{                       
                cylinder{0,yWall*y,rWall-eWall 
                texture{txtMortar} 
                finish{ambient 0.01 specular 0.1 roughness 0.05} 
                }
                union{
                #local yFlag=0;       
                #local yMax=0;
                #local yPos=(yBrickMin+yBrickMax)*0.5+eMortar;   
                #local yBrick=0;
                #local nRow=0;
                #while (yPos<=yWall)
                #local nRow=nRow+1;
                #warning concat("row ",str(nRow,0,0),"\n")
                #if (yFlag=0)
                        #local xPos=0;
                #else
                        #local xPos=0.0001;
                #end
                
                
                        #while (xPos<=xWall)
                                #switch (patternWall)
                                #case (1) // rpartition gale
                                        #local spatternWall=1;
                                        #break            
                                #case (2) // gradient y croissant
                                        #local spatternWall=(yPos+0.2)/(yWall-0.2);
                                        #break            
                                #case (3) // gradient y dcroissant
                                        #local spatternWall=1-((yPos+0.2)/(yWall-0.2));
                                        #break            
                                #end
                                #local txtBrick=texture{
                                        pigment{
                                                #if (patternWall>0)
                                                        crackle // replace if necessary
                                                        turbulence 0.5
                                                        color_map{
                                                                [0 color pigWall*(0.5+(1+srdcol*rand(R1)))*0.5*spatternWall]
                                                                [1 color pigWall*(0.5+(1+srdcol*rand(R1)))*spatternWall]
                                                        }
                                                #else
                                                        color pigWall
                                                #end
                                                
                                        }                          
                                                
                                        // add normal if necessary
                                        finish{ambient 0.01 specular 0.1 roughness 0.05} 
                                        scale xBrickMax*0.1 
                                        translate xPos+yPos
                                }
                                #local xBrick=(xBrickMin+xBrickMax)*0.5*(rand(R1)*srd1+1);
//                                #local xBrick=max(min(xBrick,xBrickMax),xBrickMin);  
                                #if (xPos+2*xBrick>xWall)
                                        #local xBrick=(xWall-xPos)*0.5;
                                #end
                                #local yBrick=(yBrickMin+yBrickMax)*0.5*(rand(R1)*srd1+1);
                                #local yBrick=max(min(yBrick,yBrickMax),yBrickMin);
                                #local rBrick=<rand(R1)-0.5,rand(R1)-0.5,0>*20*srd2;
                                #if (yFlag=0 & xPos=0) 
                                        #local xPos=xBrick*0.5;
                                        object{Brick rotate rBrick scale <xBrick*0.5,yBrick+eMortar*(rand(R1)-0.5)*srd1*0.5,1>
                                        translate y*yPos
                                        translate -z*rWall
                                        rotate -y*degrees(xPos/rWall)
                                        texture{txtBrick}
                                        }
                                        #local xPos=xPos+xBrick*0.5 + eMortar*(1+rand(R1)*srd1);
                                #else  
                                        #local xPos=xPos+xBrick;
                                        object{Brick rotate rBrick scale <xBrick,yBrick + eMortar*(rand(R1)-0.5)*srd1*0.5,1>
                                        translate y*yPos
                                        translate -z*rWall
                                        rotate -y*degrees(xPos/rWall)
                                        texture{txtBrick}
                                        }
                                        #local xPos=xPos+xBrick + eMortar*(1+rand(R1)*srd1);
                                #end
                        #end    
                        #if (yPos+yBrick>yMax)
                                #local yMax=yPos+yBrick;
                        #end
                        #local yPos=yPos+(yBrickMin+yBrickMax)+eMortar*(1+rand(R1)*srd1);
                        #if (yFlag=0) #local yFlag=1; #else #local yFlag=0; #end
                #end                   
                scale <1,yWall/yMax,1>
                }

        rotate y*tetaWall*0.5 // rotates so that the wall looks at -z
        translate z*cos(radians(tetaWall*0.5))*rWall // centers the wall on <0,0,0>
        }
        #warning concat("the width of the wall is 2 * ",str(cos(radians(tetaWall*0.5))*rWall,0,3)," \n") 
        
#end
//=========================================
// Wall examples
//-----------------------------------------

//-----------------------------------------
// Parameter examples
//-----------------------------------------
#declare typeWall=2;            // 1=box ; 2=ellipsoid
#declare pEllipsoid=0.1;        // usual ellipsoid parameter
#declare xWall=101;             // wall length in x
#declare yWall=70;              // wall height in y
#declare eMortar=1;           // mortar thickness
#declare eWall=-0.96;             // mortar depth
#declare xBrickMin=1.2;             // min brick size
#declare xBrickMax=3;             // max brick size
#declare yBrickMin=0.5;             // min brick height
#declare yBrickMax=1.7;             // max brick height
#declare seedWall=200;              // seed wall
#declare srd1=0.3;                  // randomness amount for brick position (0=no random)
#declare srd2=0.3;                  // randomness amount for brick rotation (0=no random)
#declare srdcol=0.8;                // randomness amount for color (0=no random)
#declare patternWall=1;             // y color gradient for wall texture
                                    // 0=uniform color
                                    // 1=no color gradient
                                    // 2=from dark to light
                                    // 3=from light to dark

#declare pigWall=rgb<0.89,0.9,0.95>*1.2;    // wall main color
#declare txtMortar= texture{T_Stone10} //pigment{rgb<0.89,0.9,0.95>*1.6}} // mortar texture
//-----------------------------------------
// round wall parameters
#declare tetaWall=360;              // angle (360 = bricks all around)
#declare rWall=15;                 // radius
//-----------------------------------------




