// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @                                     @
// @         Now in Technicolor!         @
// @                                     @
// @     IRTC topic: Old Technology      @
// @                                     @
// @     Kees-Jan Backhuys (c) 2003      @
// @                                     @
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

// +sr0.76 +ec0.49  emmer & slaklogo
// +sr0.86 +ec0.32  slaklogo
// +sr0.77 +ec0.49 +sc0.41  verfblik

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
# version unofficial megapov 1.0;
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare babe_on = off;
# declare babe_on = on;

# declare test_blok = on;
# declare test_blok = off;

# declare test_spot = on;
# declare test_spot = off;

# declare area_on = off;
# declare area_on = on;

# declare media_on = off;
# declare media_on = on;

# declare eigen_map = on;
//# declare eigen_map = off;

# declare normal_on = 2;
# declare normal_on = 1;
# declare normal_on = 0;

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare wavetype = 4;
# declare slak     = 2;
# declare babe     = 3;

# declare ElfPos = < 2, -1, -3.0>;
# declare PotPos = < 0, -3, -2.8>;
# declare LBxPos = < 7,  1, -2.5>;

# declare RtLgStr = 0.95;

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare bzaad = seed (321);  // this controls the randomness of the blocks

# switch (wavetype)
  # case (1) # declare tzaad = seed (111); # break
  # case (2) # declare tzaad = seed (222); # break
  # case (3) # declare tzaad = seed (333); # break
  # case (4) # declare tzaad = seed (444); # break
  # case (5) # declare tzaad = seed (555); # break
  # case (6) # declare tzaad = seed (666); # break
  # case (7) # declare tzaad = seed (777); # break
# end

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# include "colnam.inc"
# include "colors.inc"
# include "mijnmacroos.inc"
# include "balklogo.inc"

//# global_settings {assumed_gamma 1.0}

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# switch (babe) // -----------------------

  # include "eva_textures.inc"

# case (1) // ------------
  # declare babescale = 5;
  # include "elfje7_o.inc"
  # include "elfje7.inc"         
  
  # declare Elf = union {object {Elfje7 scale babescale
                                rotate z*-10 rotate -x*30 rotate y*160
                                translate <0.70, -0.28, -3.4>
                                }
                         box {  <-0.5, -0.5, -3>, <0.5, 0.5, 10>
                                # if (test_blok) pigment {Red} finish {brilliance 3} # end
                                }
                         }
# break // # case (1) ----

# case (2) // ------------
  # declare babescale = 5;
  # include "gretakniel_stats.inc"
  # include "gretakniel_o.inc"
  # include "gretakniel.inc"         

  # declare Elf = union {object {GretaKniel transform GrKniel_trans
                                rotate x*6 rotate z*0 rotate -y*70
                                scale babescale
                                translate <0.08, 0.43, -2.5>
                                }
                         box {  <-0.5, -0.5, -3>, <0.5, 0.5, 10>
                                # if (test_blok) pigment {Red} finish {brilliance 3} # end
                                }
                         }
# break // # case (2) ----

# case (3) // ------------
  # declare babescale = 5;
  # include "gretazit_stats.inc"
  # include "gretazit_o.inc"
  # include "gretazit.inc"         

  # declare ElfTrans = <0.30, 0.40, -0.15>;
  
  # declare Elf = union {object {GretaZit transform GretaZit_trans
                                rotate y*155
                                scale babescale
                                translate ElfTrans
                                }
                        # if (test_blok)
                          union {
                                box { <-0.48, -0.48, 0>, <0.48, 0.48, 10>}
                                cylinder {-z*5, z*10, 0.1}
                                pigment {Red} finish {brilliance 3}
                                }
                        # else
                          box {<-0.5, -0.5, 0>, <0.5, 0.5, 10>}
                        # end
                        }
# break // # case (3) ----

# end // # switch (babe) // --------------


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# macro WT (nummer)
  # switch (nummer)
    # case (1) ramp_wave     # break
    # case (2) triangle_wave # break
    # case (3) sine_wave     # break
    # case (4) scallop_wave  # break
    # case (5) cubic_wave    # break
    # case (6) poly_wave 0.5 # break
    # case (7) poly_wave 2   # break
  # end
# end

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//            blokkenmuur
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare Br = 11;
# declare Ho = 11;

# declare Blokken = union {     // ----------- tellers initieren ------------
                                # declare j = -Ho; # while (j < Ho)
                                  # local i = -Br; # while (i < Br)
                                  
                                    box {<-.5, -.5, -2.5*rand(bzaad)>, <.5, .5, 10> translate <i, j, 0>}
                                
                                // ----------- tellers ophogen -------------------
                                  # local i = i+1; # end // # while i ...
                                # declare j = j+1; # end // # while j ....
                                }


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//         Displacement Pigments
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

// === black & white color_map ========

# declare ZWmap = color_map {[0 color rgb 0][1 color rgb 1]}

// === rainbow color_map in mijnmacroos.inc==============
// 1 for non-repetative pigments like bozo, leopard, wrinkles, etc
// 2 for repetative pigments like gradients, marble, radial, wood, etc

# declare DisplacePigment = pigment {   quilted control0 -1 control1 1 scale 2/3.5
                                        WT (wavetype)
                                        color_map {ZWmap}
                                        }

# declare Box1Tex = texture {   pigment { // --- zwart-wit ---
                                        onion frequency 5
                                        color_map {[0 rgb 0][1 rgb 1]}
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        }
                                # if (normal_on = 2)
                                normal {onion 0.3 frequency 5 WT (wavetype)
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        }
                                # end
                                finish {brilliance 2}
                                translate <-Br, -Ho, 0>
                                }

# declare Box3Tex = texture {   pigment { // --- customized ---
                                        onion frequency 5
                                        color_map {RainBowMap1d}
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        }
                                # if (normal_on > 0)
                                normal {onion 0.3 frequency 5
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        }
                                # end
                                finish {phong 1 phong_size 250 brilliance 2} // reflection 0.1}
                                translate <-Br, -Ho, 0>
                                }


# declare texobjtrans = transform {scale <1.2, 1, 1> rotate -z*15}

# declare TexObj = cylinder   { -z*30, z*30, 3.5
                                transform texobjtrans
                                translate ElfPos + <0, 1.0, 0>
                                }

# declare BxTrb = 0.55;
# declare BoxTex = texture {    pigment_pattern {object {TexObj White, Black}
                                                turbulence <BxTrb, BxTrb, 0>
                                                octaves 2 lambda 6 
                                                }
                                # if (eigen_map)                
                                  texture_map {[0 Box3Tex][1 Box1Tex]}
                                # else
                                  texture_map {[0 Box2Tex][1 Box1Tex]}
                                # end
                                }


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//               verfpot
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


// --- set variables for paintcan --------
# declare BlSc  = 0.80;
# declare BlSz  = 1/1.8;
# declare BxTrb = 0.15;
// ---------------------------------------

# declare TexObj = cylinder {   -z*(BlSc+0.01), z*(BlSc+0.01), 0.32
                                transform texobjtrans translate y*0.5
                                }

# declare BlikTex1 = texture {  pigment {onion frequency 5
                                        color_map {ZWmap}
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        scale <1/pi, 1, 1>*BlSz 
                                        warp {cylindrical}
                                        }
                                }

# declare BlikTex2 = texture {  pigment {onion frequency 5
                                        color_map {RainBowMap1d}
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        scale <1/pi, 1, 1>*BlSz 
                                        warp {cylindrical}
                                        }
                                finish  {specular 0.5 metallic ambient 0.2}
                                # if (normal_on > 0)
                                normal {onion 0.3 frequency 5
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        scale <1/pi, 1, 1>*BlSz 
                                        warp {cylindrical}
                                        }
                                # end
                                }


//  --- set variables for vblik.inc -------------
# declare VB_BuWandTex = texture {pigment_pattern {object {TexObj White, Black}
                                                   turbulence <BxTrb, BxTrb, 0> octaves 2 lambda 6 
                                                   }
                                  texture_map {[0 BlikTex2][1 BlikTex1]}
                                  }
# declare VB_VerfTex    = texture {Box3Tex scale 1/BlSc}
# declare VB_BeugelTex  = texture {pigment {OldGold} finish {MetaalFin}}
# declare VB_FlensTex   = texture {pigment {OldGold} finish {MetaalFin}}
# declare VB_beugelstnd = 1;
# declare VB_verfhoogte = 0.87;

# include "vblik.inc"
// ----------------------------------------------

# declare VerfPot = union {     object {maakVerfBlik (0.55) scale BlSc
                                        rotate -y*25 translate <0, 0.5, 0.5>
                                        }
                                # if (test_blok)
                                  union {
                                        box { <-0.48, -0.48, 0>, <0.48, 0.48, 10>}
                                        cylinder {-z*5, z*10, 0.1}
                                        pigment {Red} finish {brilliance 3}
                                        }
                                # else
                                  box {<-0.5, -0.5, 0>, <0.5, 0.50, 10>}
                                # end
                                }


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//               de slakken
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# switch (wavetype)
  # case (1)
    # declare SlakColor = color (White + GreenYellow)/2;
    # declare TbC1 = color Turquoise;      # declare TbC2 = color Tomato;
  # break
  # case (2)
    # declare SlakColor = color GreenPale;
    # declare TbC1 = color BrightGold;     # declare TbC2 = color LightSteelBlue;
  # break
  # case (3) # declare SlakColor = color NavajoWhite;
    # declare TbC1 = color Aquamarine2;    # declare TbC2 = color HotPink;
  # break
  # case (4)
    # declare SlakColor = color Burlywood;
    # declare SlakColor = color (2*White + DeepPink)/3;
    # declare SlakColor = color (White + DeepPink)/2;
    # declare TbC1 = color SkyBlueLight;   # declare TbC2 = color Khaki2;
  # break
  # case (5)
    # declare SlakColor = color BlueLight;
    # declare TbC1 = color CadmiumRedLight; # declare TbC2 = color Banana;
  # break
  # case (6)
    # declare SlakColor = color CadmiumLemon;
    # declare TbC1 = color IndianRed2;      # declare TbC2 = color Cerulean;
  # break
  # case (7) 
    # declare SlakColor = color Very_Light_Purple;
    # declare TbC1 = color LemonChiffon;    # declare TbC2 = color CinnabarGreen; 
  # break
# end 

# switch (slak) // -------

# case (1)
  # declare SlakTex = texture { pigment {SlakColor}
                		normal	{bumps -0.4}
                		finish	{phong 0.8 ambient 0.1}
                		}
  
  # declare HuisTex = texture { pigment {marble rotate z*70
        				color_map {[0 Yellow][0.5 Raspberry][0.8 Bisque][1 Orange]} 
        				}
        			finish  {phong 0.5 phong_size 80}
        			}
  # include "slak1.inc"
# break

# case (2)

  # declare SlakTex = texture { pigment {SlakColor}
                		finish	{phong 0.8 brilliance 1.5 ambient 0.2}
                		}

  # declare HuisTex = texture { pigment {marble rotate z*70
        				color_map {[0 Yellow][0.5 Raspberry][0.6 Raspberry][1 DodgerBlue]} 
        				}
        			finish  {phong 1 phong_size 50}
        			}
  # include "slak2.inc"

# break

# end // # switch (slak) // -------


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//              KJB-logo
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare LogoBlok = union {difference {box {<-.5, -.5, -0.1>, <.5, .5, 0>}
                                        object {RuitLogo (0.95, 0) // 0)
                                                //scale 0.5
                                                scale <0.5, 0.5, 1>
                                                translate -z*0.1
                                                texture {pigment {Gray75}}
                                                }
                                        }
                        # if (test_blok)
                          union {
                                box { <-0.48, -0.48, 0>, <0.48, 0.48, 10>}
                                cylinder {-z*5, z*10, 0.1}
                                pigment {Red} finish {brilliance 3}
                                }
                        # else
                          box {<-0.5, -0.5, 0>, <0.5, 0.50, 10>}
                        # end
                        }
                              


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//          maak signatuurblok
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# switch (wavetype)
  # case (1) # declare FontName = "blkchcry.ttf" # declare BlRa = -0.01; # break
  # case (2) # declare FontName = "lhandw.ttf"   # declare BlRa =  0.00; # break
  # case (3) # declare FontName = "amazb___.ttf" # declare BlRa =  0.00; # break
  # case (4) # declare FontName = "zurichi.ttf"  # declare BlRa = -0.07; # break
  # case (5) # declare FontName = "forte.ttf"    # declare BlRa =  0.00; # break
  # case (6) # declare FontName = "brlnsdb.ttf"  # declare BlRa =  0.01; # break
  # case (7) # declare FontName = "harngton.ttf" # declare BlRa =  0.00; # break
# end 

# declare TekstBlokKleur1 = color TbC1;
# declare TekstBlokKleur2 = color TbC2;
# declare TekstBlokFin    = finish {specular 0.5 brilliance 4}  // metallic}

# declare BL_kwadrant     = 1;
# declare BL_regelaantal  = 2;
# declare BL_regelafstand = BlRa;
# declare BL_dicht        = 1;
# declare BL_dichttex     = texture {pigment {color TbC1} normal {crackle 0.2 scale 1/6} finish {phong 0.3 metallic}}

# declare TekstRegel    = array [BL_regelaantal+1]
# declare TekstRegel[1] = concat (chr(210), "Now in Technicolor!", chr(211))
# declare TekstRegel[2] = concat ("Kees-Jan Backhuys ", chr(169), " 2003")

# declare SlakPos = <6, 2+(3*0.05), 0>;

# declare ABr =  8; // ArealightBreedte 8   4
# declare LAa =  3; // LichtpuntAantal  3
# declare Ada =  1; // adaptive

# declare Signatuur = light_group {     light_source {  <15, 12, -15>, rgb 1.5
                                                        spotlight radius 10 falloff 25
                                                        point_at SlakPos
                                                        media_interaction off
                                                        # if (area_on)
                                                          area_light x*ABr, y*ABr, LAa, LAa
                                                          adaptive Ada jitter
                                                          orient circular
                                                        # end 
                                                        }

                                        object {BalkLogo (0.05, 4, 2, 0, 2, 0.05, 0.04)
                                                scale <1, 1, 8> no_reflection   // it's a vampire!!
                                                }

                                        # switch (slak)         
                                          # case (1) object {Slak1 no_reflection scale 0.17 rotate y*185 translate SlakPos} # break
                                          # case (2) object {Slak2 no_reflection scale 0.17 rotate y*  5 translate SlakPos} # break
                                        # end
                                        
                                        global_lights off 
                                        }

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@



// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//              the scene
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare SpotlightPointAt  = ElfPos + <0, 1.0, 0>;

# declare ScAsL = 35;   // sceneaslengte
# declare SpAsL = 18;   // spotaslengte

# declare SpotTrans  = transform {rotate -y*33 rotate x*60 translate SpotlightPointAt}
# declare SceneTrans = transform {rotate -x*15 rotate y*20 rotate -z*5 translate -y*1}

# declare LichtKleur = color CyanWhite;

# declare SpotKleur = color Black;
# declare SpotKleur = color LichtKleur*0.15;


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# camera {      location -z*ScAsL
        	up y*image_height right x*image_width
        	angle 25
                }

# declare ABr =  4; // ArealightBreedte 8   4
# declare LAa =  3; // LichtpuntAantal  3
# declare Ada =  1; // adaptive

# light_source {<0, 200, -300> color rgb 0.1 media_interaction off shadowless}

# declare Spot = light_source { -z*SpAsL color LichtKleur*3.5 //6
                
                                # if (media_on)
                                  spotlight radius 35 falloff 5 // this only works when the spotlight is 'inside out
                                # else                          // so with the radius bigger than the falloff
                                  spotlight radius 5 falloff 25
                                # end
                
                                # if (area_on)
                                  area_light x*ABr, y*ABr, LAa, LAa
                                  adaptive Ada jitter
                                  orient circular
                                # end 
                
                                point_at 0
                                transform SpotTrans
                                }

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# if (media_on) // ------------------------

  # declare MyDens = density {  bumps scale <1, 1, 5>*0.3
                                color_map {[0 LichtKleur][0.7 SpotKleur][1 SpotKleur]}
                                turbulence 0.5
                                }

  # media {     scattering {4, rgb 0.05}
                intervals 1
                samples 5
                method 3
                density {MyDens transform SpotTrans transform SceneTrans}
                }
                
  # sphere {0, 100 pigment {Clear} hollow}
  
  # if (test_spot)
     cone {     -z*SpAsL, 0, 0, 1
                pigment {bozo scale <1, 1, 5>*0.2
                        color_map {[0 Red][1 Blue]}
                        translate -z*SpAsL
                        }
                transform SpotTrans
                transform SceneTrans
                no_shadow
                }
  # end

# end // # if (media_on) // ---------------


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# union {object {Blokken}
         object {VerfPot  translate PotPos}
         object {LogoBlok translate LBxPos}
         object {Spot}

         # if (babe > 0) object {Elf translate ElfPos} # end

         texture {BoxTex}
         transform SceneTrans
         }

# object {Signatuur scale 0.038 rotate -x*4 translate <-0.760, -0.565, -0.90*ScAsL>}
