// ----- handy macros -----
//
// a rect box with corners on 3 given 2D points
// #macro Rect3ptBox(P1 P2 P3)
// 


// a pipe cylinder P1 to P2, with major radius r1, and minor radius r2
#macro Pipe(P1, P2, r1, r2)   
// V1 = P1, V2 = P2 - P1
  #local P3 = P1 - 0.1*(P2-P1); // V1 - 0.1*V2
  #local P4 = P1 + 1.1*(P2-P1); // V1 + 1.1*V2
  difference {
    cylinder {P1,P2,r1}
    cylinder {P3,P4,r2}  
  }
#end

// a line of object starting at a location and repeating at an interval 
#macro LineOf(Obj StartPos IncPos Num) 
  #local _COUNT = 0;
  #local _CPOS = StartPos;
  #while (_COUNT < Num)
    object {Obj translate _CPOS}
    #local _CPOS = _CPOS + IncPos;
    #local _COUNT = _COUNT + 1;
  #end
#end  

// a ring of objects starting at a location and orbiting the origin by IncRot 
#macro RingOf(Obj StartPos IncRot Num)
  #local _COUNT = 0;
  #local _ROT = <0,0,0>;
  #while (_COUNT < Num)
    object {Obj translate StartPos 
      rotate <_ROT.x,0,0> 
      rotate <0,_ROT.y,0> 
      rotate <0,0,_ROT.z>}
    #local _ROT = _ROT + IncRot;
    #local _COUNT = _COUNT + 1;
  #end
#end  

  
// a grid of object starting at a location and repeating at IncPos and IncPos2
#macro GridOf(Obj StartPos IncPos IncPos2 Num Num2)
  #local _COUNT2 = 0;
  #local _CPOS2 = StartPos;
  #while (_COUNT2 < Num2)
    #local _COUNT = 0;
    #local _CPOS = _CPOS2;
    #while (_COUNT < Num)
      object {Obj translate _CPOS}
      #local _CPOS = _CPOS + IncPos;
      #local _COUNT = _COUNT + 1;
    #end
    #local _CPOS2 = _CPOS2 + IncPos2;
    #local _COUNT2 = _COUNT2 + 1;
  #end
#end 
