
//-------------------------------------------------
#switch (lamp_mode)
 #case (1)
   #declare lamp =
   light_source { 0 colour .45  
     looks_like  { 
       difference {
        sphere {0,1}
        box {<-1.1,0,-1.1>,1.1}
          pigment {rgb 1} 
          finish {ambient 1} 
        } 
     }
     fade_power 2
     fade_distance 30
   }
 #break 
 #case (2)
   #declare lamp =
   light_source { 0 
     color rgb .45
     area_light
     <1, 0, 0> <0, 0, 1>
     4, 4
     adaptive 2
     jitter              // adds random softening of light
     circular            // make the shape of the light circular
     orient              // orient light
     looks_like  {
       difference {
        sphere {0,1}
        box {<-1.1,0,-1.1>,1.1}
          pigment {White} 
          finish {ambient 1}
        }
     }
     fade_power 2
     fade_distance 30
   }

 #break
#end 
//-------------------------------------------------
#declare Bench =
union { 
 difference { 
  object {Round_Box(<-9.9,0,-2.4>,<9.9,3,2.4> .4, on) }  
  object { cylinder {<0,0,-5>,<0,0,5>,1.6} scale <5,1.3,1>}
  object { cylinder {<-11,0,0>,<11,0,0>,1.45}scale <1,1.65,1> }
  texture {T_Wood5 scale 3}
 } 
 difference { 
  object {Round_Box(<-10,0,-2.5>,<10,3.25,2.5> .4, on) }
  box {<-11,1,-3>,<11,2,3>}  
  object { cylinder {<0,0,-5>,<0,0,5>,1.5} scale <5,1.3,1>}
  object { cylinder {<-11,0,0>,<11,0,0>,1.35}scale <1,1.65,1> }
  #local Bank_holes = 11 ;
  #while (Bank_holes>0)
   object { cylinder {<-12,2.5,-3>,<-12,2.5,3>,.1} 
            translate x*Bank_holes*2
          }
   #local Bank_holes = Bank_holes-1 ;
  #end        
 }
 union {
   object {Round_Box(<-9.7,2,-2.2>,<9.7,3.31,-1.1> .4, on) }
   object {Round_Box(<-9.7,2,-1.1>,<9.7,3.31,0> .4, on) }
   object {Round_Box(<-9.7,2,0>,<9.7,3.31,1.1> .4, on) }
   object {Round_Box(<-9.7,2,1.1>,<9.7,3.31,2.2> .4, on) }
   translate y*0.2
   texture {
      pigment {colour rgb <230,175,110>/255 }
      finish {specular .3 roughness 0.002}
   }
   
 }  
 
 union {
  cylinder {<-9.6,1.4,-2.2>,<-9.6,1.4,2.2>,.1}
  cylinder {<9.6,1.4,-2.2>,<9.6,1.4,2.2>,.1}
  texture {Polished_Chrome}
 }
 texture {T_Wood3 scale 3 translate <100,20,0>}
}
//-------------------------------------------------
#declare Exit_Sign =
union {
 box {<-1.4,-0.9,-0.01>,<1.4,0.9,0.02> 
  pigment {color rgb <26,142,26>/255}
 } 
 object {
  prism {                                
   linear_sweep linear_spline -0.01,0.03, 10,  
   < -1.25, 0>,< -.666,-.75>, < 0,-.75>, < -.333,-.333>,< 1.25, -0.333>,
   < 1.25, .333>, < -.333,.333>, < 0,.75>,< -.666,.75>,< -1.25,0>
   pigment {color rgb 1}   
  }
  rotate x*-90
  }
  
}
//-------------------------------------------------
#declare Rotulo_Est =
union {
 cone {0,0.6<0,0.5,0>,0.001}
 cylinder {0,<0,6.2,0>,0.1}
 box {<-1,-.5,-.01>, <1,.5,.01> rotate x*20 translate y*6.5}
 object { 
    box {<-.8,-.45,-.03>, <.8,.45,.01> }
    pigment {
      image_map { gif "sign.gif" map_type 0 interpolate 2 once }
    translate <-.5,-.5,0>
    scale <1.6,.9,1>
    }
 rotate x*20 translate y*6.5   
 } 
 pigment {Black}
 
}
//-------------------------------------------------
#declare Peana =
union { 
 box {<-7,0,-5>,<7,1,5>}
 box {<-6.5,0,-4.5>,<6.5,2,4.5>} 
 texture { 
  pigment {rgb .9}
  finish {
   diffuse .7
   brilliance 0.75
   specular .5
   roughness .06
  }
 } 
}
//-------------------------------------------------
#declare Papelera =
union {
 box {<-.65,-1,-.55>,<.65,.3,.55>}
 difference { 
  object {Round_Box(<-.6,-1,-.5>,<.6,5,.5> .01, on)}
  object {Round_Box(<-.55,-1,-.45>,<.55,8,.45> .01, on) pigment {Gray90}}  
  object {Round_Box(<-.45,4,-2>,<.45,4.5,.4> .1, on) pigment {Gray90}}  
 } 
 union {
  cylinder {<-.45,4,-.5>,<.45,4,-.5>,0.03}
  cylinder {<-.45,4.5,-.5>,<.45,4.5,-.5>,0.03}
  cylinder {<-.45,4,-.5>,<-.45,4.5,-.5>,0.03}
  cylinder {<.45,4,-.5>,<.45,4.5,-.5>,0.03}
  sphere {<-.45,4,-.5>.03}
  sphere {<.45,4,-.5>.03}
  sphere {<.45,4.5,-.5>.03}
  sphere {<-.45,4.5,-.5>.03}
  texture { pigment {Gray70} finish{phong .8 reflection .8} }
 }
 pigment {Black}
 finish {
  phong .8
  reflection .4
 } 
}
//-------------------------------------------------
#declare Ancient_Title =
union {
 //object { text { ttf "cyrvetic.ttf" "Art from" 0.5,0 } scale 3 translate <30,24,24.75> }
 object { text { ttf "timrom.ttf" "Ancient Greece" 0.5,0 } scale 7 translate <30,18,24.75> }
 object { text { ttf "cyrvetic.ttf" "Escherville Municipal Arts Centre June-July 2003" 0.5,0 } scale 1.5 translate <30,16,24.75> }
 texture { 
  pigment {White}
  finish {
   phong 0.5
   brilliance 0.75
   diffuse 0.6
   }
  normal {bumps 0.1 bump_size 0.3} 
 } 
}
//-------------------------------------------------
#declare Title_53178349 =
union {
 object { text { ttf "cyrvetic.ttf" "5" 0.5,0 } scale 2 translate <0,5.8+(3.6*9),0> } 
 object { text { ttf "cyrvetic.ttf" "3" 0.5,0 } scale 2 translate <0,5.8+(3.6*8),0> }
 object { text { ttf "cyrvetic.ttf" "1" 0.5,0 } scale 2 translate <0.22,5.8+(3.6*7),0> }
 object { text { ttf "cyrvetic.ttf" "7" 0.5,0 } scale 2 translate <0,5.8+(3.6*6),0> } 
 object { text { ttf "cyrvetic.ttf" "8" 0.5,0 } scale 2 translate <0,5.8+(3.6*5),0> } 
 object { text { ttf "cyrvetic.ttf" "3" 0.5,0 } scale 2 translate <0,5.8+(3.6*4),0> } 
 object { text { ttf "cyrvetic.ttf" "4" 0.5,0 } scale 2 translate <0,5.8+(3.6*3),0> } 
 object { text { ttf "cyrvetic.ttf" "9" 0.5,0 } scale 2 translate <0,5.8+(3.6*2),0> } 
 object { text { ttf "cyrvetic.ttf" "m" 0.5,0 } scale <1.9,2,2> translate <-0.15,5.8+(3.6*1),0> } 
 object { text { ttf "cyrvetic.ttf" "j" 0.5,0 } scale 2 translate <0,5.8,0> } 
 texture { 
  pigment {Black}
  finish {
   brilliance 0.75
   diffuse 0.6
   phong 0.5
   }  
 }
}
//-------------------------------------------------
#declare OTHERS_TITLE=
union {
 object { text { ttf "arial.ttf" "Soon \"Pioneers\" Exhibition with:" 0.5,0 } scale 1.75 translate <0,6,0> }
 object { text { ttf "arial.ttf" "Kudac D. Bivk" 0.5,0 } scale 1.3 translate <0,0,0> }  
 object { text { ttf "arial.ttf" "Asanri Cool - NL" 0.5,0 } scale 1.3 translate <0,2,0> }
 object { text { ttf "arial.ttf" "Dr. Max Nelan Eane - NZ" 0.5,0 } scale 1.3 translate <0,4,0> }

 object { text { ttf "arial.ttf" "Dr. Fran Mae" 0.5,0 } scale 1.3 translate <18,0,0> }
 object { text { ttf "arial.ttf" "Dr. W. Welles" 0.5,0 } scale 1.3 translate <18,2,0> }
 object { text { ttf "arial.ttf" "Scyro N. Ghui" 0.5,0 } scale 1.3 translate <18,4,0> }
                                  
texture { 
  pigment {White}
  finish {
   phong 0.5
   brilliance 0.75
   diffuse 0.6
   }
  normal {bumps 0.1 bump_size 0.3} 
 }  
}
//-------------------------------------------------
#declare Altillo =
union {
 box { <150,24.5,0>,<215,25.5,-35> }
 cylinder {<191,7,26>,<191,32.5,-.5>,.15 pigment {Black}} // barandilla escalera
 cylinder {<191,3,26>,<191,29.5,-.5>,.15} //     "
 cylinder {<191,0,26>,<191,7,26>,.15}     //     "
 sphere {<191,7,26>,.2}                   //     "

 // columna 
 box {<150,0,0>,<152,40,-2>} 
 box {<149.75,0,0.25>,<152.25,4,-2.25> pigment {Gray90}}
 
 
 cylinder {<150.5,32.5,0>,<150.5,32.5,-35>,.15 pigment {Black}} // barandilla altillo
 cylinder {<150.5,29.5,0>,<150.5,29.5,-35>,.15} // barandilla altillo 
 
 cylinder {<150.5,25.5,-17.5>,<150.5,32.5,-17.5>,.15} // barandilla altillo
 cylinder {<150.5,25.5,-8.75>,<150.5,32.5,-8.75>,.15} // barandilla altillo
 cylinder {<150.5,25.5,-26.25>,<150.5,32.5,-26.25>,.15} // barandilla altillo
 
 
 cylinder {<150.5,32.5,-.5>,<191,32.5,-.5>,.15 pigment {Black}} // barandilla altillo
 cylinder {<150.5,29.5,-.5>,<191,29.5,-.5>,.15} // barandilla altillo
 
 cylinder {<165,25.5,-.5>,<165,32.5,-.5>,.15} // barandilla altillo 
 cylinder {<178,25.5,-.5>,<178,32.5,-.5>,.15} // barandilla altillo

 box {<-.75,-.25,0>,<.75,.25,-35> rotate x*45 
      translate <195,0,25>
      pigment {Black}
     }
 
 #local conta_peld = 12.5;
 #while (conta_peld>0)
  union {
         box {<190,0,26>,<200,0.5,24>}
         box {<193,-0.05,23.95>,<197,0.55,26.05> pigment {Black}}
         cylinder {<191,0.5,25>,<191,7,25>,.14}
         translate <0,conta_peld*2,-conta_peld*2>
  }
  #local conta_peld = conta_peld-1;
 #end
 pigment {White}
}

// -------------------------------------------------
#declare Cuadro_1 =
box { <-8.6,-10,0.001>,<8.6,10,0.002>
    pigment {
      image_map {
        jpeg "120gr.jpg" map_type 0 interpolate 2 once
      }
    translate <-.5,-.5,0>
    scale <4.3,5.5,1>
    scale 3
    }
}
#declare Cuadro_2 =
box { <-9,-9,0.001>,<9,9,0.002>
    pigment {
      image_map {
        jpeg "010gr.jpg" map_type 0 interpolate 2 once
      }
    translate <-.5,-.5,0>
    scale 16
    }
}
// -------------------------------------------------
#declare Estanteria =
union {
 box {<-2.5,0,-1.5>,<2.5,0.75,1.5>}
 box {<-2.5,0,-1.5>,<-2.4,10,1.5>}
 box {<2.4,0,-1.5>,<2.5,10,1.5>}
 box {<-2.5,9.5,-1.5>,<2.5,10,1.5>}
 pigment {White}
}

#declare Aparador =
union {
 box {<-2,0,-2.5>,<2,0.75,2.5> texture {T_Wood3}}
 box {<-2.65,0.75,-2.65>,<2.65,4,2.65> texture {T_Wood5} } 
 
// pigment {White}
}
// -------------------------------------------------
#declare Enchufe =
difference {
 box {<-.25,-.25,-.2>,<.25,.25,.3>}
 cylinder {<0,0,-.3>,<0,0,.1>,.2}
 cylinder {<-.05,0,-.35>,<-.05,0,.4>,.03}
 cylinder {< .05,0,-.35>,< .05,0,.4>,.03}
 pigment {White}
}

// -------------------------------------------------
#declare p1 = <0.0,  -0.5> ;
#declare p2 = <1.75,  0.0> ;
#declare p3 = <0.8,   0.2> ;
#declare p4 = <2.2,   4.0> ;
#declare p5 = <3.5,   7.5> ;
#declare p6 = <2.2,  10.0> ;
#declare p7 = <3.2,  11.0> ;
#declare p8 = <2.7,  11.1> ;
#declare p9 = <0.0,   6.0> ;

#declare Vase =
sor {
    9,   
    p1,p2,p3,p4,p5,p6,p7,p8,p9
    texture {
       pigment {
          marble 
          turbulence 0.9 
          color_map {
                [0.1  color White]
                [0.2999  color White]                
                [0.3  color Black]
                [0.4999  color Black]                
                [0.5  color <221,178,110>/255]
                [0.5999 color <221,178,110>/255]                                
                [0.6  color Clear]
                [0.79999  color Clear]                
                [0.8  color <158,98,44>/255]                
                [0.94999  color <158,98,44>/255]                          
                }       
          }
        finish {diffuse 0.5}
        scale 3
     }   
    texture {
       pigment {
          gradient y
          color_map {                           
                [0.1  color <221,178,110>/255]
                [0.2999  color <221,178,110>/255]              
                [0.3  color Black]      
                [0.37999  color Black]
                [0.38  color White]
                [0.41999  color White]
                [0.42  color Black]
                [0.4999  color Black]                
                [0.5  color <221,178,110>/255]
                [0.5999   color <221,178,110>/255]                                
                [0.6  color Clear]
                [0.79999  color Clear]               
                [0.8  color <221,178,110>/255]                
                [0.94999  color <221,178,110>/255]
                [0.95  color <1,0,0>]                
                }
          }
       finish { phong 0.3
               reflection 0.1
              }
       scale 6
       }
    texture {
       pigment {
          agate
          agate_turb 0.6
          color_map {
                [0.025  color <.7,.7,.7,.95>]
                [0.3  Clear]
                [0.9  color  rgbf <.95,.95,.95,.95>]
                }
          }
       scale 5
      }
} 
// -------------------------------------------------
#macro hilera (num_tbls,lng_tbls,semilla)
#local Cj = 
box {<-.498,-1,-.498>,<.498,0,.498>}
union {
#local R1 = seed (semilla) ;
#local R2 = seed (semilla) ;
#local R3 = seed (semilla) ;
#local R4 = seed (semilla) ;
#local Dist = 0 ;

#local Tbl_lng = lng_tbls ; // longitud mxima de los tableros
#local Xs = num_tbls ; // nmero de tableros por hilera

sphere {<rand(R3),0,0>0.000001 pigment {Clear}} // disruptor

#while (Xs>0)  
   object {
      Cj      
      scale <((Tbl_lng*rand(R1))+4),1,1>                  
      translate x*Dist      
      texture {
         T_Wood10
         rotate y*90
         translate <rand(R4)*100,0,rand(R4)*25>
         scale <4,4,rand(R4)+.6>
         #if (rand(R4)>.5)
          rotate y*rand(R4)*7
         #else
          rotate y*rand(R4)*-7
         #end
  finish { brilliance 2 
           reflection{.03,.1}
           specular .2 
           roughness .05 
           diffuse .5
           conserve_energy
          }                    
  normal { bumps .01 bump_size .001 scale .05 }
  normal { wrinkles 0.01}    

  scale 4                
      }
    }
    
#local Xs = Xs-1 ;

#local Dist = Dist + ((Tbl_lng*.5*rand(R2))+0.25) + ((Tbl_lng*.5*rand(R3))+0.25);

#end
}
#end

#declare parquet = -25 ;

#while (parquet<40)
 object {hilera(300,25,parquet)
         translate z*parquet
         }
 
 #declare parquet=parquet+1;
#end


object {Estanteria translate <160,25.5,-33.5>}
object {Estanteria translate <170,25.5,-33.5>}
object {Estanteria translate <180,25.5,-33.5>}
object {Aparador translate <165,25.5,-10>}
object {Aparador translate <185,25.5,-20>}
object {Vase scale 0.7 translate <165,29.5,-10>}