// Persistence of Vision Ray Tracer Scene Description File
// File: mg_ahau.pov
// Vers: 3.5
// Desc: include file for tzolkin
// Date: May 07 2003/June 11 2003
// Auth: marjorie 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions

#include "mg_tz01.inc"
#include "mg_tz02.inc"
#include "mg_tz03.inc"


global_settings{
	adc_bailout 0.0039
	ambient_light rgb 0//<255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 13//10
	number_of_waves 10
	/*radiosity{
		brightness 1//3.300
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	} */
}


//modified from skies.inc
//agua2 substitutes SkyBlue
#declare P_Cloud4 =
pigment {
    wrinkles
    turbulence 0.1
    lambda 2.2
    omega 0.707
    color_map {
        [0.20 agua2*0.85]  //
        [0.50 White ]
        [1.00 Gray70 ]
    }
    scale <0.5, 0.15, 1>
}

#declare S_Cloud2 =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.00 agua3]//
            [0.10 agua2]//
            [0.20 P_Cloud4 ]
        }
    }
}

sky_sphere {S_Cloud2}


camera{ 

   //arriba test
	//location < -6.361, 20, -80.1 > //
	//look_at < 28, 5.527, 100 > 
	
	 //originales NO TOCAR
	location < -6.361, 1.628, -41.5 > //< -6.361, 1.627, -41.5 >< -6.361, 1.627, -41.1 > 
	look_at < 28, 5.528, 100 >//< 28, 5.527, 100 >  
		
	//para el despliegue vertical
	right     1.5/2*x 
	angle 40//20
	rotate 3*x
}


#include "mg_tz_lit.inc" //iluminacin

//cercanas o mas visibles 

object {luces_grupo_01}

//del terreno
object{luces_grupo_02}

//posteriores  
object {luces_grupo_03}

//restantes 
object {luces_grupo_04}



#include "mg_tz04.inc"
object{plantas_grandes_medianas}


// 
light_source {
  0*x                     // 
  color rgb <1,1,1>       // 
  spotlight
  parallel                // 
  translate <-18, 7, -15> // 
  point_at <-3, 1, -23>      // 
  radius 100                // 
  tightness 30//50            // 
  falloff 200//8               // 
  fade_distance 20//18//17
  fade_power 1
  projected_through { object { plantas_grandes_medianas } }
}
// antes de la anterior
light_source {
  0*x                     // 
  color rgb <1,1,1>       // 
  spotlight
  parallel                // 
  translate <-18, 6.5, -10> // 
  point_at <-2, 1, -14>      // 
  radius 100                // 
  tightness 30//50            // 
  falloff 200//8               // 
  fade_distance 20//16//17
  fade_power 1
  projected_through { object { plantas_grandes_medianas } }
}




//divide el sky_sphere slo visual
plane { y, -0.40 pigment{White}}

//templo
object {
   templo 
   scale 1.5  
   otate -20*y   //
   translate <-0.5,4.5,5> 
} //


#declare variante=seed(1010);


//plano base
object{
   plano_01
   texture {paredes_all}//
   texture {por_encima translate 0.0001*y scale <13,13,20>}//

}


//camineria
#declare variante=seed(1010); 
object{
   plano_04 
      texture { paredes_all02 scale rand(variante)}
      texture {por_encima translate 0.0001*y scale <13,13,20>}//
      texture {
         pigment{
            bumps
               color_map{
                  [0.10 Gray70 filter 0.5 transmit 0.5]
                  [1.0 Clear]
               }
         } 
         normal {
            bump_map { 
               png "cantos.png" 
               map_type 0        
               interpolate 2     
               bump_size 1.5     
            } 
         }
      translate 0.00015*y
        
      }
} 


//tzolkin
object{
   tzol_05_13
   scale <2.1,4.25,0.25>
   rotate 103.1*y 
   translate -3.85*x
   translate 1*y
   translate -36.58*z

}




//enfrente de tzolkin
object{
   tzol_ft
   rotate -78*y//
   translate -6.72*x 
   translate 1*y
   translate -38.7*z 
  
}
  
  
//vegetacion
//detras del templo
object{
   selva_atras 
   texture {paredes_all03}
   translate<0,0,20>

}

//derecha del templo
object{
   selva_atras
   texture {paredes_all03}
   texture {por_encima translate 0.0001*y scale <13,13,20>}//
   rotate 120*y 
   translate<20,0.1,18>
}




//arco/boveda salediza
object{
   boveda_salediza 
   scale <0.90,0.46,0.75>
      texture {paredes_all02}//{escaleras}
      texture {por_encima translate 0.0001*y }//
   rotate -0.4*y
   translate -0.45*x
   translate 2.50*y
   translate -9.6*z

}


#include "lizard06.inc" //
object {lagartijo  
        scale 0.10
        rotate -78*y //-78ok
        translate <-6.52,4.59,-38.5>}


//vegetacion derecha templo

#include "hojas01.inc"
#declare vegetacion_derecha_templo=
union{
object{hojas01 scale 0.50 rotate 0*y   translate <-10,1,6>}
object{hojas01 scale 0.50 rotate 13*y   translate <-9,2,5.5>}
object{hojas01 scale 0.50 rotate 26*y   translate <-8,1,6.5>}
 object{hojas01 scale 0.50 rotate 39*y   translate <8,0,9>}
 object{hojas01 scale 0.50 rotate 52*y   translate <10.5,1,9>}
 object{hojas01 scale 0.50 rotate 65*y   translate <12.5,2,9>}
 object{hojas01 scale 0.50 rotate 78*y   translate <10,0,6>}
 object{hojas01 scale 0.50 rotate 91*y   translate <12.25,-.75,6>}
object{hojas01 scale 0.50 rotate 104*y   translate <10,0.25,5>}
object{hojas01 scale 0.50 rotate 117*y   translate <13,1.20,4>} 
object{hojas01 scale 0.50 rotate 130*y   translate <15,1,6>}
//aadida
object{hojas01 scale 0.50 rotate 143*y   translate <16,-1,3>}
//
object{hojas01 scale 0.50 rotate 143*y   translate <17,0,3>}
object{hojas01 scale 0.50 rotate 156*y   translate <19,1,5>}
}

object{vegetacion_derecha_templo}


light_source {
  0*x                     
  color Carton//
  spotlight
  parallel                
  translate <7, 10, 7> 
  point_at <5, 0.5, -14>      
  radius 105                
  tightness 16//           
  falloff 200//              
  fade_distance 20//
  fade_power 1
  projected_through { object { vegetacion_derecha_templo } }
}
//sub-grupo 2 //modificar +1x +2*z  +2*-y
object{hojas01 scale 0.50 rotate 91*y   translate <13,-2,8>}
object{hojas01 scale 0.50 rotate 104*y   translate <11,-2.25,7>}
object{hojas01 scale 0.50 rotate 117*y   translate <14,0,6>}
object{hojas01 scale 0.50 rotate 130*y   translate <16,-1,8>}
object{hojas01 scale 0.50 rotate 143*y   translate <18,-2,5>}


#include "hojas02.inc"
object{hojas02 scale 0.15 translate <16,0,0>} //7x <8,0,0>12



//hierbas de la camineria
object {hierbas_cam}

//rastreras de la derecha
object {rastreras translate 1*x}

//de_arriba
#include "desde_arriba.inc"
object{desde_arriba scale 0.015 translate <-5.850,4.0,-40.2>}

//frente al arco (2)
#include "pac_fte.inc"

//plataforma 
object {pac_fte scale 0.15 translate <-5.20,1.33,-33>}


#include "pac_fte_up.inc"

object {
   pac_fte_up 
   scale 0.55 
   rotate -100*y//
   translate <-5.20,2.38,-33>
} //


//izquierda frente
#include "otra_mata.inc"                                      

object{
   otra_mata
   scale 0.010
   translate <-6.2,5.0,-37.5>  //
}
