
// POV-Ray Object File - Catwalks
// created 10-Jun-03
// last update 27-Jun-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Catwalks.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Catwalk(Length,Width) with railings all around
// Stairs(Height)
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Catwalk origin is at the top of the floor
// Catwalk length extends into +X
// Catwalk width extends into +Y
// Stairs origin is at the top step

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc" // uncomment for testing only
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================




//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================


#declare CatwalkTex =
	texture {
//		pigment { color rgb<0.575,0.592,0.547>*1.00 } // dirty grey default texture
		pigment { color rgb <0.945,0.679,0.129> } // industrial yellow
		finish { metallic specular 0.32 roughness 0.135 }
	}

#declare GratedFloorTex =
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.2 rgb<0.575,0.592,0.547> ]
				[ 0.2 rgbf<0.575,0.592,0.547,1.0> ]
			}
			scale 4
		}
		finish { metallic specular 0.32 roughness 0.135 }
	}

#declare CGrayTex =
	texture {
		pigment { rgb<0.575,0.592,0.547> }
		finish { metallic specular 0.32 roughness 0.135 }
	}

//===============================================
//             Macros
//===============================================

#macro Railing(Length)
	union {
		cylinder { <0,0,0>,<Length,0,0>,1.6 translate <0,0,39> }
		cylinder { <0,0,0>,<Length,0,0>,1.2 scale <1,1,.25> translate <0,0,14> }
		cylinder { <0,0,0>,<Length,0,0>,1.2 scale <1,1,.25> translate <0,0,28> }
		#local N=0;
		#while ( N < Length )
			cylinder { <0,0,0>,<0,0,39>,1.2
				translate <N,0,0>
			}
			#local N = N + 60;
		#end
		cylinder { // end post
			<0,0,0>,<0,0,39>,1.2
			translate <Length,0,0>
		}
		texture { CatwalkTex }
	} // end union
#end

#macro Catwalk(Length,Width,OpeningStart,OpeningLength)
	union {
		box { <0,0,-8>,<Length,4,-0.3> }
		box { <0,0,-8>,<Length,4,-0.3> translate <0,Width-4,0> }
		box { <0,0,-8>,<4,Width,-0.3> }
		box { <0,0,-8>,<4,Width,-0.3> translate <Length-4,0,0> }
		box { // floor
			<0,0,-2>,<Length,Width,0>
			texture { GratedFloorTex }
		}
		object { Railing(OpeningStart-3) translate <3,3,0> }
		object { Railing(Length-OpeningStart-OpeningLength-3) translate <OpeningStart+OpeningLength,3,0> }
		object { Railing(Length-6) translate <3,Width-3,0> }
		object { Railing(Width-6) rotate z*90 translate <3,3,0> }
		object { Railing(Width-6) rotate z*90 translate <Length-3,3,0> }
		texture { CatwalkTex }
	} // end union
#end

#macro I_Beam(Height,Length)
	union {
		box { <0,-Height/7,0>,<Length,Height/7,0.5> }
		box { <0,-Height/7,0>,<Length,Height/7,0.5> translate <0,0,Height-0.5> }
		box { <0,-0.25,0>,<Length,0.25,Height-0.5> }
	} // end union
#end

#macro Stairs(Length,Width)
	#declare SAngle = 65;
	union {
		object { I_Beam(10,Length) translate <0,-Width/2,0> }
		object { I_Beam(10,Length) translate <0, Width/2,0> }
		#declare StepX = 0;
		#while ( StepX < Length )
			box { // step
				<0,-Width/2,-2>,<10,Width/2,0>
				texture { GratedFloorTex }
				rotate y*-SAngle
				translate <StepX,0,0>
			}
			#declare StepX = StepX + 16;
		#end
		// handrails
		box { <0,-0.7,0>,<1.4,0.7,40> rotate y*-SAngle translate <0,-Width/2,0> }
		box { <0,-0.7,0>,<1.4,0.7,40> rotate y*-SAngle translate <0, Width/2,0> }
		box { <0,-0.7,-0.4>,<10,0.7,0.3> translate <0,-Width/2,40> rotate y*-SAngle }
		box { <0,-0.7,-0.4>,<10,0.7,0.3> translate <0, Width/2,40> rotate y*-SAngle }

		box { <0,-0.7,-0.4>,<Length,0.7,0.3> rotate y*SAngle translate <0,-Width/2,36> rotate y*-SAngle translate <0,0,10.6> }
		box { <0,-0.7,-0.4>,<Length,0.7,0.3> rotate y*SAngle translate <0, Width/2,36> rotate y*-SAngle translate <0,0,10.6> }
		box { <0,-0.7,-6>,<1.4,0.7,36> rotate y*-SAngle translate <0,-Width/2,10> }
		box { <0,-0.7,-6>,<1.4,0.7,36> rotate y*-SAngle translate <0,Width/2,10> }
		box { <0,-0.7,-6>,<1.4,0.7,36> rotate y*-SAngle translate <Length/2,-Width/2,10> }
		box { <0,-0.7,-6>,<1.4,0.7,36> rotate y*-SAngle translate <Length/2,Width/2,10> }
		box { <0,-0.7,-6>,<1.4,0.7,36> rotate y*-SAngle translate <Length-2,-Width/2,10> }
		box { <0,-0.7,-6>,<1.4,0.7,36> rotate y*-SAngle translate <Length-2,Width/2,10> }

		rotate <0,SAngle,-90>
		translate <Width/2,0,0>
		texture { CatwalkTex }
	} // end union
#end

//===============================================
//             Objects
//===============================================



//===============================================
//             Groups
//===============================================


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings{ max_trace_level 10 }
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <4*Feet, -20*Feet, 25*Feet> // overall
		look_at <0*Feet,7*Feet,5*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb .4, rgb .3 } scale 10 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }

object { Catwalk(18*Feet,8*Feet,40,30) scale 1 rotate z*40 translate <-80,0,60> }
object { Stairs(10*Feet,30) translate <40,0,0> rotate z*40 translate <-80,0,60> }
object { Stairs(10*Feet,30) translate <40,0,0> rotate z*90 translate <2*Feet,1*Feet,10*Feet> }

#end
