
// POV-Ray Object File - Light Fixtures
// created 26-Jun-03
// last update 27-Jun-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// CeilingLightShape
// CeilingLight
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Light fixture origin is at the center of the main light source


#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#declare AreaSun = 0; // 0=normal light, 1=area light for the sun
	#include "GIncludeRH.inc" // uncomment for testing only
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================




//===============================================
//             Variables
//===============================================

#declare CPR = 0.9/2; // CopperPipeRadius

//===============================================
//             Textures
//===============================================

#declare EmittingWhiteTex =
	texture {
		pigment { color rgb<0.575,0.592,0.547>*1.00 }
		finish { ambient 30 specular 0.82 roughness 0.013 }
	}

#declare DarkMetalTex =
	texture {
		pigment { color rgb<0.672,0.592,0.247>*.13 }
		finish { metallic specular 0.92 roughness 0.035 }
	}

#declare OldBrassTex =
	texture {
//		pigment { color rgb<0.575,0.592,0.547>*1.00 }
		pigment {
			granite
			color_map {
				[ 0.0 rgb<0.775,0.632,0.347> ]
				[ 0.4 rgb<0.333,0.214,0.237> ]
				[ 0.7 rgb<0.103,0.014,0.006> ]
			}
			scale 2
		}
		finish { metallic specular 0.32 roughness 0.135 }
	}
#declare DarkWoodTex =
	texture {
		pigment { color rgb<0.435,0.347,0.187>*0.35 }
		normal { bumps 0.4 scale <1,1,20> }
		finish {  specular 0.22 roughness 0.235 }
	}
#declare GreyPaint =
	texture {
		pigment { color rgb<0.672,0.692,0.747>*.83 }
		finish { specular 0.72 roughness 0.052 }
	}
#declare SafetyYellowTex =
	texture {
		pigment { color rgb <0.945,0.679,0.129> } // industrial yellow
		finish { metallic specular 0.32 roughness 0.135 }
	}
#declare CeramicWhiteTex =
	texture {
		pigment { color rgb <0.945,0.979,0.929> }
		finish { metallic specular 0.32 roughness 0.135 }
	}



#declare BrightChrome =
	texture {
		pigment { color rgb<0.835,0.892,0.987>*0.26 }
//		pigment { color rgb<.5,.5,1> }
		finish { brilliance 5 reflection 0.4 }
	}



//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

//---------------- Ceiling Light ----------------------

#declare CeilingLightShape =
	union {
		cylinder {
			<0,0,0>,<0,0,-2.2>,5.6
			texture { OldBrassTex }
		}
		box {
			<-2,-2,0>,<2,2,.1>
			texture { DarkMetalTex }
		}
		torus {
			5.6,.3
			rotate x*90
			texture { OldBrassTex }
		}
		difference {
			sphere {
				<0,0,0>,5
				scale <1,1,.72>
			}
			cylinder {
				<0,0,0>,<0,0,6>,8
			}
			texture { EmittingWhiteTex }
			translate <0,0,-2.3>
		} // end difference
		#declare BB = 0;
		#while ( BB < 360 )
			sphere {
				<0,0,0>,.3
				scale <1,1,1.3>
				translate <5.5,0,-2.4>
				rotate z*BB
				texture { EmittingWhiteTex }
			}
			#declare BB = BB + 8;
		#end
	} // end union

#declare CeilingLight =
	light_source { 
		<0*Feet,0*Feet,0*Feet>
		color rgb <0.820,0.863,0.761>*1.6
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <0,0,-1>
		radius 15
		falloff 40
		tightness 1
		#if (AreaSun=1)
			area_light <0,0,0.5>,<0,0.5,0>,4,4 adaptive 1 jitter circular orient
		#end
		looks_like { object { CeilingLightShape } }
	}

//---------------- Street Light ----------------------

#declare StreetLightShape =
	union {
		sphere_sweep {
			b_spline
			6,
			<0,4,0>,4.0,<0,0,0>,3.8,<0,-8,8>,3.3,<0,-24,16>,3.0,<0,-36,14>,2.8,<0,-44,10>,2.8
			translate <0,0,32*Feet-8>
			texture { GreyPaint }
		}
		sphere {
			<0,0,0>,6
			scale <.72,1.22,0.85>
			translate <0,-36,32*Feet+3>
			texture { GreyPaint }
		}
		sphere {
			<0,0,0>,6
			scale <.7,1.2,0.63>
			translate <0,-36,32*Feet>
			texture { EmittingWhiteTex }
		}
		translate <0,36,-32*Feet>
	} // end union

#declare StreetLight =
	union {
	light_source { 
		<0*Feet,0*Feet,0*Feet>
		color rgb <0.860,0.823,0.661>*3.6
		fade_distance 16*Feet
		fade_power 1
		spotlight
		point_at <0,0,-1>
		radius 25
		falloff 50
		tightness 1
		#if (AreaSun=1)
			area_light <0,0,0.5>,<0,0.5,0>,4,4 adaptive 1 jitter circular orient
		#end
		looks_like { object { StreetLightShape } }
	}
		cylinder { // main pole
			<0,0,-20*Feet>,<0,0,36*Feet>,4.8
			texture { DarkWoodTex }
		translate <0,36,-32*Feet>
		}
		box { // electrical
			<0,-8,0>,<6,8,20>
			translate <4.0,0,48>
			texture { GreyPaint }
		translate <0,36,-32*Feet>
		}
		cylinder { // conduit
			<0,0,-20*Feet>,<0,0,48>,1.82
			translate <7,0,0>
			texture { GreyPaint }
		translate <0,36,-32*Feet>
		}
	} // end union

#declare StreetLightUnlit =
	union {
		object { StreetLightShape }
		cylinder { // main pole
			<0,0,-20*Feet>,<0,0,36*Feet>,4.8
			texture { DarkWoodTex }
		translate <0,36,-32*Feet>
		}
		box { // electrical
			<0,-8,0>,<6,8,20>
			translate <4.0,0,48>
			texture { GreyPaint }
		translate <0,36,-32*Feet>
		}
		cylinder { // conduit
			<0,0,-20*Feet>,<0,0,48>,1.82
			translate <7,0,0>
			texture { GreyPaint }
		translate <0,36,-32*Feet>
		}
	} // end union

//---------------- Bare Bulb Light ----------------------

#declare BareBulbLightShape =
	union {
		cylinder {
			<0,0,-3>,<0,0,0>,3
			texture { SafetyYellowTex }
		}
		box {
			<-2,-1,0>,<2,1,.1>
			texture { DarkMetalTex }
		}
		cylinder {
			<0,0,-3>,<0,0,-5>,1.8
			texture { CeramicWhiteTex }
		}
		cone {
			<0,0,0>,.62,<0,0,-4.0>,1.4
			translate <0,0,-5>
			texture { EmittingWhiteTex }
		}
		sphere {
			<0,0,0>,1.6
			translate <0,0,-5-4>
			texture { EmittingWhiteTex }
		}
	} // end union

#declare BareBulbLight =
	light_source { 
		<0*Feet,0*Feet,0*Feet>
		color rgb <0.820,0.863,0.561>*1.7
		fade_distance 8*Feet
		fade_power 1
		spotlight
		point_at <0,0,-1>
		radius 16
		falloff 38
		tightness 1
		#if (AreaSun=1)
			area_light <0,0,0.5>,<0,0.5,0>,4,4 adaptive 1 jitter circular orient
		#end
		looks_like { object { BareBulbLightShape } }
	}

#macro BlankLight(Power)
	light_source { 
		<0*Feet,0*Feet,0*Feet>
		color rgb <0.820,0.863,0.561>*Power
		fade_distance 8*Feet
		fade_power 1
		#if (AreaSun=1)
			area_light <0,0,0.5>,<0,0.5,0>,4,4 adaptive 1 jitter circular orient
		#end
	}
#end


//===============================================
//             Groups
//===============================================


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings{ max_trace_level 10 }
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <4*Feet, -10*Feet, 5*Feet> // overall
		look_at <0*Feet,0,3*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 0.6
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb .4, rgb .3 } scale 10 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }
/*
object { CeilingLightShape scale 1 rotate x*0 translate <0,0,20> }
object { CeilingLightShape scale 1 rotate x*50 translate <20,0,20> }
object { CeilingLightShape scale 1 rotate x*-120 translate <-20,0,20> }
//object { CeilingLight scale 1 rotate x*0 translate <-0,0,60> }
object { StreetLightShape rotate z*0 translate <0,40,30> }
object { StreetLightShape rotate z*12 translate <-20,40,40> }
object { StreetLight rotate z*-92 translate <-80,80,30> }
object { StreetLight rotate z*20 translate <-10*Feet,40*Feet,32*Feet> }
object { StreetLight rotate z*120 translate <-20*Feet,40*Feet,32*Feet> }
*/
object { BareBulbLightShape scale 1 rotate x*0 translate <0,0,20> }
object { BareBulbLightShape scale 1 rotate x*50 translate <20,0,20> }
object { BareBulbLightShape scale 1 rotate x*-120 translate <-20,0,20> }

object { BareBulbLight scale 1 rotate x*0 translate <0,0,40> }

#end
