
// POV-Ray Object File - Piles
// created 11-Jun-03
// last update 11-Jun-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Piles.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
//
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc" // uncomment for testing only
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================




//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================


#declare PileTex =
	texture {
		pigment { 
			granite
			color_map {
				[ 0.0 color rgb <0.663,0.310,0.192> ]
				[ 0.5 color rgb <0.663,0.310,0.192>*.2 ]
			}
			scale 6
		}
		finish { phong .13 phong_size 10 }
	}

//===============================================
//             Macros
//===============================================

#macro Pile(Seed,Components)
	blob {
		threshold 0.6
		#declare RS = seed(Seed);
		#declare N = 0;
		#while (N < Components)
			sphere { <0,0,0>,5+rand(RS)*15,1 translate <rand(RS)*40,rand(RS)*40,rand(RS)*40+N*1> }
			#declare N = N + 1;
		#end
		texture { PileTex }
	}
#end

//===============================================
//             Objects
//===============================================

#declare Pile1 =
	blob {
		threshold 0.6
		#declare RS = seed(20941);
		#declare N = 0;
		#while (N < 140)
			sphere { <0,0,0>,5+rand(RS)*15,1 translate <rand(RS)*40,rand(RS)*40,rand(RS)*40+N*1> }
			#declare N = N + 1;
		#end
		texture { PileTex }
	}


//===============================================
//             Groups
//===============================================


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings{ max_trace_level 10 }
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <4*Feet, -20*Feet, 5*Feet> // overall
		look_at <0*Feet,0,3*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb .4, rgb .3 } scale 10 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


object { Pile(10349,140) scale 1 rotate z*0 translate <0,0,10> }
#end
