
// POV-Ray Object File - Pumps and Valves
// created 27-Jun-03
// last update 27-Jun-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "PumpsValves.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// BigPump
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc" // uncomment for testing only
	#include "PipeGroup.inc"
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================




//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare PumpPaint =
	texture {
		pigment { color rgb<0.571,0.238,0.187>*1.00 }
		finish { metallic specular 0.72 roughness 0.100 }
	}
#declare ClearPig =
	pigment { color rgbt<1,1,1,1> }
#declare RustPig =
	pigment {
		bozo
		color_map {
			[ 0.3 rgb<0.571,0.238,0.187,1.00>*0.30 ]
			[ 0.5 rgbt<0.571,0.238,0.187,1.0> ]
		}
		scale 1
		scale 1/24
		turbulence 0.4
	}
#declare DirtyRustZ12 =
	texture {
		pigment {
			gradient z
			pigment_map {
				[ 0.2 RustPig ]
				[ 1.0 ClearPig ]
			}
			scale 24
		}
//		finish { specular 0.72 roughness 0.100 }
	}
#declare PumpTex =
	texture { PumpPaint }
	texture { DirtyRustZ12 }
//	texture { PumpPaint }
			


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare BigPump=
	union {

		cylinder { // main
			<10,0,0>,<28,0,0>,8
			translate <0,0,12>
		}
		cylinder { // left main
			<10,0,0>,<15,0,0>,8.5
			translate <0,0,12>
		}
		torus { // left end
			6,2.5
			rotate z*90
			translate <10,0,12>
		}
		torus { // right end
			6,2
			rotate z*90
			translate <28,0,12>
		}
		#declare V = 0;
		#while (V < 360)
			box {
				<-8,-9,-0.2>,<1,9,0.2>
				rotate x*V
				translate <30,0,12>
			}
			#declare V = V + 40;
		#end
		superellipsoid { // base
			<.3,.3>
			scale <20,10,4>
			translate <12,0,-1>
		}
		box { // base center
			<14,-6,0>,<30-6,4,8>
		}
		box { // support
			<0,-8,0><2.2,8,12>
			translate <11,0,0>
		}
		box { // support
			<0,-8,0><2.2,8,12>
			translate <21,0,0>
		}
		superellipsoid { // elec box
			<.13,.13>
			scale <4,2.5,4>
			translate <16,-8,12>
		}
		cylinder { // pump
			<-8,0,0>,<10,0,0>,6
			translate <0,0,12>
		}
		torus { // impeller
			6,3
			rotate z*90
			translate <-6,0,12>
		}
		cylinder { // inlet pipe
			<0,0,0>,<0,10,0>,3.4
			translate <-6,0,12-6>
		}
		cylinder { // outlet pipe
			<0,0,0>,<0,0,12>,3.4
			translate <-6,-6,12>
		}
		translate <6,6,0> // center at outlet pipe
		texture { PumpTex }
	} // end union


//===============================================
//             Groups
//===============================================


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings{ max_trace_level 10 }
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <4*Feet, -20*Feet, 5*Feet> // overall
		look_at <0*Feet,0,3*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb .4, rgb .3 } scale 10 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }

#declare BigPumpArray = array[6]
{<0,0,0>,<0,0,40>,<0,20,40>,<0,20,130>,<-50,20,130>,<-50,20,90> }

object { BigPump scale 1.0 rotate z*0 translate <0*Feet,0*Feet,0> }
object { PipeTrack(BigPumpArray,7,pigment{rgb<.45,.30,.28>}) translate <0,0,12> }

object { BigPump scale 1.0 rotate z*70 translate <5*Feet,-2*Feet,0> }
object { BigPump scale 1.0 rotate z*270 translate <-5*Feet,5*Feet,40> }
#end
