#version unofficial MegaPov 1.0;

#declare rope_color = color rgb <1, 0.92, 0.82>*1.5;

#declare rope_pattern =
pigment {
    marble
    scale 0.5*sqrt (2)
    rotate -45*z
    scale <1, 0.5, 1>
    color_map {
        [0    color rgb 0]
        [0.5  color rgb 0]
        [0.5  color rgb 1]
        [1    color rgb 1]
    }
}

#declare rope_tex =
texture {
    pigment {
        bozo
        scale <1, 10, 1>*0.005
        rotate -45*z
        scale <1, 2, 1>
        color_map {
            [0    rope_color]
            [0.5  rope_color*0.83]
            [1    rope_color*0.9]
        }
    }
    normal {
        pigment_pattern {rope_pattern}
        normal_map {
            [0
                average
                normal_map {
                    [
                        marble
                        scale 0.5*sqrt (2)
                        rotate -45*z
                        scale <1, 0.5, 1>
                        slope_map {
                            [0    <1, 0>]
                            [0.5  <0, -2>]
                            [0.5  <0, 2>]
                            [1    <1, 0>]
                        }
                    ]
                    [
                        marble 1.5
                        scale 0.05*sqrt (2)
                        rotate -45*z
                        scale <1, 2, 1>
                        slope_map {
                            [0    <0, 2>]
                            [0.5  <1, 0>]
                            [1    <0, -2>]
                        }
                    ]
                }
            ]
            [1
                average
                normal_map {
                    [
                        marble
                        scale 0.5*sqrt (2)
                        rotate -45*z
                        scale <1, 0.5, 1>
                        slope_map {
                            [0    <1, 0>]
                            [0.5  <0, -2>]
                            [0.5  <0, 2>]
                            [1    <1, 0>]
                        }
                    ]
                    [
                        marble 1.5
                        translate 0.25*x
                        scale 0.05*sqrt (2)
                        rotate -45*z
                        scale <1, 2, 1>
                        slope_map {
                            [0    <0, 2>]
                            [0.5  <1, 0>]
                            [1    <0, -2>]
                        }
                    ]
                }
            ]
        }
    }
}

#declare rope_radius = 0.015;
#declare rope_acc0 = 20;
#declare rope_acc1 = 20;
#declare rope_gap = 0.0025;
#declare rope_add_length = 0.475;

#declare rope_spirals = ceil ((-stones_hole_depth-rope_add_length+wooden_part1_height+lawn_alt)/(2*pi*(wooden_part6_radius+rope_radius)));

#declare rope_spiral =
mesh {
    #local I = 0;
    #local I_c = rope_acc0;
    #while (I < I_c)
        #local II = 0;
        #local II_c = rope_acc1;
        #while (II < II_c)
            #local P0 = vrotate (vrotate (rope_radius*x, I/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*II/II_c*x)-(2*rope_radius+rope_gap)*II/II_c*x;
            #local P1 = vrotate (vrotate (rope_radius*x, (I+1)/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*II/II_c*x)-(2*rope_radius+rope_gap)*II/II_c*x;
            #local P2 = vrotate (vrotate (rope_radius*x, I/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*(II+1)/II_c*x)-(2*rope_radius+rope_gap)*(II+1)/II_c*x;
            #local P3 = vrotate (vrotate (rope_radius*x, (I+1)/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*(II+1)/II_c*x)-(2*rope_radius+rope_gap)*(II+1)/II_c*x;
            #local N0 = vrotate (vrotate (x, I/I_c*360*y), 360*II/II_c*x);
            #local N1 = vrotate (vrotate (x, (I+1)/I_c*360*y), 360*II/II_c*x);
            #local N2 = vrotate (vrotate (x, I/I_c*360*y), 360*(II+1)/II_c*x);
            #local N3 = vrotate (vrotate (x, (I+1)/I_c*360*y), 360*(II+1)/II_c*x);
            smooth_triangle {P0, N0, P1, N1, P2, N2  uv_vectors  <I/I_c, II/II_c>, <(I+1)/I_c, II/II_c>, <I/I_c, (II+1)/II_c>}
            smooth_triangle {P1, N1, P2, N2, P3, N3  uv_vectors  <(I+1)/I_c, II/II_c>, <I/I_c, (II+1)/II_c>, <(I+1)/I_c, (II+1)/II_c>}
            #local II = II+1;
        #end
        #local I = I+1;
    #end
    texture {
        uv_mapping
        rope_tex
        scale <1, 0.25, 1>
    }
}

#declare rope_spiral0 =
mesh {
    #local I = 0;
    #local I_c = rope_acc0;
    #while (I < I_c)
        #local II = 0;
        #local II_c = rope_acc1;
        #while (II < II_c)
            #local P0 = vrotate (vrotate (rope_radius*x, I/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*II/II_c*x)-(2*rope_radius+rope_gap)*(1-sin ((II_c-II)/II_c*pi/2))*x;
            #local P1 = vrotate (vrotate (rope_radius*x, (I+1)/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*II/II_c*x)-(2*rope_radius+rope_gap)*(1-sin ((II_c-II)/II_c*pi/2))*x;
            #local P2 = vrotate (vrotate (rope_radius*x, I/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*(II+1)/II_c*x)-(2*rope_radius+rope_gap)*(1-sin ((II_c-(II+1))/II_c*pi/2))*x;
            #local P3 = vrotate (vrotate (rope_radius*x, (I+1)/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*(II+1)/II_c*x)-(2*rope_radius+rope_gap)*(1-sin ((II_c-(II+1))/II_c*pi/2))*x;
            #local N0 = vrotate (vrotate (x, I/I_c*360*y), 360*II/II_c*x);
            #local N1 = vrotate (vrotate (x, (I+1)/I_c*360*y), 360*II/II_c*x);
            #local N2 = vrotate (vrotate (x, I/I_c*360*y), 360*(II+1)/II_c*x);
            #local N3 = vrotate (vrotate (x, (I+1)/I_c*360*y), 360*(II+1)/II_c*x);
            smooth_triangle {P0, N0, P1, N1, P2, N2  uv_vectors  <I/I_c, II/II_c>, <(I+1)/I_c, II/II_c>, <I/I_c, (II+1)/II_c>}
            smooth_triangle {P1, N1, P2, N2, P3, N3  uv_vectors  <(I+1)/I_c, II/II_c>, <I/I_c, (II+1)/II_c>, <(I+1)/I_c, (II+1)/II_c>}
            #local II = II+1;
        #end
        #local I = I+1;
    #end
    texture {
        uv_mapping
        rope_tex
        scale <1, 0.25, 1>
    }
}

#declare rope_spiral1 =
mesh {
    #local I = 0;
    #local I_c = rope_acc0;
    #while (I < I_c)
        #local II = 0;
        #local II_c = rope_acc1;
        #while (II < II_c/2)
            #local P0 = vrotate (vrotate (rope_radius*x, I/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*II/II_c*x)-(2*rope_radius+rope_gap)*II/II_c*x;
            #local P1 = vrotate (vrotate (rope_radius*x, (I+1)/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*II/II_c*x)-(2*rope_radius+rope_gap)*II/II_c*x;
            #local P2 = vrotate (vrotate (rope_radius*x, I/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*(II+1)/II_c*x)-(2*rope_radius+rope_gap)*(II+1)/II_c*x;
            #local P3 = vrotate (vrotate (rope_radius*x, (I+1)/I_c*360*y)-(wooden_part6_radius+rope_radius)*z, 360*(II+1)/II_c*x)-(2*rope_radius+rope_gap)*(II+1)/II_c*x;
            #local N0 = vrotate (vrotate (x, I/I_c*360*y), 360*II/II_c*x);
            #local N1 = vrotate (vrotate (x, (I+1)/I_c*360*y), 360*II/II_c*x);
            #local N2 = vrotate (vrotate (x, I/I_c*360*y), 360*(II+1)/II_c*x);
            #local N3 = vrotate (vrotate (x, (I+1)/I_c*360*y), 360*(II+1)/II_c*x);
            smooth_triangle {P0, N0, P1, N1, P2, N2  uv_vectors  <I/I_c, II/II_c>, <(I+1)/I_c, II/II_c>, <I/I_c, (II+1)/II_c>}
            smooth_triangle {P1, N1, P2, N2, P3, N3  uv_vectors  <(I+1)/I_c, II/II_c>, <I/I_c, (II+1)/II_c>, <(I+1)/I_c, (II+1)/II_c>}
            #local II = II+1;
        #end
        #local I = I+1;
    #end
    texture {
        uv_mapping
        rope_tex
        scale <1, 0.25, 1>
    }
}

#declare rope_straight_part =
mesh {
    #local I = 0;
    #local I_c = rope_acc0;
    #while (I < I_c)
        #local P0 = vrotate (rope_radius*x, I/I_c*360*y)-(wooden_part6_radius+rope_radius)*z-rope_add_length*y;
        #local P1 = vrotate (rope_radius*x, (I+1)/I_c*360*y)-(wooden_part6_radius+rope_radius)*z-rope_add_length*y;
        #local P2 = vrotate (rope_radius*x, I/I_c*360*y)-(wooden_part6_radius+rope_radius)*z;
        #local P3 = vrotate (rope_radius*x, (I+1)/I_c*360*y)-(wooden_part6_radius+rope_radius)*z;
        #local N0 = vrotate (x, I/I_c*360*y);
        #local N1 = vrotate (x, (I+1)/I_c*360*y);
        #local N2 = N0;
        #local N3 = N1;
        #local uv_length = -rope_add_length/(2*pi*(wooden_part6_radius+2*rope_radius));
        smooth_triangle {P0, N0, P1, N1, P2, N2  uv_vectors  <I/I_c, uv_length>, <(I+1)/I_c, uv_length>, <I/I_c, 0>}
        smooth_triangle {P1, N1, P2, N2, P3, N3  uv_vectors  <(I+1)/I_c, uv_length>, <I/I_c, 0>, <(I+1)/I_c, 0>}
        #local I = I+1;
    #end
    texture {
        uv_mapping
        rope_tex
        scale <1, 0.25, 1>
    }
}

#declare rope =
union {
    union {
        #local I = 0;
        #local I_c = rope_spirals;
        #while (I < I_c)
            #if (I = 0)
                object {rope_spiral0  translate -(2*rope_radius+rope_gap)*I*x}
            #else
                #if (I = I_c-1)
                    object {rope_spiral1  translate -(2*rope_radius+rope_gap)*I*x}
                #else
                    object {rope_spiral  translate -(2*rope_radius+rope_gap)*I*x}
                #end
            #end
            #declare I = I+1;
        #end
        translate (wooden_part1_height+wooden_part1_width/2)*y
    }
    object {rope_straight_part
        translate (2*rope_radius+rope_gap)*(1-sin (pi/2))*x+(wooden_part1_height+wooden_part1_width/2)*y
    }
    object {wooden_stick
        scale <1, 2.65, 1>
        texture {dark_wood_tex
            rotate 90*x
            translate 100*rand (Z2)*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*z
            rotate 360*rand (Z2)*y
        }
        rotate (35-70)*x
        translate <-(2*rope_radius+rope_gap)*(I_c+0.2), wooden_part1_height+wooden_part1_width/2, 0>
    }
    translate (2*rope_radius+rope_gap)*I_c*0.2*x+lawn_alt*y
}

#declare bucket_parts = 12;
#declare bucket_min_radius = 0.12;
#declare bucket_max_radius = 0.15;
#declare bucket_height = 0.3;
#declare bucket_part_thickness = 0.0125;
#declare bucket_handle_height = bucket_max_radius+0.0095;

#declare bucket_part =
union {
    #local P0 = <bucket_min_radius, 0, -wooden_part_edge_sharpness>;
    #local P1 = vrotate (<bucket_min_radius, 0, wooden_part_edge_sharpness>, 1/bucket_parts*360*y);
    #local P2 = vrotate (<bucket_min_radius-bucket_part_thickness, 0, wooden_part_edge_sharpness>, 1/bucket_parts*360*y);
    #local P3 = <bucket_min_radius-bucket_part_thickness, 0, -wooden_part_edge_sharpness>;
    #local P4 = <bucket_max_radius, bucket_height, -wooden_part_edge_sharpness>;
    #local P5 = vrotate (<bucket_max_radius, bucket_height, wooden_part_edge_sharpness>, 1/bucket_parts*360*y);
    #local P6 = vrotate (<bucket_max_radius-bucket_part_thickness, bucket_height, wooden_part_edge_sharpness>, 1/bucket_parts*360*y);
    #local P7 = <bucket_max_radius-bucket_part_thickness, bucket_height, -wooden_part_edge_sharpness>;
    rounded_triangle (P0, P1, P4, 2*wooden_part_edge_sharpness)
    rounded_triangle (P1, P4, P5, 2*wooden_part_edge_sharpness)
    rounded_triangle (P2, P3, P6, 2*wooden_part_edge_sharpness)
    rounded_triangle (P3, P6, P7, 2*wooden_part_edge_sharpness)
    rounded_triangle (P4, P5, P7, 2*wooden_part_edge_sharpness)
    rounded_triangle (P5, P7, P6, 2*wooden_part_edge_sharpness)
}

#declare bucket_bottom =
union {
    #local I = 0;
    #local I_c = bucket_parts;
    #while (I < I_c)
        object {
            rounded_triangle (<0, 0, 0>, (bucket_min_radius-0.5*bucket_part_thickness)*x, vrotate ((bucket_min_radius-0.5*bucket_part_thickness)*x, 1/I_c*360*y), 2*wooden_part_edge_sharpness)
            rotate I/I_c*360*y
        }
        #declare I = I+1;
    #end
}

#declare dark_metal_mat =
material {
    texture {
        pigment {color rgb 0.7}
        finish {
            metallic
            diffuse 0.5
            brilliance 4.5
            specular 0.85
            roughness 0.1
            reflection {
                fresnel
                metallic
            }
        }
        normal {wrinkles 0.5  scale 0.001}
    }
    interior {ior 8}
}

#declare bucket_handle =
union {
    difference {
        torus {bucket_max_radius+0.0095, 0.008  rotate 90*x}
        plane {y, 0}
    }
    sphere {0, 0.013  scale <0.0095/0.013, 1, 1>  translate (bucket_max_radius+0.0095)*x}
    sphere {0, 0.013  scale <0.0095/0.013, 1, 1>  translate -(bucket_max_radius+0.0095)*x}
    rotate 0.5/bucket_parts*360*y
    translate (bucket_height-0.01)*y
}

#local Z0 = seed (16);

#declare bucket =
union {
    #local I = 0;
    #local I_c = bucket_parts;
    #while (I < I_c)
        object {bucket_part
            texture {dark_wood_tex
                rotate 90*x
                translate 100*rand (Z0)*y
                rotate (-3+6*rand (Z0))*x
                translate 0.15*rand (Z0)*z
                rotate 360*rand (Z0)*y
            }
            rotate I/I_c*360*y
        }
        #local I = I+1;
    #end
    object {bucket_bottom
        texture {dark_wood_tex
            translate 100*rand (Z0)*z+wooden_part1_width/2*y
            rotate (-3+6*rand (Z0))*x
            translate 0.15*rand (Z0)*y
            rotate 360*rand (Z0)*z
            rotate 360*rand (Z0)*y
        }
    }
    object {bucket_handle  material {dark_metal_mat}}
    translate (2*rope_radius+rope_gap)*(1-sin (pi/2))*x+(wooden_part1_height+wooden_part1_width/2)*y+
        (2*rope_radius+rope_gap)*I_c*0.2*x+lawn_alt*y-
        (wooden_part6_radius+rope_radius)*z-
        (bucket_height+rope_add_length+bucket_handle_height)*y
    rotate 14*y
}
