// Persistence of Vision Ray Tracer Include File
// File: 2roses.inc
// Vers: 3.5
// Desc: IRTC 2003/07 Contest (Surrealism)
// Date: 2003/08/09 - 2003/08/25
// Auth: Slawomir Szczyrba
//

//****************************************************************************
// Includes
//****************************************************************************
#include "colors.inc"    
#include "textures.inc"    
#include "functions.inc"    
#include "glass.inc"    
#include "metals.inc"    
#include "rad_def.inc"
#include "lightsys.inc" 
#include "lightsys_CIE-sRGB.inc"
#include "shapes.inc"

#include "roza.inc"
#include "listek0.inc"
#include "wazon.inc"
#include "woda1.inc"

//****************************************************************************
// Variables
//****************************************************************************
#declare BRIGHTNESS=1/300; 
#declare WHITE_POINT=Wp_Daylight_Film;//Wp_Indoor_Film;   // 3300K 
#declare COLOR_FILTER=<1,1,1>; // no correction           
#declare lm_test=Lm_Fluorescent_15w;
     
//#ifndef(Test) #local Test=no; #end      
              
#if (Test)
 #declare RadMode    = Radiosity_Fast;
 #declare KloszLampy = 12;
 #declare GestoscAtm = .009;
#else 
 #declare RadMode    = Radiosity_IndoorLQ;
 #declare KloszLampy = 7;
 #declare GestoscAtm = .0087;
#end

//****************************************************************************
// Materials
//****************************************************************************
#declare M_Glass=    // Glass material
material {
 texture {
  pigment {rgbt 1}
  finish {
   ambient 0.0
   diffuse 0.05
   specular 0.6
   roughness 0.005
   reflection { 0.1, 1.0 fresnel on }
   conserve_energy
  }
 }
 interior {
  ior 1.5
  fade_power 1001
  fade_distance 0.9
  fade_color <0.5,0.8,0.6>
 }
}

#declare M_MyWater = material {
 texture {
  pigment { color rgbf <.98,.98,1,.9> }
  finish {
   reflection {0.3, 1 fresnel}
   conserve_energy
  }
 } 
 interior { ior 1.33 }
}

//****************************************************************************
// Table
//****************************************************************************
#declare stolik = union {
difference { //blat stolika
 cylinder { 0,.007*y, .6 }
 plane {z,0}
 plane {x,0}
 material { 
  M_Glass
  texture  { 
   pigment { color rgb <0.209804, 0.184314, 0.184314> * .5 filter .35 } 
  }
 }
 photons { target refraction off reflection on }
}
union { // ramka i mocowanie stolika
difference { 
 lathe {
  linear_spline
  11,
  <0.593,      0>,
  <0.607,      0>,
  <0.607,  0.007>,
  <0.593,  0.007>,
  <0.593,  0.009>,
  <0.609,  0.009>,
  <0.611,  0.007>,
  <0.611,      0>,
  <0.609, -0.002>,
  <0.593, -0.002>,
  <0.593,      0>
 } 
 plane {z,0}
 plane {x,0}
} 
difference {
 superellipsoid {<.3,.3>}
 box { -2,2 scale y/3 translate <1.6,0,1.6> }
 scale <.011,.006,.011>
 translate <.004,.0035,.004>
}
difference {
 superellipsoid {<.3,.3>}
 box { -2,2 scale y/3 translate 1.6*z }
 scale <.011,.006,.011>
 translate <.5,.0035,.004>
}
difference {
 superellipsoid {<.3,.3>}
 box { -2,2 scale y/3 translate 1.6*x }
 scale <.011,.006,.011> 
 translate <.004,.0035,.5>
}
// texture { /*Brushed_*/Aluminum scale 1 }
 photons { target refraction off reflection on }  
// finish { ambient 1 }
 texture { T_Chrome_3D }
}
 translate <.007,0,.007>
}

#declare stolik0 = difference { //blat stolika
 cylinder { 0,.007*y, .6 }
 plane {z,0}
 plane {x,0}
 pigment { color rgb .7} 
}


//****************************************************************************
// Isosuface wall
//****************************************************************************
#declare isosciany = union {
 isosurface {
  function { f_rounded_box (x,y,z,0.1,1,1,1) + f_crackle(x*180,y*180,z*180)*.001 }
  contained_by { box { -1.1, 1.1 } }
  accuracy 0.001
  max_gradient 1.1
  translate <.5,0,-1>
 } 
 isosurface {
  function { f_rounded_box (x,y,z,.01,1,1,1) + f_crackle(x*180,y*180,z*180)*.001}
  contained_by { box { -1.1, 1.1 } }
  accuracy 0.001
  max_gradient 1.2
  translate <-1.005,0,1>
 }
 union {
  box { <10,0,10>, <20,10,-20> }
  box { <10,0,10>, <-20,10,20>}
  plane { y,0 double_illuminate hollow}
  plane {y,10 double_illuminate hollow pigment { color rgb 3} finish {ambient 150} no_reflection}
  pigment { color rgb 1} finish {ambient 20} normal { crackle .25 scale .01 }
  photons { collect off }
  hollow
  translate -y*5
 }
 pigment { color rgb 1 }
 finish {ambient 5}
 hollow
} 

//****************************************************************************
// Box wall
//****************************************************************************
#declare boxsciany = union {
 box { 0, <10,10,-10> }
 box { 0, <-10,10,10>}   
 union {
  box { <10,0,10>, <20,10,-20> 
  //uv_mapping pigment { image_map { jpeg "lazur.jpg" map_type 0 interpolate 2 once }}
  //finish {ambient 150}
  }
  box { <10,0,10>, <-20,10,20>
  //uv_mapping pigment { image_map { jpeg "lazur.jpg" map_type 0 interpolate 2 once }}
  //finish {ambient 150}
  }
  plane { y,0 double_illuminate hollow}
  plane {y,10 double_illuminate hollow pigment { color rgb 3} finish {ambient 150} no_reflection}
  photons { collect off }
 } 
 pigment { color rgb 1} finish {ambient 20} normal { crackle .25 scale .01 }
 hollow
 translate -y*5
} 
#if (Test) #declare sciany = boxsciany; #else #declare sciany = isosciany; #end

//****************************************************************************
// Light
//****************************************************************************
#declare swiatlo = light_source {
//Light(Cl_Extraterrestrial_Sun,lm_test,0,0,0,0,0)
 0 Light_Color(Cl_Extraterrestrial_Sun,lm_test)   
 #if (Test)
  area_light x*.02,y*.02,3,3
  adaptive 1
 #else
  area_light x*.02,y*.02,5,5
  adaptive 3
#end 
 orient
 circular
 jitter
 Light_Fading()
 photons { refraction on reflection on }
 media_attenuation on
 media_interaction on
} 

//****************************************************************************
// Lamp
//****************************************************************************
#declare lampa = union {
 #local dystans = .15;
 difference { //cylinder lampy
  cylinder { 0,y*.1,.015}
  cylinder { -y,y,.010}
  cylinder { -x,x,.0035 translate y*.09}
  cylinder { -z,z,.0035 translate y*.08}
//  cylinder { -x,x,.0035 translate y*.03}
//  cylinder { -z,z,.0035 translate y*.03}
  photons  { target reflection on refraction off }
  
 }
 union { // uchwyt lampy
  cylinder { -x*dystans, x*.03, .0025 translate y*.09 }
  cylinder { -z*dystans, z*.03, .0025 translate y*.08 }
  sphere { 0, .005 scale x*2 translate <.03,.09,0> }       
  sphere { 0, .005 scale z*2 translate <0,.08,.03> }       
  photons  { target reflection on refraction off }
  //photons { collect off }
 }  
 union { //uchwyt klosza
  #local dist = .06;
  cylinder { -x*dist, x*dist, .0025 translate y*.03 }
  cylinder { -z*dist, z*dist, .0025 translate y*.03 }
  sphere { 0, .005 scale x*2  translate <dist,.03,0> }       
  sphere { 0, .005 scale z*2  translate <0,.03,dist> }       
  sphere { 0, .005 scale x*2  translate <-dist,.03,0> }       
  sphere { 0, .005 scale z*2  translate <0,.03,-dist> }       
  photons  { target reflection on refraction off }
  //photons { collect off }
 }
 difference { // klosz
  torus { .04, .006 scale <0,10,0> }
//  cylinder {-x,x,.004 translate y*.03}
//  cylinder {-z,z,.004 translate y*.03}
  pigment {color rgb 1 transmit .8 }
  hollow
  interior {
   ior 1.44
   media {    // atmospheric media sample
    intervals 10
    emission KloszLampy
//    scattering { 3, .01 }
    samples 1, 10
    confidence 0.9999
    variance 1/1000
    ratio 0.9
   }
  }
//  finish { reflection 0 }
  photons  { /*target reflection off refraction on*/ collect off pass_through}
 } 
 light_source { swiatlo translate -y*.01 }
 
 union { //sznurek
  cylinder {0, -y*.3 ,.00049 pigment{color rgb 1 } finish {ambient 100} }
  sphere { 0, .007 translate -y*.3 texture { T_Chrome_3C } }
//  cylinder {0, -y*0.02 , .025 translate -y*.3 texture { T_Chrome_3C } }
  translate <0,0,-.015>
 } 
  
 difference { //mocowanie na scianie 1
  superellipsoid {<1,.3> scale <.01,.01,.003> }
  cylinder {-z,z,.004 translate y*.03}
  translate <0,.08,-dystans>
  photons  { target reflection on refraction on }
  //photons { collect off }
 }  
 difference { //mocowanie na scianie 2
  superellipsoid {<1,.3> scale <.01,.01,.003> }
  cylinder {-z,z,.004 translate y*.03}
  translate <0,.09,-dystans>
  rotate y*90
  photons  { target reflection on refraction on }
  //photons { collect off }
 }  
 texture { T_Chrome_4D finish {reflection 0.70}}
 translate <dystans,.06,dystans>
}                       

//****************************************************************************
// Atmosphere
//****************************************************************************
#declare atmosphere = box { -1, 11
 hollow
 pigment { color rgbt 1 }
 interior {
  media {
   intervals 10
   absorption GestoscAtm
 //  scattering { 3, .0001 extinction .5 }
   samples 1, 100
   confidence 0.9999
   variance 1/1000
   ratio 0.9
   method 3
  }
 }
}

//****************************************************************************
// Rose1
//****************************************************************************
#declare roza1 = union {
 #local I = 0;
 #local MAX = 7;
  #while ( I<MAX )
//   #debug concat("I =",str(I,2,0))
   object { platek0 rotate y*8 rotate x*32 translate x*2 rotate y*I*(360/MAX)}
   #local I = I + 1;  
  #end
 #local I = 0;
 #local MAX = 9;
 #while ( I<MAX )
//  #debug concat("I =",str(I,2,0))
  object { platek1 rotate y*80 rotate -z*5 translate <3.7,9,0> rotate y*I*(360/MAX) scale .6}
  #local I = I + 1;  
 #end
 #local I = 0;
 #local MAX = 9;
 #while ( I<MAX )
//  #debug concat("I =",str(I,2,0))
  object { platek1 rotate y*80 rotate -z*5 translate <3,17,0> rotate y*I*(360/MAX) scale .3 translate y*6}
  #local I = I + 1;  
 #end
 #local I = 0;
 #local MAX = 5;
 #while ( I<MAX )
//  #debug concat("I =",str(I,2,0))
  object { listek0 translate x*.2 rotate y*I*(360/MAX) scale 2 translate y*0}
  #local I = I + 1;  
 #end
 object { Round_Box_Union(<-.6,0,-.6>,<.6,-55,.6>,.35) rotate y*30 }
 translate y*55 
 scale .5
} 

//****************************************************************************
// Rose2
//****************************************************************************
#declare roza2 = union {
 #local I = 0;
 #local MAX = 7;
  #while ( I<MAX )
//   #debug concat("I =",str(I,2,0))
   object { platek0 rotate y*8 rotate x*32 translate x*2 rotate y*I*(360/MAX)}
   #local I = I + 1;  
  #end
 #local I = 0;
 #local MAX = 9;
 #while ( I<MAX )
//  #debug concat("I =",str(I,2,0))
  object { platek1 rotate y*80 rotate -z*5 translate <3.7,9,0> rotate y*I*(360/MAX) scale .6}
  #local I = I + 1;  
 #end
 #local I = 0;
 #local MAX = 9;
 #while ( I<MAX )
//  #debug concat("I =",str(I,2,0))
  object { platek1 rotate y*80 rotate -z*5 translate <3,17,0> rotate y*I*(360/MAX) scale .3 translate y*6}
  #local I = I + 1;  
 #end
 union {
  #local I = 0;
  #local MAX = 5;
  #while ( I<MAX )
//  #debug concat("I =",str(I,2,0))
   object { listek0 translate x*.2 rotate y*I*(360/MAX) scale 2 translate y*0}
   #local I = I + 1;  
  #end
  texture {
   pigment { color DarkGreen }
   finish { phong .7 phong_size .1 ambient 40}
  }
 }
 julia_fractal {
  <-0.083,0.0,-0.83,-0.025>
  quaternion
  sqr
  max_iteration 8
  precision 15  
  clipped_by { box {-.12 , .8 }}
  scale <40,.9,.9>      
  rotate z*90   
  rotate y*15      
  translate -y*20
  pigment { color ForestGreen }
  finish { phong .7 phong_size .1 ambient 40}
 }
 texture {
  pigment { color /*DustyRose*/  Red }
  finish { phong .2 phong_size .7 ambient 30}
 }
 rotate y*15 
 translate y*55 
 scale .5
} 

//****************************************************************************
// Clock
//****************************************************************************
 #local promien=.4;
 #local szerokosc=1;
 #local stopka_r=promien/2;
 #local stopka_h=promien/4;

#declare wyswietlacz = union {
 box { <-szerokosc*.8,0,-promien/4>, <szerokosc*.8,promien*5,promien/4> 
  material{M_Glass}
  photons { target reflection on refraction off }
 }
 difference { 
  box {<-szerokosc*.8,0,0>,<szerokosc*.8,promien*5,0.001> }
  box {<-szerokosc*.79,0.01,-1>,<szerokosc*.79,promien*5-.01,1> }
  pigment{color rgb 1}
 }
 union {
  text { ttf "crystal.ttf", "21:37",.001,0 scale <.56,1,.56> translate <-szerokosc*.7,promien*2.8,0>}
  text { ttf "crystal.ttf", "FRI 13",.001,0 scale .28 translate <-szerokosc*.7,promien*1.8,0>}
  text { ttf "crystal.ttf", "AUG 04",.001,0 scale .28 translate <-szerokosc*.7,promien*1.1,0>}
  no_shadow
  pigment { color rgb <.1,.1,.115>*3 filter .7}
  photons { target reflection on refraction on }
//  rotate y*180
 }
 rotate x*10 
} 
 
#declare zegar = union {
 //obudowa
 difference {
  cylinder { -szerokosc*x,szerokosc*x,promien}
  object {wyswietlacz}
 } 
 //stopki
 cylinder { -y*stopka_h,y*stopka_h, stopka_r translate <-szerokosc/2,-(promien-stopka_h/2),0> }
 cylinder { -y*stopka_h,y*stopka_h, stopka_r translate < szerokosc/2,-(promien-stopka_h/2),0> }
 //stopki2
 cylinder { -y*stopka_h,y*stopka_h, stopka_r translate <-szerokosc/2,-(promien-stopka_h/2),promien*3> }
 cylinder { -y*stopka_h,y*stopka_h, stopka_r translate < szerokosc/2,-(promien-stopka_h/2),promien*3> }
 //ramka
 cylinder { <-szerokosc/2,0,0>, <-szerokosc/2,-(promien-stopka_h/2),promien*3>, .03 }
 cylinder { < szerokosc/2,0,0>, < szerokosc/2,-(promien-stopka_h/2),promien*3>, .03 }
 cylinder { <-szerokosc/2,-(promien-stopka_h/2),promien*3>,< szerokosc/2,-(promien-stopka_h/2),promien*3>, .03 }
 object {wyswietlacz}
 translate y*(promien+stopka_h*2)
 photons { target reflection on refraction off }
 texture { T_Chrome_4D }
 rotate y*180 
//finish {reflection 0.70} 
 scale .6
}  

//****************************************************************************
// Klein bottle
//****************************************************************************
#declare klein = box { -.99,.99
  hollow              
  pigment { color rgbt 1 }
  interior {
   media { 
    aa_level 5
    aa_threshold 0.01
    method 3
    intervals 3
    samples 20,20
    emission rgb<0.1,0.95,0.1>*.9
    density { 
     density_file df3 "klein.df3" translate -.5 rotate -x*90 rotate y*105
     scale 2  
     color_map {
      [0.0  rgbf <0,0,0,1>]
      [1.0  rgb <1,1,1>*10]
     }
    }
   }
  }
  scale 1.2
 }
