#include "functions.inc"
#include "glass.inc"
#include "colors.inc"  
#include "shapes.inc"
#include "shapes2.inc"


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 4
  max_trace_level 4
  number_of_waves 10  
  

 
  
  

}


background { color rgb <0.0, 0.0, 0.0> }



#declare RoadTex1 = texture
      {
         crackle
         texture_map
         {
            [0.0   
               pigment
               {
                  color rgb <1.0, 0.9006667, 1.0>
               }               
               finish
               {
                  ambient 1
                  diffuse 0.009433
                  brilliance 0.145333
                  phong 0.0047
                  phong_size 0.89
                  specular 0.0047
               }
            ]
            [0.01  
               pigment
               {
                  color rgb <1.0, 0.9006667, 1.0>
               }               
               finish
               {
                  ambient 1
                  diffuse 0.009433
                  brilliance 0.145333
                  phong 0.0047
                  phong_size 0.89
                  specular 0.0047
               }
            ]
            [0.011 
               pigment
               {
                   color rgb <1.0, 1.0, 0.0>
               }               
               finish
               {
                  ambient 1
                  diffuse 0.009433
                  brilliance 0.145333
                  phong 0.0047
                  phong_size 0.89
                  specular 0.0047
               }
            ]
            [0.05  
               pigment
               {
                  color rgb <1.0, 1.0, 0.0>
               }               
               finish
               {
                  ambient 1
                  diffuse 0.009433
                  brilliance 0.145333
                  phong 0.0047
                  phong_size 0.89
                  specular 0.0047
               }
            ]
            [0.051 
               pigment
               {
                   color rgbt <1.0, 1.0, 0.0, 1.0>
               }               
               finish
               {
                  ambient 0.0
                  diffuse 0.009433
                  brilliance 0.145333
                  phong 0.0047
                  phong_size 0.89
                  specular 0.0047
               }
            ]
            [1.0   
               pigment
               {
                  color rgbt <1.0, 1.0, 0.0, 1.0>
               }               
               finish
               {
                  ambient 0.0
                  diffuse 0.009433
                  brilliance 0.145333
                  phong 0.0047
                  phong_size 0.89
                  specular 0.0047
               }
            ]

         }
         turbulence 0.2
         ramp_wave
      scale  2
      }   

   
#declare RoadTex = texture   {pigment{color rgb<1,1,0>} finish {ambient 0.8 diffuse 0.0 phong 1 phong_size 3 reflection 0}  }




#declare R=8;
#declare R1=R+0.01;
#declare Box = 0;
#declare globscale = 7;
#declare Earthscale = 7;
//camera { location  <0, 0, -90> look_at <0, 0, 0> angle 28}    


// fisheye lens for wide round field of view (up to 360 degrees)
camera {fisheye location <0,0,-50> look_at  <0,0,0> angle 360}


light_source {<-0,0,40> colour rgb 1}
light_source {<-0,0,-40> colour rgb 1}


#declare Earth = sphere {
  <0, 0, 0> // center of sphere <X Y Z>
  3       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling 
  
// texture pigment {} attribute
// create a texture that lays an image's colors onto a surface
// image maps into X-Y plane from <0,0,0> to <1,1,0>     
hollow
texture {pigment{
image_map {
  jpeg "bluemarble.jpg" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
  map_type 1        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
   once           // for no repetitive tiling

        }
}
finish {ambient 0.4 diffuse 0.6 phong 0 reflection 0.0}
} 
  

}



sphere {Earth
rotate <-60,0,0>
scale Earthscale
translate <0,100,0>
}

sphere {Earth
rotate <60,180,0>
scale Earthscale
translate <0,-100,0>
}

sphere {Earth
rotate <0,0,0>
scale Earthscale
translate <100,0,0>
}

sphere {Earth
rotate <0,180,0>
scale Earthscale
translate <-100,0,0>
}


sphere {Earth
rotate <0,0,0>
scale Earthscale
translate <0,0,-200>
}

sphere {Earth
rotate <0,0,0>
scale Earthscale
translate <0,0, 100>
}




//Astral Roads
#include "shapes_lo.inc"
#if (1)
// Ring_Sphere (R_major_H, R_major_V, R_minor_H, R_minor_V, Number_of_Rings_horizontal, Number_of_Rings_vertical)
object{Ring_Sphere  (10.00, 10.02, .15, .15, 6,6)   
//object{Ring_Sphere  (10.00, 10.02, 1, 1, 6,5) 
 //       texture {  pigment{color Black}
 //                 finish {ambient 0.7 diffuse 0.0 phong 0 reflection 0}
 //               } // end of texture
texture {RoadTex}


        scale <1,1,1>*10
        rotate<0,0,0> 
        translate<0,0,0>
      } // end of object -------------------------------------------------


// Mirrorsphere
//sphere { <0, 0, 0>, 140  
//        hollow
//        texture { pigment{color rgb<0,0,0>} finish {ambient 0.0 diffuse 0.0 phong 0 reflection 1}  } 
//        scale <1,1,1>                   
//      }




superellipsoid {
  <2.75,2.75>   
  hollow
  texture { pigment{color rgb<0,0,0>} finish {ambient 0.0 diffuse 0.0 phong 0 reflection 1}  } 
  scale <200,200,200> 
  rotate <-60,0,21>                      
}




#end



// -----------------------------------Begin Azathoth Body------------------------------------------------

//#declare F = function {f_ridged_mf(x,y,z,1,3,1,0.2,3,1)}   
//#declare F = function {f_ridged_mf(x,y,z,.01,3,3,0.2,6,1)}   //good one
//#declare F = function {f_ridged_mf(x,y/3,z/3,.01,3,3,.5,10,1)} 
#declare F = function {f_ridged_mf(x,y,z/3,.01,3,3,.5,10,1)} 
#declare S = function {f_sphere(x,y,z,5)}
#declare G = function {f_sphere(x,y,z,3)} 
#declare GAK = function{S(x,y,z) + 5*F(x,y,z-4)}  
#declare GAK1 = function{f_sphere(x,y,z,3) + 5*F(x,y,z-4)} 



#if (1)
isosurface {
  function {S(x,y,z) + 2*F(x,y,z+5)}
        max_gradient 8
        #if (Box=0)
           contained_by{sphere {0,R}}
        #else
          contained_by{box {<-R,-R,-0>,R}}
        #end        
        

  //      texture {T_Glass3}  
  //      interior {I_Glass}
  //      pigment {rgb 0.9}
  pigment { function {4*F(x,y,z+5)}
    color_map { [0.0 rgb <.5,0,.02>]  
                [0.2 rgb <.0,.4,.1>]
                [0.5 rgb <.2,.2,.2>]
                [1.0 rgb <.5,0,.2>]    }   
   } 
  
  


  
  
finish {ambient .25 phong 0.25 phong_size 10}       
  scale globscale 
}

#end
// -----------------------------------End Azathoth Body------------------------------------------------






#if (0)
      
// Lens

sphere {
  <0, 0, 0> 2.75 
  scale <1,1,.4>  
  
//scale<.1,.1,.1>

  translate <0,0,-1>
  scale globscale
  hollow    
     texture {T_Glass1}  
     interior {I_Glass}
}

// Iris
torus { 1.2, .8    
  scale<1,.3,1>
  rotate<90,0,0>   
  translate<0,0,-1>
  texture {RoadTex}  
    scale globscale
}

// 'Retina'
sphere {
  <0, 0, 0> 2.75 
  scale <1,1,.2>   
  pigment {rgb <0,0,0>} finish {ambient 0.0 phong 0.0 phong_size 0}    
    scale globscale
}


#end     





#if(0)
#declare F2 = function {f_ridged_mf(x,y,z,.01,3,3,.5,10,1)} 

// tentacle
isosurface{

  function{min( 
 f_sphere(x-0.011128, y, z-0.003930,0.308472) ,
 f_sphere(x+0.399983, y, z+0.992199,0.287810) ,
 f_sphere(x+0.989501, y, z+0.609757,0.231783) ,       
 f_sphere(x+1.594533, y, z+0.503029,0.148232) ,
 f_sphere(x+1.998481, y, z+0.393090,0.083651) ,
 f_sphere(x-0.007122, y, z+0.313400,0.278398) ,
 f_sphere(x+0.002807, y, z+0.660622,0.278398) ,
 f_sphere(x+0.136844, y, z+0.905385,0.284527) ,
 f_sphere(x+0.628317, y, z+0.865540,0.253839) ,
 f_sphere(x+0.807034, y, z+0.728928,0.239619) ,
 f_sphere(x+1.194254, y, z+0.541087,0.204379) ,
 f_sphere(x+1.382900, y, z+0.518318,0.156847) ,
 f_sphere(x+1.487152, y, z+0.512626,0.136461) ,
 f_sphere(x+1.695655, y, z+0.455704,0.115038) ,
 f_sphere(x+1.789978, y, z+0.427243,0.105623) ,
 f_sphere(x+1.884301, y, z+0.404475,0.097115) ,
 f_sphere(x+1.948838, y, z+0.393090,0.094108) ,
 f_sphere(x-0.007122, y, z+0.159712,0.293760) ,
 f_sphere(x-0.002158, y, z+0.489857,0.272132) ,
 f_sphere(x+0.042521, y, z+0.785850,0.244873) ,
 f_sphere(x+0.255989, y, z+0.985076,0.265774) ,
 f_sphere(x+0.514136, y, z+0.922462,0.258919) ,
 f_sphere(x+0.712711, y, z+0.791542,0.217551) ,
 f_sphere(x+0.891428, y, z+0.666314,0.197532) ,
 f_sphere(x+1.094967, y, z+0.569548,0.200114) ,
 f_sphere(x+1.303470, y, z+0.524010,0.177759) ,
 f_sphere(x+2.058054, y, z+0.376014,0.073195) ,
 f_sphere(x+2.122591, y, z+0.370322,0.057519)  ) - 0.2*F2((x+100),(y+100),(z+100))   } //             - 0.33*F2(x,y,z) 
  contained_by { sphere {<0,0,0>, 6 } }
  accuracy 0.003
  max_gradient 10    
#if (1)   
  texture{

    pigment { function {F2((x+100),(y+100),(z+100))}
    color_map { [0.0 rgb <.7,0,.2>]  
                [0.2 rgb <.2,.7,.2>]
                [0.5 rgb <.2,.2,.2>]
                [1.0 rgb <1,0,1>]
    } 
    

    
    }
 
 
//    pigment {rgb <1,1,0>}     finish {ambient .7}  }
    finish {ambient 0.3 diffuse 0.85 specular 0.2 phong 1}}     
#end

//  pigment {rgb <1,1,0>}     finish {ambient .7}   
  scale <7,3,3>
  rotate<180,-95,60>
  translate <-4,-2,0>
}


#end




