

/****************** decay.pov :: A scene of urban decay **********************************\
 *  for irtc ending oct 31 -
 *  topic: decay
 *  I see... urban... industrial... the vision is wavy...
 *  some sort of old building...
 *  a warehouse... no, a factory of some sort...
 *  reactor_x@hotmail.com
 
#declare miscellaneous_notes = 
notes{

	When rendering this scene, please note that it was done in 2 passes:
		The first pass used a smaller amount of light sources in the area light and had no
		window panes (layered transparent reflective textures slow things down a bit) and
		SAVED the radiosity data.
		
		The second (and final pass) had all scene elements, including atmosphere and LOADED
		the radiosity data.  You can let it take samples (I do) or you can set the
		start and end pre_trace to 1.
		
		High quality area lights interacting with media is very slow and is not done here,
		rather a low quality, low intensity light is used for media interaction.  I wanted
		to have a variable density for the dust (in source below), but it was too slow.
		
		Window panes are in the source, but I had to comment them out to make it finish
		before the deadline.
		
		There are area light artifacts that can be fixed by a larger number of light sources
		or a higher adaptive setting.
		
		This image has the dubious distinction of being created by someone while deployed in
		Iraq.  Since I don't have a laptop (yet!), it was mad on a borrowed laptop that
		was used only when I had time while it's owner wasn't using it.  When I get mine
		(soon), I am going to enter the next contest.
}

#declare which_settings =
settings{
//build radiosity data (no window panes, no atmosphere, 1 low light source area light):
  radiosity {
    pretrace_start		0.100
    pretrace_end		0.002
    count				60          
    nearest_count		20   
    error_bound			0.25  
    recursion_limit		4  
    low_error_factor	0.40
    gray_threshold		0.0 
    minimum_reuse		0.002
    brightness			0.15    
    adc_bailout			0.01/2
	save_file			"dfinal.rad"
    always_sample on
    	}
    	
command line: +q9 +w1000 +h600 -a0.2

// final (load radiosity data, atmosphere, window panes, aa, use all area lights with higher light source amount)
radiosity {
    pretrace_start	1.00
    pretrace_end	1.00
    brightness		0.15 
    adc_bailout 0.01/2
	load_file "dfinal.rad"
    always_sample on           // turn sampling in final trace off [on]
		}

command line: +q9 +w1000 +h600 +a0.2
	


}

#declare other_sidenotes =
notes{

-- 11 Oct 2003 - so the scene is almost going nearly as well as I'd expected, and I haven't
   run out of time.
   Yet.

-- 18 Oct 2003 - Discovered during viewing of test images that the scene has no over head
	light objects.  Adding more would require radiosity data to be recomputed, etc. etc.
	Still trying to work the window pane issue.

-- 23 Oct 2003 - Trying keyword 'no_shadow' for window panes.  This will result in a
	very inaccurate effect (uniform shadows on the wall) but it should decrease the render
	time enough for me to allow window panes.
-- Changing 'no_shadow' to light groups, using a low quality area light for the window panes.
-- Light groups are not behaving as expected (shadows still cast from other light sources),
	further tinkering required.

-- 24 Oct 2003 - Resorted to leaving window panes out during pre-trace for radiosity, will add
	them during final pass.
-- 30 Oct 2003 - Out of time and unable to finish the final render.  Will have to submit a
	test image.

//-----------------------------------------------------------------------------------------\\
Please note:

  If you render the source, you will not get the exact image submitted.  The image was made
  with this source file, however the radiosity and media parameters, the light sources, and
  the window panes are different as the image submitted was an earlier version.  The way this
  image was intended cannot be submitted due to time constraints.
  
Gamma:
  The gamma is a best guess, this was created on a laptop as I have no access to a machine
  with a CRT.

Radiosity:
  The saved radiosity data was not included in the source kit, it's file size is <6.3 megabytes.
  
	}
*/


#local inch = 1/12;
#declare scene_ambient = 0;//<.3,.3,.3>;
#include "dtex.inc"
#local test_mode = off;
// used in global_settings, sets how many instances of waves/ripples to use


//#if(test_mode = off)
// radiosity (global illumination) settings
global_settings {
	assumed_gamma 1.22
	max_trace_level 8
//radiosity {
/*    pretrace_start		1
    pretrace_end		1
    brightness			0.225    
    always_sample		off
   	load_file			"d_final.rad"


    pretrace_start		0.080
    pretrace_end		0.010
    count				75          
    nearest_count		20   
    error_bound			0.25  
    recursion_limit		4  
    low_error_factor	0.20
    gray_threshold		0.0 
    minimum_reuse		0.00175
    brightness			0.325    
    adc_bailout			0.01/2
	load_file			"d_final.rad"
	save_file			"dfinal.rad"
		}
*/
}







// atmospheric media can be generated by adding a media statement
// to the scene not attached to any specific object... but it'd be slower
// media doesn't fill the whole room, either... just a portion.
box{ <-5.9,-1,-5.5>, <12,22,33>
pigment{ color rgbt 1 }
interior{
media {    // atmospheric media sample
	intervals 1
	scattering { 1, rgb <1,.975,.9> * .6 extinction 0 }
	method 3
	density{
		gradient x
		density_map{
			[0.00 wrinkles turbulence .4 scale <1/18.1,1,1> * 10
				color_map{
					[0.00 color rgb <1,1,1> * 1 ]
					[0.50 color rgb <1,1,1> * 1 ]
					[0.50 color rgb <1,1,1> * 0 ]
					[1.00 color rgb <1,1,1> * 0 ]
						} ]
			[0.50 wrinkles turbulence .4 scale <1/18.1,1,1> * 10
				color_map{
					[0.00 color rgb <1,1,1> * 1 ]
					[0.50 color rgb <1,1,1> * 1 ]
					[0.50 color rgb <1,1,1> * 0 ]
					[1.00 color rgb <1,1,1> * 0 ]
						} ]
			[0.50 color rgb <1,1,1> *	.1	]
			[0.70 color rgb <1,1,1> *	0	]
			[1.00 color rgb <1,1,1> *	0	]
				}
				scale <18.1,1,1>
				translate <-6,0,0>
			}
//	jitter 1
	samples 5,5
	confidence 0.9
	variance 1/10
	ratio 0.9
	}
}

hollow
}


//#end */









#macro smooth_prism(height1,height2,point_array,rad)

#local points = dimension_size(point_array,1);
#local counter = 0;
prism
{
	linear_sweep
	linear_spline
	height1, height2, points,
#while(counter < (points - 1) )
	point_array[counter],
#local counter = counter + 1;
#end
	point_array[points - 1]
}

#local counter = 0;
#while(counter < (points - 2) )
cylinder{ <point_array[counter].u,0,point_array[counter].v>, <point_array[counter+1].u,0,point_array[counter+1].v>, rad scale <1,height1/rad,1> }
sphere{ <point_array[counter].u,0,point_array[counter].v>, rad scale <1,height1/rad,1> }
#local counter = counter + 1;
#end
sphere{ <point_array[counter+1].u,0,point_array[counter+1].v>, rad scale <1,height1/rad,1> }

#end







#declare basic_gray =
texture{
pigment{ color rgb <.75,.75,.75> }
finish{ specular 0 roughness 1 ambient scene_ambient }

}



#declare basic_bronze =
texture{
pigment{ color rgb <.65,.6,.05> }
finish{ specular 0 roughness 1 ambient scene_ambient }

}


#declare basic_white =
texture{
pigment{ color rgb <1,1,1> }
finish{ specular 0 roughness 1 ambient scene_ambient }

}



#declare bright_white =
texture{
pigment{ color rgb <1,1,1> }
finish{ specular 0 roughness 1 diffuse 0 ambient 50 }

}








#local left_wall_object =
union{
box{ <-inch * 1.5,0,-5 * inch>, <inch * 1.5,20,5 * inch> }
cylinder{ <0,0,-5 * inch>, <0,20,-5 * inch>, inch scale <1.5,1,1> }
cylinder{ <0,0,5 * inch>, <0,20,5 * inch>, inch scale <1.5,1,1> }
}


#local horizontal_molding =
union
{
box{ <-inch/4,inch/8,-2.5>, <inch/4,-inch/8,2.5> }
box{ <-inch/8,inch/4,-2.5>, <inch/8,-inch/4,2.5> }
cylinder{ <-inch/8, inch/8,-2.5>, <-inch/8, inch/8,2.5>, inch/8 }
cylinder{ <-inch/8,-inch/8,-2.5>, <-inch/8,-inch/8,2.5>, inch/8 }
cylinder{ < inch/8, inch/8,-2.5>, < inch/8, inch/8,2.5>, inch/8 }
cylinder{ < inch/8,-inch/8,-2.5>, < inch/8,-inch/8,2.5>, inch/8 }
}


#local vertical_molding =
union
{
box{ <-inch/4,0,inch/8>, <inch/4,5,-inch/8> }
box{ <-inch/8,0,inch/4>, <inch/8,5,-inch/4> }

cylinder{ <-inch/8,0, inch/8>, <-inch/8,5, inch/8>, inch/8 }
cylinder{ <-inch/8,0,-inch/8>, <-inch/8,5,-inch/8>, inch/8 }
cylinder{ < inch/8,0, inch/8>, < inch/8,5, inch/8>, inch/8 }
cylinder{ < inch/8,0,-inch/8>, < inch/8,5,-inch/8>, inch/8 }
}




#local vertical_molding1 =
union
{
box{ <-inch/4,0,inch/8>, <inch/4,3,-inch/8> }
box{ <-inch/8,0,inch/4>, <inch/8,3,-inch/4> }

cylinder{ <-inch/8,0, inch/8>, <-inch/8,3, inch/8>, inch/8 }
cylinder{ <-inch/8,0,-inch/8>, <-inch/8,3,-inch/8>, inch/8 }
cylinder{ < inch/8,0, inch/8>, < inch/8,3, inch/8>, inch/8 }
cylinder{ < inch/8,0,-inch/8>, < inch/8,3,-inch/8>, inch/8 }
}



#local vertical_molding2 =
union
{
box{ <-inch/4,3,inch/8>, <inch/4,5,-inch/8> }
box{ <-inch/8,3,inch/4>, <inch/8,5,-inch/4> }

cylinder{ <-inch/8,3, inch/8>, <-inch/8,5, inch/8>, inch/8 }
cylinder{ <-inch/8,3,-inch/8>, <-inch/8,5,-inch/8>, inch/8 }
cylinder{ < inch/8,3, inch/8>, < inch/8,5, inch/8>, inch/8 }
cylinder{ < inch/8,3,-inch/8>, < inch/8,5,-inch/8>, inch/8 }
}





#local window_top =
union // window is 6 x 5
{
// molding

object{ horizontal_molding translate <0,0 + 1 * 4,0> }
object{ horizontal_molding translate <0,0 + 1 * 3,0> }
object{ horizontal_molding translate <0,inch/4 + 1 * 3,0> }
object{ horizontal_molding translate <0,inch/2 + 1 * 3,0> }
object{ horizontal_molding translate <0,-inch/4 + 1 * 3,0> }
object{ horizontal_molding translate <0,-inch/2 + 1 * 3,0> }

object{ vertical_molding2 translate <0,0,-2.5 + 5/6 * 0> }
object{ vertical_molding2 translate <0,0,-2.5 + 5/6 * 1> }
object{ vertical_molding2 translate <0,0,-2.5 + 5/6 * 2> }
object{ vertical_molding2 translate <0,0,-2.5 + 5/6 * 3> }
object{ vertical_molding2 translate <0,0,-2.5 + 5/6 * 4> }
object{ vertical_molding2 translate <0,0,-2.5 + 5/6 * 5> }
object{ vertical_molding2 translate <0,0,-2.5 + 5/6 * 6> }

/*
union
{
#local counter = 3;
#while(counter < 5)
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 2 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 1 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 0 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-1 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-2 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-3 * 5/6> }
#local counter = counter + 1;
#end


texture{ glass }
texture{ layer_of_filth_01 }
texture{ layer_of_filth_02 }
}
*/



}

#local window_bottom =
union // lower part of window
{
object{ horizontal_molding translate <0,0 + 1 * 0,0> }
object{ horizontal_molding translate <0,0 + 1 * 1,0> }
object{ horizontal_molding translate <0,0 + 1 * 2,0> }
object{ horizontal_molding translate <0,0 + 1 * 3,0> }
object{ vertical_molding1 translate <0,0,-2.5 + 5/6 * 0> }
object{ vertical_molding1 translate <0,0,-2.5 + 5/6 * 1> }
object{ vertical_molding1 translate <0,0,-2.5 + 5/6 * 2> }
object{ vertical_molding1 translate <0,0,-2.5 + 5/6 * 3> }
object{ vertical_molding1 translate <0,0,-2.5 + 5/6 * 4> }
object{ vertical_molding1 translate <0,0,-2.5 + 5/6 * 5> }
object{ vertical_molding1 translate <0,0,-2.5 + 5/6 * 6> }

/*
union
{

#local counter = 0;
#while(counter < 3)
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 2 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 1 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 0 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-1 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-2 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-3 * 5/6> }
#local counter = counter + 1;
#end

texture{ glass }
texture{ layer_of_filth_01 }
texture{ layer_of_filth_02 }
}

*/
texture{ basic_white }
// panes

translate <0,0,0>
}


#local top_panes =
union
{
#local counter = 3;
#while(counter < 5)
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 2 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 1 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 0 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-1 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-2 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-3 * 5/6> }
#local counter = counter + 1;
#end
texture{ glass }
texture{ layer_of_filth_01 }
texture{ layer_of_filth_02 }
}




#local bottom_panes =
union
{
#local counter = 0;
#while(counter < 3)
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 2 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 1 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter, 0 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-1 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-2 * 5/6> }
box{ <-1/16*inch,0,0>, <1/16*inch,1,5/6> translate <0,counter,-3 * 5/6> }
#local counter = counter + 1;
#end

texture{ glass }
texture{ layer_of_filth_01 }
texture{ layer_of_filth_02 }
}


//breaker box

#local breaker_box =
union
{

difference
{
box{ <-8,-10,-2>*inch, <8,12,2>*inch }
box{ <-5.5, -8,-3>*inch, <5.5, 8,1>*inch }
}

// door
union
{
box{ <-5.4,-7.9,-2>*inch, <5.4,8.9,-1.875>*inch }
cylinder{ <-4*inch,2*inch,-1.85*inch>, <-4*inch,2*inch,-2.1*inch>, 1/3*inch texture{ old_black_paint } }
cylinder{ <-4*inch,1*inch,-1.85*inch>, <-4*inch,1*inch,-2.1*inch>, 1/3*inch texture{ old_black_paint } }
box{ <-1/3*inch,1*inch,-2.1*inch>, <1/3*inch,2*inch,1.85*inch> texture{ old_black_paint } translate <-4*inch,0,0> }

translate <-5.9*inch,0,0> rotate <0,-32,0> translate <5.9*inch,0,0> 
}

// pipes (vertical)
cylinder{ <0,-9*inch,0>, <0,-5.1,0> inch translate <-3,0,-1>*inch }
cylinder{ <0,-9*inch,0>, <0,-5.1,0> 1/2*inch translate < 0,0,-1>*inch }
cylinder{ <0,-9*inch,0>, <0,-5.1,0> 1/2*inch translate < 3,0,-1>*inch }
// (horizontal)
cylinder{ <7,1,0>*inch, <3,1*inch,0*inch> inch translate <0,0,0> }


texture{ basic_gray }
translate <0,5,-inch>

}




#local water_tower =
union
{
// storage tank
sphere{ <0,0,0>, 1 clipped_by{ box{ <-1,0,-1>, <1,1,1> } } scale <25,20,25> * 1.25 }
sphere{ <0,0,0>, 1 clipped_by{ box{ <-1,-1,-1>, <1,0,1> } } scale <25,13,25>*1.25 translate <0,-10,0> }
cylinder{ <0,0,0>, <0,-10,0>, 25*1.25 }

// catwalk
torus{ (25*1.25+1), 1*inch translate <0,-2,0> }
torus{ (25*1.25+2), 1*inch translate <0,-2,0> }
torus{ (25*1.25+3), 1*inch translate <0,-2,0> }
torus{ (25*1.25+4), 1*inch translate <0,-2,0> }
#local counter = 0;
#while(counter<360)
cylinder{ <0,0,25*1.25>, <0,0,25*1.25+4>, inch/2 rotate <0,counter,0> translate <0,-2+1/2*inch,0> }
#local counter = counter+1;
#end
// railing
torus{ (25*1.25+4), 1*inch translate <0,1.25,0> }
#local counter = 0;
#while(counter<360)
cylinder{ <0,-2,25*1.25+4>, <0,1.25,25*1.25+4>, inch/1 rotate <0,counter,0> }
#local counter = counter+20;
#end

// ladder and railings

torus{ 25*1.25, 3*inch rotate <90,0,0> clipped_by{ box{ <-40,1,-1>, <0,40,1> } } scale <1,4/5,1> translate <-2,2,-1> rotate <0,-35,0> }
torus{ 25*1.25, 3*inch rotate <90,0,0> clipped_by{ box{ <-40,1,-1>, <0,40,1> } } scale <1,4/5,1> translate <-2,2, 1> rotate <0,-35,0> }

// struts
#local counter = 0;
#while(counter<360)
cone{ <0,0,0>, 8*inch, <0,-80,-5>, 10*inch translate <0,0,-25*1.25+1> rotate <0,counter,0> }

cylinder{ <0,-40,-25*1.25-1>, vrotate(<0,-10,-25*1.25>,<0,60,0>), 6*inch rotate <0,counter,0> }
cylinder{ <0,-10,-25*1.25>, vrotate(<0,-40,-25*1.25-1>,<0,60,0>), 6*inch rotate <0,counter,0> }

cylinder{ <0,-75,-25*1.25-4>, vrotate(<0,-40,-25*1.25-1>,<0,60,0>), 6*inch rotate <0,counter,0> }
cylinder{ <0,-40,-25*1.25-1>, vrotate(<0,-75,-25*1.25-4>,<0,60,0>), 6*inch rotate <0,counter,0> }

#local counter = counter + 60;
#end

torus{ 25*1.25+.5, 4*inch translate <0,-40,0> }



translate <0,80,0>

}




#local pipe_holder =
union
{
box{ <-7.5 * inch,0,-inch>, <7.5*inch,-1/4 *inch,inch> }
box{ <-7.5 * inch,0,-1/8*inch>, <7.5*inch,-1/4 *inch,1/8*inch> }
box{ <-7.5 * inch,0,-1/8*inch + 7/8*inch>, <7.5*inch,-1/4 *inch,1/8*inch + 7/8*inch> }
box{ <-7.5 * inch,0,-1/8*inch - 7/8*inch>, <7.5*inch,-1/4 *inch,1/8*inch - 7/8*inch> }

cylinder{ <-7.25*inch,0,0>, <-7.25*inch,1/2*inch,0>, 1/2*inch }
cylinder{ < 7.25*inch,0,0>, < 7.25*inch,1/2*inch,0>, 1/2*inch }
cylinder{ <-7.25*inch,0,0>, <-7.25*inch,1 * inch,0>, 1/4*inch }
cylinder{ < 7.25*inch,0,0>, < 7.25*inch,1 * inch,0>, 1/4*inch }
cylinder{ <-7.25*inch,0,0>, <-7.25*inch,5,0>, 1/8*inch texture{ basic_white } }
cylinder{ < 7.25*inch,0,0>, < 7.25*inch,5,0>, 1/8*inch texture{ basic_white } }
texture{ basic_bronze }
}




#local pipe =
union
{
cylinder{ <0,0,0>, <0,0,15>, 1/2*inch }

cylinder{ <0,0,-1/2*inch>, <0,0,1/2*inch>, 3/4*inch texture{ basic_bronze } }
torus{ 1/2*inch, 1/4*inch rotate <90,0,0> translate <0,0,-1/2*inch> texture{ old_black_paint } }
torus{ 1/2*inch, 1/4*inch rotate <90,0,0> translate <0,0, 1/2*inch> texture{ old_black_paint } }
}





#local piping =
union
{
object{ pipe translate <-2 * inch - 1*inch,0,-1 - 0 * inch> }
object{ pipe translate <-1 * inch - 1/2*inch,0,-1 - 3 * inch> }
object{ pipe translate < 0 * inch + 0 * inch,0,-1 - 6 * inch> }
object{ pipe translate < 1 * inch + 1/2*inch,0,-1 - 9 * inch> }
object{ pipe translate < 2 * inch + 1*inch,0,-1 - 12 * inch> }
object{ pipe_holder translate <0,-inch,0> }
}


#local down_wall_pipe =
union
{
cylinder{ <0,0,0>, <0,-5,0>, 1/2*inch texture{ basic_white } }
// top elbow
torus{ 2*inch, 3/4*inch rotate <0,0,90> clipped_by{ box{ <-1.25*inch,0,0>, <1.25*inch,3.25*inch,3.25*inch> } } translate <0,0,-2*inch> }
torus{ 10/16*inch, 5/16*inch rotate <90,0,0> translate <0,2*inch,-7/3*inch> }
torus{ 3/4*inch, 3/16*inch rotate <00,0,0> translate <0,-1/3*inch,0> }
torus{ 3/4*inch, 3/16*inch rotate <90,0,0> translate <0,2*inch,-2*inch> }
torus{ 3/4*inch, 3/16*inch rotate <00,0,0> translate <0,0,0> }
cylinder{ <0,2*inch,-2*inch>, <0,2*inch,-7/3*inch>, 15/16*inch }
cylinder{ <0,0,0>, <0,-1/3*inch,0>, 15/16*inch }
//bottom elbow
union
{
torus{ 2*inch, 3/4*inch rotate <90,0,0> clipped_by{ box{ <-3.25*inch,-3.25*inch,-1.25*inch>, <0,0,1.25*inch> } } translate <2*inch,0,0> }
torus{ 3/4*inch, 3/16*inch rotate <0,0,00> translate <0,-1/3*inch,0> }
torus{ 3/4*inch, 3/16*inch rotate <0,0,00> translate <0,0,0> }
torus{ 3/4*inch, 3/16*inch rotate <0,0,90> translate <(2-1/3)*inch,-2*inch,0> }
torus{ 3/4*inch, 3/16*inch rotate <0,0,90> translate <2*inch,-2*inch,0> }
cylinder{ <(2-1/3)*inch,-2*inch,0>, <2*inch,-2*inch,0>, 15/16*inch }
cylinder{ <0,0,0>, <0,-1/3*inch,0>, 15/16*inch }

//gas cock
cylinder{ <2*inch,-2*inch,0>, <5.5*inch,-2*inch,0>, 1/2*inch texture{ basic_white } }
cone{ <5.5*inch,-2*inch,0>, 1/2*inch, <7.5*inch,-2*inch,0>, 1/4*inch texture{ basic_white } } 
cylinder{ <3*inch,-2*inch,0>, <5*inch,-2*inch,0>, 3/4*inch }
cylinder{ <4*inch,-2*inch,0>, <4*inch,-1*inch,0>, 1/3*inch }
cylinder{ <4*inch,-2*inch,0>, <4*inch,-1/2*inch,0>, 3/16*inch texture{ basic_white } }
sphere{ <4*inch,-1/2*inch,0>, 3/16*inch texture{ basic_white } }
polygon{ 5, <3.875,-1/2,0>*inch, <4,-1/8,0>*inch, <5.5,2/3,0>*inch, <5.5,-1/4,0>*inch, <3.875,-1/2,0>*inch }

translate <0,-5,0>
}




texture{ basic_bronze }
}


#local side_wall_pipe =
union
{
cylinder{ <0,2*inch,-2*inch>, <0,2*inch,10>, 1/2*inch }       
torus{ 1/2*inch, 1/4*inch rotate <90,0,0> translate <0,2*inch,-inch> }
torus{ 1/2*inch, 1/4*inch rotate <90,0,0> translate <0,2*inch, inch> }
cylinder{ <0,2*inch,-inch>, <0,2*inch,inch>, 3/4*inch }
translate <0,0,-10-2*inch>
}








#local prism1 = array[9]
{
	<0,0>, <0,-inch>, <3.5*inch,0>,
	<3*inch,3>, 	<3*inch,3+3*inch>,
	<3.5*inch,3.5>, <3*inch,3.5+1/4*inch>,
	<0,3.5>, <0,0>
}







#local prism2 = array[12]
{
	<0,-inch/4>, <1.75*inch,inch/4>, <3.5*inch,0>,
	<3.25*inch,8*inch>, <3.5*inch,3.5>, <2.75*inch,3.5>,
	<1.25*inch,3.5+3/4*inch>, <0,3.5+1/4*inch>,
	<0,3.5-3*inch>, <1/2*inch,2.5>, <-1/2*inch,1.5>, <0,-inch/4>
}



#local prism3 = array[9]
{
	<0,0>, <1/2*inch,0>, <3.5*inch,1/2*inch>,
	<3.25*inch,3*inch>, <3.5*inch,4*inch>, <3.25*inch,1.5>,
	<3.5*inch,3.5>, <0,3.5+inch>, <0,0>
}
	

#local prism4 = array[11]
{
	<1/2*inch,1/2*inch>, <1.5*inch,1/4*inch>, <3*inch,1/2*inch>,
	<3.5*inch,3/8*inch>, <3.25*inch,2*inch>, <3*inch,1.5>,
	<3.5*inch,3.5>, <0,3.5>, <1/4*inch,2.75>, <3/4*inch,1.5>,
	<1/2*inch,1/2*inch>
}



#local prism5 = array[8]
{
	<1/2*inch,1/2*inch>, <1.5*inch,1/4*inch>, <3*inch,1/2*inch>,
	<3.5*inch,3/8*inch>, <3.25*inch,2*inch>, <3*inch,1.5>,
	<3/4*inch,1.5>,	<1/2*inch,1/2*inch>
}




#local prism6 = array[6]
{
	<3/4*inch,1.5>, <3*inch,1.5>, <3.5*inch,3.5>,
	<0,3.5>, <1/4*inch,2.75>, <3/4*inch,1.5>,
}





#local old_junk_pallet1 =
union
{
union{ smooth_prism(-1/4*inch,1/4*inch,prism1,1/8*inch) scale <1,1,.75> * 1.5 translate < 0*inch,inch,0> }
union{ smooth_prism(-1/4*inch,1/4*inch,prism2,1/8*inch) scale <1,1,.75> * 1.5 translate < 8*inch,inch,0> }
union{ smooth_prism(-1/4*inch,1/4*inch,prism3,1/8*inch) scale <1,1,.75> * 1.5 translate <16*inch,inch,0> }
union{ smooth_prism(-1/4*inch,1/4*inch,prism4,1/8*inch) scale <1,1,.75> * 1.5 translate <24*inch,inch,0> }
union{ smooth_prism(-1/4*inch,1/4*inch,prism1,1/8*inch) scale <1,1,.75> * 1.5 translate <32*inch,inch,0> }

box{ <-2*inch,-inch,0>, <39.5*inch,inch,inch> translate <0,0,4*inch> }
box{ <-2*inch,-inch,0>, <39.5*inch,inch,inch> translate <0,0,9/8*3.5-4*inch> }

box{ <0,-1/4*inch,0>, <5*inch,1/4*inch,9/8*3.5> translate < 1*inch,-inch,0> }
box{ <0,-1/4*inch,0>, <5*inch,1/4*inch,9/8*3.5> translate <30*inch,-inch,0> }


texture{ basic_white }
translate <0,1.25*inch,0>
}






#local old_junk_pallet2 =
union
{
union{ smooth_prism(-1/4*inch,1/4*inch,prism3,1/8*inch) scale <1,1,.75> * 1.5 translate < 0*inch,inch,0> }
union{ smooth_prism(-1/4*inch,1/4*inch,prism4,1/8*inch) scale <1,1,.75> * 1.5 translate < 8*inch,inch,0> }
union{ smooth_prism(-1/4*inch,1/4*inch,prism2,1/8*inch) scale <1,1,.75> * 1.5 translate <16*inch,inch,0> }
union{ smooth_prism(-1/4*inch,1/4*inch,prism5,1/8*inch) scale <1,1,.75> * 1.5 translate <0,0,-4*inch> rotate <9,0,0> translate <24*inch,inch,4*inch> }
union{ smooth_prism(-1/4*inch,1/4*inch,prism6,1/8*inch) scale <1,1,.75> * 1.5 translate <0,0,-3.5+4*inch> rotate <-9,0,0> translate <24*inch,inch,3.5-4*inch> }
union{ smooth_prism(-1/4*inch,1/4*inch,prism1,1/8*inch) scale <1,1,.75> * 1.5 translate <32*inch,inch,0> }

box{ <-2*inch,-inch,0>, <39.5*inch,inch,inch> translate <0,0,4*inch> }
box{ <-2*inch,-inch,0>, <39.5*inch,inch,inch> translate <0,0,9/8*3.5-4*inch> }

box{ <0,-1/4*inch,0>, <5*inch,1/4*inch,9/8*3.5> translate < 1*inch,-inch,0> }
box{ <0,-1/4*inch,0>, <5*inch,1/4*inch,9/8*3.5> translate <30*inch,-inch,0> }


texture{ basic_white }
translate <0,1.25*inch,0>
}






#local old_junk_wood =
union
{
smooth_prism(-1/4*inch,1/4*inch,prism2,1/8*inch)
texture{ basic_white }
scale <1,1,.75> * 1.5
translate < 8*inch,1/4*inch,0>
}



#local old_paper =
polygon{ 5, <0,0,0>, <8.5*inch,0,0>, <8.5*inch,0,11*inch>, <0,0,11*inch>, <0,0,0> translate <0,.0001,0> }



#local old_junk_small_pipe =
union
{
cylinder{ <0,0,0>, <0,-2,0>, 1/2*inch texture{ basic_white } }
torus{ 2*inch, 3/4*inch rotate <0,0,90> clipped_by{ box{ <-1.25*inch,0,0>, <1.25*inch,3.25*inch,3.25*inch> } } translate <0,0,-2*inch> }
torus{ 10/16*inch, 5/16*inch rotate <90,0,0> translate <0,2*inch,-7/3*inch> }
torus{ 3/4*inch, 3/16*inch rotate <00,0,0> translate <0,-1/3*inch,0> }
torus{ 3/4*inch, 3/16*inch rotate <90,0,0> translate <0,2*inch,-2*inch> }
torus{ 3/4*inch, 3/16*inch rotate <00,0,0> translate <0,0,0> }
cylinder{ <0,2*inch,-2*inch>, <0,2*inch,-7/3*inch>, 15/16*inch }
cylinder{ <0,0,0>, <0,-1/3*inch,0>, 15/16*inch }
texture{ basic_bronze }
rotate <0,0,90>
translate <0,1/2*inch,0>
}

#local old_junk_large_pipe =
difference{
union
{
torus{ 1.25, 6*inch clipped_by{ box{ <0,-3,0>, <3,3,3> } } texture{ old_red_paint } }
cone{ <0,0,1.25>, 6*inch, <-6*inch,0,1.25>, 8*inch texture{ old_red_paint } }
cone{ <1.25,0,0>, 6*inch, <1.25,0,-6*inch>, 8*inch texture{ old_red_paint } }

cylinder{ <-6*inch,0,1.25>, <-7*inch,0,1.25>, 10*inch texture{ old_red_paint } }
cylinder{ <-5.5*inch,0,1.25>, <-7.5*inch,0,1.25>, 9.5*inch texture{ basic_white } }
torus{ 9.5*inch, .5*inch rotate <0,0,90> translate <-6*inch,0,1.25> texture{ old_red_paint } }
torus{ 9.5*inch, .5*inch rotate <0,0,90> translate <-7*inch,0,1.25> texture{ old_red_paint } }

cylinder{ <1.25,0,-7*inch>, <1.25,0,-6*inch>, 10*inch texture{ old_red_paint } }
cylinder{ <1.25,0,-7.5*inch>, <1.25,0,-5.5*inch>, 9.5*inch texture{ basic_white } }
torus{ 9.5*inch, .5*inch rotate <90,0,0> translate <1.25,0,-6*inch> texture{ old_red_paint } }
torus{ 9.5*inch, .5*inch rotate <90,0,0> translate <1.25,0,-7*inch> texture{ old_red_paint } }
}

cylinder{ <0,0,1.25>, <-1,0,1.25>, 5.5*inch }
cylinder{ <1.25,0,-1>, <1.25,0,0>, 5.5*inch }
cylinder{ <-5*inch,0,1.25>, <-1,0,1.25>, 6.5*inch }
cylinder{ <1.25,0,-1>, <1.25,0,-5*inch>, 6.5*inch }

cylinder{ <0,0,-8*inch>, <0,0,-5*inch>, 5/8*inch translate <8.25*inch,0,0> rotate <0,0,00>  translate <1.25,0,0> }
cylinder{ <0,0,-8*inch>, <0,0,-5*inch>, 5/8*inch translate <8.25*inch,0,0> rotate <0,0,45>  translate <1.25,0,0> }
cylinder{ <0,0,-8*inch>, <0,0,-5*inch>, 5/8*inch translate <8.25*inch,0,0> rotate <0,0,90>  translate <1.25,0,0> }
cylinder{ <0,0,-8*inch>, <0,0,-5*inch>, 5/8*inch translate <8.25*inch,0,0> rotate <0,0,135> translate <1.25,0,0> }
cylinder{ <0,0,-8*inch>, <0,0,-5*inch>, 5/8*inch translate <8.25*inch,0,0> rotate <0,0,180> translate <1.25,0,0> }
cylinder{ <0,0,-8*inch>, <0,0,-5*inch>, 5/8*inch translate <8.25*inch,0,0> rotate <0,0,225> translate <1.25,0,0> }
cylinder{ <0,0,-8*inch>, <0,0,-5*inch>, 5/8*inch translate <8.25*inch,0,0> rotate <0,0,270> translate <1.25,0,0> }
cylinder{ <0,0,-8*inch>, <0,0,-5*inch>, 5/8*inch translate <8.25*inch,0,0> rotate <0,0,315> translate <1.25,0,0> }
                                        
cylinder{ <-8*inch,0,0>, <-5*inch,0,0>, 5/8*inch translate <0,0,8.25*inch> rotate < 00,0,0> translate <0,0,1.25> }
cylinder{ <-8*inch,0,0>, <-5*inch,0,0>, 5/8*inch translate <0,0,8.25*inch> rotate < 45,0,0> translate <0,0,1.25> }
cylinder{ <-8*inch,0,0>, <-5*inch,0,0>, 5/8*inch translate <0,0,8.25*inch> rotate < 90,0,0> translate <0,0,1.25> }
cylinder{ <-8*inch,0,0>, <-5*inch,0,0>, 5/8*inch translate <0,0,8.25*inch> rotate <135,0,0> translate <0,0,1.25> }
cylinder{ <-8*inch,0,0>, <-5*inch,0,0>, 5/8*inch translate <0,0,8.25*inch> rotate <180,0,0> translate <0,0,1.25> }
cylinder{ <-8*inch,0,0>, <-5*inch,0,0>, 5/8*inch translate <0,0,8.25*inch> rotate <225,0,0> translate <0,0,1.25> }
cylinder{ <-8*inch,0,0>, <-5*inch,0,0>, 5/8*inch translate <0,0,8.25*inch> rotate <270,0,0> translate <0,0,1.25> }
cylinder{ <-8*inch,0,0>, <-5*inch,0,0>, 5/8*inch translate <0,0,8.25*inch> rotate <315,0,0> translate <0,0,1.25> }
texture{ old_black_paint }
}



// build the chair
#local chair =
union
{
// seat
superellipsoid{ <.5,.1> scale <.75,1/2*inch,.75> }

// chair back
intersection
{
difference
{
cylinder{ <0,-1,0>, <0,1,0>, 2 }
cylinder{ <0,-2,0>, <0,2,0>, 2-1*inch }
translate <0,0,-2>
}

union
{
cylinder{ <0,0,-5*inch>, <0,0,5*inch>, 1  scale <1,1/3,1> }
box{ <-1,2*inch-1/3,-5*inch>, <1,0,5*inch> }
box{ <2*inch-1,-1/3,-5*inch>, <1-2*inch,0,5*inch> }
cylinder{ < 2*inch-1,2*inch-1/3,-5*inch>, < 2*inch-1,2*inch-1/3, 5*inch>, 2*inch }
cylinder{ <-2*inch+1,2*inch-1/3,-5*inch>, <-2*inch+1,2*inch-1/3, 5*inch>, 2*inch }
}
translate <0,1.25,1.05>
}

union
{
// support (seat to back)
cylinder{ < .5,-inch,-.6>, < .5,-inch,.65>, 1/3*inch }
cylinder{ <-.5,-inch,-.6>, <-.5,-inch,.65>, 1/3*inch }
torus{ .5,1/3*inch rotate <0,0,90> clipped_by{ box{ <-1*inch,0,0>, <1*inch,-.75,.75> } } scale <1,1,.5> translate < .5,.5-inch,.65> }
torus{ .5,1/3*inch rotate <0,0,90> clipped_by{ box{ <-1*inch,0,0>, <1*inch,-.75,.75> } } scale <1,1,.5> translate <-.5,.5-inch,.65> }
cylinder{ < .5,.5-inch,.9>, < .45,1.35,1>, 1/3*inch }
cylinder{ <-.5,.5-inch,.9>, <-.45,1.35,1>, 1/3*inch }
// chair legs
torus{ .8, 1/3*inch rotate <90,0,0> clipped_by{ box{ <-1.5,0,-inch>, <1.5,1.5,inch> } } scale <1,5*inch,1> translate <0,-5*inch,-.6> }
cylinder{ <-.8,0,0>, <-.85,-.35,0>, 1/3*inch translate <0,-5*inch,-.6> }
cylinder{ <0.0,0,0>, <-.05,-1.15,0>, 1/3*inch rotate <-15,0,22> translate <.8,-5*inch,-.6> }
// bent leg
sphere{ <-.85,-.35,0> 1/3*inch translate <0,-5*inch,-.6> }
cylinder{ <0,-.35,0>, <0,-1.15,0>, 1/3*inch translate <0,.35,0> rotate <-3,0,15> translate <0,-.35,0> translate <-.85,-5*inch,-.6> }

torus{ .8, 1/3*inch rotate <90,0,0> clipped_by{ box{ <-1.5,0,-inch>, <1.5,1.5,inch> } } scale <1,5*inch,1> translate <0,-5*inch, .65> }
cylinder{ < .8,0,0>, < .85,-1.15,.15>, 1/3*inch translate <0,-5*inch, .65> }
cylinder{ <-.8,0,0>, <-.85,-1.15,.15>, 1/3*inch translate <0,-5*inch, .65> }

texture{ old_black_paint }
// texture{ old_black_paint }
}

texture{ basic_white }
}




union
{
object{ down_wall_pipe translate <0,0*inch,0.5> }
object{ down_wall_pipe translate <0,2*inch,6.5> }
object{ down_wall_pipe translate <0,4*inch,12.5> }
object{ down_wall_pipe translate <0,6*inch,18.5> }

object{ side_wall_pipe translate <0,0*inch,0.5> }
object{ side_wall_pipe translate <0,2*inch,6.5> }
object{ side_wall_pipe translate <0,4*inch,12.5> }
object{ side_wall_pipe translate <0,6*inch,18.5> }

object{ side_wall_pipe translate <0,2*inch,-3.5> }
object{ side_wall_pipe translate <0,4*inch,2.5> }
object{ side_wall_pipe translate <0,6*inch,8.5> }
object{ side_wall_pipe translate <0,6*inch,-1.5> }


texture{ basic_white }
translate <-6 + 3*inch,8+inch,0>
}




#local drawers =
// drawers
union
{
superellipsoid
{
	<0.1,0.1>
	scale <0.125,2.95*inch,1.5>
	translate <1.125,0,0>
	texture{ old_red_paint }
}

box{ <1.25,-1/2*inch,-2*inch>, <1.25+inch/2,1/2*inch,2*inch> texture{ old_black_paint } }
}

#local table =
union
{
box{ <-1.5-1.5*inch,3 - 1.5*inch, -5>, <1.5+1.5*inch,3 - 6*inch,12> }
box{ <-1.5,3 - 1.5*inch, -5-1.5*inch>, <1.5,3 - 6*inch,12+1.5*inch> }
box{ <-1.5-1.5*inch,3 - 1.5*inch, -5>, <1.5+1.5*inch,3 - 6*inch,12> }

box{ <-1.5,3 - 2*inch, -5-2*inch>, <1.5,3 - 6*inch,12+2*inch> }
box{ <-1.5-2*inch,3 - 2*inch, -5>, <1.5+2*inch,3 - 6*inch,12> }

cylinder{ <-1.5,3 - 2*inch,-5>, <-1.5,3 - 6*inch,-5>, 2*inch }
cylinder{ < 1.5,3 - 2*inch,-5>, < 1.5,3 - 6*inch,-5>, 2*inch }
cylinder{ <-1.5,3 - 2*inch,12>, <-1.5,3 - 6*inch,12>, 2*inch }
cylinder{ < 1.5,3 - 2*inch,12>, < 1.5,3 - 6*inch,12>, 2*inch }

cylinder{ <-1.5,3 - 1.5*inch,-5>, <-1.5,3 - 6*inch,-5>, 1.5*inch }
cylinder{ < 1.5,3 - 1.5*inch,-5>, < 1.5,3 - 6*inch,-5>, 1.5*inch }
cylinder{ <-1.5,3 - 1.5*inch,12>, <-1.5,3 - 6*inch,12>, 1.5*inch }
cylinder{ < 1.5,3 - 1.5*inch,12>, < 1.5,3 - 6*inch,12>, 1.5*inch }

torus{ 1.5 * inch, .5*inch translate <-1.5,3 - 2*inch,-5> }
torus{ 1.5 * inch, .5*inch translate < 1.5,3 - 2*inch,-5> }
torus{ 1.5 * inch, .5*inch translate <-1.5,3 - 2*inch,12> }
torus{ 1.5 * inch, .5*inch translate < 1.5,3 - 2*inch,12> }

cylinder{ <-1.5,3 - 2*inch,-5 -1.5*inch>, < 1.5,3 - 2*inch,-5 -1.5*inch>, .5*inch }
cylinder{ <-1.5 - 1.5*inch,3 - 2*inch,-5>, <-1.5 - 1.5*inch,3 - 2*inch,12>, .5*inch }
cylinder{ < 1.5 + 1.5*inch,3 - 2*inch,-5>, < 1.5 + 1.5*inch,3 - 2*inch,12>, .5*inch }
cylinder{ <-1.5,3 - 2*inch,12 +1.5*inch>, < 1.5,3 - 2*inch,12 +1.5*inch>, .5*inch }

// legs
box{ <-1.5,3 - 3*inch,-5>, <-1.5 + 3*inch,0,-5 + 3*inch> }
box{ < 1.5,3 - 3*inch,-5>, < 1.5 - 3*inch,0,-5 + 3*inch> }
box{ <-1.5,3 - 3*inch,12>, <-1.5 + 3*inch,0,12 - 3*inch> }
box{ < 1.5,3 - 3*inch,12>, < 1.5 - 3*inch,0,12 - 3*inch> }

box{ <-1.5,.75,-5>, < 1.5,.75 + 2*inch,-5 + 3*inch> }
box{ <-1.5,.75,12>, < 1.5,.75 + 2*inch,12 - 3*inch> }
box{ <-1.5,.75,-5>, <-1.5 + 2*inch,.75 + 2*inch,12> }


// drawers

box{ <-1.25,0,-1.5>, <1.0,2+5*inch,1.5> texture{ old_red_paint } translate <0,0,-3-1/2*inch> }
box{ <-1.25,0,-1.5>, <1.0,2+5*inch,1.5> texture{ old_red_paint } translate <0,0,0> }
object{ drawers translate <0, 3*inch,-3-1/2*inch> }
object{ drawers translate <0, 9*inch,-3-1/2*inch> }
object{ drawers translate <0,15*inch,-3-1/2*inch> }
object{ drawers translate <0,21*inch,-3-1/2*inch> }
object{ drawers translate <0,27*inch,-3-1/2*inch> }

object{ drawers translate <0, 3*inch,0> }
object{ drawers translate <0, 9*inch,0> }
object{ drawers translate <0,15*inch,0> }
object{ drawers translate <0,21*inch,0> }
object{ drawers translate <0,27*inch,0> }


//#if(test_mode)
//texture{ basic_white }
//#else
texture{ old_table_texture_01 }
texture{ old_table_texture_02 }
//#end
}




//left wall
union
{
// panels that run horizontally
box{ <-inch * 1.5,0,-15>, <inch * 1.5,3-inch,20> }
box{ <-inch * 1.5,8+inch,-15>, <inch * 1.5,9-inch,20> }
box{ <-inch * 1.5,14+inch,-15>, <inch *1.5,20,20> }
cylinder{ <0,3-inch,-15>, <0,3-inch,20>, inch scale <1.5,1,1> }
cylinder{ <0,8+inch,-15>, <0,8+inch,20>, inch scale <1.5,1,1> }
cylinder{ <0,9-inch,-15>, <0,9-inch,20>, inch scale <1.5,1,1> }
cylinder{ <0,14+inch,-15>, <0,14+inch,20>, inch scale <1.5,1,1> }

// vertical ones
object{ left_wall_object translate <0,0,-6.25> }
object{ left_wall_object translate <0,0,-5.5> }
object{ left_wall_object translate <0,0,0.5> }
object{ left_wall_object translate <0,0,6.5> }
object{ left_wall_object translate <0,0,12.5> }
object{ left_wall_object translate <0,0,18.5> }
box{ <-inch * 1.5,0,19-5 * inch>, <inch * 1.5,20,20+5 * inch> }
box{ <-inch * 1.5,0,-6.5>, <inch * 1.5,20,-15> }





// windows
object{ window_top	translate <0,3,-2.5> }
object{ window_top	translate <0,3, 3.5> }
object{ window_top	translate <0,3, 9.5> }
object{ window_top	translate <0,3,15.5> }

object{ window_bottom	translate <0,-2,0> rotate <0,0,27> translate <0,2,0> translate <0,3,-2.5> }
object{ window_bottom	translate <0,-2,0> rotate <0,0,14> translate <0,2,0> translate <0,3, 3.5> }
object{ window_bottom	translate <0,-2,0> rotate <0,0, 8> translate <0,2,0> translate <0,3, 9.5> }
object{ window_bottom	translate <0,-2,0> rotate <0,0,32> translate <0,2,0> translate <0,3,15.5> }

// windows
object{ window_top	translate <0,9,-2.5> }
object{ window_top	translate <0,9, 3.5> }
object{ window_top	translate <0,9, 9.5> }
object{ window_top	translate <0,9,15.5> }
object{ window_bottom	translate <0,-2,0> rotate <0,0, 8> translate <0,2,0> translate <0,9,-2.5> }
object{ window_bottom	translate <0,-2,0> rotate <0,0, 0> translate <0,2,0> translate <0,9, 3.5> }
object{ window_bottom	translate <0,-2,0> rotate <0,0,21> translate <0,2,0> translate <0,9, 9.5> }
object{ window_bottom	translate <0,-2,0> rotate <0,0,12> translate <0,2,0> translate <0,9,15.5> }

union
{
object{ top_panes	translate <0,3,-2.5> }
object{ top_panes	translate <0,3, 3.5> }
object{ top_panes	translate <0,3, 9.5> }
object{ top_panes	translate <0,3,15.5> }

object{ bottom_panes	translate <0,-2,0> rotate <0,0,27> translate <0,2,0> translate <0,3,-2.5> }
object{ bottom_panes	translate <0,-2,0> rotate <0,0,14> translate <0,2,0> translate <0,3, 3.5> }
object{ bottom_panes	translate <0,-2,0> rotate <0,0, 8> translate <0,2,0> translate <0,3, 9.5> }
object{ bottom_panes	translate <0,-2,0> rotate <0,0,32> translate <0,2,0> translate <0,3,15.5> }

object{ top_panes	translate <0,9,-2.5> }
object{ top_panes	translate <0,9, 3.5> }
object{ top_panes	translate <0,9, 9.5> }
object{ top_panes	translate <0,9,15.5> }

object{ bottom_panes	translate <0,-2,0> rotate <0,0, 8> translate <0,2,0> translate <0,9,-2.5> }
object{ bottom_panes	translate <0,-2,0> rotate <0,0, 0> translate <0,2,0> translate <0,9, 3.5> }
object{ bottom_panes	translate <0,-2,0> rotate <0,0,21> translate <0,2,0> translate <0,9, 9.5> }
object{ bottom_panes	translate <0,-2,0> rotate <0,0,12> translate <0,2,0> translate <0,9,15.5> }
	no_shadow
}

#if(test_mode)
texture{ basic_white }
#else
texture{ wall_texture_01 }
#end
translate <-6,0,0>
}




#local back_wall_object =
union{
box{ <-8 * inch,0,-inch * 3.5>, <8 * inch,18,inch * 1.5> }
box{ <-9 * inch,0,-inch * 2.5>, <9 * inch,18,inch * 1.5> }
cylinder{ <-8*inch,0,-2.5*inch>, <-8*inch,18,-2.5*inch>, inch }
cylinder{ < 8*inch,0,-2.5*inch>, < 8*inch,18,-2.5*inch>, inch }
}




#local I_beam_1 =
union
{
box{ <-7,1.5*inch,-1/8*inch>, <20,-1.5*inch,1/8*inch> }

box{ <-7,-1/8*inch,-1.5*inch>, <20,1/8*inch,1.5*inch> translate <0,-1.5*inch,0> }
box{ <-7,-1/8*inch,-1.5*inch>, <20,1/8*inch,1.5*inch> translate <0, 1.5*inch,0> }
cylinder{ <-7,0,0>, <20,0,0> 1/8*inch scale <1,1,.5> translate <0,-1.5*inch,-1.5*inch> }
cylinder{ <-7,0,0>, <20,0,0> 1/8*inch scale <1,1,.5> translate <0,-1.5*inch, 1.5*inch> }
cylinder{ <-7,0,0>, <20,0,0> 1/8*inch scale <1,1,.5> translate <0, 1.5*inch,-1.5*inch> }
cylinder{ <-7,0,0>, <20,0,0> 1/8*inch scale <1,1,.5> translate <0, 1.5*inch, 1.5*inch> }
}




#local I_beam_2 =
union
{
box{ <-1/8*inch,-1.5*inch,-10>, <1/8*inch,1.5*inch,120> }

box{ <-1.5*inch,-1/8*inch,-10>, <1.5*inch,1/8*inch,120> translate <0,-1.5*inch,0> }
box{ <-1.5*inch,-1/8*inch,-10>, <1.5*inch,1/8*inch,120> translate <0, 1.5*inch,0> }

cylinder{ <0,0,-10>, <0,0,120>, 1/8*inch scale <.5,1,1> translate <-1.5*inch,-1.5*inch,0> }
cylinder{ <0,0,-10>, <0,0,120>, 1/8*inch scale <.5,1,1> translate <-1.5*inch, 1.5*inch,0> }
cylinder{ <0,0,-10>, <0,0,120>, 1/8*inch scale <.5,1,1> translate < 1.5*inch,-1.5*inch,0> }
cylinder{ <0,0,-10>, <0,0,120>, 1/8*inch scale <.5,1,1> translate < 1.5*inch, 1.5*inch,0> }
}




#local sky_light_window =
union
{
box{ <0,-1/4*inch,-1/4*inch>, <6,1/4*inch,1/4*inch> translate <0,0,1*8/6> }
box{ <0,-1/4*inch,-1/4*inch>, <6,1/4*inch,1/4*inch> translate <0,0,2*8/6> }
box{ <0,-1/4*inch,-1/4*inch>, <6,1/4*inch,1/4*inch> translate <0,0,3*8/6> }
box{ <0,-1/4*inch,-1/4*inch>, <6,1/4*inch,1/4*inch> translate <0,0,4*8/6> }
box{ <0,-1/4*inch,-1/4*inch>, <6,1/4*inch,1/4*inch> translate <0,0,5*8/6> }

box{ <-1/4*inch,-1/4*inch,0>, <1/4*inch,1/4*inch,8> translate <1*6/5,0,0> }
box{ <-1/4*inch,-1/4*inch,0>, <1/4*inch,1/4*inch,8> translate <2*6/5,0,0> }
box{ <-1/4*inch,-1/4*inch,0>, <1/4*inch,1/4*inch,8> translate <3*6/5,0,0> }
box{ <-1/4*inch,-1/4*inch,0>, <1/4*inch,1/4*inch,8> translate <4*6/5,0,0> }

}




union
{
// back wall
box{ <-6,0,-inch * 1.5>, <12,10,inch * 1.5> translate <0,0,20> }
box{ <-6,13,-inch * 1.5>, <12,18,inch * 1.5> translate <0,0,20> }
//vertical parts
box{ <-6,0,-inch * 1.5>, <-1,18,inch * 1.5> translate <0,0,20> }
box{ <7.5,0,-inch * 1.5>, <12,18,inch * 1.5> translate <0,0,20> }

object{ back_wall_object translate <-1,0,20> }
object{ back_wall_object translate <7.5,0,20> }


// right wall
box{ <-inch * 1.5,0,-15>, <inch * 1.5,18,20> translate <12,0,0> }
// top



// I beams that support the lights/pipes
#local counter = 0;
#while(counter < 120)
object{ I_beam_1 texture{ basic_white } translate <0,17,-1 + counter> }
#local counter = counter + 5;
#end

object{ I_beam_2 texture{ basic_white } translate <-5.5,17,0> }
object{ I_beam_2 texture{ basic_white } translate <-0.5,17,0> }
object{ I_beam_2 texture{ basic_white } translate < 4.5,17,0> }
object{ I_beam_2 texture{ basic_white } translate < 9.5,17,0> }
object{ I_beam_2 texture{ basic_white } translate <14.5,17,0> }
object{ I_beam_2 texture{ basic_white } translate <19.5,17,0> }


// roof with skylights
difference
{
box{ <0,0,-10>, <75,2*inch,120> }
#local counter = 25;
#while(counter < 100)
box{ <5,-inch,0>, <11,3*inch,8> translate <0,0,counter> }
#local counter = counter + 20;
#end
rotate <0,0,30> translate <-6,20,0>
}


#local counter = 25;
#while(counter < 120)
object{ sky_light_window translate <5,0,counter> rotate <0,0,30> translate <-6,20,0> }
#local counter = counter + 20;
#end

// next room
box{ <-6,0,19>, <20,21,120> clipped_by{ box{ <-7,-1,20>, <20,20,121> } } }
polygon{ 5, <-6,20,120>, vrotate(<75,0,120>,<0,0,30>)+<-6,20,0>, vrotate(<75,0,120>,<0,0,30>)+<20,20,0>, <20,20,120>, <-6,20,120> } 


#if(test_mode)
texture{ basic_white }
#else
texture{ wall_texture_01 }
#end


}



// ventilation ducting thing and old wires
#local a = 1.1;
#local a1 = <10*inch,a/2,a/2>;
#local a2 = <0,.5,0> + <5.4,a/2,a/2>;
#local a3 = <0,.5,0> + <13.5,a/2+2*inch,a/2>;
#local a4 = <0,.5,0> + <17+inch,a/2,a/2>;

#local b1 = (a1+a2)/2;  
#local b2 = (3*a2+2*a3)/5-<0,5*inch,0>;
#local b3 = (a3+a4)/2;
#local trad = 5*inch;

union
{
box{ <0,0,0>, <6*inch,a,a> }
cone{ <6*inch,a/2,a/2>, a/2, <10*inch,a/2,a/2>, 5*inch }
// #macro sweep(s_precision,s0,s1,s2,s3,s_radius)
union
{

sweep2(10,a1,a1+<3*inch,0,0>,b1-<7*inch,2*inch,0>,b1-<2*inch,2*inch,0>,trad)
sweep2(9,b1-<2*inch,2*inch,0>,b1+<4*inch,-2*inch,0>,a2+<-8*inch,0,0>,a2,trad)
sweep2(13,a2,a2+<6*inch,0,0>,b2-<3*inch,0,-1/2*inch>,b2,trad)
sweep2(19,b2,b2+<30*inch,0,0>,a3-<1.5,0,0>,a3,trad)
sweep2(8,a3,a3+<6*inch,0,0>,b3-<10*inch,1*inch,0>,b3-<0,2*inch,0>,trad)
sweep2(8,b3-<0,2*inch,0>,b3+<10*inch,-1*inch,0>,a4-<5*inch,0,0>,a4,trad)

sweep(10,a1,a1+<3*inch,0,0>,b1-<7*inch,2*inch,0>,b1-<2*inch,2*inch,0>,4*inch)
sweep(10,b1-<2*inch,2*inch,0>,b1+<4*inch,-2*inch,0>,a2+<-8*inch,0,0>,a2,4*inch)
sweep(10,a2,a2+<6*inch,0,0>,b2-<3*inch,0,-1/2*inch>,b2,4*inch)
sweep(10,b2,b2+<30*inch,0,0>,a3-<1.5,0,0>,a3,4*inch)
sweep(10,a3,a3+<6*inch,0,0>,b3-<10*inch,1*inch,0>,b3-<0,2*inch,0>,4*inch)
sweep(10,b3-<0,2*inch,0>,b3+<10*inch,-1*inch,0>,a4-<5*inch,0,0>,a4,4*inch)
texture{ basic_white }
}
// duct supports
cylinder{ < 5.4-inch,.5+a/2,a/2>, < 5.4+inch,.5+a/2,a/2>, 5.25*inch texture{ old_black_paint } }
cylinder{ <13.5-inch,.5+a/2+2*inch,a/2>, <13.5+inch,.5+a/2+2*inch,a/2>, 5.25*inch texture{ old_black_paint } }
box{ <0,0,0>, <6*inch,a,a> translate <17.5,.5,0>}
cone{ <6*inch,a/2,a/2>, 4*inch, <10*inch,a/2,a/2>, a/2 translate <17.5-10*inch,.5,0>}

// wires
box{ <17.65,-1,-2>, <18,-1+4*inch,-1> }

texture{ old_black_paint }
translate <-6,13,17+inch>
}



// piping, right
union
{
object{ piping texture{ basic_white } translate <0,0,-15> }
object{ piping texture{ basic_white } translate <0,0, -5> }
object{ piping texture{ basic_white } translate <0,0,  5> }
object{ piping texture{ basic_white } translate <0,0, 15> }
translate <9,12,0>
}



// piping, left
union
{
object{ piping texture{ basic_white } translate <0,0,-15> }
object{ piping texture{ basic_white } translate <0,0, -5> }
object{ piping texture{ basic_white } translate <0,0,  5> }
object{ piping texture{ basic_white } translate <0,0, 15> }
translate <-2.5,12,0>
}

// breaker box
object{ breaker_box translate <10,0,20> }


// table and drawers
object{ table translate <-3.8,0,5> }

// debris
union
{
object{ old_junk_large_pipe texture{ rust_01 } rotate <0,-78,0> translate <3,10*inch,1> scale <1,1,1> * 1/2}

object{ old_junk_small_pipe texture{ rust_01 } rotate <0,-141,0> translate <8,0,10> }
object{ old_junk_small_pipe texture{ rust_01 } rotate <0,-16,0> translate <-4,3-1.5*inch,1> }

object{ old_junk_pallet1 texture{ wood_texture } rotate <0,37,0> translate <0,0,7> }
object{ old_junk_pallet2 texture{ wood_texture } rotate <0,-72,0> translate <7,0,-1> }
object{ old_junk_wood	 texture{ wood_texture } rotate <0,-22,0> translate <-.5,0,-3> }

object{ old_paper texture{ basic_white } rotate <0,25,0> translate <-2,0,-3> }
object{ old_paper texture{ basic_white } rotate <0,-62,0> translate <-3,3-1.5*inch,2> }
object{ old_paper texture{ basic_white } rotate <0,48,0> translate <2,0,4> }
object{ old_paper texture{ basic_white } rotate <0,146,0> translate <8,0,12> }
object{ old_paper texture{ basic_white } rotate <0,111,0> translate <9.6,0,7> }

object{ chair translate <0,1.15,-.6> rotate <81,0,0> rotate <0,72,0> translate <5,.30,4> }

translate <.4,0,2>
}




union
{
// road
box{ < -10,-1,-100>, <10,2*inch,300> translate <-35,0,0> }
box{ <-200,-1,-10>, <0,2*inch,10> translate <0,0,45> }
// purposefully indistinct building-like blocks
union
{
box{ <-30,0,15>, <-15,7,30>				texture{ old_green_paint } }
box{ <-32,7,13>, <-13,7+6*inch,32>		texture{ old_black_paint } }
box{ <-23,0,15>, <-20,6,14.9>			texture{ old_black_paint } }
// stuff on the roof
cylinder{ <-20,7,20>, <-20,8,20>, .25	texture{ old_black_paint } }
sphere{ <-20,8.25,20>, .35 texture{ old_black_paint } } 
box{ <-27,7,16.5>, <-26,8,18> texture{ old_black_paint } }
box{ <-25,7,16>, <-24,8,22> texture{ old_black_paint } }
box{ <-20,7,24>, <-17,9,29> texture{ old_black_paint } }
cylinder{ <-28,7,16>, <-28,8,16>, .35 texture{ old_black_paint } }
cone{ <-28,8,16>, .35, <-28,8+5*inch,16>, .5	open texture{ old_black_paint } }
cylinder{ <-28,8+5*inch,16>, <-28,8+10*inch,16>, .5	open texture{ old_black_paint } }
cone{ <-28,8+10*inch,16>, .5, <-28,8+15*inch,16>, .35	open texture{ old_black_paint } }
translate <0,0,40>
}


box{ <-25,0,15>, <-45,15,50>			texture{ old_green_paint } translate <-20,0,40> }
box{ <-23,15,13>, <-47,15+6*inch,52>	texture{ old_black_paint } translate <-20,0,40> }

union
{
// stuff on the roof
cylinder{ <-20,7,20>, <-20,8,20>, .25	texture{ old_black_paint } }
sphere{ <-20,8.25,20>, .35 texture{ old_black_paint } } 
box{ <-27,7,16.5>, <-26,8,18> texture{ old_black_paint } }
box{ <-25,7,16>, <-24,8,22> texture{ old_black_paint } }
box{ <-20,7,24>, <-17,9,29> texture{ old_black_paint } }

cylinder{ <-28,7,16>, <-28,9,16>, .4 texture{ old_black_paint } }
cone{ <-28,9,16>, .4, <-28,9+5*inch,16>, .75	open texture{ old_black_paint } }
cylinder{ <-28,9+5*inch,16>, <-28,9+10*inch,16>, .75	open texture{ old_black_paint } }
cone{ <-28,9+10*inch,16>, .75, <-28,9+15*inch,16>, .4	open texture{ old_black_paint } }
translate <-32,8,40>
}



object{ water_tower texture{ old_green_paint } translate <-100,0,180> }

texture{ road_tex }

translate <-25,0,0>
}



// grass
grass_options(<.25,1,0>,.5,1.25,.5,.015)
#declare grass01=
mesh
{
grass(5000,<-10,-.05,-10>, <10,0,10>,3)
texture{ grass1 }
}

#declare grass02=
mesh
{
grass(1000,<-5,-.05,-5>, <5,0,5>,3)
texture{ grass1 }
}


// right side
#local counter = 25;
#while(counter > -55)
object{ grass01 translate <-40,0,counter> }
object{ grass01 translate <-20,0,counter> }
#local counter = counter - 20;
#end

// right side
#local counter = 65;
#while(counter < 305)
object{ grass01 translate <-40,0,counter> }
object{ grass01 translate <-20,0,counter> }
#local counter = counter + 20;
#end

//left side
object{ grass02 translate <-75,0,30> }

grass_options(<.25,1,0>,10*inch,18*inch,.5,.015)

#local counter = 65;
#while(counter < 305)
object{ grass01 translate <-240,0,counter> }
object{ grass01 translate <-220,0,counter> }
object{ grass01 translate <-200,0,counter> }
object{ grass01 translate <-180,0,counter> }
object{ grass01 translate <-160,0,counter> }
object{ grass01 translate <-140,0,counter> }
object{ grass01 translate <-120,0,counter> }
object{ grass01 translate <-100,0,counter> }
#if(counter > 85) object{ grass01 translate <-80,0,counter> } #end
#local counter = counter + 20;
#end


grass_options(<.25,1,0>,4*inch,6*inch,.5,.008)

// grass in the cracks
mesh
{
grass(200,<-75,-.05,44.95>, <-85,0,45.05>,3)
grass(200,<-72,-.05,48.95>, <-65,0,49.05>,3)
grass(200,<-65,-.05,43.95>, <-45,0,44.05>,3)
grass(200,<-42,-.05,44.95>, <-25,0,45.05>,3)

grass(200,<-59.95,-.05, 46>, <-60.05,0,60>,3)
grass(300,<-57.95,-.05, 45>, <-58.05,0,30>,3)
grass(500,<-60.95,-.05, 29>, <-61.05,0, 0>,3)
grass(500,<-62.95,-.05,-25>, <-63.05,0, 2>,3)
texture{ grass1 }
}



#local hf_bg1 =
height_field
{
	tga "hills.tga"
	smooth
	translate <-.5,0,-.5>
	scale <100,15,300>
}



#local hf_bg2 =
height_field
{
	tga "hills.tga"
	smooth
	translate <-.5,0,-.5>
	scale <100,50,100>
}



union
{
plane
{
	y, 0
}
object{ hf_bg1	rotate <0,5,0>	translate <-300,0,200> }
object{ hf_bg1	rotate <0,90,0>	translate <-100,0,300> }
object{ hf_bg2	texture{ stone_tex } rotate <0,32,0>	translate <-350,0,200> }
object{ hf_bg2	texture{ stone_tex } rotate <0,-48,0>	translate <-175,0,350> }

	texture{ ground_tex }
}


sky_sphere
{
pigment
{
	gradient y
	color_map{
		[0.00 color rgb <.4,.4,.35> ]
		[0.10 color rgb <.25,.3,.35> ]
		[0.50 color rgb <0,.075,.2> ]
		[1.00 color rgb <0,.075,.2> ]
			}
	}

}



plane
{
	y, 2000
	texture{
pigment{
	bozo
	turbulence .4
	frequency 3
	sine_wave
	scale 2
	pigment_map{
	[0.00
	wrinkles
	turbulence .4
	lambda 3.0
	sine_wave
	frequency 1/2
	octaves 8
	scale <1,1,1>/4
	color_map{
	[0.00 color rgbt <1,1,1,0> ]
//	[0.50 color rgbt <1,1,1,1> ]
	[1.00 color rgbt <1,1,1,1> ]
			} ]
	[0.50 color rgbt <1,1,1,1> ]
	[1.00 color rgbt <1,1,1,1> ]
			}
		}
finish{ specular 0 roughness 1 ambient 1 diffuse 0 }
scale <2000,1000,1000>*3
}
clipped_by{ plane{ z, 10000 } }
hollow
rotate <5,0,0>
}





// this light source is used for media (the other area lights do not interact with media)
light_source
{
	<0,0,0>
	color rgb <1,.975,.875> * .01
	area_light
	<-100,-100,-100>*4, <100,100,100>*4
	3,3
	jitter
	adaptive 0
	circular
	orient
	translate <-1000,600,-300> * 10
}






light_source
{
	<0,0,0>
	color rgb <1,1,.95> * 1.1
//	area_light
//	<-100,-100,-100>*6, <100,100,100>*6
//	15,15
//	jitter
//	adaptive 4
//	circular
//	orient
	media_interaction off
	translate <-1000,600,-300> * 10
}


/*
light_source
{
	<0,0,0>
	color rgb <1,1,.95> * .8
//	area_light
//	<-100,-100,-100>*3, <100,100,100>*3
//	15, 15
//	jitter
//	adaptive 5
//	circular
//	orient
	media_interaction off
	translate <-1000,600,-300> * 10
}


*/








camera
{

	location <4,4,-10>
	look_at  <0,5.5,1>
	right <5/3,0,0>
	angle 84
translate <2,0,0>

}


