// Persistence of Vision Ray Tracer Include File
// File: forget.inc
// Vers: 3.5
// Desc: IRTC 2003/09 competition (Decay)
// Date: 2003/10/15
// Auth: Slawomir Szczyrba
//

//***************************************************************************
// Earth's Atmosphere
//***************************************************************************

#local f_gradY = function(A,B,C) {
  (1*(B>1)+(B-1)*(B>0)*(B<1)+0*(B<0)) * f_spherical(A,B,C)
} 

#local AtmR = 82;
#declare MAir = media {
   emission .0165
   intervals 7   
   samples 1, 8
   confidence 0.9999
   variance 1/1000         
   density {
    function { f_spherical(x,y,z)  }
//    ramp_wave
//    turbulence .36       
    omega .835
    color_map {
     [0.0 color rgb <0, 0, 0>]
     [0.15 color rgb <0, 0, 0>]
     [0.5 color rgb <.3, 0.45, 0.8>]
     [1.0 color rgb <.7, 0.8, 1>]
    } 
    scale <1,.95,1>
    translate y*.05
    scale AtmR
//    translate y*100
//    rotate y*20
   } //density   
  }

//***************************************************************************
// Radiation's Glow
//***************************************************************************
#local MapDiv=.05;
#declare DRadiation = density {
    agate agate_turb 1.7
//   omega .2835
    color_map {
     [0 rgb <.1,1,0>*.5]
     [MapDiv rgb <.1,1,0>*.5]
     [MapDiv rgb 0 ]
     [1 rgb 0 ]
    }
    scale .35
//    rotate -y*45
   } 
#declare DNone = density {}
#declare MRadiation = media {
   emission .135
   intervals 7   
   samples 1, 8
   confidence 0.9999
   variance 1/1000         
   density {
   gradient -y    
    density_map {
     [0 DNone]
//     [0 DRadiation]
     [.3 DNone ]
     [1 DRadiation]
    }
   scale 160  
   translate -y*60
  }
 }            

//***************************************************************************
// Earth's texture
//***************************************************************************
#declare SkyScale=<12,9,12>*2;
#declare TEarth =
 texture {
  pigment {
   gradient y
   turbulence .18
   color_map {
    [0 color rgb <.75,.6,.3>*.5]
    [.8 color rgb <.3,.4,.8>]
    [.9 color rgb <1,1,1>]
    [1 color rgb <1,1,1>]
   }
   scale 80
   translate -y*18
   rotate y*45
  }   
  finish { ambient 0 diffuse .8 }
 } 
 texture {
  pigment {
   bozo
   turbulence 0.8 //0.6
   octaves 10
   omega .5
   lambda 2.5
   color_map {
    [0.0, 0.4 color rgbt<.75, .75, .75, 0> color rgbt<.9, .9, .9, .9> ]
    [0.4, 0.7 color rgbt<.9, .9, .9, .9>   color rgbt<1, 1, 1, 1> ]
    [0.7, 1.0 color rgbt<1, 1, 1, 1>       color rgbt<1, 1, 1, 1> ]
   }
  }
  finish { ambient 0.2 diffuse 1.0 }
  scale SkyScale
 } 
 texture {
  pigment {
   bozo
   turbulence 0.8 //0.6
   octaves 10
   omega .5
   lambda 2.5
   color_map {
    [0.0, 0.4 color rgbt<.75, .75, .75, 0> color rgbt<.9, .9, .9, .9> ]
    [0.4, 0.6 color rgbt<.9, .9, .9, .9>   color rgbt<1, 1, 1, 1> ]
    [0.6, 1.0 color rgbt<1, 1, 1, 1>       color rgbt<1, 1, 1, 1> ]
   }
  }
  finish { ambient 0.05 diffuse 0.95 }
  scale SkyScale
 }
 
//***************************************************************************
// Moon's surface
//***************************************************************************
 #local ALFA=0;  
 #declare B = function {
  pigment {
   bozo
   turbulence 0.5
   omega .6   
   lambda 2
   frequency 1 
   pigment_map {
    [0 rgb 0]
    [1 rgb 1]
   }
   scale 50 
  }
 }                                  
 #declare F=function {
  pigment {
   granite
   turbulence 0.1
   color_map {
    [0 rgb 0][1 rgb 1]
   }
   scale 5
  }
 }  
 #declare C1 = function {
  pigment {
   cells
   turbulence 0.5
   omega .9   
   lambda 2   
   frequency 2 
   pigment_map {
    [0 rgb 0]
    [1 rgb 1]
   }    
   scale 500
  } 
 }

//***************************************************************************
// Moon
//***************************************************************************
#declare Moon = isosurface {
  function { y-50*B(x,y,z).red*C1(x,y,z).red+.2*F(x,y,z).red }
  max_gradient 10
//  evaluate 1,8,.8
  accuracy .001
  contained_by { box { <50, 0, 0>, <-40, 37, 100> } }
  clipped_by { plane {x,0} rotate -y*75 translate <45,0,65>}
  pigment{color rgb 1} finish{ ambient .012 diffuse 1.5}
  rotate y*ALFA 
 }

//***************************************************************************
// Earth
//***************************************************************************
#declare Earth = union {
 sphere { 
  0, 60 
  hollow
  texture { TEarth }
 }
 sphere {
  0, 70
  hollow
  pigment { color rgbt <0,1,0,1> }
  interior {
   media { MAir }
//   media { MRadiation }
  }
 }
 sphere {
  0, 61
  hollow
  pigment { color rgbt <0,1,0,1> }
  interior {
//   media { MAir }
   media { MRadiation }
  }
 }
}
