// Persistence of Vision Ray Tracer Include File
// File: kolo.inc
// Vers: 3.5
// Desc: IRTC 2003/09 competition (Decay)
// Date: 2003/09/21
// Auth: Slawomir Szczyrba
//

#include "metals.inc"
// Layer 2
#declare opona = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, 0.500, 0.000> <-1.575, 0.500, -0.115> <-1.575, 0.435, -0.272> <-1.575, 0.354, -0.354> 
		<-1.823, 0.612, 0.000> <-1.823, 0.612, -0.115> <-1.823, 0.514, -0.352> <-1.823, 0.433, -0.433> 
		<-1.823, 1.788, 0.000> <-1.823, 1.788, -0.436> <-1.823, 1.573, -0.956> <-1.823, 1.264, -1.264> 
		<-1.575, 1.900, 0.000> <-1.575, 1.900, -0.436> <-1.575, 1.652, -1.035> <-1.575, 1.344, -1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, 0.500, 0.000> <-1.823, 0.612, 0.000> <-1.823, 1.788, 0.000> <-1.575, 1.900, 0.000> 
		<-1.575, 0.500, 0.115> <-1.823, 0.612, 0.115> <-1.823, 1.788, 0.436> <-1.575, 1.900, 0.436> 
		<-1.575, 0.435, 0.272> <-1.823, 0.514, 0.352> <-1.823, 1.573, 0.956> <-1.575, 1.652, 1.035> 
		<-1.575, 0.354, 0.354> <-1.823, 0.433, 0.433> <-1.823, 1.264, 1.264> <-1.575, 1.344, 1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, 0.500, 0.000> <-1.026, 0.252, 0.000> <0.975, 0.252, 0.000> <1.525, 0.500, 0.000> 
		<-1.575, 0.500, -0.115> <-1.026, 0.252, -0.115> <0.975, 0.252, -0.115> <1.525, 0.500, -0.115> 
		<-1.575, 0.435, -0.272> <-1.026, 0.259, -0.097> <0.975, 0.259, -0.097> <1.525, 0.435, -0.272> 
		<-1.575, 0.354, -0.354> <-1.026, 0.178, -0.178> <0.975, 0.178, -0.178> <1.525, 0.354, -0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, 0.500, 0.000> <-1.575, 0.500, 0.115> <-1.575, 0.435, 0.272> <-1.575, 0.354, 0.354> 
		<-1.026, 0.252, 0.000> <-1.026, 0.252, 0.115> <-1.026, 0.259, 0.097> <-1.026, 0.178, 0.178> 
		<0.975, 0.252, 0.000> <0.975, 0.252, 0.115> <0.975, 0.259, 0.097> <0.975, 0.178, 0.178> 
		<1.525, 0.500, 0.000> <1.525, 0.500, 0.115> <1.525, 0.435, 0.272> <1.525, 0.354, 0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 0.500, 0.000> <1.773, 0.612, 0.000> <1.773, 1.788, 0.000> <1.525, 1.900, 0.000> 
		<1.525, 0.500, -0.115> <1.773, 0.612, -0.115> <1.773, 1.788, -0.436> <1.525, 1.900, -0.436> 
		<1.525, 0.435, -0.272> <1.773, 0.514, -0.352> <1.773, 1.573, -0.956> <1.525, 1.652, -1.035> 
		<1.525, 0.354, -0.354> <1.773, 0.433, -0.433> <1.773, 1.264, -1.264> <1.525, 1.344, -1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 0.500, 0.000> <1.525, 0.500, 0.115> <1.525, 0.435, 0.272> <1.525, 0.354, 0.354> 
		<1.773, 0.612, 0.000> <1.773, 0.612, 0.115> <1.773, 0.514, 0.352> <1.773, 0.433, 0.433> 
		<1.773, 1.788, 0.000> <1.773, 1.788, 0.436> <1.773, 1.573, 0.956> <1.773, 1.264, 1.264> 
		<1.525, 1.900, 0.000> <1.525, 1.900, 0.436> <1.525, 1.652, 1.035> <1.525, 1.344, 1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 1.900, 0.000> <0.975, 2.148, 0.000> <-1.026, 2.148, 0.000> <-1.575, 1.900, 0.000> 
		<1.525, 1.900, -0.436> <0.975, 2.148, -0.436> <-1.026, 2.148, -0.436> <-1.575, 1.900, -0.436> 
		<1.525, 1.652, -1.035> <0.975, 1.827, -1.210> <-1.026, 1.827, -1.210> <-1.575, 1.652, -1.035> 
		<1.525, 1.344, -1.344> <0.975, 1.519, -1.519> <-1.026, 1.519, -1.519> <-1.575, 1.344, -1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 1.900, 0.000> <1.525, 1.900, 0.436> <1.525, 1.652, 1.035> <1.525, 1.344, 1.344> 
		<0.975, 2.148, 0.000> <0.975, 2.148, 0.436> <0.975, 1.827, 1.210> <0.975, 1.519, 1.519> 
		<-1.026, 2.148, 0.000> <-1.026, 2.148, 0.436> <-1.026, 1.827, 1.210> <-1.026, 1.519, 1.519> 
		<-1.575, 1.900, 0.000> <-1.575, 1.900, 0.436> <-1.575, 1.652, 1.035> <-1.575, 1.344, 1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, 0.354, 0.354> <-1.823, 0.433, 0.433> <-1.823, 1.264, 1.264> <-1.575, 1.344, 1.344> 
		<-1.575, 0.272, 0.435> <-1.823, 0.352, 0.514> <-1.823, 0.956, 1.573> <-1.575, 1.035, 1.652> 
		<-1.575, 0.115, 0.500> <-1.823, 0.115, 0.612> <-1.823, 0.436, 1.788> <-1.575, 0.436, 1.900> 
		<-1.575, 0.000, 0.500> <-1.823, 0.000, 0.612> <-1.823, 0.000, 1.788> <-1.575, 0.000, 1.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, 0.354, 0.354> <-1.575, 0.272, 0.435> <-1.575, 0.115, 0.500> <-1.575, 0.000, 0.500> 
		<-1.026, 0.178, 0.178> <-1.026, 0.097, 0.259> <-1.026, 0.115, 0.252> <-1.026, 0.000, 0.252> 
		<0.975, 0.178, 0.178> <0.975, 0.097, 0.259> <0.975, 0.115, 0.252> <0.975, 0.000, 0.252> 
		<1.525, 0.354, 0.354> <1.525, 0.272, 0.435> <1.525, 0.115, 0.500> <1.525, 0.000, 0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, 0.000, 0.500> <-1.823, 0.000, 0.612> <-1.823, 0.000, 1.788> <-1.575, 0.000, 1.900> 
		<-1.575, -0.115, 0.500> <-1.823, -0.115, 0.612> <-1.823, -0.436, 1.788> <-1.575, -0.436, 1.900> 
		<-1.575, -0.272, 0.435> <-1.823, -0.352, 0.514> <-1.823, -0.956, 1.573> <-1.575, -1.035, 1.652> 
		<-1.575, -0.354, 0.354> <-1.823, -0.433, 0.433> <-1.823, -1.264, 1.264> <-1.575, -1.343, 1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, 0.000, 0.500> <-1.575, -0.115, 0.500> <-1.575, -0.272, 0.435> <-1.575, -0.354, 0.354> 
		<-1.026, 0.000, 0.252> <-1.026, -0.115, 0.252> <-1.026, -0.097, 0.259> <-1.026, -0.178, 0.178> 
		<0.975, 0.000, 0.252> <0.975, -0.115, 0.252> <0.975, -0.097, 0.259> <0.975, -0.178, 0.178> 
		<1.525, 0.000, 0.500> <1.525, -0.115, 0.500> <1.525, -0.272, 0.435> <1.525, -0.354, 0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, -0.354, 0.354> <-1.823, -0.433, 0.433> <-1.823, -1.264, 1.264> <-1.575, -1.343, 1.344> 
		<-1.575, -0.435, 0.272> <-1.823, -0.514, 0.352> <-1.823, -1.573, 0.956> <-1.575, -1.652, 1.035> 
		<-1.575, -0.500, 0.115> <-1.823, -0.612, 0.115> <-1.823, -1.788, 0.436> <-1.575, -1.900, 0.436> 
		<-1.575, -0.500, 0.000> <-1.823, -0.612, 0.000> <-1.823, -1.788, 0.000> <-1.575, -1.900, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, -0.354, 0.354> <-1.575, -0.435, 0.272> <-1.575, -0.500, 0.115> <-1.575, -0.500, 0.000> 
		<-1.026, -0.178, 0.178> <-1.026, -0.259, 0.097> <-1.026, -0.252, 0.115> <-1.026, -0.252, 0.000> 
		<0.975, -0.178, 0.178> <0.975, -0.259, 0.097> <0.975, -0.252, 0.115> <0.975, -0.252, 0.000> 
		<1.525, -0.354, 0.354> <1.525, -0.435, 0.272> <1.525, -0.500, 0.115> <1.525, -0.500, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, -0.500, 0.000> <-1.823, -0.612, 0.000> <-1.823, -1.788, 0.000> <-1.575, -1.900, 0.000> 
		<-1.575, -0.500, -0.115> <-1.823, -0.612, -0.115> <-1.823, -1.788, -0.436> <-1.575, -1.900, -0.436> 
		<-1.575, -0.435, -0.272> <-1.823, -0.514, -0.352> <-1.823, -1.573, -0.956> <-1.575, -1.652, -1.035> 
		<-1.575, -0.354, -0.354> <-1.823, -0.433, -0.433> <-1.823, -1.264, -1.264> <-1.575, -1.343, -1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, -0.500, 0.000> <-1.575, -0.500, -0.115> <-1.575, -0.435, -0.272> <-1.575, -0.354, -0.354> 
		<-1.026, -0.252, 0.000> <-1.026, -0.252, -0.115> <-1.026, -0.259, -0.097> <-1.026, -0.178, -0.178> 
		<0.975, -0.252, 0.000> <0.975, -0.252, -0.115> <0.975, -0.259, -0.097> <0.975, -0.178, -0.178> 
		<1.525, -0.500, 0.000> <1.525, -0.500, -0.115> <1.525, -0.435, -0.272> <1.525, -0.354, -0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, -0.354, -0.354> <-1.823, -0.433, -0.433> <-1.823, -1.264, -1.264> <-1.575, -1.343, -1.344> 
		<-1.575, -0.272, -0.435> <-1.823, -0.352, -0.514> <-1.823, -0.956, -1.573> <-1.575, -1.035, -1.652> 
		<-1.575, -0.115, -0.500> <-1.823, -0.115, -0.612> <-1.823, -0.436, -1.788> <-1.575, -0.436, -1.900> 
		<-1.575, 0.000, -0.500> <-1.823, 0.000, -0.612> <-1.823, 0.000, -1.788> <-1.575, 0.000, -1.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, -0.354, -0.354> <-1.575, -0.272, -0.435> <-1.575, -0.115, -0.500> <-1.575, 0.000, -0.500> 
		<-1.026, -0.178, -0.178> <-1.026, -0.097, -0.259> <-1.026, -0.115, -0.252> <-1.026, 0.000, -0.252> 
		<0.975, -0.178, -0.178> <0.975, -0.097, -0.259> <0.975, -0.115, -0.252> <0.975, 0.000, -0.252> 
		<1.525, -0.354, -0.354> <1.525, -0.272, -0.435> <1.525, -0.115, -0.500> <1.525, 0.000, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, 0.000, -0.500> <-1.823, 0.000, -0.612> <-1.823, 0.000, -1.788> <-1.575, 0.000, -1.900> 
		<-1.575, 0.115, -0.500> <-1.823, 0.115, -0.612> <-1.823, 0.436, -1.788> <-1.575, 0.436, -1.900> 
		<-1.575, 0.272, -0.435> <-1.823, 0.352, -0.514> <-1.823, 0.956, -1.573> <-1.575, 1.035, -1.652> 
		<-1.575, 0.354, -0.354> <-1.823, 0.433, -0.433> <-1.823, 1.264, -1.264> <-1.575, 1.344, -1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.575, 0.000, -0.500> <-1.575, 0.115, -0.500> <-1.575, 0.272, -0.435> <-1.575, 0.354, -0.354> 
		<-1.026, 0.000, -0.252> <-1.026, 0.115, -0.252> <-1.026, 0.097, -0.259> <-1.026, 0.178, -0.178> 
		<0.975, 0.000, -0.252> <0.975, 0.115, -0.252> <0.975, 0.097, -0.259> <0.975, 0.178, -0.178> 
		<1.525, 0.000, -0.500> <1.525, 0.115, -0.500> <1.525, 0.272, -0.435> <1.525, 0.354, -0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 0.354, 0.354> <1.525, 0.272, 0.435> <1.525, 0.115, 0.500> <1.525, 0.000, 0.500> 
		<1.773, 0.433, 0.433> <1.773, 0.352, 0.514> <1.773, 0.115, 0.612> <1.773, 0.000, 0.612> 
		<1.773, 1.264, 1.264> <1.773, 0.956, 1.573> <1.773, 0.436, 1.788> <1.773, 0.000, 1.788> 
		<1.525, 1.344, 1.344> <1.525, 1.035, 1.652> <1.525, 0.436, 1.900> <1.525, 0.000, 1.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 0.000, 0.500> <1.525, -0.115, 0.500> <1.525, -0.272, 0.435> <1.525, -0.354, 0.354> 
		<1.773, 0.000, 0.612> <1.773, -0.115, 0.612> <1.773, -0.352, 0.514> <1.773, -0.433, 0.433> 
		<1.773, 0.000, 1.788> <1.773, -0.436, 1.788> <1.773, -0.956, 1.573> <1.773, -1.264, 1.264> 
		<1.525, 0.000, 1.900> <1.525, -0.436, 1.900> <1.525, -1.035, 1.652> <1.525, -1.343, 1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, -0.354, 0.354> <1.525, -0.435, 0.272> <1.525, -0.500, 0.115> <1.525, -0.500, 0.000> 
		<1.773, -0.433, 0.433> <1.773, -0.514, 0.352> <1.773, -0.612, 0.115> <1.773, -0.612, 0.000> 
		<1.773, -1.264, 1.264> <1.773, -1.573, 0.956> <1.773, -1.788, 0.436> <1.773, -1.788, 0.000> 
		<1.525, -1.343, 1.344> <1.525, -1.652, 1.035> <1.525, -1.900, 0.436> <1.525, -1.900, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, -0.500, 0.000> <1.525, -0.500, -0.115> <1.525, -0.435, -0.272> <1.525, -0.354, -0.354> 
		<1.773, -0.612, 0.000> <1.773, -0.612, -0.115> <1.773, -0.514, -0.352> <1.773, -0.433, -0.433> 
		<1.773, -1.788, 0.000> <1.773, -1.788, -0.436> <1.773, -1.573, -0.956> <1.773, -1.264, -1.264> 
		<1.525, -1.900, 0.000> <1.525, -1.900, -0.436> <1.525, -1.652, -1.035> <1.525, -1.343, -1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, -0.354, -0.354> <1.525, -0.272, -0.435> <1.525, -0.115, -0.500> <1.525, 0.000, -0.500> 
		<1.773, -0.433, -0.433> <1.773, -0.352, -0.514> <1.773, -0.115, -0.612> <1.773, 0.000, -0.612> 
		<1.773, -1.264, -1.264> <1.773, -0.956, -1.573> <1.773, -0.436, -1.788> <1.773, 0.000, -1.788> 
		<1.525, -1.343, -1.344> <1.525, -1.035, -1.652> <1.525, -0.436, -1.900> <1.525, 0.000, -1.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 0.000, -0.500> <1.525, 0.115, -0.500> <1.525, 0.272, -0.435> <1.525, 0.354, -0.354> 
		<1.773, 0.000, -0.612> <1.773, 0.115, -0.612> <1.773, 0.352, -0.514> <1.773, 0.433, -0.433> 
		<1.773, 0.000, -1.788> <1.773, 0.436, -1.788> <1.773, 0.956, -1.573> <1.773, 1.264, -1.264> 
		<1.525, 0.000, -1.900> <1.525, 0.436, -1.900> <1.525, 1.035, -1.652> <1.525, 1.344, -1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 1.344, 1.344> <1.525, 1.035, 1.652> <1.525, 0.436, 1.900> <1.525, 0.000, 1.900> 
		<0.975, 1.519, 1.519> <0.975, 1.210, 1.827> <0.975, 0.436, 2.148> <0.975, 0.000, 2.148> 
		<-1.026, 1.519, 1.519> <-1.026, 1.210, 1.827> <-1.026, 0.436, 2.148> <-1.026, 0.000, 2.148> 
		<-1.575, 1.344, 1.344> <-1.575, 1.035, 1.652> <-1.575, 0.436, 1.900> <-1.575, 0.000, 1.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 0.000, 1.900> <1.525, -0.436, 1.900> <1.525, -1.035, 1.652> <1.525, -1.343, 1.344> 
		<0.975, 0.000, 2.148> <0.975, -0.436, 2.148> <0.975, -1.210, 1.827> <0.975, -1.519, 1.519> 
		<-1.026, 0.000, 2.148> <-1.026, -0.436, 2.148> <-1.026, -1.210, 1.827> <-1.026, -1.519, 1.519> 
		<-1.575, 0.000, 1.900> <-1.575, -0.436, 1.900> <-1.575, -1.035, 1.652> <-1.575, -1.343, 1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, -1.343, 1.344> <1.525, -1.652, 1.035> <1.525, -1.900, 0.436> <1.525, -1.900, 0.000> 
		<0.975, -1.519, 1.519> <0.975, -1.827, 1.210> <0.975, -2.148, 0.436> <0.975, -2.148, 0.000> 
		<-1.026, -1.519, 1.519> <-1.026, -1.827, 1.210> <-1.026, -2.148, 0.436> <-1.026, -2.148, 0.000> 
		<-1.575, -1.343, 1.344> <-1.575, -1.652, 1.035> <-1.575, -1.900, 0.436> <-1.575, -1.900, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, -1.900, 0.000> <1.525, -1.900, -0.436> <1.525, -1.652, -1.035> <1.525, -1.343, -1.344> 
		<0.975, -2.148, 0.000> <0.975, -2.148, -0.436> <0.975, -1.827, -1.210> <0.975, -1.519, -1.519> 
		<-1.026, -2.148, 0.000> <-1.026, -2.148, -0.436> <-1.026, -1.827, -1.210> <-1.026, -1.519, -1.519> 
		<-1.575, -1.900, 0.000> <-1.575, -1.900, -0.436> <-1.575, -1.652, -1.035> <-1.575, -1.343, -1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, -1.343, -1.344> <1.525, -1.035, -1.652> <1.525, -0.436, -1.900> <1.525, 0.000, -1.900> 
		<0.975, -1.519, -1.519> <0.975, -1.210, -1.827> <0.975, -0.436, -2.148> <0.975, 0.000, -2.148> 
		<-1.026, -1.519, -1.519> <-1.026, -1.210, -1.827> <-1.026, -0.436, -2.148> <-1.026, 0.000, -2.148> 
		<-1.575, -1.343, -1.344> <-1.575, -1.035, -1.652> <-1.575, -0.436, -1.900> <-1.575, 0.000, -1.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 0.000, -1.900> <1.525, 0.436, -1.900> <1.525, 1.035, -1.652> <1.525, 1.344, -1.344> 
		<0.975, 0.000, -2.148> <0.975, 0.436, -2.148> <0.975, 1.210, -1.827> <0.975, 1.519, -1.519> 
		<-1.026, 0.000, -2.148> <-1.026, 0.436, -2.148> <-1.026, 1.210, -1.827> <-1.026, 1.519, -1.519> 
		<-1.575, 0.000, -1.900> <-1.575, 0.436, -1.900> <-1.575, 1.035, -1.652> <-1.575, 1.344, -1.344> 
	}
}
// Layer 3
#declare bieznik = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.672, 0.650, 0.000> <-1.345, 0.348, -0.121> <-0.619, 0.421, -0.617> <0.037, 0.419, -0.617> 
		<-1.908, 0.868, 0.087> <-1.581, 0.565, -0.034> <-0.622, 0.889, -0.633> <0.033, 0.887, -0.633> 
		<-1.890, 1.771, 0.092> <-1.551, 2.036, -0.032> <-0.606, 1.513, -0.632> <0.029, 1.511, -0.632> 
		<-1.638, 1.968, 0.000> <-1.299, 2.233, -0.123> <-0.609, 1.980, -0.617> <0.026, 1.978, -0.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.672, 0.650, 0.000> <-1.908, 0.868, 0.087> <-1.890, 1.771, 0.092> <-1.638, 1.968, 0.000> 
		<-1.672, 0.642, 0.016> <-1.908, 0.859, 0.103> <-1.890, 1.778, 0.106> <-1.638, 1.975, 0.015> 
		<-1.672, 0.620, 0.035> <-1.960, 0.895, 0.140> <-1.945, 1.742, 0.145> <-1.638, 1.991, 0.032> 
		<-1.672, 0.621, 0.053> <-1.960, 0.896, 0.158> <-1.945, 1.742, 0.161> <-1.638, 1.992, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.672, 0.650, 0.000> <-1.672, 0.642, 0.016> <-1.672, 0.620, 0.035> <-1.672, 0.621, 0.053> 
		<-1.345, 0.348, -0.121> <-1.345, 0.339, -0.105> <-1.288, 0.253, -0.105> <-1.288, 0.254, -0.087> 
		<-0.619, 0.421, -0.617> <-0.619, 0.403, -0.617> <-0.513, 0.391, -0.582> <-0.513, 0.392, -0.564> 
		<0.037, 0.419, -0.617> <0.037, 0.401, -0.617> <0.037, 0.389, -0.582> <0.037, 0.390, -0.564> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.037, 0.419, -0.617> <0.655, 0.417, -0.617> <1.337, 0.346, -0.118> <1.636, 0.640, 0.000> 
		<0.033, 0.887, -0.633> <0.652, 0.885, -0.633> <1.565, 0.570, -0.028> <1.865, 0.864, 0.090> 
		<0.029, 1.511, -0.632> <0.635, 1.509, -0.632> <1.533, 2.016, -0.027> <1.848, 1.754, 0.094> 
		<0.026, 1.978, -0.617> <0.632, 1.977, -0.617> <1.287, 2.220, -0.121> <1.602, 1.958, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.037, 0.419, -0.617> <0.037, 0.401, -0.617> <0.037, 0.389, -0.582> <0.037, 0.390, -0.564> 
		<0.655, 0.417, -0.617> <0.655, 0.399, -0.617> <0.555, 0.387, -0.582> <0.555, 0.388, -0.564> 
		<1.337, 0.346, -0.118> <1.337, 0.337, -0.102> <1.286, 0.253, -0.102> <1.286, 0.254, -0.084> 
		<1.636, 0.640, 0.000> <1.636, 0.631, 0.016> <1.636, 0.610, 0.035> <1.636, 0.611, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.636, 0.640, 0.000> <1.636, 0.631, 0.016> <1.636, 0.610, 0.035> <1.636, 0.611, 0.053> 
		<1.865, 0.864, 0.090> <1.865, 0.856, 0.106> <1.914, 0.893, 0.144> <1.914, 0.894, 0.162> 
		<1.848, 1.754, 0.094> <1.848, 1.761, 0.109> <1.901, 1.723, 0.148> <1.901, 1.724, 0.164> 
		<1.602, 1.958, 0.000> <1.602, 1.965, 0.015> <1.602, 1.982, 0.032> <1.602, 1.982, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.602, 1.958, 0.000> <1.602, 1.965, 0.015> <1.602, 1.982, 0.032> <1.602, 1.982, 0.048> 
		<1.287, 2.220, -0.121> <1.287, 2.227, -0.106> <1.233, 2.300, -0.110> <1.233, 2.301, -0.094> 
		<0.632, 1.977, -0.617> <0.632, 1.993, -0.617> <0.534, 2.000, -0.585> <0.534, 2.001, -0.569> 
		<0.026, 1.978, -0.617> <0.026, 1.995, -0.617> <0.026, 2.002, -0.585> <0.026, 2.003, -0.569> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, 1.978, -0.617> <0.026, 1.995, -0.617> <0.026, 2.002, -0.585> <0.026, 2.003, -0.569> 
		<-0.609, 1.980, -0.617> <-0.609, 1.997, -0.617> <-0.507, 2.003, -0.585> <-0.507, 2.004, -0.569> 
		<-1.299, 2.233, -0.123> <-1.299, 2.240, -0.109> <-1.241, 2.315, -0.113> <-1.241, 2.315, -0.097> 
		<-1.638, 1.968, 0.000> <-1.638, 1.975, 0.015> <-1.638, 1.991, 0.032> <-1.638, 1.992, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.672, 0.655, 0.102> <-1.672, 0.645, 0.087> <-1.672, 0.622, 0.071> <-1.672, 0.621, 0.053> 
		<-1.953, 0.914, 0.205> <-1.953, 0.904, 0.191> <-1.960, 0.897, 0.176> <-1.960, 0.896, 0.158> 
		<-1.938, 1.739, 0.211> <-1.938, 1.744, 0.195> <-1.945, 1.743, 0.178> <-1.945, 1.742, 0.161> 
		<-1.638, 1.973, 0.102> <-1.638, 1.979, 0.086> <-1.638, 1.993, 0.065> <-1.638, 1.992, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.672, 0.655, 0.102> <-1.283, 0.295, -0.042> <-0.513, 0.426, -0.515> <0.037, 0.424, -0.515> 
		<-1.672, 0.645, 0.087> <-1.283, 0.285, -0.056> <-0.513, 0.415, -0.530> <0.037, 0.414, -0.530> 
		<-1.672, 0.622, 0.071> <-1.288, 0.255, -0.069> <-0.513, 0.392, -0.546> <0.037, 0.391, -0.546> 
		<-1.672, 0.621, 0.053> <-1.288, 0.254, -0.087> <-0.513, 0.392, -0.564> <0.037, 0.390, -0.564> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.037, 0.424, -0.515> <0.555, 0.422, -0.515> <1.280, 0.295, -0.039> <1.636, 0.645, 0.102> 
		<0.037, 0.414, -0.530> <0.555, 0.412, -0.530> <1.280, 0.285, -0.053> <1.636, 0.635, 0.087> 
		<0.037, 0.391, -0.546> <0.555, 0.389, -0.546> <1.286, 0.255, -0.066> <1.636, 0.612, 0.071> 
		<0.037, 0.390, -0.564> <0.555, 0.388, -0.564> <1.286, 0.254, -0.084> <1.636, 0.611, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.636, 0.645, 0.102> <1.908, 0.912, 0.209> <1.894, 1.720, 0.214> <1.602, 1.963, 0.102> 
		<1.636, 0.635, 0.087> <1.908, 0.902, 0.194> <1.894, 1.726, 0.198> <1.602, 1.969, 0.086> 
		<1.636, 0.612, 0.071> <1.914, 0.895, 0.180> <1.901, 1.725, 0.181> <1.602, 1.983, 0.065> 
		<1.636, 0.611, 0.053> <1.914, 0.894, 0.162> <1.901, 1.724, 0.164> <1.602, 1.982, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.602, 1.963, 0.102> <1.228, 2.274, -0.042> <0.534, 1.982, -0.515> <0.026, 1.983, -0.515> 
		<1.602, 1.969, 0.086> <1.228, 2.280, -0.058> <0.534, 1.988, -0.531> <0.026, 1.989, -0.531> 
		<1.602, 1.983, 0.065> <1.233, 2.302, -0.077> <0.534, 2.002, -0.552> <0.026, 2.003, -0.552> 
		<1.602, 1.982, 0.048> <1.233, 2.301, -0.094> <0.534, 2.001, -0.569> <0.026, 2.003, -0.569> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, 1.983, -0.515> <-0.507, 1.985, -0.515> <-1.235, 2.288, -0.045> <-1.638, 1.973, 0.102> 
		<0.026, 1.989, -0.531> <-0.507, 1.991, -0.531> <-1.235, 2.294, -0.061> <-1.638, 1.979, 0.086> 
		<0.026, 2.003, -0.552> <-0.507, 2.005, -0.552> <-1.241, 2.316, -0.080> <-1.638, 1.993, 0.065> 
		<0.026, 2.003, -0.569> <-0.507, 2.004, -0.569> <-1.241, 2.315, -0.097> <-1.638, 1.992, 0.048> 
	}
}

#declare kolo = union {
 #local I=0;
 #while (I<360)
  object { bieznik rotate x*I }
  #local I=I+15;
 #end  
 object { opona }
 superellipsoid {
  <1,.2> rotate y*90 scale <1.75,.5,.5>
  texture{T_Chrome_3B}
  normal {leopard -.35 scale <.2,.2,1>*.05 }
 }
 pigment { rgb .17 quick_color rgb <0,1,0> }
 finish { phong 0.05 phong_size 1 ambient .25}
 normal { bumps -.3 scale .00001 }
 scale .232
}
