// Persistence of Vision Ray Tracer Scene Description File
// File: book.inc
// Vers: 3.5
// Desc: The "CreateBook" macro
// Date: 2003/10/16
// Auth: Maurizio Tomasi

#include "shapes.inc"

#macro CreateBook (Width, Height, Thickness, Color, 
    NumOfDecorations, DecoColor, TitleImage)

    #if (NumOfDecorations > 0)
    union
    #else
    object
    #end
    {
        object
        {
            Round_Box_Union (<-Thickness/2, 0, -Width/2>, 
                <Thickness/2, Height, Width/2>, Thickness/10)
            
            texture 
            { 
                pigment
                {
                    color Color 
                }
                
                normal
                {
                    wrinkles 0.5
                    scale 0.02
                }
                
                finish { diffuse 0.3 }
            }
            #if (strlen (TitleImage) > 0)
                #if (NumOfDecorations = 0)
                    texture
                    {
                        pigment
                        {
                            image_map
                            {
                                png TitleImage
                                interpolate 2
                            }
                            
                            rotate -90*z
                            scale <Thickness, Height, 1>
                            translate -Thickness/2*x
                        }
                    }
                #end
            #end
        }

        #local LargeDecoRadius = Height / 70;
        #local SmallDecoRadius = Height / 80;
        
        #local Count = 0;
        #while (Count < NumOfDecorations)
        
            union
            {
                cylinder
                {
                    <-Thickness/2, 0, 0>,
                    < Thickness/2, 0, 0>,
                    SmallDecoRadius
                    
                    translate LargeDecoRadius*y
                }

                cylinder
                {
                    <-Thickness/2, 0, 0>,
                    < Thickness/2, 0, 0>,
                    SmallDecoRadius
                    
                    translate -LargeDecoRadius*y
                }

                cylinder
                {
                    <-Thickness/2 + LargeDecoRadius/2, 0, 0>,
                    < Thickness/2 - LargeDecoRadius/2, 0, 0>,
                    LargeDecoRadius
                }
                
                sphere
                {
                    <-Thickness/2 + LargeDecoRadius/2, 0, 0>,
                    LargeDecoRadius
                }

                sphere
                {
                    <Thickness/2 - LargeDecoRadius/2, 0, 0>,
                    LargeDecoRadius
                }

                scale <1, 1, 0.25>
                translate <0, (Count + 1) / (NumOfDecorations + 1) * Height, -Width/2>
                
                texture 
                { 
                    pigment
                    {
                        color DecoColor
                    }
                    
                    normal
                    {
                        wrinkles 0.5
                        scale 0.02
                    }
                    
                    finish
                    {
                        diffuse 0.3
                        specular 0.6
                        roughness 0.01
                    }
                }
            }
        
            #declare Count = Count + 1;
        #end
        
        translate Thickness/2*x
    }

#end
