// Persistence of Vision Ray Tracer Scene Description File
// File: chair.inc
// Vers: 3.5
// Desc: Chair
// Date: 2003/09/21
// Auth: Maurizio Tomasi

#ifndef (__CHAIR_INC__)
#declare __CHAIR_INC__ = 1;

#include "rand.inc"
#include "colors.inc"
#include "woods.inc"
#include "shapes.inc"

#local ChairSeed = seed (37624);

#local Wood =
texture
{
    T_Wood2
    
    finish
    {
        specular 1.0
        roughness 0.03
    }
    normal
    {
        bozo 0.3
        scale 0.5
    }
    
    scale 0.3
}
texture
{
    // This gives a colder tint to T_Wood2
    pigment { color rgbt <0.5, 0.5, 1.0, 0.91> }
}

#local InlayWood =
texture
{
    T_Wood1
    
    finish
    {
        specular 1.0
        roughness 0.03
    }
    normal
    {
        bozo 0.3
        scale 0.5
    }
    
    scale 0.1
}


#local PillowTex =
texture
{
    pigment { color rgb <0.7, 0.6, 0.3> }
    finish { crand 0.12 }
}


#local BackPrism =
prism
{
    cubic_spline
    -0.03, 0, 8
    <-0.20, 0.85>, <-0.17, 0.90>, <0, 0.93>, <0.17, 0.90>, 
    <0.20, 0.85>, <0, 0.80>, <-0.17, 0.90>, <-0.20, 0.85>
    
    rotate -90*x
}

#local BackLeg =
union
{
    box { <0.13, 0.00, 0.00>, <0.17, 0.90, 0.03> }
    
    intersection {
        box { <0.13, 0.90, -0.1>, <0.17, 1.50, 0.1> }
        
        object { BackPrism }
    }
}


#local FrontLeg =
box
{
    <0.13, 0.00, 0.33>, <0.17, 0.45, 0.37>
}


#declare Legs =
union
{
    object { BackLeg }
    object { BackLeg scale <-1, 1, 1> }

    object { FrontLeg }
    object { FrontLeg scale <-1, 1, 1> }
}


#local Base =
union
{
    difference
    {
        Round_Box_Union (<-0.165, 0.38, 0.005>, <0.165, 0.445, 0.365>, 0.005)
        
        object { Legs scale <0.98, 1, 0.98> }
    
        texture 
        { 
            Wood 
            rotate <0, RRand (42, 48, ChairSeed), 0> 
            translate VRand (ChairSeed)
        }
    }

    difference
    {    
        object { Round_Box_Union (<-0.14, 0.42, 0.02>, <0.14, 0.45, 0.34>, 0.03) }
        object { Legs }
        
        texture { PillowTex }
    }
}

#local Back =
union
{
    intersection
    {
        object { BackPrism }
        
        box { <-0.13, 0.90, -0.1>, <0.13, 1.50, 0.1> }
    }
    
    box { <-0.13, 0.50, 0.00>, <0.13, 0.90, 0.03> }

    texture
    {
        material_map
        {
            png "chair-motive.png"
            once
        
            texture 
            {
                Wood 
                rotate <RRand (87, 93, ChairSeed), RRand (-3, 3, ChairSeed), 0> 
                translate VRand (ChairSeed)
            }

            texture 
            {
                InlayWood
                
                rotate <RRand (87, 93, ChairSeed), RRand (-3, 3, ChairSeed), 0> 
                translate VRand (ChairSeed)
            }

        }
        
        translate -0.5*x            
        scale <3.5, 1, 1>*0.06
        translate 0.86*y
    }
}

#local PillowX1 = -0.13;
#local PillowX2 =  0.13;
#local PillowY1 =  0.55;
#local PillowY2 =  0.85;

#local PillowNails =
union
{
    #local Incr = (PillowY2 - PillowY1) / 10;
    
    #local Count = PillowY1 + Incr/2;
    #while (Count < PillowY2)
        sphere 
        { 
            <PillowX1 + 0.01, Count, -0.008>, 0.005
        }
        
        #declare Count = Count + Incr;
    #end


    #local Incr = (PillowX2 - PillowX1) / 8;
    
    #local Count = PillowX1 + 3*Incr/2;
    #while (Count < 0)
        sphere 
        { 
            <Count, PillowY1 + 0.01, -0.008>, 0.005
        }
        
        #declare Count = Count + Incr;
    #end


    #local Incr = (PillowX2 - PillowX1) / 8;
    
    #local Count = PillowX1 + 3*Incr/2;
    #while (Count < 0)
        sphere 
        { 
            <Count, PillowY2 - 0.01, -0.008>, 0.005
        }
        
        #declare Count = Count + Incr;
    #end
}


#local BackPillow =
union
{
    object
    {
        Round_Box_Union (<-0.13, 0.55, -0.008>, <0.13, 0.85, 0.038>, 0.008)
    
        texture { PillowTex }        
    }

    union
    {
        object { PillowNails }
        object { PillowNails scale <-1, 1, 1> }
        
        pigment { color rgb 0.7 }
    }
    
}

#declare Chair =
union
{
    object
    {
        Legs
        
        texture 
        { 
            Wood 
            rotate <RRand (87, 93, ChairSeed), RRand (-3, 3, ChairSeed), 0> 
            translate VRand (ChairSeed)
        }
    }

    object { Base }
        
    object { Back }
    object { BackPillow }
}


#end // __CHAIR_INC__
